/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms.api;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdNodeBasedDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.sinch.xms.SinchSMSApi;
import com.sinch.xms.api.ParameterValues;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

class JacksonUtils {
    JacksonUtils() {
    }

    static final class ParameterValuesSerializer
    extends StdSerializer<ParameterValues> {
        private static final long serialVersionUID = 1L;

        public ParameterValuesSerializer() {
            super(ParameterValues.class);
        }

        public void serialize(ParameterValues value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            for (Map.Entry<String, String> entry : value.substitutions().entrySet()) {
                gen.writeStringField(entry.getKey(), entry.getValue());
            }
            if (value.defaultValue() != null) {
                gen.writeStringField("default", value.defaultValue());
            }
            gen.writeEndObject();
        }
    }

    static final class ParameterValuesDeserializer
    extends StdNodeBasedDeserializer<ParameterValues> {
        private static final long serialVersionUID = 1L;

        public ParameterValuesDeserializer() {
            super(ParameterValues.class);
        }

        public ParameterValues convert(JsonNode root, DeserializationContext ctxt) throws IOException {
            ParameterValues.Builder builder = SinchSMSApi.parameterValues();
            if (root.has("default")) {
                builder.defaultValue(root.get("default").asText());
            }
            Iterator it = root.fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                if ("default".equals(entry.getKey())) {
                    builder.defaultValue(((JsonNode)entry.getValue()).asText());
                    continue;
                }
                builder.putSubstitution((String)entry.getKey(), ((JsonNode)entry.getValue()).asText());
            }
            return builder.build();
        }
    }

    static final class ByteArrayHexSerializer
    extends StdScalarSerializer<byte[]> {
        private static final long serialVersionUID = 1L;

        public ByteArrayHexSerializer() {
            super(byte[].class);
        }

        public void serialize(byte[] value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(Hex.encodeHexString((byte[])value));
        }
    }

    static final class ByteArrayHexDeserializer
    extends FromStringDeserializer<byte[]> {
        private static final long serialVersionUID = 1L;

        public ByteArrayHexDeserializer() {
            super(byte[].class);
        }

        protected byte[] _deserialize(String value, DeserializationContext ctxt) throws IOException {
            try {
                return Hex.decodeHex((char[])value.toCharArray());
            }
            catch (DecoderException e) {
                return (byte[])ctxt.handleWeirdStringValue(this.handledType(), value, e.getMessage(), new Object[0]);
            }
        }
    }
}

