/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sinch.xms.api.JacksonUtils;
import com.sinch.xms.api.MoBinarySms;
import com.sinch.xms.api.MoSms;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
final class MoBinarySmsImpl
extends MoBinarySms {
    @Nullable
    private final byte[] udh;
    private final byte[] body;
    private final String id;
    private final String sender;
    private final String recipient;
    @Nullable
    private final String operator;
    @Nullable
    private final OffsetDateTime sentAt;
    private final OffsetDateTime receivedAt;
    @Nullable
    private final String clientReference;

    private MoBinarySmsImpl(@Nullable byte[] udh, byte[] body, String id, String sender, String recipient, @Nullable String operator, @Nullable OffsetDateTime sentAt, OffsetDateTime receivedAt, @Nullable String clientReference) {
        this.udh = udh;
        this.body = body;
        this.id = id;
        this.sender = sender;
        this.recipient = recipient;
        this.operator = operator;
        this.sentAt = sentAt;
        this.receivedAt = receivedAt;
        this.clientReference = clientReference;
    }

    @Override
    @JsonProperty(value="udh")
    @JsonSerialize(using=JacksonUtils.ByteArrayHexSerializer.class)
    @JsonDeserialize(using=JacksonUtils.ByteArrayHexDeserializer.class)
    @Nullable
    public byte[] udh() {
        return this.udh;
    }

    @Override
    @JsonProperty(value="body")
    public byte[] body() {
        return (byte[])this.body.clone();
    }

    @Override
    @JsonProperty(value="id")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="from")
    public String sender() {
        return this.sender;
    }

    @Override
    @JsonProperty(value="to")
    public String recipient() {
        return this.recipient;
    }

    @Override
    @JsonProperty(value="operator_id")
    @Nullable
    public String operator() {
        return this.operator;
    }

    @Override
    @JsonProperty(value="sent_at")
    @Nullable
    public OffsetDateTime sentAt() {
        return this.sentAt;
    }

    @Override
    @JsonProperty(value="received_at")
    public OffsetDateTime receivedAt() {
        return this.receivedAt;
    }

    @Override
    @JsonProperty(value="client_reference")
    @Nullable
    public String clientReference() {
        return this.clientReference;
    }

    public final MoBinarySmsImpl withUdh(byte ... elements) {
        byte[] newValue = elements == null ? null : (byte[])elements.clone();
        return new MoBinarySmsImpl(newValue, this.body, this.id, this.sender, this.recipient, this.operator, this.sentAt, this.receivedAt, this.clientReference);
    }

    public final MoBinarySmsImpl withBody(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new MoBinarySmsImpl(this.udh, newValue, this.id, this.sender, this.recipient, this.operator, this.sentAt, this.receivedAt, this.clientReference);
    }

    public final MoBinarySmsImpl withId(String value) {
        if (this.id.equals(value)) {
            return this;
        }
        String newValue = MoBinarySmsImpl.requireNonNull(value, "id");
        return new MoBinarySmsImpl(this.udh, this.body, newValue, this.sender, this.recipient, this.operator, this.sentAt, this.receivedAt, this.clientReference);
    }

    public final MoBinarySmsImpl withSender(String value) {
        if (this.sender.equals(value)) {
            return this;
        }
        String newValue = MoBinarySmsImpl.requireNonNull(value, "sender");
        return new MoBinarySmsImpl(this.udh, this.body, this.id, newValue, this.recipient, this.operator, this.sentAt, this.receivedAt, this.clientReference);
    }

    public final MoBinarySmsImpl withRecipient(String value) {
        if (this.recipient.equals(value)) {
            return this;
        }
        String newValue = MoBinarySmsImpl.requireNonNull(value, "recipient");
        return new MoBinarySmsImpl(this.udh, this.body, this.id, this.sender, newValue, this.operator, this.sentAt, this.receivedAt, this.clientReference);
    }

    public final MoBinarySmsImpl withOperator(@Nullable String value) {
        if (MoBinarySmsImpl.equals(this.operator, value)) {
            return this;
        }
        return new MoBinarySmsImpl(this.udh, this.body, this.id, this.sender, this.recipient, value, this.sentAt, this.receivedAt, this.clientReference);
    }

    public final MoBinarySmsImpl withSentAt(@Nullable OffsetDateTime value) {
        if (this.sentAt == value) {
            return this;
        }
        return new MoBinarySmsImpl(this.udh, this.body, this.id, this.sender, this.recipient, this.operator, value, this.receivedAt, this.clientReference);
    }

    public final MoBinarySmsImpl withReceivedAt(OffsetDateTime value) {
        if (this.receivedAt == value) {
            return this;
        }
        OffsetDateTime newValue = MoBinarySmsImpl.requireNonNull(value, "receivedAt");
        return new MoBinarySmsImpl(this.udh, this.body, this.id, this.sender, this.recipient, this.operator, this.sentAt, newValue, this.clientReference);
    }

    public final MoBinarySmsImpl withClientReference(@Nullable String value) {
        if (MoBinarySmsImpl.equals(this.clientReference, value)) {
            return this;
        }
        return new MoBinarySmsImpl(this.udh, this.body, this.id, this.sender, this.recipient, this.operator, this.sentAt, this.receivedAt, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof MoBinarySmsImpl && this.equalTo((MoBinarySmsImpl)another);
    }

    private boolean equalTo(MoBinarySmsImpl another) {
        return Arrays.equals(this.udh, another.udh) && Arrays.equals(this.body, another.body) && this.id.equals(another.id) && this.sender.equals(another.sender) && this.recipient.equals(another.recipient) && MoBinarySmsImpl.equals(this.operator, another.operator) && MoBinarySmsImpl.equals(this.sentAt, another.sentAt) && this.receivedAt.equals(another.receivedAt) && MoBinarySmsImpl.equals(this.clientReference, another.clientReference);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Arrays.hashCode(this.udh);
        h = h * 17 + Arrays.hashCode(this.body);
        h = h * 17 + this.id.hashCode();
        h = h * 17 + this.sender.hashCode();
        h = h * 17 + this.recipient.hashCode();
        h = h * 17 + MoBinarySmsImpl.hashCode(this.operator);
        h = h * 17 + MoBinarySmsImpl.hashCode(this.sentAt);
        h = h * 17 + this.receivedAt.hashCode();
        h = h * 17 + MoBinarySmsImpl.hashCode(this.clientReference);
        return h;
    }

    public String toString() {
        return "MoBinarySms{udh=" + Arrays.toString(this.udh) + ", body=" + Arrays.toString(this.body) + ", id=" + this.id + ", sender=" + this.sender + ", recipient=" + this.recipient + ", operator=" + this.operator + ", sentAt=" + this.sentAt + ", receivedAt=" + this.receivedAt + ", clientReference=" + this.clientReference + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static MoBinarySmsImpl fromJson(Json json) {
        MoBinarySms.Builder builder = new MoBinarySms.Builder();
        if (json.udh != null) {
            builder.udh(json.udh);
        }
        if (json.body != null) {
            builder.body(json.body);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.sender != null) {
            builder.sender(json.sender);
        }
        if (json.recipient != null) {
            builder.recipient(json.recipient);
        }
        if (json.operator != null) {
            builder.operator(json.operator);
        }
        if (json.sentAt != null) {
            builder.sentAt(json.sentAt);
        }
        if (json.receivedAt != null) {
            builder.receivedAt(json.receivedAt);
        }
        if (json.clientReference != null) {
            builder.clientReference(json.clientReference);
        }
        return (MoBinarySmsImpl)builder.build();
    }

    public static MoBinarySms copyOf(MoBinarySms instance) {
        if (instance instanceof MoBinarySmsImpl) {
            return (MoBinarySmsImpl)instance;
        }
        return new MoBinarySms.Builder().using(instance).build();
    }

    private static <T> T requireNonNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    private static int hashCode(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    private static boolean equals(Object left, Object right) {
        return left == right || left != null && left.equals(right);
    }

    @NotThreadSafe
    static class Builder {
        private static final long INIT_BIT_BODY = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_SENDER = 4L;
        private static final long INIT_BIT_RECIPIENT = 8L;
        private static final long INIT_BIT_RECEIVED_AT = 16L;
        private long initBits = 31L;
        @Nullable
        private byte[] udh;
        @Nullable
        private byte[] body;
        @Nullable
        private String id;
        @Nullable
        private String sender;
        @Nullable
        private String recipient;
        @Nullable
        private String operator;
        @Nullable
        private OffsetDateTime sentAt;
        @Nullable
        private OffsetDateTime receivedAt;
        @Nullable
        private String clientReference;

        Builder() {
            if (!(this instanceof MoBinarySms.Builder)) {
                throw new UnsupportedOperationException("Use: new MoBinarySms.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final MoBinarySms.Builder using(MoBinarySms instance) {
            MoBinarySmsImpl.requireNonNull(instance, "instance");
            this.from(instance);
            return (MoBinarySms.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MoBinarySms.Builder using(MoSms instance) {
            MoBinarySmsImpl.requireNonNull(instance, "instance");
            this.from(instance);
            return (MoBinarySms.Builder)this;
        }

        private void from(Object object) {
            MoSms instance;
            if (object instanceof MoBinarySms) {
                instance = (MoBinarySms)object;
                byte[] udhValue = ((MoBinarySms)instance).udh();
                if (udhValue != null) {
                    this.udh(udhValue);
                }
                this.body(((MoBinarySms)instance).body());
            }
            if (object instanceof MoSms) {
                instance = (MoSms)object;
                this.sender(instance.sender());
                this.recipient(instance.recipient());
                String clientReferenceValue = instance.clientReference();
                if (clientReferenceValue != null) {
                    this.clientReference(clientReferenceValue);
                }
                this.id(instance.id());
                OffsetDateTime sentAtValue = instance.sentAt();
                if (sentAtValue != null) {
                    this.sentAt(sentAtValue);
                }
                this.receivedAt(instance.receivedAt());
                String operatorValue = instance.operator();
                if (operatorValue != null) {
                    this.operator(operatorValue);
                }
            }
        }

        @JsonProperty(value="udh")
        @CanIgnoreReturnValue
        public final MoBinarySms.Builder udh(byte ... udh) {
            this.udh = udh;
            return (MoBinarySms.Builder)this;
        }

        @JsonProperty(value="body")
        @CanIgnoreReturnValue
        public final MoBinarySms.Builder body(byte ... body) {
            this.body = (byte[])body.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (MoBinarySms.Builder)this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final MoBinarySms.Builder id(String id) {
            this.id = (String)MoBinarySmsImpl.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (MoBinarySms.Builder)this;
        }

        @JsonProperty(value="from")
        @CanIgnoreReturnValue
        public final MoBinarySms.Builder sender(String sender) {
            this.sender = (String)MoBinarySmsImpl.requireNonNull(sender, "sender");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return (MoBinarySms.Builder)this;
        }

        @JsonProperty(value="to")
        @CanIgnoreReturnValue
        public final MoBinarySms.Builder recipient(String recipient) {
            this.recipient = (String)MoBinarySmsImpl.requireNonNull(recipient, "recipient");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return (MoBinarySms.Builder)this;
        }

        @JsonProperty(value="operator_id")
        @CanIgnoreReturnValue
        public final MoBinarySms.Builder operator(@Nullable String operator) {
            this.operator = operator;
            return (MoBinarySms.Builder)this;
        }

        @JsonProperty(value="sent_at")
        @CanIgnoreReturnValue
        public final MoBinarySms.Builder sentAt(@Nullable OffsetDateTime sentAt) {
            this.sentAt = sentAt;
            return (MoBinarySms.Builder)this;
        }

        @JsonProperty(value="received_at")
        @CanIgnoreReturnValue
        public final MoBinarySms.Builder receivedAt(OffsetDateTime receivedAt) {
            this.receivedAt = (OffsetDateTime)MoBinarySmsImpl.requireNonNull(receivedAt, "receivedAt");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return (MoBinarySms.Builder)this;
        }

        @JsonProperty(value="client_reference")
        @CanIgnoreReturnValue
        public final MoBinarySms.Builder clientReference(@Nullable String clientReference) {
            this.clientReference = clientReference;
            return (MoBinarySms.Builder)this;
        }

        public MoBinarySms build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new MoBinarySmsImpl(this.udh, this.body, this.id, this.sender, this.recipient, this.operator, this.sentAt, this.receivedAt, this.clientReference);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("body");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("sender");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("recipient");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("receivedAt");
            }
            return "Cannot build MoBinarySms, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends MoBinarySms {
        @Nullable
        byte[] udh;
        @Nullable
        byte[] body;
        @Nullable
        String id;
        @Nullable
        String sender;
        @Nullable
        String recipient;
        @Nullable
        String operator;
        @Nullable
        OffsetDateTime sentAt;
        @Nullable
        OffsetDateTime receivedAt;
        @Nullable
        String clientReference;

        Json() {
        }

        @JsonProperty(value="udh")
        @JsonSerialize(using=JacksonUtils.ByteArrayHexSerializer.class)
        @JsonDeserialize(using=JacksonUtils.ByteArrayHexDeserializer.class)
        public void setUdh(@Nullable byte[] udh) {
            this.udh = udh;
        }

        @JsonProperty(value="body")
        public void setBody(byte[] body) {
            this.body = body;
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="from")
        public void setSender(String sender) {
            this.sender = sender;
        }

        @JsonProperty(value="to")
        public void setRecipient(String recipient) {
            this.recipient = recipient;
        }

        @JsonProperty(value="operator_id")
        public void setOperator(@Nullable String operator) {
            this.operator = operator;
        }

        @JsonProperty(value="sent_at")
        public void setSentAt(@Nullable OffsetDateTime sentAt) {
            this.sentAt = sentAt;
        }

        @JsonProperty(value="received_at")
        public void setReceivedAt(OffsetDateTime receivedAt) {
            this.receivedAt = receivedAt;
        }

        @JsonProperty(value="client_reference")
        public void setClientReference(@Nullable String clientReference) {
            this.clientReference = clientReference;
        }

        @Override
        public byte[] udh() {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] body() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String sender() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String recipient() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String operator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OffsetDateTime sentAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OffsetDateTime receivedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String clientReference() {
            throw new UnsupportedOperationException();
        }
    }
}

