/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sinch.xms.api.MoSms;
import com.sinch.xms.api.MoTextSms;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
final class MoTextSmsImpl
extends MoTextSms {
    private final String body;
    @Nullable
    private final String keyword;
    private final String id;
    private final String sender;
    private final String recipient;
    @Nullable
    private final String operator;
    @Nullable
    private final OffsetDateTime sentAt;
    private final OffsetDateTime receivedAt;
    @Nullable
    private final String clientReference;

    private MoTextSmsImpl(String body, @Nullable String keyword, String id, String sender, String recipient, @Nullable String operator, @Nullable OffsetDateTime sentAt, OffsetDateTime receivedAt, @Nullable String clientReference) {
        this.body = body;
        this.keyword = keyword;
        this.id = id;
        this.sender = sender;
        this.recipient = recipient;
        this.operator = operator;
        this.sentAt = sentAt;
        this.receivedAt = receivedAt;
        this.clientReference = clientReference;
    }

    @Override
    @JsonProperty(value="body")
    public String body() {
        return this.body;
    }

    @Override
    @JsonProperty(value="keyword")
    @Nullable
    public String keyword() {
        return this.keyword;
    }

    @Override
    @JsonProperty(value="id")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="from")
    public String sender() {
        return this.sender;
    }

    @Override
    @JsonProperty(value="to")
    public String recipient() {
        return this.recipient;
    }

    @Override
    @JsonProperty(value="operator_id")
    @Nullable
    public String operator() {
        return this.operator;
    }

    @Override
    @JsonProperty(value="sent_at")
    @Nullable
    public OffsetDateTime sentAt() {
        return this.sentAt;
    }

    @Override
    @JsonProperty(value="received_at")
    public OffsetDateTime receivedAt() {
        return this.receivedAt;
    }

    @Override
    @JsonProperty(value="client_reference")
    @Nullable
    public String clientReference() {
        return this.clientReference;
    }

    public final MoTextSmsImpl withBody(String value) {
        if (this.body.equals(value)) {
            return this;
        }
        String newValue = MoTextSmsImpl.requireNonNull(value, "body");
        return new MoTextSmsImpl(newValue, this.keyword, this.id, this.sender, this.recipient, this.operator, this.sentAt, this.receivedAt, this.clientReference);
    }

    public final MoTextSmsImpl withKeyword(@Nullable String value) {
        if (MoTextSmsImpl.equals(this.keyword, value)) {
            return this;
        }
        return new MoTextSmsImpl(this.body, value, this.id, this.sender, this.recipient, this.operator, this.sentAt, this.receivedAt, this.clientReference);
    }

    public final MoTextSmsImpl withId(String value) {
        if (this.id.equals(value)) {
            return this;
        }
        String newValue = MoTextSmsImpl.requireNonNull(value, "id");
        return new MoTextSmsImpl(this.body, this.keyword, newValue, this.sender, this.recipient, this.operator, this.sentAt, this.receivedAt, this.clientReference);
    }

    public final MoTextSmsImpl withSender(String value) {
        if (this.sender.equals(value)) {
            return this;
        }
        String newValue = MoTextSmsImpl.requireNonNull(value, "sender");
        return new MoTextSmsImpl(this.body, this.keyword, this.id, newValue, this.recipient, this.operator, this.sentAt, this.receivedAt, this.clientReference);
    }

    public final MoTextSmsImpl withRecipient(String value) {
        if (this.recipient.equals(value)) {
            return this;
        }
        String newValue = MoTextSmsImpl.requireNonNull(value, "recipient");
        return new MoTextSmsImpl(this.body, this.keyword, this.id, this.sender, newValue, this.operator, this.sentAt, this.receivedAt, this.clientReference);
    }

    public final MoTextSmsImpl withOperator(@Nullable String value) {
        if (MoTextSmsImpl.equals(this.operator, value)) {
            return this;
        }
        return new MoTextSmsImpl(this.body, this.keyword, this.id, this.sender, this.recipient, value, this.sentAt, this.receivedAt, this.clientReference);
    }

    public final MoTextSmsImpl withSentAt(@Nullable OffsetDateTime value) {
        if (this.sentAt == value) {
            return this;
        }
        return new MoTextSmsImpl(this.body, this.keyword, this.id, this.sender, this.recipient, this.operator, value, this.receivedAt, this.clientReference);
    }

    public final MoTextSmsImpl withReceivedAt(OffsetDateTime value) {
        if (this.receivedAt == value) {
            return this;
        }
        OffsetDateTime newValue = MoTextSmsImpl.requireNonNull(value, "receivedAt");
        return new MoTextSmsImpl(this.body, this.keyword, this.id, this.sender, this.recipient, this.operator, this.sentAt, newValue, this.clientReference);
    }

    public final MoTextSmsImpl withClientReference(@Nullable String value) {
        if (MoTextSmsImpl.equals(this.clientReference, value)) {
            return this;
        }
        return new MoTextSmsImpl(this.body, this.keyword, this.id, this.sender, this.recipient, this.operator, this.sentAt, this.receivedAt, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof MoTextSmsImpl && this.equalTo((MoTextSmsImpl)another);
    }

    private boolean equalTo(MoTextSmsImpl another) {
        return this.body.equals(another.body) && MoTextSmsImpl.equals(this.keyword, another.keyword) && this.id.equals(another.id) && this.sender.equals(another.sender) && this.recipient.equals(another.recipient) && MoTextSmsImpl.equals(this.operator, another.operator) && MoTextSmsImpl.equals(this.sentAt, another.sentAt) && this.receivedAt.equals(another.receivedAt) && MoTextSmsImpl.equals(this.clientReference, another.clientReference);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.body.hashCode();
        h = h * 17 + MoTextSmsImpl.hashCode(this.keyword);
        h = h * 17 + this.id.hashCode();
        h = h * 17 + this.sender.hashCode();
        h = h * 17 + this.recipient.hashCode();
        h = h * 17 + MoTextSmsImpl.hashCode(this.operator);
        h = h * 17 + MoTextSmsImpl.hashCode(this.sentAt);
        h = h * 17 + this.receivedAt.hashCode();
        h = h * 17 + MoTextSmsImpl.hashCode(this.clientReference);
        return h;
    }

    public String toString() {
        return "MoTextSms{body=" + this.body + ", keyword=" + this.keyword + ", id=" + this.id + ", sender=" + this.sender + ", recipient=" + this.recipient + ", operator=" + this.operator + ", sentAt=" + this.sentAt + ", receivedAt=" + this.receivedAt + ", clientReference=" + this.clientReference + "}";
    }

    public static MoTextSms copyOf(MoTextSms instance) {
        if (instance instanceof MoTextSmsImpl) {
            return (MoTextSmsImpl)instance;
        }
        return new MoTextSms.Builder().using(instance).build();
    }

    private static <T> T requireNonNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    private static int hashCode(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    private static boolean equals(Object left, Object right) {
        return left == right || left != null && left.equals(right);
    }

    @NotThreadSafe
    static class Builder {
        private static final long INIT_BIT_BODY = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_SENDER = 4L;
        private static final long INIT_BIT_RECIPIENT = 8L;
        private static final long INIT_BIT_RECEIVED_AT = 16L;
        private long initBits = 31L;
        @Nullable
        private String body;
        @Nullable
        private String keyword;
        @Nullable
        private String id;
        @Nullable
        private String sender;
        @Nullable
        private String recipient;
        @Nullable
        private String operator;
        @Nullable
        private OffsetDateTime sentAt;
        @Nullable
        private OffsetDateTime receivedAt;
        @Nullable
        private String clientReference;

        Builder() {
            if (!(this instanceof MoTextSms.Builder)) {
                throw new UnsupportedOperationException("Use: new MoTextSms.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final MoTextSms.Builder using(MoTextSms instance) {
            MoTextSmsImpl.requireNonNull(instance, "instance");
            this.from(instance);
            return (MoTextSms.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MoTextSms.Builder using(MoSms instance) {
            MoTextSmsImpl.requireNonNull(instance, "instance");
            this.from(instance);
            return (MoTextSms.Builder)this;
        }

        private void from(Object object) {
            MoSms instance;
            if (object instanceof MoTextSms) {
                instance = (MoTextSms)object;
                this.body(((MoTextSms)instance).body());
                String keywordValue = ((MoTextSms)instance).keyword();
                if (keywordValue != null) {
                    this.keyword(keywordValue);
                }
            }
            if (object instanceof MoSms) {
                instance = (MoSms)object;
                this.sender(instance.sender());
                this.recipient(instance.recipient());
                String clientReferenceValue = instance.clientReference();
                if (clientReferenceValue != null) {
                    this.clientReference(clientReferenceValue);
                }
                this.id(instance.id());
                OffsetDateTime sentAtValue = instance.sentAt();
                if (sentAtValue != null) {
                    this.sentAt(sentAtValue);
                }
                this.receivedAt(instance.receivedAt());
                String operatorValue = instance.operator();
                if (operatorValue != null) {
                    this.operator(operatorValue);
                }
            }
        }

        @JsonProperty(value="body")
        @CanIgnoreReturnValue
        public final MoTextSms.Builder body(String body) {
            this.body = (String)MoTextSmsImpl.requireNonNull(body, "body");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (MoTextSms.Builder)this;
        }

        @JsonProperty(value="keyword")
        @CanIgnoreReturnValue
        public final MoTextSms.Builder keyword(@Nullable String keyword) {
            this.keyword = keyword;
            return (MoTextSms.Builder)this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final MoTextSms.Builder id(String id) {
            this.id = (String)MoTextSmsImpl.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (MoTextSms.Builder)this;
        }

        @JsonProperty(value="from")
        @CanIgnoreReturnValue
        public final MoTextSms.Builder sender(String sender) {
            this.sender = (String)MoTextSmsImpl.requireNonNull(sender, "sender");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return (MoTextSms.Builder)this;
        }

        @JsonProperty(value="to")
        @CanIgnoreReturnValue
        public final MoTextSms.Builder recipient(String recipient) {
            this.recipient = (String)MoTextSmsImpl.requireNonNull(recipient, "recipient");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return (MoTextSms.Builder)this;
        }

        @JsonProperty(value="operator_id")
        @CanIgnoreReturnValue
        public final MoTextSms.Builder operator(@Nullable String operator) {
            this.operator = operator;
            return (MoTextSms.Builder)this;
        }

        @JsonProperty(value="sent_at")
        @CanIgnoreReturnValue
        public final MoTextSms.Builder sentAt(@Nullable OffsetDateTime sentAt) {
            this.sentAt = sentAt;
            return (MoTextSms.Builder)this;
        }

        @JsonProperty(value="received_at")
        @CanIgnoreReturnValue
        public final MoTextSms.Builder receivedAt(OffsetDateTime receivedAt) {
            this.receivedAt = (OffsetDateTime)MoTextSmsImpl.requireNonNull(receivedAt, "receivedAt");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return (MoTextSms.Builder)this;
        }

        @JsonProperty(value="client_reference")
        @CanIgnoreReturnValue
        public final MoTextSms.Builder clientReference(@Nullable String clientReference) {
            this.clientReference = clientReference;
            return (MoTextSms.Builder)this;
        }

        public MoTextSms build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new MoTextSmsImpl(this.body, this.keyword, this.id, this.sender, this.recipient, this.operator, this.sentAt, this.receivedAt, this.clientReference);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("body");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("sender");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("recipient");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("receivedAt");
            }
            return "Cannot build MoTextSms, some of required attributes are not set " + attributes;
        }
    }
}

