/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sinch.xms.api.JacksonUtils;
import com.sinch.xms.api.MtBatchBinarySmsCreate;
import com.sinch.xms.api.MtBatchSmsCreate;
import com.sinch.xms.api.ReportType;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
final class MtBatchBinarySmsCreateImpl
extends MtBatchBinarySmsCreate {
    private final byte[] udh;
    private final byte[] body;
    private final List<String> recipients;
    @Nullable
    private final String sender;
    @Nullable
    private final ReportType deliveryReport;
    @Nullable
    private final OffsetDateTime sendAt;
    @Nullable
    private final OffsetDateTime expireAt;
    @Nullable
    private final URI callbackUrl;
    @Nullable
    private final Boolean feedbackEnabled;
    private final Set<String> tags;
    @Nullable
    private final String clientReference;
    @Nullable
    private final Boolean flashMessage;
    @Nullable
    private final Integer maxNumberOfMessageParts;
    @Nullable
    private final String dltPrincipalEntity;
    @Nullable
    private final String dltTemplateId;
    @Nullable
    private final Integer senderTon;
    @Nullable
    private final Integer senderNpi;

    private MtBatchBinarySmsCreateImpl(byte[] udh, byte[] body, List<String> recipients, @Nullable String sender, @Nullable ReportType deliveryReport, @Nullable OffsetDateTime sendAt, @Nullable OffsetDateTime expireAt, @Nullable URI callbackUrl, @Nullable Boolean feedbackEnabled, Set<String> tags, @Nullable String clientReference, @Nullable Boolean flashMessage, @Nullable Integer maxNumberOfMessageParts, @Nullable String dltPrincipalEntity, @Nullable String dltTemplateId, @Nullable Integer senderTon, @Nullable Integer senderNpi) {
        this.udh = udh;
        this.body = body;
        this.recipients = recipients;
        this.sender = sender;
        this.deliveryReport = deliveryReport;
        this.sendAt = sendAt;
        this.expireAt = expireAt;
        this.callbackUrl = callbackUrl;
        this.feedbackEnabled = feedbackEnabled;
        this.tags = tags;
        this.clientReference = clientReference;
        this.flashMessage = flashMessage;
        this.maxNumberOfMessageParts = maxNumberOfMessageParts;
        this.dltPrincipalEntity = dltPrincipalEntity;
        this.dltTemplateId = dltTemplateId;
        this.senderTon = senderTon;
        this.senderNpi = senderNpi;
    }

    @Override
    @JsonProperty(value="udh")
    @JsonSerialize(using=JacksonUtils.ByteArrayHexSerializer.class)
    @JsonDeserialize(using=JacksonUtils.ByteArrayHexDeserializer.class)
    public byte[] udh() {
        return (byte[])this.udh.clone();
    }

    @Override
    @JsonProperty(value="body")
    public byte[] body() {
        return (byte[])this.body.clone();
    }

    @Override
    @JsonProperty(value="to")
    public List<String> recipients() {
        return this.recipients;
    }

    @Override
    @JsonProperty(value="from")
    @Nullable
    public String sender() {
        return this.sender;
    }

    @Override
    @JsonProperty(value="delivery_report")
    @Nullable
    public ReportType deliveryReport() {
        return this.deliveryReport;
    }

    @Override
    @JsonProperty(value="send_at")
    @Nullable
    public OffsetDateTime sendAt() {
        return this.sendAt;
    }

    @Override
    @JsonProperty(value="expire_at")
    @Nullable
    public OffsetDateTime expireAt() {
        return this.expireAt;
    }

    @Override
    @JsonProperty(value="callback_url")
    @Nullable
    public URI callbackUrl() {
        return this.callbackUrl;
    }

    @Override
    @JsonProperty(value="feedback_enabled")
    @Nullable
    public Boolean feedbackEnabled() {
        return this.feedbackEnabled;
    }

    @Override
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Deprecated
    public Set<String> tags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="client_reference")
    @Nullable
    public String clientReference() {
        return this.clientReference;
    }

    @Override
    @JsonProperty(value="flash_message")
    @Nullable
    public Boolean flashMessage() {
        return this.flashMessage;
    }

    @Override
    @JsonProperty(value="max_number_of_message_parts")
    @Nullable
    public Integer maxNumberOfMessageParts() {
        return this.maxNumberOfMessageParts;
    }

    @Override
    @JsonProperty(value="dlt_principal_entity_id")
    @Nullable
    public String dltPrincipalEntity() {
        return this.dltPrincipalEntity;
    }

    @Override
    @JsonProperty(value="dlt_template_id")
    @Nullable
    public String dltTemplateId() {
        return this.dltTemplateId;
    }

    @Override
    @JsonProperty(value="from_ton")
    @Nullable
    public Integer senderTon() {
        return this.senderTon;
    }

    @Override
    @JsonProperty(value="from_npi")
    @Nullable
    public Integer senderNpi() {
        return this.senderNpi;
    }

    public final MtBatchBinarySmsCreateImpl withUdh(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return MtBatchBinarySmsCreateImpl.validate(new MtBatchBinarySmsCreateImpl(newValue, this.body, this.recipients, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.feedbackEnabled, this.tags, this.clientReference, this.flashMessage, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi));
    }

    public final MtBatchBinarySmsCreateImpl withBody(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return MtBatchBinarySmsCreateImpl.validate(new MtBatchBinarySmsCreateImpl(this.udh, newValue, this.recipients, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.feedbackEnabled, this.tags, this.clientReference, this.flashMessage, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi));
    }

    public final MtBatchBinarySmsCreateImpl withRecipients(String ... elements) {
        List<String> newValue = MtBatchBinarySmsCreateImpl.createUnmodifiableList(false, MtBatchBinarySmsCreateImpl.createSafeList(Arrays.asList(elements), true, false));
        return MtBatchBinarySmsCreateImpl.validate(new MtBatchBinarySmsCreateImpl(this.udh, this.body, newValue, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.feedbackEnabled, this.tags, this.clientReference, this.flashMessage, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi));
    }

    public final MtBatchBinarySmsCreateImpl withRecipients(Iterable<String> elements) {
        if (this.recipients == elements) {
            return this;
        }
        List<String> newValue = MtBatchBinarySmsCreateImpl.createUnmodifiableList(false, MtBatchBinarySmsCreateImpl.createSafeList(elements, true, false));
        return MtBatchBinarySmsCreateImpl.validate(new MtBatchBinarySmsCreateImpl(this.udh, this.body, newValue, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.feedbackEnabled, this.tags, this.clientReference, this.flashMessage, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi));
    }

    public final MtBatchBinarySmsCreateImpl withSender(@Nullable String value) {
        if (MtBatchBinarySmsCreateImpl.equals(this.sender, value)) {
            return this;
        }
        return MtBatchBinarySmsCreateImpl.validate(new MtBatchBinarySmsCreateImpl(this.udh, this.body, this.recipients, value, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.feedbackEnabled, this.tags, this.clientReference, this.flashMessage, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi));
    }

    public final MtBatchBinarySmsCreateImpl withDeliveryReport(@Nullable ReportType value) {
        if (this.deliveryReport == value) {
            return this;
        }
        return MtBatchBinarySmsCreateImpl.validate(new MtBatchBinarySmsCreateImpl(this.udh, this.body, this.recipients, this.sender, value, this.sendAt, this.expireAt, this.callbackUrl, this.feedbackEnabled, this.tags, this.clientReference, this.flashMessage, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi));
    }

    public final MtBatchBinarySmsCreateImpl withSendAt(@Nullable OffsetDateTime value) {
        if (this.sendAt == value) {
            return this;
        }
        return MtBatchBinarySmsCreateImpl.validate(new MtBatchBinarySmsCreateImpl(this.udh, this.body, this.recipients, this.sender, this.deliveryReport, value, this.expireAt, this.callbackUrl, this.feedbackEnabled, this.tags, this.clientReference, this.flashMessage, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi));
    }

    public final MtBatchBinarySmsCreateImpl withExpireAt(@Nullable OffsetDateTime value) {
        if (this.expireAt == value) {
            return this;
        }
        return MtBatchBinarySmsCreateImpl.validate(new MtBatchBinarySmsCreateImpl(this.udh, this.body, this.recipients, this.sender, this.deliveryReport, this.sendAt, value, this.callbackUrl, this.feedbackEnabled, this.tags, this.clientReference, this.flashMessage, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi));
    }

    public final MtBatchBinarySmsCreateImpl withCallbackUrl(@Nullable URI value) {
        if (this.callbackUrl == value) {
            return this;
        }
        return MtBatchBinarySmsCreateImpl.validate(new MtBatchBinarySmsCreateImpl(this.udh, this.body, this.recipients, this.sender, this.deliveryReport, this.sendAt, this.expireAt, value, this.feedbackEnabled, this.tags, this.clientReference, this.flashMessage, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi));
    }

    public final MtBatchBinarySmsCreateImpl withFeedbackEnabled(@Nullable Boolean value) {
        if (MtBatchBinarySmsCreateImpl.equals(this.feedbackEnabled, value)) {
            return this;
        }
        return MtBatchBinarySmsCreateImpl.validate(new MtBatchBinarySmsCreateImpl(this.udh, this.body, this.recipients, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, value, this.tags, this.clientReference, this.flashMessage, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi));
    }

    @Deprecated
    public final MtBatchBinarySmsCreateImpl withTags(String ... elements) {
        Set<String> newValue = MtBatchBinarySmsCreateImpl.createUnmodifiableSet(MtBatchBinarySmsCreateImpl.createSafeList(Arrays.asList(elements), true, false));
        return MtBatchBinarySmsCreateImpl.validate(new MtBatchBinarySmsCreateImpl(this.udh, this.body, this.recipients, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.feedbackEnabled, newValue, this.clientReference, this.flashMessage, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi));
    }

    @Deprecated
    public final MtBatchBinarySmsCreateImpl withTags(Iterable<String> elements) {
        if (this.tags == elements) {
            return this;
        }
        Set<String> newValue = MtBatchBinarySmsCreateImpl.createUnmodifiableSet(MtBatchBinarySmsCreateImpl.createSafeList(elements, true, false));
        return MtBatchBinarySmsCreateImpl.validate(new MtBatchBinarySmsCreateImpl(this.udh, this.body, this.recipients, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.feedbackEnabled, newValue, this.clientReference, this.flashMessage, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi));
    }

    public final MtBatchBinarySmsCreateImpl withClientReference(@Nullable String value) {
        if (MtBatchBinarySmsCreateImpl.equals(this.clientReference, value)) {
            return this;
        }
        return MtBatchBinarySmsCreateImpl.validate(new MtBatchBinarySmsCreateImpl(this.udh, this.body, this.recipients, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.feedbackEnabled, this.tags, value, this.flashMessage, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi));
    }

    public final MtBatchBinarySmsCreateImpl withFlashMessage(@Nullable Boolean value) {
        if (MtBatchBinarySmsCreateImpl.equals(this.flashMessage, value)) {
            return this;
        }
        return MtBatchBinarySmsCreateImpl.validate(new MtBatchBinarySmsCreateImpl(this.udh, this.body, this.recipients, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.feedbackEnabled, this.tags, this.clientReference, value, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi));
    }

    public final MtBatchBinarySmsCreateImpl withMaxNumberOfMessageParts(@Nullable Integer value) {
        if (MtBatchBinarySmsCreateImpl.equals(this.maxNumberOfMessageParts, value)) {
            return this;
        }
        return MtBatchBinarySmsCreateImpl.validate(new MtBatchBinarySmsCreateImpl(this.udh, this.body, this.recipients, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.feedbackEnabled, this.tags, this.clientReference, this.flashMessage, value, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi));
    }

    public final MtBatchBinarySmsCreateImpl withDltPrincipalEntity(@Nullable String value) {
        if (MtBatchBinarySmsCreateImpl.equals(this.dltPrincipalEntity, value)) {
            return this;
        }
        return MtBatchBinarySmsCreateImpl.validate(new MtBatchBinarySmsCreateImpl(this.udh, this.body, this.recipients, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.feedbackEnabled, this.tags, this.clientReference, this.flashMessage, this.maxNumberOfMessageParts, value, this.dltTemplateId, this.senderTon, this.senderNpi));
    }

    public final MtBatchBinarySmsCreateImpl withDltTemplateId(@Nullable String value) {
        if (MtBatchBinarySmsCreateImpl.equals(this.dltTemplateId, value)) {
            return this;
        }
        return MtBatchBinarySmsCreateImpl.validate(new MtBatchBinarySmsCreateImpl(this.udh, this.body, this.recipients, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.feedbackEnabled, this.tags, this.clientReference, this.flashMessage, this.maxNumberOfMessageParts, this.dltPrincipalEntity, value, this.senderTon, this.senderNpi));
    }

    public final MtBatchBinarySmsCreateImpl withSenderTon(@Nullable Integer value) {
        if (MtBatchBinarySmsCreateImpl.equals(this.senderTon, value)) {
            return this;
        }
        return MtBatchBinarySmsCreateImpl.validate(new MtBatchBinarySmsCreateImpl(this.udh, this.body, this.recipients, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.feedbackEnabled, this.tags, this.clientReference, this.flashMessage, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, value, this.senderNpi));
    }

    public final MtBatchBinarySmsCreateImpl withSenderNpi(@Nullable Integer value) {
        if (MtBatchBinarySmsCreateImpl.equals(this.senderNpi, value)) {
            return this;
        }
        return MtBatchBinarySmsCreateImpl.validate(new MtBatchBinarySmsCreateImpl(this.udh, this.body, this.recipients, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.feedbackEnabled, this.tags, this.clientReference, this.flashMessage, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof MtBatchBinarySmsCreateImpl && this.equalTo((MtBatchBinarySmsCreateImpl)another);
    }

    private boolean equalTo(MtBatchBinarySmsCreateImpl another) {
        return Arrays.equals(this.udh, another.udh) && Arrays.equals(this.body, another.body) && this.recipients.equals(another.recipients) && MtBatchBinarySmsCreateImpl.equals(this.sender, another.sender) && MtBatchBinarySmsCreateImpl.equals(this.deliveryReport, another.deliveryReport) && MtBatchBinarySmsCreateImpl.equals(this.sendAt, another.sendAt) && MtBatchBinarySmsCreateImpl.equals(this.expireAt, another.expireAt) && MtBatchBinarySmsCreateImpl.equals(this.callbackUrl, another.callbackUrl) && MtBatchBinarySmsCreateImpl.equals(this.feedbackEnabled, another.feedbackEnabled) && this.tags.equals(another.tags) && MtBatchBinarySmsCreateImpl.equals(this.clientReference, another.clientReference) && MtBatchBinarySmsCreateImpl.equals(this.flashMessage, another.flashMessage) && MtBatchBinarySmsCreateImpl.equals(this.maxNumberOfMessageParts, another.maxNumberOfMessageParts) && MtBatchBinarySmsCreateImpl.equals(this.dltPrincipalEntity, another.dltPrincipalEntity) && MtBatchBinarySmsCreateImpl.equals(this.dltTemplateId, another.dltTemplateId) && MtBatchBinarySmsCreateImpl.equals(this.senderTon, another.senderTon) && MtBatchBinarySmsCreateImpl.equals(this.senderNpi, another.senderNpi);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Arrays.hashCode(this.udh);
        h = h * 17 + Arrays.hashCode(this.body);
        h = h * 17 + this.recipients.hashCode();
        h = h * 17 + MtBatchBinarySmsCreateImpl.hashCode(this.sender);
        h = h * 17 + MtBatchBinarySmsCreateImpl.hashCode(this.deliveryReport);
        h = h * 17 + MtBatchBinarySmsCreateImpl.hashCode(this.sendAt);
        h = h * 17 + MtBatchBinarySmsCreateImpl.hashCode(this.expireAt);
        h = h * 17 + MtBatchBinarySmsCreateImpl.hashCode(this.callbackUrl);
        h = h * 17 + MtBatchBinarySmsCreateImpl.hashCode(this.feedbackEnabled);
        h = h * 17 + this.tags.hashCode();
        h = h * 17 + MtBatchBinarySmsCreateImpl.hashCode(this.clientReference);
        h = h * 17 + MtBatchBinarySmsCreateImpl.hashCode(this.flashMessage);
        h = h * 17 + MtBatchBinarySmsCreateImpl.hashCode(this.maxNumberOfMessageParts);
        h = h * 17 + MtBatchBinarySmsCreateImpl.hashCode(this.dltPrincipalEntity);
        h = h * 17 + MtBatchBinarySmsCreateImpl.hashCode(this.dltTemplateId);
        h = h * 17 + MtBatchBinarySmsCreateImpl.hashCode(this.senderTon);
        h = h * 17 + MtBatchBinarySmsCreateImpl.hashCode(this.senderNpi);
        return h;
    }

    public String toString() {
        return "MtBatchBinarySmsCreate{udh=" + Arrays.toString(this.udh) + ", body=" + Arrays.toString(this.body) + ", recipients=" + this.recipients + ", sender=" + this.sender + ", deliveryReport=" + this.deliveryReport + ", sendAt=" + this.sendAt + ", expireAt=" + this.expireAt + ", callbackUrl=" + this.callbackUrl + ", feedbackEnabled=" + this.feedbackEnabled + ", tags=" + this.tags + ", clientReference=" + this.clientReference + ", flashMessage=" + this.flashMessage + ", maxNumberOfMessageParts=" + this.maxNumberOfMessageParts + ", dltPrincipalEntity=" + this.dltPrincipalEntity + ", dltTemplateId=" + this.dltTemplateId + ", senderTon=" + this.senderTon + ", senderNpi=" + this.senderNpi + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static MtBatchBinarySmsCreateImpl fromJson(Json json) {
        MtBatchBinarySmsCreate.Builder builder = new MtBatchBinarySmsCreate.Builder();
        if (json.udh != null) {
            builder.udh(json.udh);
        }
        if (json.body != null) {
            builder.body(json.body);
        }
        if (json.recipients != null) {
            builder.addAllRecipients(json.recipients);
        }
        if (json.sender != null) {
            builder.sender(json.sender);
        }
        if (json.deliveryReport != null) {
            builder.deliveryReport(json.deliveryReport);
        }
        if (json.sendAt != null) {
            builder.sendAt(json.sendAt);
        }
        if (json.expireAt != null) {
            builder.expireAt(json.expireAt);
        }
        if (json.callbackUrl != null) {
            builder.callbackUrl(json.callbackUrl);
        }
        if (json.feedbackEnabled != null) {
            builder.feedbackEnabled(json.feedbackEnabled);
        }
        if (json.tags != null) {
            builder.addAllTags(json.tags);
        }
        if (json.clientReference != null) {
            builder.clientReference(json.clientReference);
        }
        if (json.flashMessage != null) {
            builder.flashMessage(json.flashMessage);
        }
        if (json.maxNumberOfMessageParts != null) {
            builder.maxNumberOfMessageParts(json.maxNumberOfMessageParts);
        }
        if (json.dltPrincipalEntity != null) {
            builder.dltPrincipalEntity(json.dltPrincipalEntity);
        }
        if (json.dltTemplateId != null) {
            builder.dltTemplateId(json.dltTemplateId);
        }
        if (json.senderTon != null) {
            builder.senderTon(json.senderTon);
        }
        if (json.senderNpi != null) {
            builder.senderNpi(json.senderNpi);
        }
        return (MtBatchBinarySmsCreateImpl)builder.build();
    }

    private static MtBatchBinarySmsCreateImpl validate(MtBatchBinarySmsCreateImpl instance) {
        instance.check();
        return instance;
    }

    public static MtBatchBinarySmsCreate copyOf(MtBatchBinarySmsCreate instance) {
        if (instance instanceof MtBatchBinarySmsCreateImpl) {
            return (MtBatchBinarySmsCreateImpl)instance;
        }
        return new MtBatchBinarySmsCreate.Builder().using(instance).build();
    }

    private static <T> T requireNonNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    private static int hashCode(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    private static boolean equals(Object left, Object right) {
        return left == right || left != null && left.equals(right);
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                MtBatchBinarySmsCreateImpl.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @NotThreadSafe
    static class Builder {
        private static final long INIT_BIT_UDH = 1L;
        private static final long INIT_BIT_BODY = 2L;
        private long initBits = 3L;
        @Nullable
        private byte[] udh;
        @Nullable
        private byte[] body;
        private List<String> recipients = new ArrayList<String>();
        @Nullable
        private String sender;
        @Nullable
        private ReportType deliveryReport;
        @Nullable
        private OffsetDateTime sendAt;
        @Nullable
        private OffsetDateTime expireAt;
        @Nullable
        private URI callbackUrl;
        @Nullable
        private Boolean feedbackEnabled;
        private List<String> tags = new ArrayList<String>();
        @Nullable
        private String clientReference;
        @Nullable
        private Boolean flashMessage;
        @Nullable
        private Integer maxNumberOfMessageParts;
        @Nullable
        private String dltPrincipalEntity;
        @Nullable
        private String dltTemplateId;
        @Nullable
        private Integer senderTon;
        @Nullable
        private Integer senderNpi;

        Builder() {
            if (!(this instanceof MtBatchBinarySmsCreate.Builder)) {
                throw new UnsupportedOperationException("Use: new MtBatchBinarySmsCreate.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final MtBatchBinarySmsCreate.Builder using(MtBatchSmsCreate instance) {
            MtBatchBinarySmsCreateImpl.requireNonNull(instance, "instance");
            this.from(instance);
            return (MtBatchBinarySmsCreate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MtBatchBinarySmsCreate.Builder using(MtBatchBinarySmsCreate instance) {
            MtBatchBinarySmsCreateImpl.requireNonNull(instance, "instance");
            this.from(instance);
            return (MtBatchBinarySmsCreate.Builder)this;
        }

        private void from(Object object) {
            MtBatchSmsCreate instance;
            if (object instanceof MtBatchSmsCreate) {
                ReportType deliveryReportValue;
                Boolean feedbackEnabledValue;
                OffsetDateTime sendAtValue;
                URI callbackUrlValue;
                Integer senderNpiValue;
                String dltPrincipalEntityValue;
                Integer senderTonValue;
                String dltTemplateIdValue;
                OffsetDateTime expireAtValue;
                Boolean flashMessageValue;
                instance = (MtBatchSmsCreate)object;
                Integer maxNumberOfMessagePartsValue = instance.maxNumberOfMessageParts();
                if (maxNumberOfMessagePartsValue != null) {
                    this.maxNumberOfMessageParts(maxNumberOfMessagePartsValue);
                }
                if ((flashMessageValue = instance.flashMessage()) != null) {
                    this.flashMessage(flashMessageValue);
                }
                if ((expireAtValue = instance.expireAt()) != null) {
                    this.expireAt(expireAtValue);
                }
                if ((dltTemplateIdValue = instance.dltTemplateId()) != null) {
                    this.dltTemplateId(dltTemplateIdValue);
                }
                this.addAllTags(instance.tags());
                String senderValue = instance.sender();
                if (senderValue != null) {
                    this.sender(senderValue);
                }
                if ((senderTonValue = instance.senderTon()) != null) {
                    this.senderTon(senderTonValue);
                }
                this.addAllRecipients(instance.recipients());
                String clientReferenceValue = instance.clientReference();
                if (clientReferenceValue != null) {
                    this.clientReference(clientReferenceValue);
                }
                if ((dltPrincipalEntityValue = instance.dltPrincipalEntity()) != null) {
                    this.dltPrincipalEntity(dltPrincipalEntityValue);
                }
                if ((senderNpiValue = instance.senderNpi()) != null) {
                    this.senderNpi(senderNpiValue);
                }
                if ((callbackUrlValue = instance.callbackUrl()) != null) {
                    this.callbackUrl(callbackUrlValue);
                }
                if ((sendAtValue = instance.sendAt()) != null) {
                    this.sendAt(sendAtValue);
                }
                if ((feedbackEnabledValue = instance.feedbackEnabled()) != null) {
                    this.feedbackEnabled(feedbackEnabledValue);
                }
                if ((deliveryReportValue = instance.deliveryReport()) != null) {
                    this.deliveryReport(deliveryReportValue);
                }
            }
            if (object instanceof MtBatchBinarySmsCreate) {
                instance = (MtBatchBinarySmsCreate)object;
                this.body(((MtBatchBinarySmsCreate)instance).body());
                this.udh(((MtBatchBinarySmsCreate)instance).udh());
            }
        }

        @JsonProperty(value="udh")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsCreate.Builder udh(byte ... udh) {
            this.udh = (byte[])udh.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (MtBatchBinarySmsCreate.Builder)this;
        }

        @JsonProperty(value="body")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsCreate.Builder body(byte ... body) {
            this.body = (byte[])body.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (MtBatchBinarySmsCreate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MtBatchBinarySmsCreate.Builder addRecipient(String element) {
            this.recipients.add((String)MtBatchBinarySmsCreateImpl.requireNonNull(element, "recipients element"));
            return (MtBatchBinarySmsCreate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MtBatchBinarySmsCreate.Builder addRecipient(String ... elements) {
            for (String element : elements) {
                this.recipients.add((String)MtBatchBinarySmsCreateImpl.requireNonNull(element, "recipients element"));
            }
            return (MtBatchBinarySmsCreate.Builder)this;
        }

        @JsonProperty(value="to")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsCreate.Builder recipients(Iterable<String> elements) {
            this.recipients.clear();
            return this.addAllRecipients(elements);
        }

        @CanIgnoreReturnValue
        public final MtBatchBinarySmsCreate.Builder addAllRecipients(Iterable<String> elements) {
            for (String element : elements) {
                this.recipients.add((String)MtBatchBinarySmsCreateImpl.requireNonNull(element, "recipients element"));
            }
            return (MtBatchBinarySmsCreate.Builder)this;
        }

        @JsonProperty(value="from")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsCreate.Builder sender(@Nullable String sender) {
            this.sender = sender;
            return (MtBatchBinarySmsCreate.Builder)this;
        }

        @JsonProperty(value="delivery_report")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsCreate.Builder deliveryReport(@Nullable ReportType deliveryReport) {
            this.deliveryReport = deliveryReport;
            return (MtBatchBinarySmsCreate.Builder)this;
        }

        @JsonProperty(value="send_at")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsCreate.Builder sendAt(@Nullable OffsetDateTime sendAt) {
            this.sendAt = sendAt;
            return (MtBatchBinarySmsCreate.Builder)this;
        }

        @JsonProperty(value="expire_at")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsCreate.Builder expireAt(@Nullable OffsetDateTime expireAt) {
            this.expireAt = expireAt;
            return (MtBatchBinarySmsCreate.Builder)this;
        }

        @JsonProperty(value="callback_url")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsCreate.Builder callbackUrl(@Nullable URI callbackUrl) {
            this.callbackUrl = callbackUrl;
            return (MtBatchBinarySmsCreate.Builder)this;
        }

        @JsonProperty(value="feedback_enabled")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsCreate.Builder feedbackEnabled(@Nullable Boolean feedbackEnabled) {
            this.feedbackEnabled = feedbackEnabled;
            return (MtBatchBinarySmsCreate.Builder)this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsCreate.Builder addTag(String element) {
            this.tags.add((String)MtBatchBinarySmsCreateImpl.requireNonNull(element, "tags element"));
            return (MtBatchBinarySmsCreate.Builder)this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsCreate.Builder addTag(String ... elements) {
            for (String element : elements) {
                this.tags.add((String)MtBatchBinarySmsCreateImpl.requireNonNull(element, "tags element"));
            }
            return (MtBatchBinarySmsCreate.Builder)this;
        }

        @JsonProperty(value="tags")
        @Deprecated
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsCreate.Builder tags(Iterable<String> elements) {
            this.tags.clear();
            return this.addAllTags(elements);
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsCreate.Builder addAllTags(Iterable<String> elements) {
            for (String element : elements) {
                this.tags.add((String)MtBatchBinarySmsCreateImpl.requireNonNull(element, "tags element"));
            }
            return (MtBatchBinarySmsCreate.Builder)this;
        }

        @JsonProperty(value="client_reference")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsCreate.Builder clientReference(@Nullable String clientReference) {
            this.clientReference = clientReference;
            return (MtBatchBinarySmsCreate.Builder)this;
        }

        @JsonProperty(value="flash_message")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsCreate.Builder flashMessage(@Nullable Boolean flashMessage) {
            this.flashMessage = flashMessage;
            return (MtBatchBinarySmsCreate.Builder)this;
        }

        @JsonProperty(value="max_number_of_message_parts")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsCreate.Builder maxNumberOfMessageParts(@Nullable Integer maxNumberOfMessageParts) {
            this.maxNumberOfMessageParts = maxNumberOfMessageParts;
            return (MtBatchBinarySmsCreate.Builder)this;
        }

        @JsonProperty(value="dlt_principal_entity_id")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsCreate.Builder dltPrincipalEntity(@Nullable String dltPrincipalEntity) {
            this.dltPrincipalEntity = dltPrincipalEntity;
            return (MtBatchBinarySmsCreate.Builder)this;
        }

        @JsonProperty(value="dlt_template_id")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsCreate.Builder dltTemplateId(@Nullable String dltTemplateId) {
            this.dltTemplateId = dltTemplateId;
            return (MtBatchBinarySmsCreate.Builder)this;
        }

        @JsonProperty(value="from_ton")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsCreate.Builder senderTon(@Nullable Integer senderTon) {
            this.senderTon = senderTon;
            return (MtBatchBinarySmsCreate.Builder)this;
        }

        @JsonProperty(value="from_npi")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsCreate.Builder senderNpi(@Nullable Integer senderNpi) {
            this.senderNpi = senderNpi;
            return (MtBatchBinarySmsCreate.Builder)this;
        }

        public MtBatchBinarySmsCreate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return MtBatchBinarySmsCreateImpl.validate(new MtBatchBinarySmsCreateImpl(this.udh, this.body, MtBatchBinarySmsCreateImpl.createUnmodifiableList(true, this.recipients), this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.feedbackEnabled, MtBatchBinarySmsCreateImpl.createUnmodifiableSet(this.tags), this.clientReference, this.flashMessage, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("udh");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("body");
            }
            return "Cannot build MtBatchBinarySmsCreate, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends MtBatchBinarySmsCreate {
        @Nullable
        byte[] udh;
        @Nullable
        byte[] body;
        List<String> recipients = Collections.emptyList();
        @Nullable
        String sender;
        @Nullable
        ReportType deliveryReport;
        @Nullable
        OffsetDateTime sendAt;
        @Nullable
        OffsetDateTime expireAt;
        @Nullable
        URI callbackUrl;
        @Nullable
        Boolean feedbackEnabled;
        Set<String> tags = Collections.emptySet();
        @Nullable
        String clientReference;
        @Nullable
        Boolean flashMessage;
        @Nullable
        Integer maxNumberOfMessageParts;
        @Nullable
        String dltPrincipalEntity;
        @Nullable
        String dltTemplateId;
        @Nullable
        Integer senderTon;
        @Nullable
        Integer senderNpi;

        Json() {
        }

        @JsonProperty(value="udh")
        @JsonSerialize(using=JacksonUtils.ByteArrayHexSerializer.class)
        @JsonDeserialize(using=JacksonUtils.ByteArrayHexDeserializer.class)
        public void setUdh(byte[] udh) {
            this.udh = udh;
        }

        @JsonProperty(value="body")
        public void setBody(byte[] body) {
            this.body = body;
        }

        @JsonProperty(value="to")
        public void setRecipients(List<String> recipients) {
            this.recipients = recipients;
        }

        @JsonProperty(value="from")
        public void setSender(@Nullable String sender) {
            this.sender = sender;
        }

        @JsonProperty(value="delivery_report")
        public void setDeliveryReport(@Nullable ReportType deliveryReport) {
            this.deliveryReport = deliveryReport;
        }

        @JsonProperty(value="send_at")
        public void setSendAt(@Nullable OffsetDateTime sendAt) {
            this.sendAt = sendAt;
        }

        @JsonProperty(value="expire_at")
        public void setExpireAt(@Nullable OffsetDateTime expireAt) {
            this.expireAt = expireAt;
        }

        @JsonProperty(value="callback_url")
        public void setCallbackUrl(@Nullable URI callbackUrl) {
            this.callbackUrl = callbackUrl;
        }

        @JsonProperty(value="feedback_enabled")
        public void setFeedbackEnabled(@Nullable Boolean feedbackEnabled) {
            this.feedbackEnabled = feedbackEnabled;
        }

        @JsonProperty(value="tags")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setTags(Set<String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="client_reference")
        public void setClientReference(@Nullable String clientReference) {
            this.clientReference = clientReference;
        }

        @JsonProperty(value="flash_message")
        public void setFlashMessage(@Nullable Boolean flashMessage) {
            this.flashMessage = flashMessage;
        }

        @JsonProperty(value="max_number_of_message_parts")
        public void setMaxNumberOfMessageParts(@Nullable Integer maxNumberOfMessageParts) {
            this.maxNumberOfMessageParts = maxNumberOfMessageParts;
        }

        @JsonProperty(value="dlt_principal_entity_id")
        public void setDltPrincipalEntity(@Nullable String dltPrincipalEntity) {
            this.dltPrincipalEntity = dltPrincipalEntity;
        }

        @JsonProperty(value="dlt_template_id")
        public void setDltTemplateId(@Nullable String dltTemplateId) {
            this.dltTemplateId = dltTemplateId;
        }

        @JsonProperty(value="from_ton")
        public void setSenderTon(@Nullable Integer senderTon) {
            this.senderTon = senderTon;
        }

        @JsonProperty(value="from_npi")
        public void setSenderNpi(@Nullable Integer senderNpi) {
            this.senderNpi = senderNpi;
        }

        @Override
        public byte[] udh() {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] body() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> recipients() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String sender() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReportType deliveryReport() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OffsetDateTime sendAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OffsetDateTime expireAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI callbackUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean feedbackEnabled() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> tags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String clientReference() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean flashMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer maxNumberOfMessageParts() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String dltPrincipalEntity() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String dltTemplateId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer senderTon() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer senderNpi() {
            throw new UnsupportedOperationException();
        }
    }
}

