/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sinch.xms.api.BatchId;
import com.sinch.xms.api.JacksonUtils;
import com.sinch.xms.api.MtBatchBinarySmsResult;
import com.sinch.xms.api.MtBatchSmsResult;
import com.sinch.xms.api.ReportType;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
final class MtBatchBinarySmsResultImpl
extends MtBatchBinarySmsResult {
    private final byte[] udh;
    private final byte[] body;
    private final BatchId id;
    private final List<String> recipients;
    @Nullable
    private final String sender;
    private final ReportType deliveryReport;
    @Nullable
    private final URI callbackUrl;
    @Nullable
    private final OffsetDateTime sendAt;
    @Nullable
    private final OffsetDateTime expireAt;
    @Nullable
    private final OffsetDateTime createdAt;
    @Nullable
    private final OffsetDateTime modifiedAt;
    private final boolean canceled;
    @Nullable
    private final String clientReference;
    private final boolean flashMessage;
    @Nullable
    private final Boolean feedbackEnabled;
    @Nullable
    private final Integer maxNumberOfMessageParts;
    @Nullable
    private final String dltPrincipalEntity;
    @Nullable
    private final String dltTemplateId;
    @Nullable
    private final Integer senderTon;
    @Nullable
    private final Integer senderNpi;

    private MtBatchBinarySmsResultImpl(byte[] udh, byte[] body, BatchId id, List<String> recipients, @Nullable String sender, ReportType deliveryReport, @Nullable URI callbackUrl, @Nullable OffsetDateTime sendAt, @Nullable OffsetDateTime expireAt, @Nullable OffsetDateTime createdAt, @Nullable OffsetDateTime modifiedAt, boolean canceled, @Nullable String clientReference, boolean flashMessage, @Nullable Boolean feedbackEnabled, @Nullable Integer maxNumberOfMessageParts, @Nullable String dltPrincipalEntity, @Nullable String dltTemplateId, @Nullable Integer senderTon, @Nullable Integer senderNpi) {
        this.udh = udh;
        this.body = body;
        this.id = id;
        this.recipients = recipients;
        this.sender = sender;
        this.deliveryReport = deliveryReport;
        this.callbackUrl = callbackUrl;
        this.sendAt = sendAt;
        this.expireAt = expireAt;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.canceled = canceled;
        this.clientReference = clientReference;
        this.flashMessage = flashMessage;
        this.feedbackEnabled = feedbackEnabled;
        this.maxNumberOfMessageParts = maxNumberOfMessageParts;
        this.dltPrincipalEntity = dltPrincipalEntity;
        this.dltTemplateId = dltTemplateId;
        this.senderTon = senderTon;
        this.senderNpi = senderNpi;
    }

    @Override
    @JsonProperty(value="udh")
    @JsonSerialize(using=JacksonUtils.ByteArrayHexSerializer.class)
    @JsonDeserialize(using=JacksonUtils.ByteArrayHexDeserializer.class)
    public byte[] udh() {
        return (byte[])this.udh.clone();
    }

    @Override
    @JsonProperty(value="body")
    public byte[] body() {
        return (byte[])this.body.clone();
    }

    @Override
    @JsonProperty(value="id")
    public BatchId id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="to")
    public List<String> recipients() {
        return this.recipients;
    }

    @Override
    @JsonProperty(value="from")
    @Nullable
    public String sender() {
        return this.sender;
    }

    @Override
    @JsonProperty(value="delivery_report")
    public ReportType deliveryReport() {
        return this.deliveryReport;
    }

    @Override
    @JsonProperty(value="callbackUrl")
    @Nullable
    public URI callbackUrl() {
        return this.callbackUrl;
    }

    @Override
    @JsonProperty(value="send_at")
    @Nullable
    public OffsetDateTime sendAt() {
        return this.sendAt;
    }

    @Override
    @JsonProperty(value="expire_at")
    @Nullable
    public OffsetDateTime expireAt() {
        return this.expireAt;
    }

    @Override
    @JsonProperty(value="created_at")
    @Nullable
    public OffsetDateTime createdAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="modified_at")
    @Nullable
    public OffsetDateTime modifiedAt() {
        return this.modifiedAt;
    }

    @Override
    @JsonProperty(value="canceled")
    public boolean canceled() {
        return this.canceled;
    }

    @Override
    @JsonProperty(value="client_reference")
    @Nullable
    public String clientReference() {
        return this.clientReference;
    }

    @Override
    @JsonProperty(value="flash_message")
    public boolean flashMessage() {
        return this.flashMessage;
    }

    @Override
    @JsonProperty(value="feedback_enabled")
    @Nullable
    public Boolean feedbackEnabled() {
        return this.feedbackEnabled;
    }

    @Override
    @JsonProperty(value="max_number_of_message_parts")
    @Nullable
    public Integer maxNumberOfMessageParts() {
        return this.maxNumberOfMessageParts;
    }

    @Override
    @JsonProperty(value="dlt_principal_entity_id")
    @Nullable
    public String dltPrincipalEntity() {
        return this.dltPrincipalEntity;
    }

    @Override
    @JsonProperty(value="dlt_template_id")
    @Nullable
    public String dltTemplateId() {
        return this.dltTemplateId;
    }

    @Override
    @JsonProperty(value="from_ton")
    @Nullable
    public Integer senderTon() {
        return this.senderTon;
    }

    @Override
    @JsonProperty(value="from_npi")
    @Nullable
    public Integer senderNpi() {
        return this.senderNpi;
    }

    public final MtBatchBinarySmsResultImpl withUdh(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new MtBatchBinarySmsResultImpl(newValue, this.body, this.id, this.recipients, this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchBinarySmsResultImpl withBody(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new MtBatchBinarySmsResultImpl(this.udh, newValue, this.id, this.recipients, this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchBinarySmsResultImpl withId(BatchId value) {
        if (this.id == value) {
            return this;
        }
        BatchId newValue = MtBatchBinarySmsResultImpl.requireNonNull(value, "id");
        return new MtBatchBinarySmsResultImpl(this.udh, this.body, newValue, this.recipients, this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchBinarySmsResultImpl withRecipients(String ... elements) {
        List<String> newValue = MtBatchBinarySmsResultImpl.createUnmodifiableList(false, MtBatchBinarySmsResultImpl.createSafeList(Arrays.asList(elements), true, false));
        return new MtBatchBinarySmsResultImpl(this.udh, this.body, this.id, newValue, this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchBinarySmsResultImpl withRecipients(Iterable<String> elements) {
        if (this.recipients == elements) {
            return this;
        }
        List<String> newValue = MtBatchBinarySmsResultImpl.createUnmodifiableList(false, MtBatchBinarySmsResultImpl.createSafeList(elements, true, false));
        return new MtBatchBinarySmsResultImpl(this.udh, this.body, this.id, newValue, this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchBinarySmsResultImpl withSender(@Nullable String value) {
        if (MtBatchBinarySmsResultImpl.equals(this.sender, value)) {
            return this;
        }
        return new MtBatchBinarySmsResultImpl(this.udh, this.body, this.id, this.recipients, value, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchBinarySmsResultImpl withDeliveryReport(ReportType value) {
        if (this.deliveryReport == value) {
            return this;
        }
        ReportType newValue = MtBatchBinarySmsResultImpl.requireNonNull(value, "deliveryReport");
        return new MtBatchBinarySmsResultImpl(this.udh, this.body, this.id, this.recipients, this.sender, newValue, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchBinarySmsResultImpl withCallbackUrl(@Nullable URI value) {
        if (this.callbackUrl == value) {
            return this;
        }
        return new MtBatchBinarySmsResultImpl(this.udh, this.body, this.id, this.recipients, this.sender, this.deliveryReport, value, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchBinarySmsResultImpl withSendAt(@Nullable OffsetDateTime value) {
        if (this.sendAt == value) {
            return this;
        }
        return new MtBatchBinarySmsResultImpl(this.udh, this.body, this.id, this.recipients, this.sender, this.deliveryReport, this.callbackUrl, value, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchBinarySmsResultImpl withExpireAt(@Nullable OffsetDateTime value) {
        if (this.expireAt == value) {
            return this;
        }
        return new MtBatchBinarySmsResultImpl(this.udh, this.body, this.id, this.recipients, this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, value, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchBinarySmsResultImpl withCreatedAt(@Nullable OffsetDateTime value) {
        if (this.createdAt == value) {
            return this;
        }
        return new MtBatchBinarySmsResultImpl(this.udh, this.body, this.id, this.recipients, this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, value, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchBinarySmsResultImpl withModifiedAt(@Nullable OffsetDateTime value) {
        if (this.modifiedAt == value) {
            return this;
        }
        return new MtBatchBinarySmsResultImpl(this.udh, this.body, this.id, this.recipients, this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, value, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchBinarySmsResultImpl withCanceled(boolean value) {
        if (this.canceled == value) {
            return this;
        }
        return new MtBatchBinarySmsResultImpl(this.udh, this.body, this.id, this.recipients, this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, value, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchBinarySmsResultImpl withClientReference(@Nullable String value) {
        if (MtBatchBinarySmsResultImpl.equals(this.clientReference, value)) {
            return this;
        }
        return new MtBatchBinarySmsResultImpl(this.udh, this.body, this.id, this.recipients, this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, value, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchBinarySmsResultImpl withFlashMessage(boolean value) {
        if (this.flashMessage == value) {
            return this;
        }
        return new MtBatchBinarySmsResultImpl(this.udh, this.body, this.id, this.recipients, this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, value, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchBinarySmsResultImpl withFeedbackEnabled(@Nullable Boolean value) {
        if (MtBatchBinarySmsResultImpl.equals(this.feedbackEnabled, value)) {
            return this;
        }
        return new MtBatchBinarySmsResultImpl(this.udh, this.body, this.id, this.recipients, this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, value, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchBinarySmsResultImpl withMaxNumberOfMessageParts(@Nullable Integer value) {
        if (MtBatchBinarySmsResultImpl.equals(this.maxNumberOfMessageParts, value)) {
            return this;
        }
        return new MtBatchBinarySmsResultImpl(this.udh, this.body, this.id, this.recipients, this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, value, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchBinarySmsResultImpl withDltPrincipalEntity(@Nullable String value) {
        if (MtBatchBinarySmsResultImpl.equals(this.dltPrincipalEntity, value)) {
            return this;
        }
        return new MtBatchBinarySmsResultImpl(this.udh, this.body, this.id, this.recipients, this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, value, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchBinarySmsResultImpl withDltTemplateId(@Nullable String value) {
        if (MtBatchBinarySmsResultImpl.equals(this.dltTemplateId, value)) {
            return this;
        }
        return new MtBatchBinarySmsResultImpl(this.udh, this.body, this.id, this.recipients, this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, value, this.senderTon, this.senderNpi);
    }

    public final MtBatchBinarySmsResultImpl withSenderTon(@Nullable Integer value) {
        if (MtBatchBinarySmsResultImpl.equals(this.senderTon, value)) {
            return this;
        }
        return new MtBatchBinarySmsResultImpl(this.udh, this.body, this.id, this.recipients, this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, value, this.senderNpi);
    }

    public final MtBatchBinarySmsResultImpl withSenderNpi(@Nullable Integer value) {
        if (MtBatchBinarySmsResultImpl.equals(this.senderNpi, value)) {
            return this;
        }
        return new MtBatchBinarySmsResultImpl(this.udh, this.body, this.id, this.recipients, this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof MtBatchBinarySmsResultImpl && this.equalTo((MtBatchBinarySmsResultImpl)another);
    }

    private boolean equalTo(MtBatchBinarySmsResultImpl another) {
        return Arrays.equals(this.udh, another.udh) && Arrays.equals(this.body, another.body) && this.id.equals(another.id) && this.recipients.equals(another.recipients) && MtBatchBinarySmsResultImpl.equals(this.sender, another.sender) && this.deliveryReport.equals(another.deliveryReport) && MtBatchBinarySmsResultImpl.equals(this.callbackUrl, another.callbackUrl) && MtBatchBinarySmsResultImpl.equals(this.sendAt, another.sendAt) && MtBatchBinarySmsResultImpl.equals(this.expireAt, another.expireAt) && MtBatchBinarySmsResultImpl.equals(this.createdAt, another.createdAt) && MtBatchBinarySmsResultImpl.equals(this.modifiedAt, another.modifiedAt) && this.canceled == another.canceled && MtBatchBinarySmsResultImpl.equals(this.clientReference, another.clientReference) && this.flashMessage == another.flashMessage && MtBatchBinarySmsResultImpl.equals(this.feedbackEnabled, another.feedbackEnabled) && MtBatchBinarySmsResultImpl.equals(this.maxNumberOfMessageParts, another.maxNumberOfMessageParts) && MtBatchBinarySmsResultImpl.equals(this.dltPrincipalEntity, another.dltPrincipalEntity) && MtBatchBinarySmsResultImpl.equals(this.dltTemplateId, another.dltTemplateId) && MtBatchBinarySmsResultImpl.equals(this.senderTon, another.senderTon) && MtBatchBinarySmsResultImpl.equals(this.senderNpi, another.senderNpi);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Arrays.hashCode(this.udh);
        h = h * 17 + Arrays.hashCode(this.body);
        h = h * 17 + this.id.hashCode();
        h = h * 17 + this.recipients.hashCode();
        h = h * 17 + MtBatchBinarySmsResultImpl.hashCode(this.sender);
        h = h * 17 + this.deliveryReport.hashCode();
        h = h * 17 + MtBatchBinarySmsResultImpl.hashCode(this.callbackUrl);
        h = h * 17 + MtBatchBinarySmsResultImpl.hashCode(this.sendAt);
        h = h * 17 + MtBatchBinarySmsResultImpl.hashCode(this.expireAt);
        h = h * 17 + MtBatchBinarySmsResultImpl.hashCode(this.createdAt);
        h = h * 17 + MtBatchBinarySmsResultImpl.hashCode(this.modifiedAt);
        h = h * 17 + (this.canceled ? 1231 : 1237);
        h = h * 17 + MtBatchBinarySmsResultImpl.hashCode(this.clientReference);
        h = h * 17 + (this.flashMessage ? 1231 : 1237);
        h = h * 17 + MtBatchBinarySmsResultImpl.hashCode(this.feedbackEnabled);
        h = h * 17 + MtBatchBinarySmsResultImpl.hashCode(this.maxNumberOfMessageParts);
        h = h * 17 + MtBatchBinarySmsResultImpl.hashCode(this.dltPrincipalEntity);
        h = h * 17 + MtBatchBinarySmsResultImpl.hashCode(this.dltTemplateId);
        h = h * 17 + MtBatchBinarySmsResultImpl.hashCode(this.senderTon);
        h = h * 17 + MtBatchBinarySmsResultImpl.hashCode(this.senderNpi);
        return h;
    }

    public String toString() {
        return "MtBatchBinarySmsResult{udh=" + Arrays.toString(this.udh) + ", body=" + Arrays.toString(this.body) + ", id=" + this.id + ", recipients=" + this.recipients + ", sender=" + this.sender + ", deliveryReport=" + this.deliveryReport + ", callbackUrl=" + this.callbackUrl + ", sendAt=" + this.sendAt + ", expireAt=" + this.expireAt + ", createdAt=" + this.createdAt + ", modifiedAt=" + this.modifiedAt + ", canceled=" + this.canceled + ", clientReference=" + this.clientReference + ", flashMessage=" + this.flashMessage + ", feedbackEnabled=" + this.feedbackEnabled + ", maxNumberOfMessageParts=" + this.maxNumberOfMessageParts + ", dltPrincipalEntity=" + this.dltPrincipalEntity + ", dltTemplateId=" + this.dltTemplateId + ", senderTon=" + this.senderTon + ", senderNpi=" + this.senderNpi + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static MtBatchBinarySmsResultImpl fromJson(Json json) {
        MtBatchBinarySmsResult.Builder builder = new MtBatchBinarySmsResult.Builder();
        if (json.udh != null) {
            builder.udh(json.udh);
        }
        if (json.body != null) {
            builder.body(json.body);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.recipients != null) {
            builder.addAllRecipients(json.recipients);
        }
        if (json.sender != null) {
            builder.sender(json.sender);
        }
        if (json.deliveryReport != null) {
            builder.deliveryReport(json.deliveryReport);
        }
        if (json.callbackUrl != null) {
            builder.callbackUrl(json.callbackUrl);
        }
        if (json.sendAt != null) {
            builder.sendAt(json.sendAt);
        }
        if (json.expireAt != null) {
            builder.expireAt(json.expireAt);
        }
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.modifiedAt != null) {
            builder.modifiedAt(json.modifiedAt);
        }
        if (json.canceledIsSet) {
            builder.canceled(json.canceled);
        }
        if (json.clientReference != null) {
            builder.clientReference(json.clientReference);
        }
        if (json.flashMessageIsSet) {
            builder.flashMessage(json.flashMessage);
        }
        if (json.feedbackEnabled != null) {
            builder.feedbackEnabled(json.feedbackEnabled);
        }
        if (json.maxNumberOfMessageParts != null) {
            builder.maxNumberOfMessageParts(json.maxNumberOfMessageParts);
        }
        if (json.dltPrincipalEntity != null) {
            builder.dltPrincipalEntity(json.dltPrincipalEntity);
        }
        if (json.dltTemplateId != null) {
            builder.dltTemplateId(json.dltTemplateId);
        }
        if (json.senderTon != null) {
            builder.senderTon(json.senderTon);
        }
        if (json.senderNpi != null) {
            builder.senderNpi(json.senderNpi);
        }
        return (MtBatchBinarySmsResultImpl)builder.build();
    }

    public static MtBatchBinarySmsResult copyOf(MtBatchBinarySmsResult instance) {
        if (instance instanceof MtBatchBinarySmsResultImpl) {
            return (MtBatchBinarySmsResultImpl)instance;
        }
        return new MtBatchBinarySmsResult.Builder().using(instance).build();
    }

    private static <T> T requireNonNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    private static int hashCode(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    private static boolean equals(Object left, Object right) {
        return left == right || left != null && left.equals(right);
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                MtBatchBinarySmsResultImpl.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    static class Builder {
        private static final long INIT_BIT_UDH = 1L;
        private static final long INIT_BIT_BODY = 2L;
        private static final long INIT_BIT_ID = 4L;
        private static final long INIT_BIT_DELIVERY_REPORT = 8L;
        private static final long INIT_BIT_CANCELED = 16L;
        private static final long INIT_BIT_FLASH_MESSAGE = 32L;
        private long initBits = 63L;
        @Nullable
        private byte[] udh;
        @Nullable
        private byte[] body;
        @Nullable
        private BatchId id;
        private List<String> recipients = new ArrayList<String>();
        @Nullable
        private String sender;
        @Nullable
        private ReportType deliveryReport;
        @Nullable
        private URI callbackUrl;
        @Nullable
        private OffsetDateTime sendAt;
        @Nullable
        private OffsetDateTime expireAt;
        @Nullable
        private OffsetDateTime createdAt;
        @Nullable
        private OffsetDateTime modifiedAt;
        private boolean canceled;
        @Nullable
        private String clientReference;
        private boolean flashMessage;
        @Nullable
        private Boolean feedbackEnabled;
        @Nullable
        private Integer maxNumberOfMessageParts;
        @Nullable
        private String dltPrincipalEntity;
        @Nullable
        private String dltTemplateId;
        @Nullable
        private Integer senderTon;
        @Nullable
        private Integer senderNpi;

        Builder() {
            if (!(this instanceof MtBatchBinarySmsResult.Builder)) {
                throw new UnsupportedOperationException("Use: new MtBatchBinarySmsResult.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final MtBatchBinarySmsResult.Builder using(MtBatchBinarySmsResult instance) {
            MtBatchBinarySmsResultImpl.requireNonNull(instance, "instance");
            this.from(instance);
            return (MtBatchBinarySmsResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MtBatchBinarySmsResult.Builder using(MtBatchSmsResult instance) {
            MtBatchBinarySmsResultImpl.requireNonNull(instance, "instance");
            this.from(instance);
            return (MtBatchBinarySmsResult.Builder)this;
        }

        private void from(Object object) {
            MtBatchSmsResult instance;
            if (object instanceof MtBatchBinarySmsResult) {
                instance = (MtBatchBinarySmsResult)object;
                this.body(((MtBatchBinarySmsResult)instance).body());
                this.udh(((MtBatchBinarySmsResult)instance).udh());
            }
            if (object instanceof MtBatchSmsResult) {
                Boolean feedbackEnabledValue;
                URI callbackUrlValue;
                Integer senderNpiValue;
                String dltPrincipalEntityValue;
                Integer senderTonValue;
                OffsetDateTime createdAtValue;
                String dltTemplateIdValue;
                OffsetDateTime expireAtValue;
                instance = (MtBatchSmsResult)object;
                Integer maxNumberOfMessagePartsValue = instance.maxNumberOfMessageParts();
                if (maxNumberOfMessagePartsValue != null) {
                    this.maxNumberOfMessageParts(maxNumberOfMessagePartsValue);
                }
                this.flashMessage(instance.flashMessage());
                OffsetDateTime modifiedAtValue = instance.modifiedAt();
                if (modifiedAtValue != null) {
                    this.modifiedAt(modifiedAtValue);
                }
                if ((expireAtValue = instance.expireAt()) != null) {
                    this.expireAt(expireAtValue);
                }
                if ((dltTemplateIdValue = instance.dltTemplateId()) != null) {
                    this.dltTemplateId(dltTemplateIdValue);
                }
                if ((createdAtValue = instance.createdAt()) != null) {
                    this.createdAt(createdAtValue);
                }
                this.canceled(instance.canceled());
                String senderValue = instance.sender();
                if (senderValue != null) {
                    this.sender(senderValue);
                }
                if ((senderTonValue = instance.senderTon()) != null) {
                    this.senderTon(senderTonValue);
                }
                this.addAllRecipients(instance.recipients());
                String clientReferenceValue = instance.clientReference();
                if (clientReferenceValue != null) {
                    this.clientReference(clientReferenceValue);
                }
                if ((dltPrincipalEntityValue = instance.dltPrincipalEntity()) != null) {
                    this.dltPrincipalEntity(dltPrincipalEntityValue);
                }
                if ((senderNpiValue = instance.senderNpi()) != null) {
                    this.senderNpi(senderNpiValue);
                }
                if ((callbackUrlValue = instance.callbackUrl()) != null) {
                    this.callbackUrl(callbackUrlValue);
                }
                this.id(instance.id());
                OffsetDateTime sendAtValue = instance.sendAt();
                if (sendAtValue != null) {
                    this.sendAt(sendAtValue);
                }
                if ((feedbackEnabledValue = instance.feedbackEnabled()) != null) {
                    this.feedbackEnabled(feedbackEnabledValue);
                }
                this.deliveryReport(instance.deliveryReport());
            }
        }

        @JsonProperty(value="udh")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsResult.Builder udh(byte ... udh) {
            this.udh = (byte[])udh.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (MtBatchBinarySmsResult.Builder)this;
        }

        @JsonProperty(value="body")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsResult.Builder body(byte ... body) {
            this.body = (byte[])body.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (MtBatchBinarySmsResult.Builder)this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsResult.Builder id(BatchId id) {
            this.id = (BatchId)MtBatchBinarySmsResultImpl.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return (MtBatchBinarySmsResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MtBatchBinarySmsResult.Builder addRecipient(String element) {
            this.recipients.add((String)MtBatchBinarySmsResultImpl.requireNonNull(element, "recipients element"));
            return (MtBatchBinarySmsResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MtBatchBinarySmsResult.Builder addRecipient(String ... elements) {
            for (String element : elements) {
                this.recipients.add((String)MtBatchBinarySmsResultImpl.requireNonNull(element, "recipients element"));
            }
            return (MtBatchBinarySmsResult.Builder)this;
        }

        @JsonProperty(value="to")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsResult.Builder recipients(Iterable<String> elements) {
            this.recipients.clear();
            return this.addAllRecipients(elements);
        }

        @CanIgnoreReturnValue
        public final MtBatchBinarySmsResult.Builder addAllRecipients(Iterable<String> elements) {
            for (String element : elements) {
                this.recipients.add((String)MtBatchBinarySmsResultImpl.requireNonNull(element, "recipients element"));
            }
            return (MtBatchBinarySmsResult.Builder)this;
        }

        @JsonProperty(value="from")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsResult.Builder sender(@Nullable String sender) {
            this.sender = sender;
            return (MtBatchBinarySmsResult.Builder)this;
        }

        @JsonProperty(value="delivery_report")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsResult.Builder deliveryReport(ReportType deliveryReport) {
            this.deliveryReport = (ReportType)MtBatchBinarySmsResultImpl.requireNonNull(deliveryReport, "deliveryReport");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return (MtBatchBinarySmsResult.Builder)this;
        }

        @JsonProperty(value="callbackUrl")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsResult.Builder callbackUrl(@Nullable URI callbackUrl) {
            this.callbackUrl = callbackUrl;
            return (MtBatchBinarySmsResult.Builder)this;
        }

        @JsonProperty(value="send_at")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsResult.Builder sendAt(@Nullable OffsetDateTime sendAt) {
            this.sendAt = sendAt;
            return (MtBatchBinarySmsResult.Builder)this;
        }

        @JsonProperty(value="expire_at")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsResult.Builder expireAt(@Nullable OffsetDateTime expireAt) {
            this.expireAt = expireAt;
            return (MtBatchBinarySmsResult.Builder)this;
        }

        @JsonProperty(value="created_at")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsResult.Builder createdAt(@Nullable OffsetDateTime createdAt) {
            this.createdAt = createdAt;
            return (MtBatchBinarySmsResult.Builder)this;
        }

        @JsonProperty(value="modified_at")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsResult.Builder modifiedAt(@Nullable OffsetDateTime modifiedAt) {
            this.modifiedAt = modifiedAt;
            return (MtBatchBinarySmsResult.Builder)this;
        }

        @JsonProperty(value="canceled")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsResult.Builder canceled(boolean canceled) {
            this.canceled = canceled;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return (MtBatchBinarySmsResult.Builder)this;
        }

        @JsonProperty(value="client_reference")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsResult.Builder clientReference(@Nullable String clientReference) {
            this.clientReference = clientReference;
            return (MtBatchBinarySmsResult.Builder)this;
        }

        @JsonProperty(value="flash_message")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsResult.Builder flashMessage(boolean flashMessage) {
            this.flashMessage = flashMessage;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return (MtBatchBinarySmsResult.Builder)this;
        }

        @JsonProperty(value="feedback_enabled")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsResult.Builder feedbackEnabled(@Nullable Boolean feedbackEnabled) {
            this.feedbackEnabled = feedbackEnabled;
            return (MtBatchBinarySmsResult.Builder)this;
        }

        @JsonProperty(value="max_number_of_message_parts")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsResult.Builder maxNumberOfMessageParts(@Nullable Integer maxNumberOfMessageParts) {
            this.maxNumberOfMessageParts = maxNumberOfMessageParts;
            return (MtBatchBinarySmsResult.Builder)this;
        }

        @JsonProperty(value="dlt_principal_entity_id")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsResult.Builder dltPrincipalEntity(@Nullable String dltPrincipalEntity) {
            this.dltPrincipalEntity = dltPrincipalEntity;
            return (MtBatchBinarySmsResult.Builder)this;
        }

        @JsonProperty(value="dlt_template_id")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsResult.Builder dltTemplateId(@Nullable String dltTemplateId) {
            this.dltTemplateId = dltTemplateId;
            return (MtBatchBinarySmsResult.Builder)this;
        }

        @JsonProperty(value="from_ton")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsResult.Builder senderTon(@Nullable Integer senderTon) {
            this.senderTon = senderTon;
            return (MtBatchBinarySmsResult.Builder)this;
        }

        @JsonProperty(value="from_npi")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsResult.Builder senderNpi(@Nullable Integer senderNpi) {
            this.senderNpi = senderNpi;
            return (MtBatchBinarySmsResult.Builder)this;
        }

        public MtBatchBinarySmsResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new MtBatchBinarySmsResultImpl(this.udh, this.body, this.id, MtBatchBinarySmsResultImpl.createUnmodifiableList(true, this.recipients), this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("udh");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("body");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("deliveryReport");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("canceled");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("flashMessage");
            }
            return "Cannot build MtBatchBinarySmsResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends MtBatchBinarySmsResult {
        @Nullable
        byte[] udh;
        @Nullable
        byte[] body;
        @Nullable
        BatchId id;
        List<String> recipients = Collections.emptyList();
        @Nullable
        String sender;
        @Nullable
        ReportType deliveryReport;
        @Nullable
        URI callbackUrl;
        @Nullable
        OffsetDateTime sendAt;
        @Nullable
        OffsetDateTime expireAt;
        @Nullable
        OffsetDateTime createdAt;
        @Nullable
        OffsetDateTime modifiedAt;
        boolean canceled;
        boolean canceledIsSet;
        @Nullable
        String clientReference;
        boolean flashMessage;
        boolean flashMessageIsSet;
        @Nullable
        Boolean feedbackEnabled;
        @Nullable
        Integer maxNumberOfMessageParts;
        @Nullable
        String dltPrincipalEntity;
        @Nullable
        String dltTemplateId;
        @Nullable
        Integer senderTon;
        @Nullable
        Integer senderNpi;

        Json() {
        }

        @JsonProperty(value="udh")
        @JsonSerialize(using=JacksonUtils.ByteArrayHexSerializer.class)
        @JsonDeserialize(using=JacksonUtils.ByteArrayHexDeserializer.class)
        public void setUdh(byte[] udh) {
            this.udh = udh;
        }

        @JsonProperty(value="body")
        public void setBody(byte[] body) {
            this.body = body;
        }

        @JsonProperty(value="id")
        public void setId(BatchId id) {
            this.id = id;
        }

        @JsonProperty(value="to")
        public void setRecipients(List<String> recipients) {
            this.recipients = recipients;
        }

        @JsonProperty(value="from")
        public void setSender(@Nullable String sender) {
            this.sender = sender;
        }

        @JsonProperty(value="delivery_report")
        public void setDeliveryReport(ReportType deliveryReport) {
            this.deliveryReport = deliveryReport;
        }

        @JsonProperty(value="callbackUrl")
        public void setCallbackUrl(@Nullable URI callbackUrl) {
            this.callbackUrl = callbackUrl;
        }

        @JsonProperty(value="send_at")
        public void setSendAt(@Nullable OffsetDateTime sendAt) {
            this.sendAt = sendAt;
        }

        @JsonProperty(value="expire_at")
        public void setExpireAt(@Nullable OffsetDateTime expireAt) {
            this.expireAt = expireAt;
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(@Nullable OffsetDateTime createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="modified_at")
        public void setModifiedAt(@Nullable OffsetDateTime modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @JsonProperty(value="canceled")
        public void setCanceled(boolean canceled) {
            this.canceled = canceled;
            this.canceledIsSet = true;
        }

        @JsonProperty(value="client_reference")
        public void setClientReference(@Nullable String clientReference) {
            this.clientReference = clientReference;
        }

        @JsonProperty(value="flash_message")
        public void setFlashMessage(boolean flashMessage) {
            this.flashMessage = flashMessage;
            this.flashMessageIsSet = true;
        }

        @JsonProperty(value="feedback_enabled")
        public void setFeedbackEnabled(@Nullable Boolean feedbackEnabled) {
            this.feedbackEnabled = feedbackEnabled;
        }

        @JsonProperty(value="max_number_of_message_parts")
        public void setMaxNumberOfMessageParts(@Nullable Integer maxNumberOfMessageParts) {
            this.maxNumberOfMessageParts = maxNumberOfMessageParts;
        }

        @JsonProperty(value="dlt_principal_entity_id")
        public void setDltPrincipalEntity(@Nullable String dltPrincipalEntity) {
            this.dltPrincipalEntity = dltPrincipalEntity;
        }

        @JsonProperty(value="dlt_template_id")
        public void setDltTemplateId(@Nullable String dltTemplateId) {
            this.dltTemplateId = dltTemplateId;
        }

        @JsonProperty(value="from_ton")
        public void setSenderTon(@Nullable Integer senderTon) {
            this.senderTon = senderTon;
        }

        @JsonProperty(value="from_npi")
        public void setSenderNpi(@Nullable Integer senderNpi) {
            this.senderNpi = senderNpi;
        }

        @Override
        public byte[] udh() {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] body() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BatchId id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> recipients() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String sender() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReportType deliveryReport() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI callbackUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OffsetDateTime sendAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OffsetDateTime expireAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OffsetDateTime createdAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OffsetDateTime modifiedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean canceled() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String clientReference() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean flashMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean feedbackEnabled() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer maxNumberOfMessageParts() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String dltPrincipalEntity() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String dltTemplateId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer senderTon() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer senderNpi() {
            throw new UnsupportedOperationException();
        }
    }
}

