/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sinch.xms.UpdateValue;
import com.sinch.xms.api.JacksonUtils;
import com.sinch.xms.api.MtBatchBinarySmsUpdate;
import com.sinch.xms.api.MtBatchSmsUpdate;
import com.sinch.xms.api.ReportType;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
final class MtBatchBinarySmsUpdateImpl
extends MtBatchBinarySmsUpdate {
    @Nullable
    private final byte[] udh;
    @Nullable
    private final byte[] body;
    @Nullable
    private final List<String> recipientInsertions;
    @Nullable
    private final List<String> recipientRemovals;
    @Nullable
    private final String sender;
    @Nullable
    private final UpdateValue<ReportType> deliveryReport;
    @Nullable
    private final UpdateValue<OffsetDateTime> sendAt;
    @Nullable
    private final UpdateValue<OffsetDateTime> expireAt;
    @Nullable
    private final UpdateValue<URI> callbackUrl;

    private MtBatchBinarySmsUpdateImpl(@Nullable byte[] udh, @Nullable byte[] body, @Nullable List<String> recipientInsertions, @Nullable List<String> recipientRemovals, @Nullable String sender, @Nullable UpdateValue<ReportType> deliveryReport, @Nullable UpdateValue<OffsetDateTime> sendAt, @Nullable UpdateValue<OffsetDateTime> expireAt, @Nullable UpdateValue<URI> callbackUrl) {
        this.udh = udh;
        this.body = body;
        this.recipientInsertions = recipientInsertions;
        this.recipientRemovals = recipientRemovals;
        this.sender = sender;
        this.deliveryReport = deliveryReport;
        this.sendAt = sendAt;
        this.expireAt = expireAt;
        this.callbackUrl = callbackUrl;
    }

    @Override
    @JsonProperty(value="udh")
    @JsonSerialize(using=JacksonUtils.ByteArrayHexSerializer.class)
    @JsonDeserialize(using=JacksonUtils.ByteArrayHexDeserializer.class)
    @Nullable
    public byte[] udh() {
        return this.udh;
    }

    @Override
    @JsonProperty(value="body")
    @Nullable
    public byte[] body() {
        return this.body;
    }

    @Override
    @JsonProperty(value="to_add")
    @Nullable
    public List<String> recipientInsertions() {
        return this.recipientInsertions;
    }

    @Override
    @JsonProperty(value="to_remove")
    @Nullable
    public List<String> recipientRemovals() {
        return this.recipientRemovals;
    }

    @Override
    @JsonProperty(value="from")
    @Nullable
    public String sender() {
        return this.sender;
    }

    @Override
    @JsonProperty(value="delivery_report")
    @Nullable
    public UpdateValue<ReportType> deliveryReport() {
        return this.deliveryReport;
    }

    @Override
    @JsonProperty(value="send_at")
    @Nullable
    public UpdateValue<OffsetDateTime> sendAt() {
        return this.sendAt;
    }

    @Override
    @JsonProperty(value="expire_at")
    @Nullable
    public UpdateValue<OffsetDateTime> expireAt() {
        return this.expireAt;
    }

    @Override
    @JsonProperty(value="callback_url")
    @Nullable
    public UpdateValue<URI> callbackUrl() {
        return this.callbackUrl;
    }

    public final MtBatchBinarySmsUpdateImpl withUdh(byte ... elements) {
        byte[] newValue = elements == null ? null : (byte[])elements.clone();
        return MtBatchBinarySmsUpdateImpl.validate(new MtBatchBinarySmsUpdateImpl(newValue, this.body, this.recipientInsertions, this.recipientRemovals, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl));
    }

    public final MtBatchBinarySmsUpdateImpl withBody(byte ... elements) {
        byte[] newValue = elements == null ? null : (byte[])elements.clone();
        return MtBatchBinarySmsUpdateImpl.validate(new MtBatchBinarySmsUpdateImpl(this.udh, newValue, this.recipientInsertions, this.recipientRemovals, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl));
    }

    public final MtBatchBinarySmsUpdateImpl withRecipientInsertions(String ... elements) {
        if (elements == null) {
            return MtBatchBinarySmsUpdateImpl.validate(new MtBatchBinarySmsUpdateImpl(this.udh, this.body, null, this.recipientRemovals, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl));
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : MtBatchBinarySmsUpdateImpl.createUnmodifiableList(false, MtBatchBinarySmsUpdateImpl.createSafeList(Arrays.asList(elements), true, false));
        return MtBatchBinarySmsUpdateImpl.validate(new MtBatchBinarySmsUpdateImpl(this.udh, this.body, newValue, this.recipientRemovals, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl));
    }

    public final MtBatchBinarySmsUpdateImpl withRecipientInsertions(@Nullable Iterable<String> elements) {
        if (this.recipientInsertions == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : MtBatchBinarySmsUpdateImpl.createUnmodifiableList(false, MtBatchBinarySmsUpdateImpl.createSafeList(elements, true, false));
        return MtBatchBinarySmsUpdateImpl.validate(new MtBatchBinarySmsUpdateImpl(this.udh, this.body, newValue, this.recipientRemovals, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl));
    }

    public final MtBatchBinarySmsUpdateImpl withRecipientRemovals(String ... elements) {
        if (elements == null) {
            return MtBatchBinarySmsUpdateImpl.validate(new MtBatchBinarySmsUpdateImpl(this.udh, this.body, this.recipientInsertions, null, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl));
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : MtBatchBinarySmsUpdateImpl.createUnmodifiableList(false, MtBatchBinarySmsUpdateImpl.createSafeList(Arrays.asList(elements), true, false));
        return MtBatchBinarySmsUpdateImpl.validate(new MtBatchBinarySmsUpdateImpl(this.udh, this.body, this.recipientInsertions, newValue, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl));
    }

    public final MtBatchBinarySmsUpdateImpl withRecipientRemovals(@Nullable Iterable<String> elements) {
        if (this.recipientRemovals == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : MtBatchBinarySmsUpdateImpl.createUnmodifiableList(false, MtBatchBinarySmsUpdateImpl.createSafeList(elements, true, false));
        return MtBatchBinarySmsUpdateImpl.validate(new MtBatchBinarySmsUpdateImpl(this.udh, this.body, this.recipientInsertions, newValue, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl));
    }

    public final MtBatchBinarySmsUpdateImpl withSender(@Nullable String value) {
        if (MtBatchBinarySmsUpdateImpl.equals(this.sender, value)) {
            return this;
        }
        return MtBatchBinarySmsUpdateImpl.validate(new MtBatchBinarySmsUpdateImpl(this.udh, this.body, this.recipientInsertions, this.recipientRemovals, value, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl));
    }

    public final MtBatchBinarySmsUpdateImpl withDeliveryReport(@Nullable UpdateValue<ReportType> value) {
        if (this.deliveryReport == value) {
            return this;
        }
        return MtBatchBinarySmsUpdateImpl.validate(new MtBatchBinarySmsUpdateImpl(this.udh, this.body, this.recipientInsertions, this.recipientRemovals, this.sender, value, this.sendAt, this.expireAt, this.callbackUrl));
    }

    public final MtBatchBinarySmsUpdateImpl withSendAt(@Nullable UpdateValue<OffsetDateTime> value) {
        if (this.sendAt == value) {
            return this;
        }
        return MtBatchBinarySmsUpdateImpl.validate(new MtBatchBinarySmsUpdateImpl(this.udh, this.body, this.recipientInsertions, this.recipientRemovals, this.sender, this.deliveryReport, value, this.expireAt, this.callbackUrl));
    }

    public final MtBatchBinarySmsUpdateImpl withExpireAt(@Nullable UpdateValue<OffsetDateTime> value) {
        if (this.expireAt == value) {
            return this;
        }
        return MtBatchBinarySmsUpdateImpl.validate(new MtBatchBinarySmsUpdateImpl(this.udh, this.body, this.recipientInsertions, this.recipientRemovals, this.sender, this.deliveryReport, this.sendAt, value, this.callbackUrl));
    }

    public final MtBatchBinarySmsUpdateImpl withCallbackUrl(@Nullable UpdateValue<URI> value) {
        if (this.callbackUrl == value) {
            return this;
        }
        return MtBatchBinarySmsUpdateImpl.validate(new MtBatchBinarySmsUpdateImpl(this.udh, this.body, this.recipientInsertions, this.recipientRemovals, this.sender, this.deliveryReport, this.sendAt, this.expireAt, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof MtBatchBinarySmsUpdateImpl && this.equalTo((MtBatchBinarySmsUpdateImpl)another);
    }

    private boolean equalTo(MtBatchBinarySmsUpdateImpl another) {
        return Arrays.equals(this.udh, another.udh) && Arrays.equals(this.body, another.body) && MtBatchBinarySmsUpdateImpl.equals(this.recipientInsertions, another.recipientInsertions) && MtBatchBinarySmsUpdateImpl.equals(this.recipientRemovals, another.recipientRemovals) && MtBatchBinarySmsUpdateImpl.equals(this.sender, another.sender) && MtBatchBinarySmsUpdateImpl.equals(this.deliveryReport, another.deliveryReport) && MtBatchBinarySmsUpdateImpl.equals(this.sendAt, another.sendAt) && MtBatchBinarySmsUpdateImpl.equals(this.expireAt, another.expireAt) && MtBatchBinarySmsUpdateImpl.equals(this.callbackUrl, another.callbackUrl);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Arrays.hashCode(this.udh);
        h = h * 17 + Arrays.hashCode(this.body);
        h = h * 17 + MtBatchBinarySmsUpdateImpl.hashCode(this.recipientInsertions);
        h = h * 17 + MtBatchBinarySmsUpdateImpl.hashCode(this.recipientRemovals);
        h = h * 17 + MtBatchBinarySmsUpdateImpl.hashCode(this.sender);
        h = h * 17 + MtBatchBinarySmsUpdateImpl.hashCode(this.deliveryReport);
        h = h * 17 + MtBatchBinarySmsUpdateImpl.hashCode(this.sendAt);
        h = h * 17 + MtBatchBinarySmsUpdateImpl.hashCode(this.expireAt);
        h = h * 17 + MtBatchBinarySmsUpdateImpl.hashCode(this.callbackUrl);
        return h;
    }

    public String toString() {
        return "MtBatchBinarySmsUpdate{udh=" + Arrays.toString(this.udh) + ", body=" + Arrays.toString(this.body) + ", recipientInsertions=" + this.recipientInsertions + ", recipientRemovals=" + this.recipientRemovals + ", sender=" + this.sender + ", deliveryReport=" + this.deliveryReport + ", sendAt=" + this.sendAt + ", expireAt=" + this.expireAt + ", callbackUrl=" + this.callbackUrl + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static MtBatchBinarySmsUpdateImpl fromJson(Json json) {
        MtBatchBinarySmsUpdate.Builder builder = new MtBatchBinarySmsUpdate.Builder();
        if (json.udh != null) {
            builder.udh(json.udh);
        }
        if (json.body != null) {
            builder.body(json.body);
        }
        if (json.recipientInsertions != null) {
            builder.addAllRecipientInsertions(json.recipientInsertions);
        }
        if (json.recipientRemovals != null) {
            builder.addAllRecipientRemovals(json.recipientRemovals);
        }
        if (json.sender != null) {
            builder.sender(json.sender);
        }
        if (json.deliveryReport != null) {
            builder.deliveryReport(json.deliveryReport);
        }
        if (json.sendAt != null) {
            builder.sendAt(json.sendAt);
        }
        if (json.expireAt != null) {
            builder.expireAt(json.expireAt);
        }
        if (json.callbackUrl != null) {
            builder.callbackUrl(json.callbackUrl);
        }
        return (MtBatchBinarySmsUpdateImpl)builder.build();
    }

    private static MtBatchBinarySmsUpdateImpl validate(MtBatchBinarySmsUpdateImpl instance) {
        instance.check();
        return instance;
    }

    public static MtBatchBinarySmsUpdate copyOf(MtBatchBinarySmsUpdate instance) {
        if (instance instanceof MtBatchBinarySmsUpdateImpl) {
            return (MtBatchBinarySmsUpdateImpl)instance;
        }
        return new MtBatchBinarySmsUpdate.Builder().using(instance).build();
    }

    private static <T> T requireNonNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    private static int hashCode(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    private static boolean equals(Object left, Object right) {
        return left == right || left != null && left.equals(right);
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                MtBatchBinarySmsUpdateImpl.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    static class Builder {
        @Nullable
        private byte[] udh;
        @Nullable
        private byte[] body;
        private List<String> recipientInsertions = null;
        private List<String> recipientRemovals = null;
        @Nullable
        private String sender;
        @Nullable
        private UpdateValue<ReportType> deliveryReport;
        @Nullable
        private UpdateValue<OffsetDateTime> sendAt;
        @Nullable
        private UpdateValue<OffsetDateTime> expireAt;
        @Nullable
        private UpdateValue<URI> callbackUrl;

        Builder() {
            if (!(this instanceof MtBatchBinarySmsUpdate.Builder)) {
                throw new UnsupportedOperationException("Use: new MtBatchBinarySmsUpdate.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final MtBatchBinarySmsUpdate.Builder using(MtBatchSmsUpdate instance) {
            MtBatchBinarySmsUpdateImpl.requireNonNull(instance, "instance");
            this.from(instance);
            return (MtBatchBinarySmsUpdate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MtBatchBinarySmsUpdate.Builder using(MtBatchBinarySmsUpdate instance) {
            MtBatchBinarySmsUpdateImpl.requireNonNull(instance, "instance");
            this.from(instance);
            return (MtBatchBinarySmsUpdate.Builder)this;
        }

        private void from(Object object) {
            MtBatchSmsUpdate instance;
            if (object instanceof MtBatchSmsUpdate) {
                List<String> recipientInsertionsValue;
                UpdateValue<ReportType> deliveryReportValue;
                UpdateValue<OffsetDateTime> expireAtValue;
                UpdateValue<OffsetDateTime> sendAtValue;
                UpdateValue<URI> callbackUrlValue;
                List<String> recipientRemovalsValue;
                instance = (MtBatchSmsUpdate)object;
                String senderValue = instance.sender();
                if (senderValue != null) {
                    this.sender(senderValue);
                }
                if ((recipientRemovalsValue = instance.recipientRemovals()) != null) {
                    this.addAllRecipientRemovals(recipientRemovalsValue);
                }
                if ((callbackUrlValue = instance.callbackUrl()) != null) {
                    this.callbackUrl(callbackUrlValue);
                }
                if ((sendAtValue = instance.sendAt()) != null) {
                    this.sendAt(sendAtValue);
                }
                if ((expireAtValue = instance.expireAt()) != null) {
                    this.expireAt(expireAtValue);
                }
                if ((deliveryReportValue = instance.deliveryReport()) != null) {
                    this.deliveryReport(deliveryReportValue);
                }
                if ((recipientInsertionsValue = instance.recipientInsertions()) != null) {
                    this.addAllRecipientInsertions(recipientInsertionsValue);
                }
            }
            if (object instanceof MtBatchBinarySmsUpdate) {
                byte[] bodyValue;
                instance = (MtBatchBinarySmsUpdate)object;
                byte[] udhValue = ((MtBatchBinarySmsUpdate)instance).udh();
                if (udhValue != null) {
                    this.udh(udhValue);
                }
                if ((bodyValue = ((MtBatchBinarySmsUpdate)instance).body()) != null) {
                    this.body(bodyValue);
                }
            }
        }

        @JsonProperty(value="udh")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsUpdate.Builder udh(byte ... udh) {
            this.udh = udh;
            return (MtBatchBinarySmsUpdate.Builder)this;
        }

        @JsonProperty(value="body")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsUpdate.Builder body(byte ... body) {
            this.body = body;
            return (MtBatchBinarySmsUpdate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MtBatchBinarySmsUpdate.Builder addRecipientInsertion(String element) {
            if (this.recipientInsertions == null) {
                this.recipientInsertions = new ArrayList<String>();
            }
            this.recipientInsertions.add((String)MtBatchBinarySmsUpdateImpl.requireNonNull(element, "recipientInsertions element"));
            return (MtBatchBinarySmsUpdate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MtBatchBinarySmsUpdate.Builder addRecipientInsertion(String ... elements) {
            if (this.recipientInsertions == null) {
                this.recipientInsertions = new ArrayList<String>();
            }
            for (String element : elements) {
                this.recipientInsertions.add((String)MtBatchBinarySmsUpdateImpl.requireNonNull(element, "recipientInsertions element"));
            }
            return (MtBatchBinarySmsUpdate.Builder)this;
        }

        @JsonProperty(value="to_add")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsUpdate.Builder recipientInsertions(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.recipientInsertions = null;
                return (MtBatchBinarySmsUpdate.Builder)this;
            }
            this.recipientInsertions = new ArrayList<String>();
            return this.addAllRecipientInsertions(elements);
        }

        @CanIgnoreReturnValue
        public final MtBatchBinarySmsUpdate.Builder addAllRecipientInsertions(Iterable<String> elements) {
            MtBatchBinarySmsUpdateImpl.requireNonNull(elements, "recipientInsertions element");
            if (this.recipientInsertions == null) {
                this.recipientInsertions = new ArrayList<String>();
            }
            for (String element : elements) {
                this.recipientInsertions.add((String)MtBatchBinarySmsUpdateImpl.requireNonNull(element, "recipientInsertions element"));
            }
            return (MtBatchBinarySmsUpdate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MtBatchBinarySmsUpdate.Builder addRecipientRemoval(String element) {
            if (this.recipientRemovals == null) {
                this.recipientRemovals = new ArrayList<String>();
            }
            this.recipientRemovals.add((String)MtBatchBinarySmsUpdateImpl.requireNonNull(element, "recipientRemovals element"));
            return (MtBatchBinarySmsUpdate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MtBatchBinarySmsUpdate.Builder addRecipientRemoval(String ... elements) {
            if (this.recipientRemovals == null) {
                this.recipientRemovals = new ArrayList<String>();
            }
            for (String element : elements) {
                this.recipientRemovals.add((String)MtBatchBinarySmsUpdateImpl.requireNonNull(element, "recipientRemovals element"));
            }
            return (MtBatchBinarySmsUpdate.Builder)this;
        }

        @JsonProperty(value="to_remove")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsUpdate.Builder recipientRemovals(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.recipientRemovals = null;
                return (MtBatchBinarySmsUpdate.Builder)this;
            }
            this.recipientRemovals = new ArrayList<String>();
            return this.addAllRecipientRemovals(elements);
        }

        @CanIgnoreReturnValue
        public final MtBatchBinarySmsUpdate.Builder addAllRecipientRemovals(Iterable<String> elements) {
            MtBatchBinarySmsUpdateImpl.requireNonNull(elements, "recipientRemovals element");
            if (this.recipientRemovals == null) {
                this.recipientRemovals = new ArrayList<String>();
            }
            for (String element : elements) {
                this.recipientRemovals.add((String)MtBatchBinarySmsUpdateImpl.requireNonNull(element, "recipientRemovals element"));
            }
            return (MtBatchBinarySmsUpdate.Builder)this;
        }

        @JsonProperty(value="from")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsUpdate.Builder sender(@Nullable String sender) {
            this.sender = sender;
            return (MtBatchBinarySmsUpdate.Builder)this;
        }

        @JsonProperty(value="delivery_report")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsUpdate.Builder deliveryReport(@Nullable UpdateValue<ReportType> deliveryReport) {
            this.deliveryReport = deliveryReport;
            return (MtBatchBinarySmsUpdate.Builder)this;
        }

        @JsonProperty(value="send_at")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsUpdate.Builder sendAt(@Nullable UpdateValue<OffsetDateTime> sendAt) {
            this.sendAt = sendAt;
            return (MtBatchBinarySmsUpdate.Builder)this;
        }

        @JsonProperty(value="expire_at")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsUpdate.Builder expireAt(@Nullable UpdateValue<OffsetDateTime> expireAt) {
            this.expireAt = expireAt;
            return (MtBatchBinarySmsUpdate.Builder)this;
        }

        @JsonProperty(value="callback_url")
        @CanIgnoreReturnValue
        public final MtBatchBinarySmsUpdate.Builder callbackUrl(@Nullable UpdateValue<URI> callbackUrl) {
            this.callbackUrl = callbackUrl;
            return (MtBatchBinarySmsUpdate.Builder)this;
        }

        public MtBatchBinarySmsUpdate build() {
            return MtBatchBinarySmsUpdateImpl.validate(new MtBatchBinarySmsUpdateImpl(this.udh, this.body, this.recipientInsertions == null ? null : MtBatchBinarySmsUpdateImpl.createUnmodifiableList(true, this.recipientInsertions), this.recipientRemovals == null ? null : MtBatchBinarySmsUpdateImpl.createUnmodifiableList(true, this.recipientRemovals), this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl));
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends MtBatchBinarySmsUpdate {
        @Nullable
        byte[] udh;
        @Nullable
        byte[] body;
        List<String> recipientInsertions = null;
        List<String> recipientRemovals = null;
        @Nullable
        String sender;
        @Nullable
        UpdateValue<ReportType> deliveryReport;
        @Nullable
        UpdateValue<OffsetDateTime> sendAt;
        @Nullable
        UpdateValue<OffsetDateTime> expireAt;
        @Nullable
        UpdateValue<URI> callbackUrl;

        Json() {
        }

        @JsonProperty(value="udh")
        @JsonSerialize(using=JacksonUtils.ByteArrayHexSerializer.class)
        @JsonDeserialize(using=JacksonUtils.ByteArrayHexDeserializer.class)
        public void setUdh(@Nullable byte[] udh) {
            this.udh = udh;
        }

        @JsonProperty(value="body")
        public void setBody(@Nullable byte[] body) {
            this.body = body;
        }

        @JsonProperty(value="to_add")
        public void setRecipientInsertions(@Nullable List<String> recipientInsertions) {
            this.recipientInsertions = recipientInsertions;
        }

        @JsonProperty(value="to_remove")
        public void setRecipientRemovals(@Nullable List<String> recipientRemovals) {
            this.recipientRemovals = recipientRemovals;
        }

        @JsonProperty(value="from")
        public void setSender(@Nullable String sender) {
            this.sender = sender;
        }

        @JsonProperty(value="delivery_report")
        public void setDeliveryReport(@Nullable UpdateValue<ReportType> deliveryReport) {
            this.deliveryReport = deliveryReport;
        }

        @JsonProperty(value="send_at")
        public void setSendAt(@Nullable UpdateValue<OffsetDateTime> sendAt) {
            this.sendAt = sendAt;
        }

        @JsonProperty(value="expire_at")
        public void setExpireAt(@Nullable UpdateValue<OffsetDateTime> expireAt) {
            this.expireAt = expireAt;
        }

        @JsonProperty(value="callback_url")
        public void setCallbackUrl(@Nullable UpdateValue<URI> callbackUrl) {
            this.callbackUrl = callbackUrl;
        }

        @Override
        public byte[] udh() {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] body() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> recipientInsertions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> recipientRemovals() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String sender() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UpdateValue<ReportType> deliveryReport() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UpdateValue<OffsetDateTime> sendAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UpdateValue<OffsetDateTime> expireAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UpdateValue<URI> callbackUrl() {
            throw new UnsupportedOperationException();
        }
    }
}

