/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sinch.xms.api.MtBatchDryRunResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
final class MtBatchDryRunResultImpl
extends MtBatchDryRunResult {
    private final int numberOfRecipients;
    private final int numberOfMessages;
    private final List<MtBatchDryRunResult.PerRecipient> perRecipient;

    private MtBatchDryRunResultImpl(int numberOfRecipients, int numberOfMessages, List<MtBatchDryRunResult.PerRecipient> perRecipient) {
        this.numberOfRecipients = numberOfRecipients;
        this.numberOfMessages = numberOfMessages;
        this.perRecipient = perRecipient;
    }

    @Override
    @JsonProperty(value="number_of_recipients")
    public int numberOfRecipients() {
        return this.numberOfRecipients;
    }

    @Override
    @JsonProperty(value="number_of_messages")
    public int numberOfMessages() {
        return this.numberOfMessages;
    }

    @Override
    @JsonProperty(value="per_recipient")
    public List<MtBatchDryRunResult.PerRecipient> perRecipient() {
        return this.perRecipient;
    }

    public final MtBatchDryRunResultImpl withNumberOfRecipients(int value) {
        if (this.numberOfRecipients == value) {
            return this;
        }
        return new MtBatchDryRunResultImpl(value, this.numberOfMessages, this.perRecipient);
    }

    public final MtBatchDryRunResultImpl withNumberOfMessages(int value) {
        if (this.numberOfMessages == value) {
            return this;
        }
        return new MtBatchDryRunResultImpl(this.numberOfRecipients, value, this.perRecipient);
    }

    public final MtBatchDryRunResultImpl withPerRecipient(MtBatchDryRunResult.PerRecipient ... elements) {
        List<MtBatchDryRunResult.PerRecipient> newValue = MtBatchDryRunResultImpl.createUnmodifiableList(false, MtBatchDryRunResultImpl.createSafeList(Arrays.asList(elements), true, false));
        return new MtBatchDryRunResultImpl(this.numberOfRecipients, this.numberOfMessages, newValue);
    }

    public final MtBatchDryRunResultImpl withPerRecipient(Iterable<? extends MtBatchDryRunResult.PerRecipient> elements) {
        if (this.perRecipient == elements) {
            return this;
        }
        List<MtBatchDryRunResult.PerRecipient> newValue = MtBatchDryRunResultImpl.createUnmodifiableList(false, MtBatchDryRunResultImpl.createSafeList(elements, true, false));
        return new MtBatchDryRunResultImpl(this.numberOfRecipients, this.numberOfMessages, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof MtBatchDryRunResultImpl && this.equalTo((MtBatchDryRunResultImpl)another);
    }

    private boolean equalTo(MtBatchDryRunResultImpl another) {
        return this.numberOfRecipients == another.numberOfRecipients && this.numberOfMessages == another.numberOfMessages && this.perRecipient.equals(another.perRecipient);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.numberOfRecipients;
        h = h * 17 + this.numberOfMessages;
        h = h * 17 + this.perRecipient.hashCode();
        return h;
    }

    public String toString() {
        return "MtBatchDryRunResult{numberOfRecipients=" + this.numberOfRecipients + ", numberOfMessages=" + this.numberOfMessages + ", perRecipient=" + this.perRecipient + "}";
    }

    public static MtBatchDryRunResult copyOf(MtBatchDryRunResult instance) {
        if (instance instanceof MtBatchDryRunResultImpl) {
            return (MtBatchDryRunResultImpl)instance;
        }
        return new MtBatchDryRunResult.Builder().using(instance).build();
    }

    private static <T> T requireNonNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                MtBatchDryRunResultImpl.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    static class Builder {
        private static final long INIT_BIT_NUMBER_OF_RECIPIENTS = 1L;
        private static final long INIT_BIT_NUMBER_OF_MESSAGES = 2L;
        private long initBits = 3L;
        private int numberOfRecipients;
        private int numberOfMessages;
        private List<MtBatchDryRunResult.PerRecipient> perRecipient = new ArrayList<MtBatchDryRunResult.PerRecipient>();

        Builder() {
            if (!(this instanceof MtBatchDryRunResult.Builder)) {
                throw new UnsupportedOperationException("Use: new MtBatchDryRunResult.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final MtBatchDryRunResult.Builder using(MtBatchDryRunResult instance) {
            MtBatchDryRunResultImpl.requireNonNull(instance, "instance");
            this.numberOfRecipients(instance.numberOfRecipients());
            this.numberOfMessages(instance.numberOfMessages());
            this.addAllPerRecipient(instance.perRecipient());
            return (MtBatchDryRunResult.Builder)this;
        }

        @JsonProperty(value="number_of_recipients")
        @CanIgnoreReturnValue
        public final MtBatchDryRunResult.Builder numberOfRecipients(int numberOfRecipients) {
            this.numberOfRecipients = numberOfRecipients;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (MtBatchDryRunResult.Builder)this;
        }

        @JsonProperty(value="number_of_messages")
        @CanIgnoreReturnValue
        public final MtBatchDryRunResult.Builder numberOfMessages(int numberOfMessages) {
            this.numberOfMessages = numberOfMessages;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (MtBatchDryRunResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MtBatchDryRunResult.Builder addPerRecipient(MtBatchDryRunResult.PerRecipient element) {
            this.perRecipient.add((MtBatchDryRunResult.PerRecipient)MtBatchDryRunResultImpl.requireNonNull(element, "perRecipient element"));
            return (MtBatchDryRunResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MtBatchDryRunResult.Builder addPerRecipient(MtBatchDryRunResult.PerRecipient ... elements) {
            for (MtBatchDryRunResult.PerRecipient element : elements) {
                this.perRecipient.add((MtBatchDryRunResult.PerRecipient)MtBatchDryRunResultImpl.requireNonNull(element, "perRecipient element"));
            }
            return (MtBatchDryRunResult.Builder)this;
        }

        @JsonProperty(value="per_recipient")
        @CanIgnoreReturnValue
        public final MtBatchDryRunResult.Builder perRecipient(Iterable<? extends MtBatchDryRunResult.PerRecipient> elements) {
            this.perRecipient.clear();
            return this.addAllPerRecipient(elements);
        }

        @CanIgnoreReturnValue
        public final MtBatchDryRunResult.Builder addAllPerRecipient(Iterable<? extends MtBatchDryRunResult.PerRecipient> elements) {
            for (MtBatchDryRunResult.PerRecipient perRecipient : elements) {
                this.perRecipient.add((MtBatchDryRunResult.PerRecipient)MtBatchDryRunResultImpl.requireNonNull(perRecipient, "perRecipient element"));
            }
            return (MtBatchDryRunResult.Builder)this;
        }

        public MtBatchDryRunResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new MtBatchDryRunResultImpl(this.numberOfRecipients, this.numberOfMessages, MtBatchDryRunResultImpl.createUnmodifiableList(true, this.perRecipient));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("numberOfRecipients");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("numberOfMessages");
            }
            return "Cannot build MtBatchDryRunResult, some of required attributes are not set " + attributes;
        }
    }
}

