/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.sinch.xms.api.MtBatchBinarySmsCreate;
import com.sinch.xms.api.MtBatchTextSmsCreate;
import com.sinch.xms.api.ReportType;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.immutables.value.Value;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=MtBatchTextSmsCreate.class), @JsonSubTypes.Type(value=MtBatchBinarySmsCreate.class)})
public abstract class MtBatchSmsCreate {
    @JsonProperty(value="to")
    public abstract List<String> recipients();

    @Nullable
    @JsonProperty(value="from")
    public abstract String sender();

    @Nullable
    @JsonProperty(value="delivery_report")
    public abstract ReportType deliveryReport();

    @Nullable
    @JsonProperty(value="send_at")
    public abstract OffsetDateTime sendAt();

    @Nullable
    @JsonProperty(value="expire_at")
    public abstract OffsetDateTime expireAt();

    @Nullable
    @JsonProperty(value="callback_url")
    public abstract URI callbackUrl();

    @Nullable
    @JsonProperty(value="feedback_enabled")
    public abstract Boolean feedbackEnabled();

    @Deprecated
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public abstract Set<String> tags();

    @Nullable
    @JsonProperty(value="client_reference")
    public abstract String clientReference();

    @Nullable
    @JsonProperty(value="flash_message")
    public abstract Boolean flashMessage();

    @Nullable
    @JsonProperty(value="max_number_of_message_parts")
    public abstract Integer maxNumberOfMessageParts();

    @Nullable
    @JsonProperty(value="dlt_principal_entity_id")
    public abstract String dltPrincipalEntity();

    @Nullable
    @JsonProperty(value="dlt_template_id")
    public abstract String dltTemplateId();

    @JsonProperty(value="from_ton")
    @Nullable
    public abstract Integer senderTon();

    @JsonProperty(value="from_npi")
    @Nullable
    public abstract Integer senderNpi();

    @OverridingMethodsMustInvokeSuper
    @Value.Check
    protected void check() {
        if (this.recipients().isEmpty()) {
            throw new IllegalStateException("no destination");
        }
        for (String to : this.recipients()) {
            if (!to.isEmpty()) continue;
            throw new IllegalStateException("contains empty destination");
        }
        if (this.sender() != null && this.sender().isEmpty()) {
            throw new IllegalStateException("empty from address");
        }
    }
}

