/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sinch.xms.api.MtBatchSmsCreate;
import com.sinch.xms.api.MtBatchTextSmsCreate;
import com.sinch.xms.api.ParameterValues;
import com.sinch.xms.api.ReportType;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
final class MtBatchTextSmsCreateImpl
extends MtBatchTextSmsCreate {
    private final String body;
    private final Map<String, ParameterValues> parameters;
    private final List<String> recipients;
    @Nullable
    private final String sender;
    @Nullable
    private final ReportType deliveryReport;
    @Nullable
    private final OffsetDateTime sendAt;
    @Nullable
    private final OffsetDateTime expireAt;
    @Nullable
    private final URI callbackUrl;
    @Nullable
    private final Boolean feedbackEnabled;
    private final Set<String> tags;
    @Nullable
    private final String clientReference;
    @Nullable
    private final Boolean flashMessage;
    @Nullable
    private final Integer maxNumberOfMessageParts;
    @Nullable
    private final String dltPrincipalEntity;
    @Nullable
    private final String dltTemplateId;
    @Nullable
    private final Integer senderTon;
    @Nullable
    private final Integer senderNpi;

    private MtBatchTextSmsCreateImpl(String body, Map<String, ParameterValues> parameters, List<String> recipients, @Nullable String sender, @Nullable ReportType deliveryReport, @Nullable OffsetDateTime sendAt, @Nullable OffsetDateTime expireAt, @Nullable URI callbackUrl, @Nullable Boolean feedbackEnabled, Set<String> tags, @Nullable String clientReference, @Nullable Boolean flashMessage, @Nullable Integer maxNumberOfMessageParts, @Nullable String dltPrincipalEntity, @Nullable String dltTemplateId, @Nullable Integer senderTon, @Nullable Integer senderNpi) {
        this.body = body;
        this.parameters = parameters;
        this.recipients = recipients;
        this.sender = sender;
        this.deliveryReport = deliveryReport;
        this.sendAt = sendAt;
        this.expireAt = expireAt;
        this.callbackUrl = callbackUrl;
        this.feedbackEnabled = feedbackEnabled;
        this.tags = tags;
        this.clientReference = clientReference;
        this.flashMessage = flashMessage;
        this.maxNumberOfMessageParts = maxNumberOfMessageParts;
        this.dltPrincipalEntity = dltPrincipalEntity;
        this.dltTemplateId = dltTemplateId;
        this.senderTon = senderTon;
        this.senderNpi = senderNpi;
    }

    @Override
    @JsonProperty(value="body")
    public String body() {
        return this.body;
    }

    @Override
    @JsonProperty(value="parameters")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, ParameterValues> parameters() {
        return this.parameters;
    }

    @Override
    @JsonProperty(value="to")
    public List<String> recipients() {
        return this.recipients;
    }

    @Override
    @JsonProperty(value="from")
    @Nullable
    public String sender() {
        return this.sender;
    }

    @Override
    @JsonProperty(value="delivery_report")
    @Nullable
    public ReportType deliveryReport() {
        return this.deliveryReport;
    }

    @Override
    @JsonProperty(value="send_at")
    @Nullable
    public OffsetDateTime sendAt() {
        return this.sendAt;
    }

    @Override
    @JsonProperty(value="expire_at")
    @Nullable
    public OffsetDateTime expireAt() {
        return this.expireAt;
    }

    @Override
    @JsonProperty(value="callback_url")
    @Nullable
    public URI callbackUrl() {
        return this.callbackUrl;
    }

    @Override
    @JsonProperty(value="feedback_enabled")
    @Nullable
    public Boolean feedbackEnabled() {
        return this.feedbackEnabled;
    }

    @Override
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Deprecated
    public Set<String> tags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="client_reference")
    @Nullable
    public String clientReference() {
        return this.clientReference;
    }

    @Override
    @JsonProperty(value="flash_message")
    @Nullable
    public Boolean flashMessage() {
        return this.flashMessage;
    }

    @Override
    @JsonProperty(value="max_number_of_message_parts")
    @Nullable
    public Integer maxNumberOfMessageParts() {
        return this.maxNumberOfMessageParts;
    }

    @Override
    @JsonProperty(value="dlt_principal_entity_id")
    @Nullable
    public String dltPrincipalEntity() {
        return this.dltPrincipalEntity;
    }

    @Override
    @JsonProperty(value="dlt_template_id")
    @Nullable
    public String dltTemplateId() {
        return this.dltTemplateId;
    }

    @Override
    @JsonProperty(value="from_ton")
    @Nullable
    public Integer senderTon() {
        return this.senderTon;
    }

    @Override
    @JsonProperty(value="from_npi")
    @Nullable
    public Integer senderNpi() {
        return this.senderNpi;
    }

    public final MtBatchTextSmsCreateImpl withBody(String value) {
        if (this.body.equals(value)) {
            return this;
        }
        String newValue = MtBatchTextSmsCreateImpl.requireNonNull(value, "body");
        return MtBatchTextSmsCreateImpl.validate(new MtBatchTextSmsCreateImpl(newValue, this.parameters, this.recipients, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.feedbackEnabled, this.tags, this.clientReference, this.flashMessage, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi));
    }

    public final MtBatchTextSmsCreateImpl withParameters(Map<String, ? extends ParameterValues> entries) {
        if (this.parameters == entries) {
            return this;
        }
        Map<String, ParameterValues> newValue = MtBatchTextSmsCreateImpl.createUnmodifiableMap(true, false, entries);
        return MtBatchTextSmsCreateImpl.validate(new MtBatchTextSmsCreateImpl(this.body, newValue, this.recipients, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.feedbackEnabled, this.tags, this.clientReference, this.flashMessage, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi));
    }

    public final MtBatchTextSmsCreateImpl withRecipients(String ... elements) {
        List<String> newValue = MtBatchTextSmsCreateImpl.createUnmodifiableList(false, MtBatchTextSmsCreateImpl.createSafeList(Arrays.asList(elements), true, false));
        return MtBatchTextSmsCreateImpl.validate(new MtBatchTextSmsCreateImpl(this.body, this.parameters, newValue, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.feedbackEnabled, this.tags, this.clientReference, this.flashMessage, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi));
    }

    public final MtBatchTextSmsCreateImpl withRecipients(Iterable<String> elements) {
        if (this.recipients == elements) {
            return this;
        }
        List<String> newValue = MtBatchTextSmsCreateImpl.createUnmodifiableList(false, MtBatchTextSmsCreateImpl.createSafeList(elements, true, false));
        return MtBatchTextSmsCreateImpl.validate(new MtBatchTextSmsCreateImpl(this.body, this.parameters, newValue, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.feedbackEnabled, this.tags, this.clientReference, this.flashMessage, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi));
    }

    public final MtBatchTextSmsCreateImpl withSender(@Nullable String value) {
        if (MtBatchTextSmsCreateImpl.equals(this.sender, value)) {
            return this;
        }
        return MtBatchTextSmsCreateImpl.validate(new MtBatchTextSmsCreateImpl(this.body, this.parameters, this.recipients, value, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.feedbackEnabled, this.tags, this.clientReference, this.flashMessage, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi));
    }

    public final MtBatchTextSmsCreateImpl withDeliveryReport(@Nullable ReportType value) {
        if (this.deliveryReport == value) {
            return this;
        }
        return MtBatchTextSmsCreateImpl.validate(new MtBatchTextSmsCreateImpl(this.body, this.parameters, this.recipients, this.sender, value, this.sendAt, this.expireAt, this.callbackUrl, this.feedbackEnabled, this.tags, this.clientReference, this.flashMessage, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi));
    }

    public final MtBatchTextSmsCreateImpl withSendAt(@Nullable OffsetDateTime value) {
        if (this.sendAt == value) {
            return this;
        }
        return MtBatchTextSmsCreateImpl.validate(new MtBatchTextSmsCreateImpl(this.body, this.parameters, this.recipients, this.sender, this.deliveryReport, value, this.expireAt, this.callbackUrl, this.feedbackEnabled, this.tags, this.clientReference, this.flashMessage, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi));
    }

    public final MtBatchTextSmsCreateImpl withExpireAt(@Nullable OffsetDateTime value) {
        if (this.expireAt == value) {
            return this;
        }
        return MtBatchTextSmsCreateImpl.validate(new MtBatchTextSmsCreateImpl(this.body, this.parameters, this.recipients, this.sender, this.deliveryReport, this.sendAt, value, this.callbackUrl, this.feedbackEnabled, this.tags, this.clientReference, this.flashMessage, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi));
    }

    public final MtBatchTextSmsCreateImpl withCallbackUrl(@Nullable URI value) {
        if (this.callbackUrl == value) {
            return this;
        }
        return MtBatchTextSmsCreateImpl.validate(new MtBatchTextSmsCreateImpl(this.body, this.parameters, this.recipients, this.sender, this.deliveryReport, this.sendAt, this.expireAt, value, this.feedbackEnabled, this.tags, this.clientReference, this.flashMessage, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi));
    }

    public final MtBatchTextSmsCreateImpl withFeedbackEnabled(@Nullable Boolean value) {
        if (MtBatchTextSmsCreateImpl.equals(this.feedbackEnabled, value)) {
            return this;
        }
        return MtBatchTextSmsCreateImpl.validate(new MtBatchTextSmsCreateImpl(this.body, this.parameters, this.recipients, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, value, this.tags, this.clientReference, this.flashMessage, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi));
    }

    @Deprecated
    public final MtBatchTextSmsCreateImpl withTags(String ... elements) {
        Set<String> newValue = MtBatchTextSmsCreateImpl.createUnmodifiableSet(MtBatchTextSmsCreateImpl.createSafeList(Arrays.asList(elements), true, false));
        return MtBatchTextSmsCreateImpl.validate(new MtBatchTextSmsCreateImpl(this.body, this.parameters, this.recipients, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.feedbackEnabled, newValue, this.clientReference, this.flashMessage, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi));
    }

    @Deprecated
    public final MtBatchTextSmsCreateImpl withTags(Iterable<String> elements) {
        if (this.tags == elements) {
            return this;
        }
        Set<String> newValue = MtBatchTextSmsCreateImpl.createUnmodifiableSet(MtBatchTextSmsCreateImpl.createSafeList(elements, true, false));
        return MtBatchTextSmsCreateImpl.validate(new MtBatchTextSmsCreateImpl(this.body, this.parameters, this.recipients, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.feedbackEnabled, newValue, this.clientReference, this.flashMessage, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi));
    }

    public final MtBatchTextSmsCreateImpl withClientReference(@Nullable String value) {
        if (MtBatchTextSmsCreateImpl.equals(this.clientReference, value)) {
            return this;
        }
        return MtBatchTextSmsCreateImpl.validate(new MtBatchTextSmsCreateImpl(this.body, this.parameters, this.recipients, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.feedbackEnabled, this.tags, value, this.flashMessage, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi));
    }

    public final MtBatchTextSmsCreateImpl withFlashMessage(@Nullable Boolean value) {
        if (MtBatchTextSmsCreateImpl.equals(this.flashMessage, value)) {
            return this;
        }
        return MtBatchTextSmsCreateImpl.validate(new MtBatchTextSmsCreateImpl(this.body, this.parameters, this.recipients, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.feedbackEnabled, this.tags, this.clientReference, value, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi));
    }

    public final MtBatchTextSmsCreateImpl withMaxNumberOfMessageParts(@Nullable Integer value) {
        if (MtBatchTextSmsCreateImpl.equals(this.maxNumberOfMessageParts, value)) {
            return this;
        }
        return MtBatchTextSmsCreateImpl.validate(new MtBatchTextSmsCreateImpl(this.body, this.parameters, this.recipients, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.feedbackEnabled, this.tags, this.clientReference, this.flashMessage, value, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi));
    }

    public final MtBatchTextSmsCreateImpl withDltPrincipalEntity(@Nullable String value) {
        if (MtBatchTextSmsCreateImpl.equals(this.dltPrincipalEntity, value)) {
            return this;
        }
        return MtBatchTextSmsCreateImpl.validate(new MtBatchTextSmsCreateImpl(this.body, this.parameters, this.recipients, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.feedbackEnabled, this.tags, this.clientReference, this.flashMessage, this.maxNumberOfMessageParts, value, this.dltTemplateId, this.senderTon, this.senderNpi));
    }

    public final MtBatchTextSmsCreateImpl withDltTemplateId(@Nullable String value) {
        if (MtBatchTextSmsCreateImpl.equals(this.dltTemplateId, value)) {
            return this;
        }
        return MtBatchTextSmsCreateImpl.validate(new MtBatchTextSmsCreateImpl(this.body, this.parameters, this.recipients, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.feedbackEnabled, this.tags, this.clientReference, this.flashMessage, this.maxNumberOfMessageParts, this.dltPrincipalEntity, value, this.senderTon, this.senderNpi));
    }

    public final MtBatchTextSmsCreateImpl withSenderTon(@Nullable Integer value) {
        if (MtBatchTextSmsCreateImpl.equals(this.senderTon, value)) {
            return this;
        }
        return MtBatchTextSmsCreateImpl.validate(new MtBatchTextSmsCreateImpl(this.body, this.parameters, this.recipients, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.feedbackEnabled, this.tags, this.clientReference, this.flashMessage, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, value, this.senderNpi));
    }

    public final MtBatchTextSmsCreateImpl withSenderNpi(@Nullable Integer value) {
        if (MtBatchTextSmsCreateImpl.equals(this.senderNpi, value)) {
            return this;
        }
        return MtBatchTextSmsCreateImpl.validate(new MtBatchTextSmsCreateImpl(this.body, this.parameters, this.recipients, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.feedbackEnabled, this.tags, this.clientReference, this.flashMessage, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof MtBatchTextSmsCreateImpl && this.equalTo((MtBatchTextSmsCreateImpl)another);
    }

    private boolean equalTo(MtBatchTextSmsCreateImpl another) {
        return this.body.equals(another.body) && this.parameters.equals(another.parameters) && this.recipients.equals(another.recipients) && MtBatchTextSmsCreateImpl.equals(this.sender, another.sender) && MtBatchTextSmsCreateImpl.equals(this.deliveryReport, another.deliveryReport) && MtBatchTextSmsCreateImpl.equals(this.sendAt, another.sendAt) && MtBatchTextSmsCreateImpl.equals(this.expireAt, another.expireAt) && MtBatchTextSmsCreateImpl.equals(this.callbackUrl, another.callbackUrl) && MtBatchTextSmsCreateImpl.equals(this.feedbackEnabled, another.feedbackEnabled) && this.tags.equals(another.tags) && MtBatchTextSmsCreateImpl.equals(this.clientReference, another.clientReference) && MtBatchTextSmsCreateImpl.equals(this.flashMessage, another.flashMessage) && MtBatchTextSmsCreateImpl.equals(this.maxNumberOfMessageParts, another.maxNumberOfMessageParts) && MtBatchTextSmsCreateImpl.equals(this.dltPrincipalEntity, another.dltPrincipalEntity) && MtBatchTextSmsCreateImpl.equals(this.dltTemplateId, another.dltTemplateId) && MtBatchTextSmsCreateImpl.equals(this.senderTon, another.senderTon) && MtBatchTextSmsCreateImpl.equals(this.senderNpi, another.senderNpi);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.body.hashCode();
        h = h * 17 + this.parameters.hashCode();
        h = h * 17 + this.recipients.hashCode();
        h = h * 17 + MtBatchTextSmsCreateImpl.hashCode(this.sender);
        h = h * 17 + MtBatchTextSmsCreateImpl.hashCode(this.deliveryReport);
        h = h * 17 + MtBatchTextSmsCreateImpl.hashCode(this.sendAt);
        h = h * 17 + MtBatchTextSmsCreateImpl.hashCode(this.expireAt);
        h = h * 17 + MtBatchTextSmsCreateImpl.hashCode(this.callbackUrl);
        h = h * 17 + MtBatchTextSmsCreateImpl.hashCode(this.feedbackEnabled);
        h = h * 17 + this.tags.hashCode();
        h = h * 17 + MtBatchTextSmsCreateImpl.hashCode(this.clientReference);
        h = h * 17 + MtBatchTextSmsCreateImpl.hashCode(this.flashMessage);
        h = h * 17 + MtBatchTextSmsCreateImpl.hashCode(this.maxNumberOfMessageParts);
        h = h * 17 + MtBatchTextSmsCreateImpl.hashCode(this.dltPrincipalEntity);
        h = h * 17 + MtBatchTextSmsCreateImpl.hashCode(this.dltTemplateId);
        h = h * 17 + MtBatchTextSmsCreateImpl.hashCode(this.senderTon);
        h = h * 17 + MtBatchTextSmsCreateImpl.hashCode(this.senderNpi);
        return h;
    }

    public String toString() {
        return "MtBatchTextSmsCreate{body=" + this.body + ", parameters=" + this.parameters + ", recipients=" + this.recipients + ", sender=" + this.sender + ", deliveryReport=" + this.deliveryReport + ", sendAt=" + this.sendAt + ", expireAt=" + this.expireAt + ", callbackUrl=" + this.callbackUrl + ", feedbackEnabled=" + this.feedbackEnabled + ", tags=" + this.tags + ", clientReference=" + this.clientReference + ", flashMessage=" + this.flashMessage + ", maxNumberOfMessageParts=" + this.maxNumberOfMessageParts + ", dltPrincipalEntity=" + this.dltPrincipalEntity + ", dltTemplateId=" + this.dltTemplateId + ", senderTon=" + this.senderTon + ", senderNpi=" + this.senderNpi + "}";
    }

    private static MtBatchTextSmsCreateImpl validate(MtBatchTextSmsCreateImpl instance) {
        instance.check();
        return instance;
    }

    public static MtBatchTextSmsCreate copyOf(MtBatchTextSmsCreate instance) {
        if (instance instanceof MtBatchTextSmsCreateImpl) {
            return (MtBatchTextSmsCreateImpl)instance;
        }
        return new MtBatchTextSmsCreate.Builder().using(instance).build();
    }

    private static <T> T requireNonNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    private static int hashCode(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    private static boolean equals(Object left, Object right) {
        return left == right || left != null && left.equals(right);
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                MtBatchTextSmsCreateImpl.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    MtBatchTextSmsCreateImpl.requireNonNull(k, "key");
                    MtBatchTextSmsCreateImpl.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    MtBatchTextSmsCreateImpl.requireNonNull(k, "key");
                    MtBatchTextSmsCreateImpl.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @NotThreadSafe
    static class Builder {
        private static final long INIT_BIT_BODY = 1L;
        private long initBits = 1L;
        @Nullable
        private String body;
        private Map<String, ParameterValues> parameters = new LinkedHashMap<String, ParameterValues>();
        private List<String> recipients = new ArrayList<String>();
        @Nullable
        private String sender;
        @Nullable
        private ReportType deliveryReport;
        @Nullable
        private OffsetDateTime sendAt;
        @Nullable
        private OffsetDateTime expireAt;
        @Nullable
        private URI callbackUrl;
        @Nullable
        private Boolean feedbackEnabled;
        private List<String> tags = new ArrayList<String>();
        @Nullable
        private String clientReference;
        @Nullable
        private Boolean flashMessage;
        @Nullable
        private Integer maxNumberOfMessageParts;
        @Nullable
        private String dltPrincipalEntity;
        @Nullable
        private String dltTemplateId;
        @Nullable
        private Integer senderTon;
        @Nullable
        private Integer senderNpi;

        Builder() {
            if (!(this instanceof MtBatchTextSmsCreate.Builder)) {
                throw new UnsupportedOperationException("Use: new MtBatchTextSmsCreate.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final MtBatchTextSmsCreate.Builder using(MtBatchTextSmsCreate instance) {
            MtBatchTextSmsCreateImpl.requireNonNull(instance, "instance");
            this.from(instance);
            return (MtBatchTextSmsCreate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MtBatchTextSmsCreate.Builder using(MtBatchSmsCreate instance) {
            MtBatchTextSmsCreateImpl.requireNonNull(instance, "instance");
            this.from(instance);
            return (MtBatchTextSmsCreate.Builder)this;
        }

        private void from(Object object) {
            MtBatchSmsCreate instance;
            if (object instanceof MtBatchTextSmsCreate) {
                instance = (MtBatchTextSmsCreate)object;
                this.body(((MtBatchTextSmsCreate)instance).body());
                this.putAllParameters(((MtBatchTextSmsCreate)instance).parameters());
            }
            if (object instanceof MtBatchSmsCreate) {
                ReportType deliveryReportValue;
                Boolean feedbackEnabledValue;
                OffsetDateTime sendAtValue;
                URI callbackUrlValue;
                Integer senderNpiValue;
                String dltPrincipalEntityValue;
                Integer senderTonValue;
                String dltTemplateIdValue;
                OffsetDateTime expireAtValue;
                Boolean flashMessageValue;
                instance = (MtBatchSmsCreate)object;
                Integer maxNumberOfMessagePartsValue = instance.maxNumberOfMessageParts();
                if (maxNumberOfMessagePartsValue != null) {
                    this.maxNumberOfMessageParts(maxNumberOfMessagePartsValue);
                }
                if ((flashMessageValue = instance.flashMessage()) != null) {
                    this.flashMessage(flashMessageValue);
                }
                if ((expireAtValue = instance.expireAt()) != null) {
                    this.expireAt(expireAtValue);
                }
                if ((dltTemplateIdValue = instance.dltTemplateId()) != null) {
                    this.dltTemplateId(dltTemplateIdValue);
                }
                this.addAllTags(instance.tags());
                String senderValue = instance.sender();
                if (senderValue != null) {
                    this.sender(senderValue);
                }
                if ((senderTonValue = instance.senderTon()) != null) {
                    this.senderTon(senderTonValue);
                }
                this.addAllRecipients(instance.recipients());
                String clientReferenceValue = instance.clientReference();
                if (clientReferenceValue != null) {
                    this.clientReference(clientReferenceValue);
                }
                if ((dltPrincipalEntityValue = instance.dltPrincipalEntity()) != null) {
                    this.dltPrincipalEntity(dltPrincipalEntityValue);
                }
                if ((senderNpiValue = instance.senderNpi()) != null) {
                    this.senderNpi(senderNpiValue);
                }
                if ((callbackUrlValue = instance.callbackUrl()) != null) {
                    this.callbackUrl(callbackUrlValue);
                }
                if ((sendAtValue = instance.sendAt()) != null) {
                    this.sendAt(sendAtValue);
                }
                if ((feedbackEnabledValue = instance.feedbackEnabled()) != null) {
                    this.feedbackEnabled(feedbackEnabledValue);
                }
                if ((deliveryReportValue = instance.deliveryReport()) != null) {
                    this.deliveryReport(deliveryReportValue);
                }
            }
        }

        @JsonProperty(value="body")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsCreate.Builder body(String body) {
            this.body = (String)MtBatchTextSmsCreateImpl.requireNonNull(body, "body");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (MtBatchTextSmsCreate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MtBatchTextSmsCreate.Builder putParameter(String key, ParameterValues value) {
            this.parameters.put((String)MtBatchTextSmsCreateImpl.requireNonNull(key, "parameters key"), (ParameterValues)MtBatchTextSmsCreateImpl.requireNonNull(value, "parameters value"));
            return (MtBatchTextSmsCreate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MtBatchTextSmsCreate.Builder putParameter(Map.Entry<String, ? extends ParameterValues> entry) {
            String k = entry.getKey();
            ParameterValues v = entry.getValue();
            this.parameters.put((String)MtBatchTextSmsCreateImpl.requireNonNull(k, "parameters key"), (ParameterValues)MtBatchTextSmsCreateImpl.requireNonNull(v, "parameters value"));
            return (MtBatchTextSmsCreate.Builder)this;
        }

        @JsonProperty(value="parameters")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsCreate.Builder parameters(Map<String, ? extends ParameterValues> parameters) {
            this.parameters.clear();
            return this.putAllParameters(parameters);
        }

        @CanIgnoreReturnValue
        public final MtBatchTextSmsCreate.Builder putAllParameters(Map<String, ? extends ParameterValues> parameters) {
            for (Map.Entry<String, ? extends ParameterValues> entry : parameters.entrySet()) {
                String k = entry.getKey();
                ParameterValues v = entry.getValue();
                this.parameters.put((String)MtBatchTextSmsCreateImpl.requireNonNull(k, "parameters key"), (ParameterValues)MtBatchTextSmsCreateImpl.requireNonNull(v, "parameters value"));
            }
            return (MtBatchTextSmsCreate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MtBatchTextSmsCreate.Builder addRecipient(String element) {
            this.recipients.add((String)MtBatchTextSmsCreateImpl.requireNonNull(element, "recipients element"));
            return (MtBatchTextSmsCreate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MtBatchTextSmsCreate.Builder addRecipient(String ... elements) {
            for (String element : elements) {
                this.recipients.add((String)MtBatchTextSmsCreateImpl.requireNonNull(element, "recipients element"));
            }
            return (MtBatchTextSmsCreate.Builder)this;
        }

        @JsonProperty(value="to")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsCreate.Builder recipients(Iterable<String> elements) {
            this.recipients.clear();
            return this.addAllRecipients(elements);
        }

        @CanIgnoreReturnValue
        public final MtBatchTextSmsCreate.Builder addAllRecipients(Iterable<String> elements) {
            for (String element : elements) {
                this.recipients.add((String)MtBatchTextSmsCreateImpl.requireNonNull(element, "recipients element"));
            }
            return (MtBatchTextSmsCreate.Builder)this;
        }

        @JsonProperty(value="from")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsCreate.Builder sender(@Nullable String sender) {
            this.sender = sender;
            return (MtBatchTextSmsCreate.Builder)this;
        }

        @JsonProperty(value="delivery_report")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsCreate.Builder deliveryReport(@Nullable ReportType deliveryReport) {
            this.deliveryReport = deliveryReport;
            return (MtBatchTextSmsCreate.Builder)this;
        }

        @JsonProperty(value="send_at")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsCreate.Builder sendAt(@Nullable OffsetDateTime sendAt) {
            this.sendAt = sendAt;
            return (MtBatchTextSmsCreate.Builder)this;
        }

        @JsonProperty(value="expire_at")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsCreate.Builder expireAt(@Nullable OffsetDateTime expireAt) {
            this.expireAt = expireAt;
            return (MtBatchTextSmsCreate.Builder)this;
        }

        @JsonProperty(value="callback_url")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsCreate.Builder callbackUrl(@Nullable URI callbackUrl) {
            this.callbackUrl = callbackUrl;
            return (MtBatchTextSmsCreate.Builder)this;
        }

        @JsonProperty(value="feedback_enabled")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsCreate.Builder feedbackEnabled(@Nullable Boolean feedbackEnabled) {
            this.feedbackEnabled = feedbackEnabled;
            return (MtBatchTextSmsCreate.Builder)this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final MtBatchTextSmsCreate.Builder addTag(String element) {
            this.tags.add((String)MtBatchTextSmsCreateImpl.requireNonNull(element, "tags element"));
            return (MtBatchTextSmsCreate.Builder)this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final MtBatchTextSmsCreate.Builder addTag(String ... elements) {
            for (String element : elements) {
                this.tags.add((String)MtBatchTextSmsCreateImpl.requireNonNull(element, "tags element"));
            }
            return (MtBatchTextSmsCreate.Builder)this;
        }

        @JsonProperty(value="tags")
        @Deprecated
        @CanIgnoreReturnValue
        public final MtBatchTextSmsCreate.Builder tags(Iterable<String> elements) {
            this.tags.clear();
            return this.addAllTags(elements);
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final MtBatchTextSmsCreate.Builder addAllTags(Iterable<String> elements) {
            for (String element : elements) {
                this.tags.add((String)MtBatchTextSmsCreateImpl.requireNonNull(element, "tags element"));
            }
            return (MtBatchTextSmsCreate.Builder)this;
        }

        @JsonProperty(value="client_reference")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsCreate.Builder clientReference(@Nullable String clientReference) {
            this.clientReference = clientReference;
            return (MtBatchTextSmsCreate.Builder)this;
        }

        @JsonProperty(value="flash_message")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsCreate.Builder flashMessage(@Nullable Boolean flashMessage) {
            this.flashMessage = flashMessage;
            return (MtBatchTextSmsCreate.Builder)this;
        }

        @JsonProperty(value="max_number_of_message_parts")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsCreate.Builder maxNumberOfMessageParts(@Nullable Integer maxNumberOfMessageParts) {
            this.maxNumberOfMessageParts = maxNumberOfMessageParts;
            return (MtBatchTextSmsCreate.Builder)this;
        }

        @JsonProperty(value="dlt_principal_entity_id")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsCreate.Builder dltPrincipalEntity(@Nullable String dltPrincipalEntity) {
            this.dltPrincipalEntity = dltPrincipalEntity;
            return (MtBatchTextSmsCreate.Builder)this;
        }

        @JsonProperty(value="dlt_template_id")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsCreate.Builder dltTemplateId(@Nullable String dltTemplateId) {
            this.dltTemplateId = dltTemplateId;
            return (MtBatchTextSmsCreate.Builder)this;
        }

        @JsonProperty(value="from_ton")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsCreate.Builder senderTon(@Nullable Integer senderTon) {
            this.senderTon = senderTon;
            return (MtBatchTextSmsCreate.Builder)this;
        }

        @JsonProperty(value="from_npi")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsCreate.Builder senderNpi(@Nullable Integer senderNpi) {
            this.senderNpi = senderNpi;
            return (MtBatchTextSmsCreate.Builder)this;
        }

        public MtBatchTextSmsCreate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return MtBatchTextSmsCreateImpl.validate(new MtBatchTextSmsCreateImpl(this.body, MtBatchTextSmsCreateImpl.createUnmodifiableMap(false, false, this.parameters), MtBatchTextSmsCreateImpl.createUnmodifiableList(true, this.recipients), this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl, this.feedbackEnabled, MtBatchTextSmsCreateImpl.createUnmodifiableSet(this.tags), this.clientReference, this.flashMessage, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("body");
            }
            return "Cannot build MtBatchTextSmsCreate, some of required attributes are not set " + attributes;
        }
    }
}

