/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sinch.xms.api.BatchId;
import com.sinch.xms.api.MtBatchSmsResult;
import com.sinch.xms.api.MtBatchTextSmsResult;
import com.sinch.xms.api.ParameterValues;
import com.sinch.xms.api.ReportType;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
final class MtBatchTextSmsResultImpl
extends MtBatchTextSmsResult {
    private final String body;
    private final Map<String, ParameterValues> parameters;
    private final BatchId id;
    private final List<String> recipients;
    @Nullable
    private final String sender;
    private final ReportType deliveryReport;
    @Nullable
    private final URI callbackUrl;
    @Nullable
    private final OffsetDateTime sendAt;
    @Nullable
    private final OffsetDateTime expireAt;
    @Nullable
    private final OffsetDateTime createdAt;
    @Nullable
    private final OffsetDateTime modifiedAt;
    private final boolean canceled;
    @Nullable
    private final String clientReference;
    private final boolean flashMessage;
    @Nullable
    private final Boolean feedbackEnabled;
    @Nullable
    private final Integer maxNumberOfMessageParts;
    @Nullable
    private final String dltPrincipalEntity;
    @Nullable
    private final String dltTemplateId;
    @Nullable
    private final Integer senderTon;
    @Nullable
    private final Integer senderNpi;

    private MtBatchTextSmsResultImpl(String body, Map<String, ParameterValues> parameters, BatchId id, List<String> recipients, @Nullable String sender, ReportType deliveryReport, @Nullable URI callbackUrl, @Nullable OffsetDateTime sendAt, @Nullable OffsetDateTime expireAt, @Nullable OffsetDateTime createdAt, @Nullable OffsetDateTime modifiedAt, boolean canceled, @Nullable String clientReference, boolean flashMessage, @Nullable Boolean feedbackEnabled, @Nullable Integer maxNumberOfMessageParts, @Nullable String dltPrincipalEntity, @Nullable String dltTemplateId, @Nullable Integer senderTon, @Nullable Integer senderNpi) {
        this.body = body;
        this.parameters = parameters;
        this.id = id;
        this.recipients = recipients;
        this.sender = sender;
        this.deliveryReport = deliveryReport;
        this.callbackUrl = callbackUrl;
        this.sendAt = sendAt;
        this.expireAt = expireAt;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.canceled = canceled;
        this.clientReference = clientReference;
        this.flashMessage = flashMessage;
        this.feedbackEnabled = feedbackEnabled;
        this.maxNumberOfMessageParts = maxNumberOfMessageParts;
        this.dltPrincipalEntity = dltPrincipalEntity;
        this.dltTemplateId = dltTemplateId;
        this.senderTon = senderTon;
        this.senderNpi = senderNpi;
    }

    @Override
    @JsonProperty(value="body")
    public String body() {
        return this.body;
    }

    @Override
    @JsonProperty(value="parameters")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, ParameterValues> parameters() {
        return this.parameters;
    }

    @Override
    @JsonProperty(value="id")
    public BatchId id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="to")
    public List<String> recipients() {
        return this.recipients;
    }

    @Override
    @JsonProperty(value="from")
    @Nullable
    public String sender() {
        return this.sender;
    }

    @Override
    @JsonProperty(value="delivery_report")
    public ReportType deliveryReport() {
        return this.deliveryReport;
    }

    @Override
    @JsonProperty(value="callbackUrl")
    @Nullable
    public URI callbackUrl() {
        return this.callbackUrl;
    }

    @Override
    @JsonProperty(value="send_at")
    @Nullable
    public OffsetDateTime sendAt() {
        return this.sendAt;
    }

    @Override
    @JsonProperty(value="expire_at")
    @Nullable
    public OffsetDateTime expireAt() {
        return this.expireAt;
    }

    @Override
    @JsonProperty(value="created_at")
    @Nullable
    public OffsetDateTime createdAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="modified_at")
    @Nullable
    public OffsetDateTime modifiedAt() {
        return this.modifiedAt;
    }

    @Override
    @JsonProperty(value="canceled")
    public boolean canceled() {
        return this.canceled;
    }

    @Override
    @JsonProperty(value="client_reference")
    @Nullable
    public String clientReference() {
        return this.clientReference;
    }

    @Override
    @JsonProperty(value="flash_message")
    public boolean flashMessage() {
        return this.flashMessage;
    }

    @Override
    @JsonProperty(value="feedback_enabled")
    @Nullable
    public Boolean feedbackEnabled() {
        return this.feedbackEnabled;
    }

    @Override
    @JsonProperty(value="max_number_of_message_parts")
    @Nullable
    public Integer maxNumberOfMessageParts() {
        return this.maxNumberOfMessageParts;
    }

    @Override
    @JsonProperty(value="dlt_principal_entity_id")
    @Nullable
    public String dltPrincipalEntity() {
        return this.dltPrincipalEntity;
    }

    @Override
    @JsonProperty(value="dlt_template_id")
    @Nullable
    public String dltTemplateId() {
        return this.dltTemplateId;
    }

    @Override
    @JsonProperty(value="from_ton")
    @Nullable
    public Integer senderTon() {
        return this.senderTon;
    }

    @Override
    @JsonProperty(value="from_npi")
    @Nullable
    public Integer senderNpi() {
        return this.senderNpi;
    }

    public final MtBatchTextSmsResultImpl withBody(String value) {
        if (this.body.equals(value)) {
            return this;
        }
        String newValue = MtBatchTextSmsResultImpl.requireNonNull(value, "body");
        return new MtBatchTextSmsResultImpl(newValue, this.parameters, this.id, this.recipients, this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchTextSmsResultImpl withParameters(Map<String, ? extends ParameterValues> entries) {
        if (this.parameters == entries) {
            return this;
        }
        Map<String, ParameterValues> newValue = MtBatchTextSmsResultImpl.createUnmodifiableMap(true, false, entries);
        return new MtBatchTextSmsResultImpl(this.body, newValue, this.id, this.recipients, this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchTextSmsResultImpl withId(BatchId value) {
        if (this.id == value) {
            return this;
        }
        BatchId newValue = MtBatchTextSmsResultImpl.requireNonNull(value, "id");
        return new MtBatchTextSmsResultImpl(this.body, this.parameters, newValue, this.recipients, this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchTextSmsResultImpl withRecipients(String ... elements) {
        List<String> newValue = MtBatchTextSmsResultImpl.createUnmodifiableList(false, MtBatchTextSmsResultImpl.createSafeList(Arrays.asList(elements), true, false));
        return new MtBatchTextSmsResultImpl(this.body, this.parameters, this.id, newValue, this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchTextSmsResultImpl withRecipients(Iterable<String> elements) {
        if (this.recipients == elements) {
            return this;
        }
        List<String> newValue = MtBatchTextSmsResultImpl.createUnmodifiableList(false, MtBatchTextSmsResultImpl.createSafeList(elements, true, false));
        return new MtBatchTextSmsResultImpl(this.body, this.parameters, this.id, newValue, this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchTextSmsResultImpl withSender(@Nullable String value) {
        if (MtBatchTextSmsResultImpl.equals(this.sender, value)) {
            return this;
        }
        return new MtBatchTextSmsResultImpl(this.body, this.parameters, this.id, this.recipients, value, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchTextSmsResultImpl withDeliveryReport(ReportType value) {
        if (this.deliveryReport == value) {
            return this;
        }
        ReportType newValue = MtBatchTextSmsResultImpl.requireNonNull(value, "deliveryReport");
        return new MtBatchTextSmsResultImpl(this.body, this.parameters, this.id, this.recipients, this.sender, newValue, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchTextSmsResultImpl withCallbackUrl(@Nullable URI value) {
        if (this.callbackUrl == value) {
            return this;
        }
        return new MtBatchTextSmsResultImpl(this.body, this.parameters, this.id, this.recipients, this.sender, this.deliveryReport, value, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchTextSmsResultImpl withSendAt(@Nullable OffsetDateTime value) {
        if (this.sendAt == value) {
            return this;
        }
        return new MtBatchTextSmsResultImpl(this.body, this.parameters, this.id, this.recipients, this.sender, this.deliveryReport, this.callbackUrl, value, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchTextSmsResultImpl withExpireAt(@Nullable OffsetDateTime value) {
        if (this.expireAt == value) {
            return this;
        }
        return new MtBatchTextSmsResultImpl(this.body, this.parameters, this.id, this.recipients, this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, value, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchTextSmsResultImpl withCreatedAt(@Nullable OffsetDateTime value) {
        if (this.createdAt == value) {
            return this;
        }
        return new MtBatchTextSmsResultImpl(this.body, this.parameters, this.id, this.recipients, this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, value, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchTextSmsResultImpl withModifiedAt(@Nullable OffsetDateTime value) {
        if (this.modifiedAt == value) {
            return this;
        }
        return new MtBatchTextSmsResultImpl(this.body, this.parameters, this.id, this.recipients, this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, value, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchTextSmsResultImpl withCanceled(boolean value) {
        if (this.canceled == value) {
            return this;
        }
        return new MtBatchTextSmsResultImpl(this.body, this.parameters, this.id, this.recipients, this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, value, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchTextSmsResultImpl withClientReference(@Nullable String value) {
        if (MtBatchTextSmsResultImpl.equals(this.clientReference, value)) {
            return this;
        }
        return new MtBatchTextSmsResultImpl(this.body, this.parameters, this.id, this.recipients, this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, value, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchTextSmsResultImpl withFlashMessage(boolean value) {
        if (this.flashMessage == value) {
            return this;
        }
        return new MtBatchTextSmsResultImpl(this.body, this.parameters, this.id, this.recipients, this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, value, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchTextSmsResultImpl withFeedbackEnabled(@Nullable Boolean value) {
        if (MtBatchTextSmsResultImpl.equals(this.feedbackEnabled, value)) {
            return this;
        }
        return new MtBatchTextSmsResultImpl(this.body, this.parameters, this.id, this.recipients, this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, value, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchTextSmsResultImpl withMaxNumberOfMessageParts(@Nullable Integer value) {
        if (MtBatchTextSmsResultImpl.equals(this.maxNumberOfMessageParts, value)) {
            return this;
        }
        return new MtBatchTextSmsResultImpl(this.body, this.parameters, this.id, this.recipients, this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, value, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchTextSmsResultImpl withDltPrincipalEntity(@Nullable String value) {
        if (MtBatchTextSmsResultImpl.equals(this.dltPrincipalEntity, value)) {
            return this;
        }
        return new MtBatchTextSmsResultImpl(this.body, this.parameters, this.id, this.recipients, this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, value, this.dltTemplateId, this.senderTon, this.senderNpi);
    }

    public final MtBatchTextSmsResultImpl withDltTemplateId(@Nullable String value) {
        if (MtBatchTextSmsResultImpl.equals(this.dltTemplateId, value)) {
            return this;
        }
        return new MtBatchTextSmsResultImpl(this.body, this.parameters, this.id, this.recipients, this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, value, this.senderTon, this.senderNpi);
    }

    public final MtBatchTextSmsResultImpl withSenderTon(@Nullable Integer value) {
        if (MtBatchTextSmsResultImpl.equals(this.senderTon, value)) {
            return this;
        }
        return new MtBatchTextSmsResultImpl(this.body, this.parameters, this.id, this.recipients, this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, value, this.senderNpi);
    }

    public final MtBatchTextSmsResultImpl withSenderNpi(@Nullable Integer value) {
        if (MtBatchTextSmsResultImpl.equals(this.senderNpi, value)) {
            return this;
        }
        return new MtBatchTextSmsResultImpl(this.body, this.parameters, this.id, this.recipients, this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof MtBatchTextSmsResultImpl && this.equalTo((MtBatchTextSmsResultImpl)another);
    }

    private boolean equalTo(MtBatchTextSmsResultImpl another) {
        return this.body.equals(another.body) && this.parameters.equals(another.parameters) && this.id.equals(another.id) && this.recipients.equals(another.recipients) && MtBatchTextSmsResultImpl.equals(this.sender, another.sender) && this.deliveryReport.equals(another.deliveryReport) && MtBatchTextSmsResultImpl.equals(this.callbackUrl, another.callbackUrl) && MtBatchTextSmsResultImpl.equals(this.sendAt, another.sendAt) && MtBatchTextSmsResultImpl.equals(this.expireAt, another.expireAt) && MtBatchTextSmsResultImpl.equals(this.createdAt, another.createdAt) && MtBatchTextSmsResultImpl.equals(this.modifiedAt, another.modifiedAt) && this.canceled == another.canceled && MtBatchTextSmsResultImpl.equals(this.clientReference, another.clientReference) && this.flashMessage == another.flashMessage && MtBatchTextSmsResultImpl.equals(this.feedbackEnabled, another.feedbackEnabled) && MtBatchTextSmsResultImpl.equals(this.maxNumberOfMessageParts, another.maxNumberOfMessageParts) && MtBatchTextSmsResultImpl.equals(this.dltPrincipalEntity, another.dltPrincipalEntity) && MtBatchTextSmsResultImpl.equals(this.dltTemplateId, another.dltTemplateId) && MtBatchTextSmsResultImpl.equals(this.senderTon, another.senderTon) && MtBatchTextSmsResultImpl.equals(this.senderNpi, another.senderNpi);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.body.hashCode();
        h = h * 17 + this.parameters.hashCode();
        h = h * 17 + this.id.hashCode();
        h = h * 17 + this.recipients.hashCode();
        h = h * 17 + MtBatchTextSmsResultImpl.hashCode(this.sender);
        h = h * 17 + this.deliveryReport.hashCode();
        h = h * 17 + MtBatchTextSmsResultImpl.hashCode(this.callbackUrl);
        h = h * 17 + MtBatchTextSmsResultImpl.hashCode(this.sendAt);
        h = h * 17 + MtBatchTextSmsResultImpl.hashCode(this.expireAt);
        h = h * 17 + MtBatchTextSmsResultImpl.hashCode(this.createdAt);
        h = h * 17 + MtBatchTextSmsResultImpl.hashCode(this.modifiedAt);
        h = h * 17 + (this.canceled ? 1231 : 1237);
        h = h * 17 + MtBatchTextSmsResultImpl.hashCode(this.clientReference);
        h = h * 17 + (this.flashMessage ? 1231 : 1237);
        h = h * 17 + MtBatchTextSmsResultImpl.hashCode(this.feedbackEnabled);
        h = h * 17 + MtBatchTextSmsResultImpl.hashCode(this.maxNumberOfMessageParts);
        h = h * 17 + MtBatchTextSmsResultImpl.hashCode(this.dltPrincipalEntity);
        h = h * 17 + MtBatchTextSmsResultImpl.hashCode(this.dltTemplateId);
        h = h * 17 + MtBatchTextSmsResultImpl.hashCode(this.senderTon);
        h = h * 17 + MtBatchTextSmsResultImpl.hashCode(this.senderNpi);
        return h;
    }

    public String toString() {
        return "MtBatchTextSmsResult{body=" + this.body + ", parameters=" + this.parameters + ", id=" + this.id + ", recipients=" + this.recipients + ", sender=" + this.sender + ", deliveryReport=" + this.deliveryReport + ", callbackUrl=" + this.callbackUrl + ", sendAt=" + this.sendAt + ", expireAt=" + this.expireAt + ", createdAt=" + this.createdAt + ", modifiedAt=" + this.modifiedAt + ", canceled=" + this.canceled + ", clientReference=" + this.clientReference + ", flashMessage=" + this.flashMessage + ", feedbackEnabled=" + this.feedbackEnabled + ", maxNumberOfMessageParts=" + this.maxNumberOfMessageParts + ", dltPrincipalEntity=" + this.dltPrincipalEntity + ", dltTemplateId=" + this.dltTemplateId + ", senderTon=" + this.senderTon + ", senderNpi=" + this.senderNpi + "}";
    }

    public static MtBatchTextSmsResult copyOf(MtBatchTextSmsResult instance) {
        if (instance instanceof MtBatchTextSmsResultImpl) {
            return (MtBatchTextSmsResultImpl)instance;
        }
        return new MtBatchTextSmsResult.Builder().using(instance).build();
    }

    private static <T> T requireNonNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    private static int hashCode(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    private static boolean equals(Object left, Object right) {
        return left == right || left != null && left.equals(right);
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                MtBatchTextSmsResultImpl.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    MtBatchTextSmsResultImpl.requireNonNull(k, "key");
                    MtBatchTextSmsResultImpl.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    MtBatchTextSmsResultImpl.requireNonNull(k, "key");
                    MtBatchTextSmsResultImpl.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @NotThreadSafe
    static class Builder {
        private static final long INIT_BIT_BODY = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_DELIVERY_REPORT = 4L;
        private static final long INIT_BIT_CANCELED = 8L;
        private static final long INIT_BIT_FLASH_MESSAGE = 16L;
        private long initBits = 31L;
        @Nullable
        private String body;
        private Map<String, ParameterValues> parameters = new LinkedHashMap<String, ParameterValues>();
        @Nullable
        private BatchId id;
        private List<String> recipients = new ArrayList<String>();
        @Nullable
        private String sender;
        @Nullable
        private ReportType deliveryReport;
        @Nullable
        private URI callbackUrl;
        @Nullable
        private OffsetDateTime sendAt;
        @Nullable
        private OffsetDateTime expireAt;
        @Nullable
        private OffsetDateTime createdAt;
        @Nullable
        private OffsetDateTime modifiedAt;
        private boolean canceled;
        @Nullable
        private String clientReference;
        private boolean flashMessage;
        @Nullable
        private Boolean feedbackEnabled;
        @Nullable
        private Integer maxNumberOfMessageParts;
        @Nullable
        private String dltPrincipalEntity;
        @Nullable
        private String dltTemplateId;
        @Nullable
        private Integer senderTon;
        @Nullable
        private Integer senderNpi;

        Builder() {
            if (!(this instanceof MtBatchTextSmsResult.Builder)) {
                throw new UnsupportedOperationException("Use: new MtBatchTextSmsResult.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final MtBatchTextSmsResult.Builder using(MtBatchTextSmsResult instance) {
            MtBatchTextSmsResultImpl.requireNonNull(instance, "instance");
            this.from(instance);
            return (MtBatchTextSmsResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MtBatchTextSmsResult.Builder using(MtBatchSmsResult instance) {
            MtBatchTextSmsResultImpl.requireNonNull(instance, "instance");
            this.from(instance);
            return (MtBatchTextSmsResult.Builder)this;
        }

        private void from(Object object) {
            MtBatchSmsResult instance;
            if (object instanceof MtBatchTextSmsResult) {
                instance = (MtBatchTextSmsResult)object;
                this.body(((MtBatchTextSmsResult)instance).body());
                this.putAllParameters(((MtBatchTextSmsResult)instance).parameters());
            }
            if (object instanceof MtBatchSmsResult) {
                Boolean feedbackEnabledValue;
                URI callbackUrlValue;
                Integer senderNpiValue;
                String dltPrincipalEntityValue;
                Integer senderTonValue;
                OffsetDateTime createdAtValue;
                String dltTemplateIdValue;
                OffsetDateTime expireAtValue;
                instance = (MtBatchSmsResult)object;
                Integer maxNumberOfMessagePartsValue = instance.maxNumberOfMessageParts();
                if (maxNumberOfMessagePartsValue != null) {
                    this.maxNumberOfMessageParts(maxNumberOfMessagePartsValue);
                }
                this.flashMessage(instance.flashMessage());
                OffsetDateTime modifiedAtValue = instance.modifiedAt();
                if (modifiedAtValue != null) {
                    this.modifiedAt(modifiedAtValue);
                }
                if ((expireAtValue = instance.expireAt()) != null) {
                    this.expireAt(expireAtValue);
                }
                if ((dltTemplateIdValue = instance.dltTemplateId()) != null) {
                    this.dltTemplateId(dltTemplateIdValue);
                }
                if ((createdAtValue = instance.createdAt()) != null) {
                    this.createdAt(createdAtValue);
                }
                this.canceled(instance.canceled());
                String senderValue = instance.sender();
                if (senderValue != null) {
                    this.sender(senderValue);
                }
                if ((senderTonValue = instance.senderTon()) != null) {
                    this.senderTon(senderTonValue);
                }
                this.addAllRecipients(instance.recipients());
                String clientReferenceValue = instance.clientReference();
                if (clientReferenceValue != null) {
                    this.clientReference(clientReferenceValue);
                }
                if ((dltPrincipalEntityValue = instance.dltPrincipalEntity()) != null) {
                    this.dltPrincipalEntity(dltPrincipalEntityValue);
                }
                if ((senderNpiValue = instance.senderNpi()) != null) {
                    this.senderNpi(senderNpiValue);
                }
                if ((callbackUrlValue = instance.callbackUrl()) != null) {
                    this.callbackUrl(callbackUrlValue);
                }
                this.id(instance.id());
                OffsetDateTime sendAtValue = instance.sendAt();
                if (sendAtValue != null) {
                    this.sendAt(sendAtValue);
                }
                if ((feedbackEnabledValue = instance.feedbackEnabled()) != null) {
                    this.feedbackEnabled(feedbackEnabledValue);
                }
                this.deliveryReport(instance.deliveryReport());
            }
        }

        @JsonProperty(value="body")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsResult.Builder body(String body) {
            this.body = (String)MtBatchTextSmsResultImpl.requireNonNull(body, "body");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (MtBatchTextSmsResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MtBatchTextSmsResult.Builder putParameter(String key, ParameterValues value) {
            this.parameters.put((String)MtBatchTextSmsResultImpl.requireNonNull(key, "parameters key"), (ParameterValues)MtBatchTextSmsResultImpl.requireNonNull(value, "parameters value"));
            return (MtBatchTextSmsResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MtBatchTextSmsResult.Builder putParameter(Map.Entry<String, ? extends ParameterValues> entry) {
            String k = entry.getKey();
            ParameterValues v = entry.getValue();
            this.parameters.put((String)MtBatchTextSmsResultImpl.requireNonNull(k, "parameters key"), (ParameterValues)MtBatchTextSmsResultImpl.requireNonNull(v, "parameters value"));
            return (MtBatchTextSmsResult.Builder)this;
        }

        @JsonProperty(value="parameters")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsResult.Builder parameters(Map<String, ? extends ParameterValues> parameters) {
            this.parameters.clear();
            return this.putAllParameters(parameters);
        }

        @CanIgnoreReturnValue
        public final MtBatchTextSmsResult.Builder putAllParameters(Map<String, ? extends ParameterValues> parameters) {
            for (Map.Entry<String, ? extends ParameterValues> entry : parameters.entrySet()) {
                String k = entry.getKey();
                ParameterValues v = entry.getValue();
                this.parameters.put((String)MtBatchTextSmsResultImpl.requireNonNull(k, "parameters key"), (ParameterValues)MtBatchTextSmsResultImpl.requireNonNull(v, "parameters value"));
            }
            return (MtBatchTextSmsResult.Builder)this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsResult.Builder id(BatchId id) {
            this.id = (BatchId)MtBatchTextSmsResultImpl.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (MtBatchTextSmsResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MtBatchTextSmsResult.Builder addRecipient(String element) {
            this.recipients.add((String)MtBatchTextSmsResultImpl.requireNonNull(element, "recipients element"));
            return (MtBatchTextSmsResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MtBatchTextSmsResult.Builder addRecipient(String ... elements) {
            for (String element : elements) {
                this.recipients.add((String)MtBatchTextSmsResultImpl.requireNonNull(element, "recipients element"));
            }
            return (MtBatchTextSmsResult.Builder)this;
        }

        @JsonProperty(value="to")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsResult.Builder recipients(Iterable<String> elements) {
            this.recipients.clear();
            return this.addAllRecipients(elements);
        }

        @CanIgnoreReturnValue
        public final MtBatchTextSmsResult.Builder addAllRecipients(Iterable<String> elements) {
            for (String element : elements) {
                this.recipients.add((String)MtBatchTextSmsResultImpl.requireNonNull(element, "recipients element"));
            }
            return (MtBatchTextSmsResult.Builder)this;
        }

        @JsonProperty(value="from")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsResult.Builder sender(@Nullable String sender) {
            this.sender = sender;
            return (MtBatchTextSmsResult.Builder)this;
        }

        @JsonProperty(value="delivery_report")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsResult.Builder deliveryReport(ReportType deliveryReport) {
            this.deliveryReport = (ReportType)MtBatchTextSmsResultImpl.requireNonNull(deliveryReport, "deliveryReport");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return (MtBatchTextSmsResult.Builder)this;
        }

        @JsonProperty(value="callbackUrl")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsResult.Builder callbackUrl(@Nullable URI callbackUrl) {
            this.callbackUrl = callbackUrl;
            return (MtBatchTextSmsResult.Builder)this;
        }

        @JsonProperty(value="send_at")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsResult.Builder sendAt(@Nullable OffsetDateTime sendAt) {
            this.sendAt = sendAt;
            return (MtBatchTextSmsResult.Builder)this;
        }

        @JsonProperty(value="expire_at")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsResult.Builder expireAt(@Nullable OffsetDateTime expireAt) {
            this.expireAt = expireAt;
            return (MtBatchTextSmsResult.Builder)this;
        }

        @JsonProperty(value="created_at")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsResult.Builder createdAt(@Nullable OffsetDateTime createdAt) {
            this.createdAt = createdAt;
            return (MtBatchTextSmsResult.Builder)this;
        }

        @JsonProperty(value="modified_at")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsResult.Builder modifiedAt(@Nullable OffsetDateTime modifiedAt) {
            this.modifiedAt = modifiedAt;
            return (MtBatchTextSmsResult.Builder)this;
        }

        @JsonProperty(value="canceled")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsResult.Builder canceled(boolean canceled) {
            this.canceled = canceled;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return (MtBatchTextSmsResult.Builder)this;
        }

        @JsonProperty(value="client_reference")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsResult.Builder clientReference(@Nullable String clientReference) {
            this.clientReference = clientReference;
            return (MtBatchTextSmsResult.Builder)this;
        }

        @JsonProperty(value="flash_message")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsResult.Builder flashMessage(boolean flashMessage) {
            this.flashMessage = flashMessage;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return (MtBatchTextSmsResult.Builder)this;
        }

        @JsonProperty(value="feedback_enabled")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsResult.Builder feedbackEnabled(@Nullable Boolean feedbackEnabled) {
            this.feedbackEnabled = feedbackEnabled;
            return (MtBatchTextSmsResult.Builder)this;
        }

        @JsonProperty(value="max_number_of_message_parts")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsResult.Builder maxNumberOfMessageParts(@Nullable Integer maxNumberOfMessageParts) {
            this.maxNumberOfMessageParts = maxNumberOfMessageParts;
            return (MtBatchTextSmsResult.Builder)this;
        }

        @JsonProperty(value="dlt_principal_entity_id")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsResult.Builder dltPrincipalEntity(@Nullable String dltPrincipalEntity) {
            this.dltPrincipalEntity = dltPrincipalEntity;
            return (MtBatchTextSmsResult.Builder)this;
        }

        @JsonProperty(value="dlt_template_id")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsResult.Builder dltTemplateId(@Nullable String dltTemplateId) {
            this.dltTemplateId = dltTemplateId;
            return (MtBatchTextSmsResult.Builder)this;
        }

        @JsonProperty(value="from_ton")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsResult.Builder senderTon(@Nullable Integer senderTon) {
            this.senderTon = senderTon;
            return (MtBatchTextSmsResult.Builder)this;
        }

        @JsonProperty(value="from_npi")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsResult.Builder senderNpi(@Nullable Integer senderNpi) {
            this.senderNpi = senderNpi;
            return (MtBatchTextSmsResult.Builder)this;
        }

        public MtBatchTextSmsResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new MtBatchTextSmsResultImpl(this.body, MtBatchTextSmsResultImpl.createUnmodifiableMap(false, false, this.parameters), this.id, MtBatchTextSmsResultImpl.createUnmodifiableList(true, this.recipients), this.sender, this.deliveryReport, this.callbackUrl, this.sendAt, this.expireAt, this.createdAt, this.modifiedAt, this.canceled, this.clientReference, this.flashMessage, this.feedbackEnabled, this.maxNumberOfMessageParts, this.dltPrincipalEntity, this.dltTemplateId, this.senderTon, this.senderNpi);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("body");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("deliveryReport");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("canceled");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("flashMessage");
            }
            return "Cannot build MtBatchTextSmsResult, some of required attributes are not set " + attributes;
        }
    }
}

