/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sinch.xms.UpdateValue;
import com.sinch.xms.api.MtBatchSmsUpdate;
import com.sinch.xms.api.MtBatchTextSmsUpdate;
import com.sinch.xms.api.ParameterValues;
import com.sinch.xms.api.ReportType;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
final class MtBatchTextSmsUpdateImpl
extends MtBatchTextSmsUpdate {
    @Nullable
    private final String body;
    @Nullable
    private final UpdateValue<Map<String, ParameterValues>> parameters;
    @Nullable
    private final List<String> recipientInsertions;
    @Nullable
    private final List<String> recipientRemovals;
    @Nullable
    private final String sender;
    @Nullable
    private final UpdateValue<ReportType> deliveryReport;
    @Nullable
    private final UpdateValue<OffsetDateTime> sendAt;
    @Nullable
    private final UpdateValue<OffsetDateTime> expireAt;
    @Nullable
    private final UpdateValue<URI> callbackUrl;

    private MtBatchTextSmsUpdateImpl(@Nullable String body, @Nullable UpdateValue<Map<String, ParameterValues>> parameters, @Nullable List<String> recipientInsertions, @Nullable List<String> recipientRemovals, @Nullable String sender, @Nullable UpdateValue<ReportType> deliveryReport, @Nullable UpdateValue<OffsetDateTime> sendAt, @Nullable UpdateValue<OffsetDateTime> expireAt, @Nullable UpdateValue<URI> callbackUrl) {
        this.body = body;
        this.parameters = parameters;
        this.recipientInsertions = recipientInsertions;
        this.recipientRemovals = recipientRemovals;
        this.sender = sender;
        this.deliveryReport = deliveryReport;
        this.sendAt = sendAt;
        this.expireAt = expireAt;
        this.callbackUrl = callbackUrl;
    }

    @Override
    @JsonProperty(value="body")
    @Nullable
    public String body() {
        return this.body;
    }

    @Override
    @JsonProperty(value="parameters")
    @Nullable
    public UpdateValue<Map<String, ParameterValues>> parameters() {
        return this.parameters;
    }

    @Override
    @JsonProperty(value="to_add")
    @Nullable
    public List<String> recipientInsertions() {
        return this.recipientInsertions;
    }

    @Override
    @JsonProperty(value="to_remove")
    @Nullable
    public List<String> recipientRemovals() {
        return this.recipientRemovals;
    }

    @Override
    @JsonProperty(value="from")
    @Nullable
    public String sender() {
        return this.sender;
    }

    @Override
    @JsonProperty(value="delivery_report")
    @Nullable
    public UpdateValue<ReportType> deliveryReport() {
        return this.deliveryReport;
    }

    @Override
    @JsonProperty(value="send_at")
    @Nullable
    public UpdateValue<OffsetDateTime> sendAt() {
        return this.sendAt;
    }

    @Override
    @JsonProperty(value="expire_at")
    @Nullable
    public UpdateValue<OffsetDateTime> expireAt() {
        return this.expireAt;
    }

    @Override
    @JsonProperty(value="callback_url")
    @Nullable
    public UpdateValue<URI> callbackUrl() {
        return this.callbackUrl;
    }

    public final MtBatchTextSmsUpdateImpl withBody(@Nullable String value) {
        if (MtBatchTextSmsUpdateImpl.equals(this.body, value)) {
            return this;
        }
        return MtBatchTextSmsUpdateImpl.validate(new MtBatchTextSmsUpdateImpl(value, this.parameters, this.recipientInsertions, this.recipientRemovals, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl));
    }

    public final MtBatchTextSmsUpdateImpl withParameters(@Nullable UpdateValue<Map<String, ParameterValues>> value) {
        if (this.parameters == value) {
            return this;
        }
        return MtBatchTextSmsUpdateImpl.validate(new MtBatchTextSmsUpdateImpl(this.body, value, this.recipientInsertions, this.recipientRemovals, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl));
    }

    public final MtBatchTextSmsUpdateImpl withRecipientInsertions(String ... elements) {
        if (elements == null) {
            return MtBatchTextSmsUpdateImpl.validate(new MtBatchTextSmsUpdateImpl(this.body, this.parameters, null, this.recipientRemovals, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl));
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : MtBatchTextSmsUpdateImpl.createUnmodifiableList(false, MtBatchTextSmsUpdateImpl.createSafeList(Arrays.asList(elements), true, false));
        return MtBatchTextSmsUpdateImpl.validate(new MtBatchTextSmsUpdateImpl(this.body, this.parameters, newValue, this.recipientRemovals, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl));
    }

    public final MtBatchTextSmsUpdateImpl withRecipientInsertions(@Nullable Iterable<String> elements) {
        if (this.recipientInsertions == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : MtBatchTextSmsUpdateImpl.createUnmodifiableList(false, MtBatchTextSmsUpdateImpl.createSafeList(elements, true, false));
        return MtBatchTextSmsUpdateImpl.validate(new MtBatchTextSmsUpdateImpl(this.body, this.parameters, newValue, this.recipientRemovals, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl));
    }

    public final MtBatchTextSmsUpdateImpl withRecipientRemovals(String ... elements) {
        if (elements == null) {
            return MtBatchTextSmsUpdateImpl.validate(new MtBatchTextSmsUpdateImpl(this.body, this.parameters, this.recipientInsertions, null, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl));
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : MtBatchTextSmsUpdateImpl.createUnmodifiableList(false, MtBatchTextSmsUpdateImpl.createSafeList(Arrays.asList(elements), true, false));
        return MtBatchTextSmsUpdateImpl.validate(new MtBatchTextSmsUpdateImpl(this.body, this.parameters, this.recipientInsertions, newValue, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl));
    }

    public final MtBatchTextSmsUpdateImpl withRecipientRemovals(@Nullable Iterable<String> elements) {
        if (this.recipientRemovals == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : MtBatchTextSmsUpdateImpl.createUnmodifiableList(false, MtBatchTextSmsUpdateImpl.createSafeList(elements, true, false));
        return MtBatchTextSmsUpdateImpl.validate(new MtBatchTextSmsUpdateImpl(this.body, this.parameters, this.recipientInsertions, newValue, this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl));
    }

    public final MtBatchTextSmsUpdateImpl withSender(@Nullable String value) {
        if (MtBatchTextSmsUpdateImpl.equals(this.sender, value)) {
            return this;
        }
        return MtBatchTextSmsUpdateImpl.validate(new MtBatchTextSmsUpdateImpl(this.body, this.parameters, this.recipientInsertions, this.recipientRemovals, value, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl));
    }

    public final MtBatchTextSmsUpdateImpl withDeliveryReport(@Nullable UpdateValue<ReportType> value) {
        if (this.deliveryReport == value) {
            return this;
        }
        return MtBatchTextSmsUpdateImpl.validate(new MtBatchTextSmsUpdateImpl(this.body, this.parameters, this.recipientInsertions, this.recipientRemovals, this.sender, value, this.sendAt, this.expireAt, this.callbackUrl));
    }

    public final MtBatchTextSmsUpdateImpl withSendAt(@Nullable UpdateValue<OffsetDateTime> value) {
        if (this.sendAt == value) {
            return this;
        }
        return MtBatchTextSmsUpdateImpl.validate(new MtBatchTextSmsUpdateImpl(this.body, this.parameters, this.recipientInsertions, this.recipientRemovals, this.sender, this.deliveryReport, value, this.expireAt, this.callbackUrl));
    }

    public final MtBatchTextSmsUpdateImpl withExpireAt(@Nullable UpdateValue<OffsetDateTime> value) {
        if (this.expireAt == value) {
            return this;
        }
        return MtBatchTextSmsUpdateImpl.validate(new MtBatchTextSmsUpdateImpl(this.body, this.parameters, this.recipientInsertions, this.recipientRemovals, this.sender, this.deliveryReport, this.sendAt, value, this.callbackUrl));
    }

    public final MtBatchTextSmsUpdateImpl withCallbackUrl(@Nullable UpdateValue<URI> value) {
        if (this.callbackUrl == value) {
            return this;
        }
        return MtBatchTextSmsUpdateImpl.validate(new MtBatchTextSmsUpdateImpl(this.body, this.parameters, this.recipientInsertions, this.recipientRemovals, this.sender, this.deliveryReport, this.sendAt, this.expireAt, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof MtBatchTextSmsUpdateImpl && this.equalTo((MtBatchTextSmsUpdateImpl)another);
    }

    private boolean equalTo(MtBatchTextSmsUpdateImpl another) {
        return MtBatchTextSmsUpdateImpl.equals(this.body, another.body) && MtBatchTextSmsUpdateImpl.equals(this.parameters, another.parameters) && MtBatchTextSmsUpdateImpl.equals(this.recipientInsertions, another.recipientInsertions) && MtBatchTextSmsUpdateImpl.equals(this.recipientRemovals, another.recipientRemovals) && MtBatchTextSmsUpdateImpl.equals(this.sender, another.sender) && MtBatchTextSmsUpdateImpl.equals(this.deliveryReport, another.deliveryReport) && MtBatchTextSmsUpdateImpl.equals(this.sendAt, another.sendAt) && MtBatchTextSmsUpdateImpl.equals(this.expireAt, another.expireAt) && MtBatchTextSmsUpdateImpl.equals(this.callbackUrl, another.callbackUrl);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + MtBatchTextSmsUpdateImpl.hashCode(this.body);
        h = h * 17 + MtBatchTextSmsUpdateImpl.hashCode(this.parameters);
        h = h * 17 + MtBatchTextSmsUpdateImpl.hashCode(this.recipientInsertions);
        h = h * 17 + MtBatchTextSmsUpdateImpl.hashCode(this.recipientRemovals);
        h = h * 17 + MtBatchTextSmsUpdateImpl.hashCode(this.sender);
        h = h * 17 + MtBatchTextSmsUpdateImpl.hashCode(this.deliveryReport);
        h = h * 17 + MtBatchTextSmsUpdateImpl.hashCode(this.sendAt);
        h = h * 17 + MtBatchTextSmsUpdateImpl.hashCode(this.expireAt);
        h = h * 17 + MtBatchTextSmsUpdateImpl.hashCode(this.callbackUrl);
        return h;
    }

    public String toString() {
        return "MtBatchTextSmsUpdate{body=" + this.body + ", parameters=" + this.parameters + ", recipientInsertions=" + this.recipientInsertions + ", recipientRemovals=" + this.recipientRemovals + ", sender=" + this.sender + ", deliveryReport=" + this.deliveryReport + ", sendAt=" + this.sendAt + ", expireAt=" + this.expireAt + ", callbackUrl=" + this.callbackUrl + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static MtBatchTextSmsUpdateImpl fromJson(Json json) {
        MtBatchTextSmsUpdate.Builder builder = new MtBatchTextSmsUpdate.Builder();
        if (json.body != null) {
            builder.body(json.body);
        }
        if (json.parameters != null) {
            builder.parameters(json.parameters);
        }
        if (json.recipientInsertions != null) {
            builder.addAllRecipientInsertions(json.recipientInsertions);
        }
        if (json.recipientRemovals != null) {
            builder.addAllRecipientRemovals(json.recipientRemovals);
        }
        if (json.sender != null) {
            builder.sender(json.sender);
        }
        if (json.deliveryReport != null) {
            builder.deliveryReport(json.deliveryReport);
        }
        if (json.sendAt != null) {
            builder.sendAt(json.sendAt);
        }
        if (json.expireAt != null) {
            builder.expireAt(json.expireAt);
        }
        if (json.callbackUrl != null) {
            builder.callbackUrl(json.callbackUrl);
        }
        return (MtBatchTextSmsUpdateImpl)builder.build();
    }

    private static MtBatchTextSmsUpdateImpl validate(MtBatchTextSmsUpdateImpl instance) {
        instance.check();
        return instance;
    }

    public static MtBatchTextSmsUpdate copyOf(MtBatchTextSmsUpdate instance) {
        if (instance instanceof MtBatchTextSmsUpdateImpl) {
            return (MtBatchTextSmsUpdateImpl)instance;
        }
        return new MtBatchTextSmsUpdate.Builder().using(instance).build();
    }

    private static <T> T requireNonNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    private static int hashCode(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    private static boolean equals(Object left, Object right) {
        return left == right || left != null && left.equals(right);
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                MtBatchTextSmsUpdateImpl.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    static class Builder {
        @Nullable
        private String body;
        @Nullable
        private UpdateValue<Map<String, ParameterValues>> parameters;
        private List<String> recipientInsertions = null;
        private List<String> recipientRemovals = null;
        @Nullable
        private String sender;
        @Nullable
        private UpdateValue<ReportType> deliveryReport;
        @Nullable
        private UpdateValue<OffsetDateTime> sendAt;
        @Nullable
        private UpdateValue<OffsetDateTime> expireAt;
        @Nullable
        private UpdateValue<URI> callbackUrl;

        Builder() {
            if (!(this instanceof MtBatchTextSmsUpdate.Builder)) {
                throw new UnsupportedOperationException("Use: new MtBatchTextSmsUpdate.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final MtBatchTextSmsUpdate.Builder using(MtBatchSmsUpdate instance) {
            MtBatchTextSmsUpdateImpl.requireNonNull(instance, "instance");
            this.from(instance);
            return (MtBatchTextSmsUpdate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MtBatchTextSmsUpdate.Builder using(MtBatchTextSmsUpdate instance) {
            MtBatchTextSmsUpdateImpl.requireNonNull(instance, "instance");
            this.from(instance);
            return (MtBatchTextSmsUpdate.Builder)this;
        }

        private void from(Object object) {
            MtBatchSmsUpdate instance;
            if (object instanceof MtBatchSmsUpdate) {
                List<String> recipientInsertionsValue;
                UpdateValue<ReportType> deliveryReportValue;
                UpdateValue<OffsetDateTime> expireAtValue;
                UpdateValue<OffsetDateTime> sendAtValue;
                UpdateValue<URI> callbackUrlValue;
                List<String> recipientRemovalsValue;
                instance = (MtBatchSmsUpdate)object;
                String senderValue = instance.sender();
                if (senderValue != null) {
                    this.sender(senderValue);
                }
                if ((recipientRemovalsValue = instance.recipientRemovals()) != null) {
                    this.addAllRecipientRemovals(recipientRemovalsValue);
                }
                if ((callbackUrlValue = instance.callbackUrl()) != null) {
                    this.callbackUrl(callbackUrlValue);
                }
                if ((sendAtValue = instance.sendAt()) != null) {
                    this.sendAt(sendAtValue);
                }
                if ((expireAtValue = instance.expireAt()) != null) {
                    this.expireAt(expireAtValue);
                }
                if ((deliveryReportValue = instance.deliveryReport()) != null) {
                    this.deliveryReport(deliveryReportValue);
                }
                if ((recipientInsertionsValue = instance.recipientInsertions()) != null) {
                    this.addAllRecipientInsertions(recipientInsertionsValue);
                }
            }
            if (object instanceof MtBatchTextSmsUpdate) {
                UpdateValue<Map<String, ParameterValues>> parametersValue;
                instance = (MtBatchTextSmsUpdate)object;
                String bodyValue = ((MtBatchTextSmsUpdate)instance).body();
                if (bodyValue != null) {
                    this.body(bodyValue);
                }
                if ((parametersValue = ((MtBatchTextSmsUpdate)instance).parameters()) != null) {
                    this.parameters(parametersValue);
                }
            }
        }

        @JsonProperty(value="body")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsUpdate.Builder body(@Nullable String body) {
            this.body = body;
            return (MtBatchTextSmsUpdate.Builder)this;
        }

        @JsonProperty(value="parameters")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsUpdate.Builder parameters(@Nullable UpdateValue<Map<String, ParameterValues>> parameters) {
            this.parameters = parameters;
            return (MtBatchTextSmsUpdate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MtBatchTextSmsUpdate.Builder addRecipientInsertion(String element) {
            if (this.recipientInsertions == null) {
                this.recipientInsertions = new ArrayList<String>();
            }
            this.recipientInsertions.add((String)MtBatchTextSmsUpdateImpl.requireNonNull(element, "recipientInsertions element"));
            return (MtBatchTextSmsUpdate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MtBatchTextSmsUpdate.Builder addRecipientInsertion(String ... elements) {
            if (this.recipientInsertions == null) {
                this.recipientInsertions = new ArrayList<String>();
            }
            for (String element : elements) {
                this.recipientInsertions.add((String)MtBatchTextSmsUpdateImpl.requireNonNull(element, "recipientInsertions element"));
            }
            return (MtBatchTextSmsUpdate.Builder)this;
        }

        @JsonProperty(value="to_add")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsUpdate.Builder recipientInsertions(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.recipientInsertions = null;
                return (MtBatchTextSmsUpdate.Builder)this;
            }
            this.recipientInsertions = new ArrayList<String>();
            return this.addAllRecipientInsertions(elements);
        }

        @CanIgnoreReturnValue
        public final MtBatchTextSmsUpdate.Builder addAllRecipientInsertions(Iterable<String> elements) {
            MtBatchTextSmsUpdateImpl.requireNonNull(elements, "recipientInsertions element");
            if (this.recipientInsertions == null) {
                this.recipientInsertions = new ArrayList<String>();
            }
            for (String element : elements) {
                this.recipientInsertions.add((String)MtBatchTextSmsUpdateImpl.requireNonNull(element, "recipientInsertions element"));
            }
            return (MtBatchTextSmsUpdate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MtBatchTextSmsUpdate.Builder addRecipientRemoval(String element) {
            if (this.recipientRemovals == null) {
                this.recipientRemovals = new ArrayList<String>();
            }
            this.recipientRemovals.add((String)MtBatchTextSmsUpdateImpl.requireNonNull(element, "recipientRemovals element"));
            return (MtBatchTextSmsUpdate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MtBatchTextSmsUpdate.Builder addRecipientRemoval(String ... elements) {
            if (this.recipientRemovals == null) {
                this.recipientRemovals = new ArrayList<String>();
            }
            for (String element : elements) {
                this.recipientRemovals.add((String)MtBatchTextSmsUpdateImpl.requireNonNull(element, "recipientRemovals element"));
            }
            return (MtBatchTextSmsUpdate.Builder)this;
        }

        @JsonProperty(value="to_remove")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsUpdate.Builder recipientRemovals(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.recipientRemovals = null;
                return (MtBatchTextSmsUpdate.Builder)this;
            }
            this.recipientRemovals = new ArrayList<String>();
            return this.addAllRecipientRemovals(elements);
        }

        @CanIgnoreReturnValue
        public final MtBatchTextSmsUpdate.Builder addAllRecipientRemovals(Iterable<String> elements) {
            MtBatchTextSmsUpdateImpl.requireNonNull(elements, "recipientRemovals element");
            if (this.recipientRemovals == null) {
                this.recipientRemovals = new ArrayList<String>();
            }
            for (String element : elements) {
                this.recipientRemovals.add((String)MtBatchTextSmsUpdateImpl.requireNonNull(element, "recipientRemovals element"));
            }
            return (MtBatchTextSmsUpdate.Builder)this;
        }

        @JsonProperty(value="from")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsUpdate.Builder sender(@Nullable String sender) {
            this.sender = sender;
            return (MtBatchTextSmsUpdate.Builder)this;
        }

        @JsonProperty(value="delivery_report")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsUpdate.Builder deliveryReport(@Nullable UpdateValue<ReportType> deliveryReport) {
            this.deliveryReport = deliveryReport;
            return (MtBatchTextSmsUpdate.Builder)this;
        }

        @JsonProperty(value="send_at")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsUpdate.Builder sendAt(@Nullable UpdateValue<OffsetDateTime> sendAt) {
            this.sendAt = sendAt;
            return (MtBatchTextSmsUpdate.Builder)this;
        }

        @JsonProperty(value="expire_at")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsUpdate.Builder expireAt(@Nullable UpdateValue<OffsetDateTime> expireAt) {
            this.expireAt = expireAt;
            return (MtBatchTextSmsUpdate.Builder)this;
        }

        @JsonProperty(value="callback_url")
        @CanIgnoreReturnValue
        public final MtBatchTextSmsUpdate.Builder callbackUrl(@Nullable UpdateValue<URI> callbackUrl) {
            this.callbackUrl = callbackUrl;
            return (MtBatchTextSmsUpdate.Builder)this;
        }

        public MtBatchTextSmsUpdate build() {
            return MtBatchTextSmsUpdateImpl.validate(new MtBatchTextSmsUpdateImpl(this.body, this.parameters, this.recipientInsertions == null ? null : MtBatchTextSmsUpdateImpl.createUnmodifiableList(true, this.recipientInsertions), this.recipientRemovals == null ? null : MtBatchTextSmsUpdateImpl.createUnmodifiableList(true, this.recipientRemovals), this.sender, this.deliveryReport, this.sendAt, this.expireAt, this.callbackUrl));
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends MtBatchTextSmsUpdate {
        @Nullable
        String body;
        @Nullable
        UpdateValue<Map<String, ParameterValues>> parameters;
        List<String> recipientInsertions = null;
        List<String> recipientRemovals = null;
        @Nullable
        String sender;
        @Nullable
        UpdateValue<ReportType> deliveryReport;
        @Nullable
        UpdateValue<OffsetDateTime> sendAt;
        @Nullable
        UpdateValue<OffsetDateTime> expireAt;
        @Nullable
        UpdateValue<URI> callbackUrl;

        Json() {
        }

        @JsonProperty(value="body")
        public void setBody(@Nullable String body) {
            this.body = body;
        }

        @JsonProperty(value="parameters")
        public void setParameters(@Nullable UpdateValue<Map<String, ParameterValues>> parameters) {
            this.parameters = parameters;
        }

        @JsonProperty(value="to_add")
        public void setRecipientInsertions(@Nullable List<String> recipientInsertions) {
            this.recipientInsertions = recipientInsertions;
        }

        @JsonProperty(value="to_remove")
        public void setRecipientRemovals(@Nullable List<String> recipientRemovals) {
            this.recipientRemovals = recipientRemovals;
        }

        @JsonProperty(value="from")
        public void setSender(@Nullable String sender) {
            this.sender = sender;
        }

        @JsonProperty(value="delivery_report")
        public void setDeliveryReport(@Nullable UpdateValue<ReportType> deliveryReport) {
            this.deliveryReport = deliveryReport;
        }

        @JsonProperty(value="send_at")
        public void setSendAt(@Nullable UpdateValue<OffsetDateTime> sendAt) {
            this.sendAt = sendAt;
        }

        @JsonProperty(value="expire_at")
        public void setExpireAt(@Nullable UpdateValue<OffsetDateTime> expireAt) {
            this.expireAt = expireAt;
        }

        @JsonProperty(value="callback_url")
        public void setCallbackUrl(@Nullable UpdateValue<URI> callbackUrl) {
            this.callbackUrl = callbackUrl;
        }

        @Override
        public String body() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UpdateValue<Map<String, ParameterValues>> parameters() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> recipientInsertions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> recipientRemovals() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String sender() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UpdateValue<ReportType> deliveryReport() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UpdateValue<OffsetDateTime> sendAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UpdateValue<OffsetDateTime> expireAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UpdateValue<URI> callbackUrl() {
            throw new UnsupportedOperationException();
        }
    }
}

