/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sinch.xms.api.MtBatchSmsResult;
import com.sinch.xms.api.PagedBatchResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
final class PagedBatchResultImpl
extends PagedBatchResult {
    private final List<MtBatchSmsResult> content;
    private final int page;
    private final int size;
    private final int totalSize;

    private PagedBatchResultImpl(List<MtBatchSmsResult> content, int page, int size, int totalSize) {
        this.content = content;
        this.page = page;
        this.size = size;
        this.totalSize = totalSize;
    }

    @Override
    @JsonProperty(value="batches")
    public List<MtBatchSmsResult> content() {
        return this.content;
    }

    @Override
    @JsonProperty(value="page")
    public int page() {
        return this.page;
    }

    @Override
    @JsonProperty(value="page_size")
    public int size() {
        return this.size;
    }

    @Override
    @JsonProperty(value="count")
    public int totalSize() {
        return this.totalSize;
    }

    public final PagedBatchResultImpl withContent(MtBatchSmsResult ... elements) {
        List<MtBatchSmsResult> newValue = PagedBatchResultImpl.createUnmodifiableList(false, PagedBatchResultImpl.createSafeList(Arrays.asList(elements), true, false));
        return new PagedBatchResultImpl(newValue, this.page, this.size, this.totalSize);
    }

    public final PagedBatchResultImpl withContent(Iterable<? extends MtBatchSmsResult> elements) {
        if (this.content == elements) {
            return this;
        }
        List<MtBatchSmsResult> newValue = PagedBatchResultImpl.createUnmodifiableList(false, PagedBatchResultImpl.createSafeList(elements, true, false));
        return new PagedBatchResultImpl(newValue, this.page, this.size, this.totalSize);
    }

    public final PagedBatchResultImpl withPage(int value) {
        if (this.page == value) {
            return this;
        }
        return new PagedBatchResultImpl(this.content, value, this.size, this.totalSize);
    }

    public final PagedBatchResultImpl withSize(int value) {
        if (this.size == value) {
            return this;
        }
        return new PagedBatchResultImpl(this.content, this.page, value, this.totalSize);
    }

    public final PagedBatchResultImpl withTotalSize(int value) {
        if (this.totalSize == value) {
            return this;
        }
        return new PagedBatchResultImpl(this.content, this.page, this.size, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof PagedBatchResultImpl && this.equalTo((PagedBatchResultImpl)another);
    }

    private boolean equalTo(PagedBatchResultImpl another) {
        return this.content.equals(another.content) && this.page == another.page && this.size == another.size && this.totalSize == another.totalSize;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.content.hashCode();
        h = h * 17 + this.page;
        h = h * 17 + this.size;
        h = h * 17 + this.totalSize;
        return h;
    }

    public String toString() {
        return "PagedBatchResult{content=" + this.content + ", page=" + this.page + ", size=" + this.size + ", totalSize=" + this.totalSize + "}";
    }

    public static PagedBatchResult copyOf(PagedBatchResult instance) {
        if (instance instanceof PagedBatchResultImpl) {
            return (PagedBatchResultImpl)instance;
        }
        return new PagedBatchResult.Builder().using(instance).build();
    }

    private static <T> T requireNonNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                PagedBatchResultImpl.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    static class Builder {
        private static final long INIT_BIT_PAGE = 1L;
        private static final long INIT_BIT_SIZE = 2L;
        private static final long INIT_BIT_TOTAL_SIZE = 4L;
        private long initBits = 7L;
        private List<MtBatchSmsResult> content = new ArrayList<MtBatchSmsResult>();
        private int page;
        private int size;
        private int totalSize;

        Builder() {
            if (!(this instanceof PagedBatchResult.Builder)) {
                throw new UnsupportedOperationException("Use: new PagedBatchResult.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final PagedBatchResult.Builder using(PagedBatchResult instance) {
            PagedBatchResultImpl.requireNonNull(instance, "instance");
            this.addAllContent(instance.content());
            this.page(instance.page());
            this.size(instance.size());
            this.totalSize(instance.totalSize());
            return (PagedBatchResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final PagedBatchResult.Builder addContent(MtBatchSmsResult element) {
            this.content.add((MtBatchSmsResult)PagedBatchResultImpl.requireNonNull(element, "content element"));
            return (PagedBatchResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final PagedBatchResult.Builder addContent(MtBatchSmsResult ... elements) {
            for (MtBatchSmsResult element : elements) {
                this.content.add((MtBatchSmsResult)PagedBatchResultImpl.requireNonNull(element, "content element"));
            }
            return (PagedBatchResult.Builder)this;
        }

        @JsonProperty(value="batches")
        @CanIgnoreReturnValue
        public final PagedBatchResult.Builder content(Iterable<? extends MtBatchSmsResult> elements) {
            this.content.clear();
            return this.addAllContent(elements);
        }

        @CanIgnoreReturnValue
        public final PagedBatchResult.Builder addAllContent(Iterable<? extends MtBatchSmsResult> elements) {
            for (MtBatchSmsResult mtBatchSmsResult : elements) {
                this.content.add((MtBatchSmsResult)PagedBatchResultImpl.requireNonNull(mtBatchSmsResult, "content element"));
            }
            return (PagedBatchResult.Builder)this;
        }

        @JsonProperty(value="page")
        @CanIgnoreReturnValue
        public final PagedBatchResult.Builder page(int page) {
            this.page = page;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (PagedBatchResult.Builder)this;
        }

        @JsonProperty(value="page_size")
        @CanIgnoreReturnValue
        public final PagedBatchResult.Builder size(int size) {
            this.size = size;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (PagedBatchResult.Builder)this;
        }

        @JsonProperty(value="count")
        @CanIgnoreReturnValue
        public final PagedBatchResult.Builder totalSize(int totalSize) {
            this.totalSize = totalSize;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return (PagedBatchResult.Builder)this;
        }

        public PagedBatchResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new PagedBatchResultImpl(PagedBatchResultImpl.createUnmodifiableList(true, this.content), this.page, this.size, this.totalSize);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("page");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("size");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("totalSize");
            }
            return "Cannot build PagedBatchResult, some of required attributes are not set " + attributes;
        }
    }
}

