/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sinch.xms.api.GroupResult;
import com.sinch.xms.api.PagedGroupResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
final class PagedGroupResultImpl
extends PagedGroupResult {
    private final List<GroupResult> content;
    private final int page;
    private final int size;
    private final int totalSize;

    private PagedGroupResultImpl(List<GroupResult> content, int page, int size, int totalSize) {
        this.content = content;
        this.page = page;
        this.size = size;
        this.totalSize = totalSize;
    }

    @Override
    @JsonProperty(value="groups")
    public List<GroupResult> content() {
        return this.content;
    }

    @Override
    @JsonProperty(value="page")
    public int page() {
        return this.page;
    }

    @Override
    @JsonProperty(value="page_size")
    public int size() {
        return this.size;
    }

    @Override
    @JsonProperty(value="count")
    public int totalSize() {
        return this.totalSize;
    }

    public final PagedGroupResultImpl withContent(GroupResult ... elements) {
        List<GroupResult> newValue = PagedGroupResultImpl.createUnmodifiableList(false, PagedGroupResultImpl.createSafeList(Arrays.asList(elements), true, false));
        return new PagedGroupResultImpl(newValue, this.page, this.size, this.totalSize);
    }

    public final PagedGroupResultImpl withContent(Iterable<? extends GroupResult> elements) {
        if (this.content == elements) {
            return this;
        }
        List<GroupResult> newValue = PagedGroupResultImpl.createUnmodifiableList(false, PagedGroupResultImpl.createSafeList(elements, true, false));
        return new PagedGroupResultImpl(newValue, this.page, this.size, this.totalSize);
    }

    public final PagedGroupResultImpl withPage(int value) {
        if (this.page == value) {
            return this;
        }
        return new PagedGroupResultImpl(this.content, value, this.size, this.totalSize);
    }

    public final PagedGroupResultImpl withSize(int value) {
        if (this.size == value) {
            return this;
        }
        return new PagedGroupResultImpl(this.content, this.page, value, this.totalSize);
    }

    public final PagedGroupResultImpl withTotalSize(int value) {
        if (this.totalSize == value) {
            return this;
        }
        return new PagedGroupResultImpl(this.content, this.page, this.size, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof PagedGroupResultImpl && this.equalTo((PagedGroupResultImpl)another);
    }

    private boolean equalTo(PagedGroupResultImpl another) {
        return this.content.equals(another.content) && this.page == another.page && this.size == another.size && this.totalSize == another.totalSize;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.content.hashCode();
        h = h * 17 + this.page;
        h = h * 17 + this.size;
        h = h * 17 + this.totalSize;
        return h;
    }

    public String toString() {
        return "PagedGroupResult{content=" + this.content + ", page=" + this.page + ", size=" + this.size + ", totalSize=" + this.totalSize + "}";
    }

    public static PagedGroupResult copyOf(PagedGroupResult instance) {
        if (instance instanceof PagedGroupResultImpl) {
            return (PagedGroupResultImpl)instance;
        }
        return new PagedGroupResult.Builder().using(instance).build();
    }

    private static <T> T requireNonNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                PagedGroupResultImpl.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    static class Builder {
        private static final long INIT_BIT_PAGE = 1L;
        private static final long INIT_BIT_SIZE = 2L;
        private static final long INIT_BIT_TOTAL_SIZE = 4L;
        private long initBits = 7L;
        private List<GroupResult> content = new ArrayList<GroupResult>();
        private int page;
        private int size;
        private int totalSize;

        Builder() {
            if (!(this instanceof PagedGroupResult.Builder)) {
                throw new UnsupportedOperationException("Use: new PagedGroupResult.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final PagedGroupResult.Builder using(PagedGroupResult instance) {
            PagedGroupResultImpl.requireNonNull(instance, "instance");
            this.addAllContent(instance.content());
            this.page(instance.page());
            this.size(instance.size());
            this.totalSize(instance.totalSize());
            return (PagedGroupResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final PagedGroupResult.Builder addContent(GroupResult element) {
            this.content.add((GroupResult)PagedGroupResultImpl.requireNonNull(element, "content element"));
            return (PagedGroupResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final PagedGroupResult.Builder addContent(GroupResult ... elements) {
            for (GroupResult element : elements) {
                this.content.add((GroupResult)PagedGroupResultImpl.requireNonNull(element, "content element"));
            }
            return (PagedGroupResult.Builder)this;
        }

        @JsonProperty(value="groups")
        @CanIgnoreReturnValue
        public final PagedGroupResult.Builder content(Iterable<? extends GroupResult> elements) {
            this.content.clear();
            return this.addAllContent(elements);
        }

        @CanIgnoreReturnValue
        public final PagedGroupResult.Builder addAllContent(Iterable<? extends GroupResult> elements) {
            for (GroupResult groupResult : elements) {
                this.content.add((GroupResult)PagedGroupResultImpl.requireNonNull(groupResult, "content element"));
            }
            return (PagedGroupResult.Builder)this;
        }

        @JsonProperty(value="page")
        @CanIgnoreReturnValue
        public final PagedGroupResult.Builder page(int page) {
            this.page = page;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (PagedGroupResult.Builder)this;
        }

        @JsonProperty(value="page_size")
        @CanIgnoreReturnValue
        public final PagedGroupResult.Builder size(int size) {
            this.size = size;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (PagedGroupResult.Builder)this;
        }

        @JsonProperty(value="count")
        @CanIgnoreReturnValue
        public final PagedGroupResult.Builder totalSize(int totalSize) {
            this.totalSize = totalSize;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return (PagedGroupResult.Builder)this;
        }

        public PagedGroupResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new PagedGroupResultImpl(PagedGroupResultImpl.createUnmodifiableList(true, this.content), this.page, this.size, this.totalSize);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("page");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("size");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("totalSize");
            }
            return "Cannot build PagedGroupResult, some of required attributes are not set " + attributes;
        }
    }
}

