/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sinch.xms.api.MoSms;
import com.sinch.xms.api.PagedInboundsResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
final class PagedInboundsResultImpl
extends PagedInboundsResult {
    private final List<MoSms> content;
    private final int page;
    private final int size;
    private final int totalSize;

    private PagedInboundsResultImpl(List<MoSms> content, int page, int size, int totalSize) {
        this.content = content;
        this.page = page;
        this.size = size;
        this.totalSize = totalSize;
    }

    @Override
    @JsonProperty(value="inbounds")
    public List<MoSms> content() {
        return this.content;
    }

    @Override
    @JsonProperty(value="page")
    public int page() {
        return this.page;
    }

    @Override
    @JsonProperty(value="page_size")
    public int size() {
        return this.size;
    }

    @Override
    @JsonProperty(value="count")
    public int totalSize() {
        return this.totalSize;
    }

    public final PagedInboundsResultImpl withContent(MoSms ... elements) {
        List<MoSms> newValue = PagedInboundsResultImpl.createUnmodifiableList(false, PagedInboundsResultImpl.createSafeList(Arrays.asList(elements), true, false));
        return new PagedInboundsResultImpl(newValue, this.page, this.size, this.totalSize);
    }

    public final PagedInboundsResultImpl withContent(Iterable<? extends MoSms> elements) {
        if (this.content == elements) {
            return this;
        }
        List<MoSms> newValue = PagedInboundsResultImpl.createUnmodifiableList(false, PagedInboundsResultImpl.createSafeList(elements, true, false));
        return new PagedInboundsResultImpl(newValue, this.page, this.size, this.totalSize);
    }

    public final PagedInboundsResultImpl withPage(int value) {
        if (this.page == value) {
            return this;
        }
        return new PagedInboundsResultImpl(this.content, value, this.size, this.totalSize);
    }

    public final PagedInboundsResultImpl withSize(int value) {
        if (this.size == value) {
            return this;
        }
        return new PagedInboundsResultImpl(this.content, this.page, value, this.totalSize);
    }

    public final PagedInboundsResultImpl withTotalSize(int value) {
        if (this.totalSize == value) {
            return this;
        }
        return new PagedInboundsResultImpl(this.content, this.page, this.size, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof PagedInboundsResultImpl && this.equalTo((PagedInboundsResultImpl)another);
    }

    private boolean equalTo(PagedInboundsResultImpl another) {
        return this.content.equals(another.content) && this.page == another.page && this.size == another.size && this.totalSize == another.totalSize;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.content.hashCode();
        h = h * 17 + this.page;
        h = h * 17 + this.size;
        h = h * 17 + this.totalSize;
        return h;
    }

    public String toString() {
        return "PagedInboundsResult{content=" + this.content + ", page=" + this.page + ", size=" + this.size + ", totalSize=" + this.totalSize + "}";
    }

    public static PagedInboundsResult copyOf(PagedInboundsResult instance) {
        if (instance instanceof PagedInboundsResultImpl) {
            return (PagedInboundsResultImpl)instance;
        }
        return new PagedInboundsResult.Builder().using(instance).build();
    }

    private static <T> T requireNonNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                PagedInboundsResultImpl.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    static class Builder {
        private static final long INIT_BIT_PAGE = 1L;
        private static final long INIT_BIT_SIZE = 2L;
        private static final long INIT_BIT_TOTAL_SIZE = 4L;
        private long initBits = 7L;
        private List<MoSms> content = new ArrayList<MoSms>();
        private int page;
        private int size;
        private int totalSize;

        Builder() {
            if (!(this instanceof PagedInboundsResult.Builder)) {
                throw new UnsupportedOperationException("Use: new PagedInboundsResult.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final PagedInboundsResult.Builder using(PagedInboundsResult instance) {
            PagedInboundsResultImpl.requireNonNull(instance, "instance");
            this.addAllContent(instance.content());
            this.page(instance.page());
            this.size(instance.size());
            this.totalSize(instance.totalSize());
            return (PagedInboundsResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final PagedInboundsResult.Builder addContent(MoSms element) {
            this.content.add((MoSms)PagedInboundsResultImpl.requireNonNull(element, "content element"));
            return (PagedInboundsResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final PagedInboundsResult.Builder addContent(MoSms ... elements) {
            for (MoSms element : elements) {
                this.content.add((MoSms)PagedInboundsResultImpl.requireNonNull(element, "content element"));
            }
            return (PagedInboundsResult.Builder)this;
        }

        @JsonProperty(value="inbounds")
        @CanIgnoreReturnValue
        public final PagedInboundsResult.Builder content(Iterable<? extends MoSms> elements) {
            this.content.clear();
            return this.addAllContent(elements);
        }

        @CanIgnoreReturnValue
        public final PagedInboundsResult.Builder addAllContent(Iterable<? extends MoSms> elements) {
            for (MoSms moSms : elements) {
                this.content.add((MoSms)PagedInboundsResultImpl.requireNonNull(moSms, "content element"));
            }
            return (PagedInboundsResult.Builder)this;
        }

        @JsonProperty(value="page")
        @CanIgnoreReturnValue
        public final PagedInboundsResult.Builder page(int page) {
            this.page = page;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (PagedInboundsResult.Builder)this;
        }

        @JsonProperty(value="page_size")
        @CanIgnoreReturnValue
        public final PagedInboundsResult.Builder size(int size) {
            this.size = size;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (PagedInboundsResult.Builder)this;
        }

        @JsonProperty(value="count")
        @CanIgnoreReturnValue
        public final PagedInboundsResult.Builder totalSize(int totalSize) {
            this.totalSize = totalSize;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return (PagedInboundsResult.Builder)this;
        }

        public PagedInboundsResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new PagedInboundsResultImpl(PagedInboundsResultImpl.createUnmodifiableList(true, this.content), this.page, this.size, this.totalSize);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("page");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("size");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("totalSize");
            }
            return "Cannot build PagedInboundsResult, some of required attributes are not set " + attributes;
        }
    }
}

