/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sinch.xms.api.ParameterValues;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
final class ParameterValuesImpl
extends ParameterValues {
    private final Map<String, String> substitutions;
    @Nullable
    private final String defaultValue;

    private ParameterValuesImpl(Map<String, String> substitutions, @Nullable String defaultValue) {
        this.substitutions = substitutions;
        this.defaultValue = defaultValue;
    }

    @Override
    @JsonProperty(value="substitutions")
    public Map<String, String> substitutions() {
        return this.substitutions;
    }

    @Override
    @JsonProperty(value="defaultValue")
    @Nullable
    public String defaultValue() {
        return this.defaultValue;
    }

    public final ParameterValuesImpl withSubstitutions(Map<String, ? extends String> entries) {
        if (this.substitutions == entries) {
            return this;
        }
        Map<String, String> newValue = ParameterValuesImpl.createUnmodifiableMap(true, false, entries);
        return new ParameterValuesImpl(newValue, this.defaultValue);
    }

    public final ParameterValuesImpl withDefaultValue(@Nullable String value) {
        if (ParameterValuesImpl.equals(this.defaultValue, value)) {
            return this;
        }
        return new ParameterValuesImpl(this.substitutions, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ParameterValuesImpl && this.equalTo((ParameterValuesImpl)another);
    }

    private boolean equalTo(ParameterValuesImpl another) {
        return this.substitutions.equals(another.substitutions) && ParameterValuesImpl.equals(this.defaultValue, another.defaultValue);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.substitutions.hashCode();
        h = h * 17 + ParameterValuesImpl.hashCode(this.defaultValue);
        return h;
    }

    public String toString() {
        return "ParameterValues{substitutions=" + this.substitutions + ", defaultValue=" + this.defaultValue + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ParameterValuesImpl fromJson(Json json) {
        ParameterValues.Builder builder = new ParameterValues.Builder();
        if (json.substitutions != null) {
            builder.putAllSubstitutions(json.substitutions);
        }
        if (json.defaultValue != null) {
            builder.defaultValue(json.defaultValue);
        }
        return (ParameterValuesImpl)builder.build();
    }

    public static ParameterValues copyOf(ParameterValues instance) {
        if (instance instanceof ParameterValuesImpl) {
            return (ParameterValuesImpl)instance;
        }
        return new ParameterValues.Builder().using(instance).build();
    }

    private static <T> T requireNonNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    private static int hashCode(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    private static boolean equals(Object left, Object right) {
        return left == right || left != null && left.equals(right);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    ParameterValuesImpl.requireNonNull(k, "key");
                    ParameterValuesImpl.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    ParameterValuesImpl.requireNonNull(k, "key");
                    ParameterValuesImpl.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @NotThreadSafe
    static class Builder {
        private Map<String, String> substitutions = new LinkedHashMap<String, String>();
        @Nullable
        private String defaultValue;

        Builder() {
            if (!(this instanceof ParameterValues.Builder)) {
                throw new UnsupportedOperationException("Use: new ParameterValues.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final ParameterValues.Builder using(ParameterValues instance) {
            ParameterValuesImpl.requireNonNull(instance, "instance");
            this.putAllSubstitutions(instance.substitutions());
            String defaultValueValue = instance.defaultValue();
            if (defaultValueValue != null) {
                this.defaultValue(defaultValueValue);
            }
            return (ParameterValues.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ParameterValues.Builder putSubstitution(String key, String value) {
            this.substitutions.put((String)ParameterValuesImpl.requireNonNull(key, "substitutions key"), (String)ParameterValuesImpl.requireNonNull(value, "substitutions value"));
            return (ParameterValues.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ParameterValues.Builder putSubstitution(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.substitutions.put((String)ParameterValuesImpl.requireNonNull(k, "substitutions key"), (String)ParameterValuesImpl.requireNonNull(v, "substitutions value"));
            return (ParameterValues.Builder)this;
        }

        @JsonProperty(value="substitutions")
        @CanIgnoreReturnValue
        public final ParameterValues.Builder substitutions(Map<String, ? extends String> substitutions) {
            this.substitutions.clear();
            return this.putAllSubstitutions(substitutions);
        }

        @CanIgnoreReturnValue
        public final ParameterValues.Builder putAllSubstitutions(Map<String, ? extends String> substitutions) {
            for (Map.Entry<String, ? extends String> entry : substitutions.entrySet()) {
                String k = entry.getKey();
                String v = entry.getValue();
                this.substitutions.put((String)ParameterValuesImpl.requireNonNull(k, "substitutions key"), (String)ParameterValuesImpl.requireNonNull(v, "substitutions value"));
            }
            return (ParameterValues.Builder)this;
        }

        @JsonProperty(value="defaultValue")
        @CanIgnoreReturnValue
        public final ParameterValues.Builder defaultValue(@Nullable String defaultValue) {
            this.defaultValue = defaultValue;
            return (ParameterValues.Builder)this;
        }

        public ParameterValues build() {
            return new ParameterValuesImpl(ParameterValuesImpl.createUnmodifiableMap(false, false, this.substitutions), this.defaultValue);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends ParameterValues {
        @Nullable
        Map<String, String> substitutions;
        @Nullable
        String defaultValue;

        Json() {
        }

        @JsonProperty(value="substitutions")
        public void setSubstitutions(Map<String, String> substitutions) {
            this.substitutions = substitutions;
        }

        @JsonProperty(value="defaultValue")
        public void setDefaultValue(@Nullable String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public Map<String, String> substitutions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String defaultValue() {
            throw new UnsupportedOperationException();
        }
    }
}

