/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sinch.xms.api.MtBatchDryRunResult;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
final class PerRecipientImpl
extends MtBatchDryRunResult.PerRecipient {
    private final String recipient;
    private final int numberOfParts;
    private final String body;
    private final String encoding;

    private PerRecipientImpl(String recipient, int numberOfParts, String body, String encoding) {
        this.recipient = recipient;
        this.numberOfParts = numberOfParts;
        this.body = body;
        this.encoding = encoding;
    }

    @Override
    @JsonProperty(value="recipient")
    public String recipient() {
        return this.recipient;
    }

    @Override
    @JsonProperty(value="number_of_parts")
    public int numberOfParts() {
        return this.numberOfParts;
    }

    @Override
    @JsonProperty(value="body")
    public String body() {
        return this.body;
    }

    @Override
    @JsonProperty(value="encoding")
    public String encoding() {
        return this.encoding;
    }

    public final PerRecipientImpl withRecipient(String value) {
        if (this.recipient.equals(value)) {
            return this;
        }
        String newValue = PerRecipientImpl.requireNonNull(value, "recipient");
        return new PerRecipientImpl(newValue, this.numberOfParts, this.body, this.encoding);
    }

    public final PerRecipientImpl withNumberOfParts(int value) {
        if (this.numberOfParts == value) {
            return this;
        }
        return new PerRecipientImpl(this.recipient, value, this.body, this.encoding);
    }

    public final PerRecipientImpl withBody(String value) {
        if (this.body.equals(value)) {
            return this;
        }
        String newValue = PerRecipientImpl.requireNonNull(value, "body");
        return new PerRecipientImpl(this.recipient, this.numberOfParts, newValue, this.encoding);
    }

    public final PerRecipientImpl withEncoding(String value) {
        if (this.encoding.equals(value)) {
            return this;
        }
        String newValue = PerRecipientImpl.requireNonNull(value, "encoding");
        return new PerRecipientImpl(this.recipient, this.numberOfParts, this.body, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof PerRecipientImpl && this.equalTo((PerRecipientImpl)another);
    }

    private boolean equalTo(PerRecipientImpl another) {
        return this.recipient.equals(another.recipient) && this.numberOfParts == another.numberOfParts && this.body.equals(another.body) && this.encoding.equals(another.encoding);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.recipient.hashCode();
        h = h * 17 + this.numberOfParts;
        h = h * 17 + this.body.hashCode();
        h = h * 17 + this.encoding.hashCode();
        return h;
    }

    public String toString() {
        return "PerRecipient{recipient=" + this.recipient + ", numberOfParts=" + this.numberOfParts + ", body=" + this.body + ", encoding=" + this.encoding + "}";
    }

    public static MtBatchDryRunResult.PerRecipient copyOf(MtBatchDryRunResult.PerRecipient instance) {
        if (instance instanceof PerRecipientImpl) {
            return (PerRecipientImpl)instance;
        }
        return new MtBatchDryRunResult.PerRecipient.Builder().using(instance).build();
    }

    private static <T> T requireNonNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    @NotThreadSafe
    static class Builder {
        private static final long INIT_BIT_RECIPIENT = 1L;
        private static final long INIT_BIT_NUMBER_OF_PARTS = 2L;
        private static final long INIT_BIT_BODY = 4L;
        private static final long INIT_BIT_ENCODING = 8L;
        private long initBits = 15L;
        @Nullable
        private String recipient;
        private int numberOfParts;
        @Nullable
        private String body;
        @Nullable
        private String encoding;

        Builder() {
            if (!(this instanceof MtBatchDryRunResult.PerRecipient.Builder)) {
                throw new UnsupportedOperationException("Use: new MtBatchDryRunResult.PerRecipient.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final MtBatchDryRunResult.PerRecipient.Builder using(MtBatchDryRunResult.PerRecipient instance) {
            PerRecipientImpl.requireNonNull(instance, "instance");
            this.recipient(instance.recipient());
            this.numberOfParts(instance.numberOfParts());
            this.body(instance.body());
            this.encoding(instance.encoding());
            return (MtBatchDryRunResult.PerRecipient.Builder)this;
        }

        @JsonProperty(value="recipient")
        @CanIgnoreReturnValue
        public final MtBatchDryRunResult.PerRecipient.Builder recipient(String recipient) {
            this.recipient = (String)PerRecipientImpl.requireNonNull(recipient, "recipient");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (MtBatchDryRunResult.PerRecipient.Builder)this;
        }

        @JsonProperty(value="number_of_parts")
        @CanIgnoreReturnValue
        public final MtBatchDryRunResult.PerRecipient.Builder numberOfParts(int numberOfParts) {
            this.numberOfParts = numberOfParts;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (MtBatchDryRunResult.PerRecipient.Builder)this;
        }

        @JsonProperty(value="body")
        @CanIgnoreReturnValue
        public final MtBatchDryRunResult.PerRecipient.Builder body(String body) {
            this.body = (String)PerRecipientImpl.requireNonNull(body, "body");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return (MtBatchDryRunResult.PerRecipient.Builder)this;
        }

        @JsonProperty(value="encoding")
        @CanIgnoreReturnValue
        public final MtBatchDryRunResult.PerRecipient.Builder encoding(String encoding) {
            this.encoding = (String)PerRecipientImpl.requireNonNull(encoding, "encoding");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return (MtBatchDryRunResult.PerRecipient.Builder)this;
        }

        public MtBatchDryRunResult.PerRecipient build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new PerRecipientImpl(this.recipient, this.numberOfParts, this.body, this.encoding);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("recipient");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("numberOfParts");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("body");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("encoding");
            }
            return "Cannot build PerRecipient, some of required attributes are not set " + attributes;
        }
    }
}

