/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sinch.xms.api.BatchId;
import com.sinch.xms.api.DeliveryStatus;
import com.sinch.xms.api.RecipientDeliveryReport;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
final class RecipientDeliveryReportImpl
extends RecipientDeliveryReport {
    private final BatchId batchId;
    private final String recipient;
    private final int code;
    private final DeliveryStatus status;
    @Nullable
    private final String statusMessage;
    @Nullable
    private final String operator;
    private final OffsetDateTime at;
    @Nullable
    private final OffsetDateTime operatorStatusAt;
    @Nullable
    private final String clientReference;
    @Nullable
    private final String encoding;
    @Nullable
    private final Integer numberOfMessageParts;

    private RecipientDeliveryReportImpl(BatchId batchId, String recipient, int code, DeliveryStatus status, @Nullable String statusMessage, @Nullable String operator, OffsetDateTime at, @Nullable OffsetDateTime operatorStatusAt, @Nullable String clientReference, @Nullable String encoding, @Nullable Integer numberOfMessageParts) {
        this.batchId = batchId;
        this.recipient = recipient;
        this.code = code;
        this.status = status;
        this.statusMessage = statusMessage;
        this.operator = operator;
        this.at = at;
        this.operatorStatusAt = operatorStatusAt;
        this.clientReference = clientReference;
        this.encoding = encoding;
        this.numberOfMessageParts = numberOfMessageParts;
    }

    @Override
    @JsonProperty(value="batch_id")
    public BatchId batchId() {
        return this.batchId;
    }

    @Override
    @JsonProperty(value="recipient")
    public String recipient() {
        return this.recipient;
    }

    @Override
    @JsonProperty(value="code")
    public int code() {
        return this.code;
    }

    @Override
    @JsonProperty(value="status")
    public DeliveryStatus status() {
        return this.status;
    }

    @Override
    @JsonProperty(value="status_message")
    @Nullable
    public String statusMessage() {
        return this.statusMessage;
    }

    @Override
    @JsonProperty(value="operator")
    @Nullable
    public String operator() {
        return this.operator;
    }

    @Override
    @JsonProperty(value="at")
    public OffsetDateTime at() {
        return this.at;
    }

    @Override
    @JsonProperty(value="operator_status_at")
    @Nullable
    public OffsetDateTime operatorStatusAt() {
        return this.operatorStatusAt;
    }

    @Override
    @JsonProperty(value="client_reference")
    @Nullable
    public String clientReference() {
        return this.clientReference;
    }

    @Override
    @JsonProperty(value="encoding")
    @Nullable
    public String encoding() {
        return this.encoding;
    }

    @Override
    @JsonProperty(value="number_of_message_parts")
    @Nullable
    public Integer numberOfMessageParts() {
        return this.numberOfMessageParts;
    }

    public final RecipientDeliveryReportImpl withBatchId(BatchId value) {
        if (this.batchId == value) {
            return this;
        }
        BatchId newValue = RecipientDeliveryReportImpl.requireNonNull(value, "batchId");
        return new RecipientDeliveryReportImpl(newValue, this.recipient, this.code, this.status, this.statusMessage, this.operator, this.at, this.operatorStatusAt, this.clientReference, this.encoding, this.numberOfMessageParts);
    }

    public final RecipientDeliveryReportImpl withRecipient(String value) {
        if (this.recipient.equals(value)) {
            return this;
        }
        String newValue = RecipientDeliveryReportImpl.requireNonNull(value, "recipient");
        return new RecipientDeliveryReportImpl(this.batchId, newValue, this.code, this.status, this.statusMessage, this.operator, this.at, this.operatorStatusAt, this.clientReference, this.encoding, this.numberOfMessageParts);
    }

    public final RecipientDeliveryReportImpl withCode(int value) {
        if (this.code == value) {
            return this;
        }
        return new RecipientDeliveryReportImpl(this.batchId, this.recipient, value, this.status, this.statusMessage, this.operator, this.at, this.operatorStatusAt, this.clientReference, this.encoding, this.numberOfMessageParts);
    }

    public final RecipientDeliveryReportImpl withStatus(DeliveryStatus value) {
        if (this.status == value) {
            return this;
        }
        DeliveryStatus newValue = RecipientDeliveryReportImpl.requireNonNull(value, "status");
        return new RecipientDeliveryReportImpl(this.batchId, this.recipient, this.code, newValue, this.statusMessage, this.operator, this.at, this.operatorStatusAt, this.clientReference, this.encoding, this.numberOfMessageParts);
    }

    public final RecipientDeliveryReportImpl withStatusMessage(@Nullable String value) {
        if (RecipientDeliveryReportImpl.equals(this.statusMessage, value)) {
            return this;
        }
        return new RecipientDeliveryReportImpl(this.batchId, this.recipient, this.code, this.status, value, this.operator, this.at, this.operatorStatusAt, this.clientReference, this.encoding, this.numberOfMessageParts);
    }

    public final RecipientDeliveryReportImpl withOperator(@Nullable String value) {
        if (RecipientDeliveryReportImpl.equals(this.operator, value)) {
            return this;
        }
        return new RecipientDeliveryReportImpl(this.batchId, this.recipient, this.code, this.status, this.statusMessage, value, this.at, this.operatorStatusAt, this.clientReference, this.encoding, this.numberOfMessageParts);
    }

    public final RecipientDeliveryReportImpl withAt(OffsetDateTime value) {
        if (this.at == value) {
            return this;
        }
        OffsetDateTime newValue = RecipientDeliveryReportImpl.requireNonNull(value, "at");
        return new RecipientDeliveryReportImpl(this.batchId, this.recipient, this.code, this.status, this.statusMessage, this.operator, newValue, this.operatorStatusAt, this.clientReference, this.encoding, this.numberOfMessageParts);
    }

    public final RecipientDeliveryReportImpl withOperatorStatusAt(@Nullable OffsetDateTime value) {
        if (this.operatorStatusAt == value) {
            return this;
        }
        return new RecipientDeliveryReportImpl(this.batchId, this.recipient, this.code, this.status, this.statusMessage, this.operator, this.at, value, this.clientReference, this.encoding, this.numberOfMessageParts);
    }

    public final RecipientDeliveryReportImpl withClientReference(@Nullable String value) {
        if (RecipientDeliveryReportImpl.equals(this.clientReference, value)) {
            return this;
        }
        return new RecipientDeliveryReportImpl(this.batchId, this.recipient, this.code, this.status, this.statusMessage, this.operator, this.at, this.operatorStatusAt, value, this.encoding, this.numberOfMessageParts);
    }

    public final RecipientDeliveryReportImpl withEncoding(@Nullable String value) {
        if (RecipientDeliveryReportImpl.equals(this.encoding, value)) {
            return this;
        }
        return new RecipientDeliveryReportImpl(this.batchId, this.recipient, this.code, this.status, this.statusMessage, this.operator, this.at, this.operatorStatusAt, this.clientReference, value, this.numberOfMessageParts);
    }

    public final RecipientDeliveryReportImpl withNumberOfMessageParts(@Nullable Integer value) {
        if (RecipientDeliveryReportImpl.equals(this.numberOfMessageParts, value)) {
            return this;
        }
        return new RecipientDeliveryReportImpl(this.batchId, this.recipient, this.code, this.status, this.statusMessage, this.operator, this.at, this.operatorStatusAt, this.clientReference, this.encoding, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof RecipientDeliveryReportImpl && this.equalTo((RecipientDeliveryReportImpl)another);
    }

    private boolean equalTo(RecipientDeliveryReportImpl another) {
        return this.batchId.equals(another.batchId) && this.recipient.equals(another.recipient) && this.code == another.code && this.status.equals(another.status) && RecipientDeliveryReportImpl.equals(this.statusMessage, another.statusMessage) && RecipientDeliveryReportImpl.equals(this.operator, another.operator) && this.at.equals(another.at) && RecipientDeliveryReportImpl.equals(this.operatorStatusAt, another.operatorStatusAt) && RecipientDeliveryReportImpl.equals(this.clientReference, another.clientReference) && RecipientDeliveryReportImpl.equals(this.encoding, another.encoding) && RecipientDeliveryReportImpl.equals(this.numberOfMessageParts, another.numberOfMessageParts);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.batchId.hashCode();
        h = h * 17 + this.recipient.hashCode();
        h = h * 17 + this.code;
        h = h * 17 + this.status.hashCode();
        h = h * 17 + RecipientDeliveryReportImpl.hashCode(this.statusMessage);
        h = h * 17 + RecipientDeliveryReportImpl.hashCode(this.operator);
        h = h * 17 + this.at.hashCode();
        h = h * 17 + RecipientDeliveryReportImpl.hashCode(this.operatorStatusAt);
        h = h * 17 + RecipientDeliveryReportImpl.hashCode(this.clientReference);
        h = h * 17 + RecipientDeliveryReportImpl.hashCode(this.encoding);
        h = h * 17 + RecipientDeliveryReportImpl.hashCode(this.numberOfMessageParts);
        return h;
    }

    public String toString() {
        return "RecipientDeliveryReport{batchId=" + this.batchId + ", recipient=" + this.recipient + ", code=" + this.code + ", status=" + this.status + ", statusMessage=" + this.statusMessage + ", operator=" + this.operator + ", at=" + this.at + ", operatorStatusAt=" + this.operatorStatusAt + ", clientReference=" + this.clientReference + ", encoding=" + this.encoding + ", numberOfMessageParts=" + this.numberOfMessageParts + "}";
    }

    public static RecipientDeliveryReport copyOf(RecipientDeliveryReport instance) {
        if (instance instanceof RecipientDeliveryReportImpl) {
            return (RecipientDeliveryReportImpl)instance;
        }
        return new RecipientDeliveryReport.Builder().using(instance).build();
    }

    private static <T> T requireNonNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    private static int hashCode(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    private static boolean equals(Object left, Object right) {
        return left == right || left != null && left.equals(right);
    }

    @NotThreadSafe
    static class Builder {
        private static final long INIT_BIT_BATCH_ID = 1L;
        private static final long INIT_BIT_RECIPIENT = 2L;
        private static final long INIT_BIT_CODE = 4L;
        private static final long INIT_BIT_STATUS = 8L;
        private static final long INIT_BIT_AT = 16L;
        private long initBits = 31L;
        @Nullable
        private BatchId batchId;
        @Nullable
        private String recipient;
        private int code;
        @Nullable
        private DeliveryStatus status;
        @Nullable
        private String statusMessage;
        @Nullable
        private String operator;
        @Nullable
        private OffsetDateTime at;
        @Nullable
        private OffsetDateTime operatorStatusAt;
        @Nullable
        private String clientReference;
        @Nullable
        private String encoding;
        @Nullable
        private Integer numberOfMessageParts;

        Builder() {
            if (!(this instanceof RecipientDeliveryReport.Builder)) {
                throw new UnsupportedOperationException("Use: new RecipientDeliveryReport.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final RecipientDeliveryReport.Builder using(RecipientDeliveryReport instance) {
            Integer numberOfMessagePartsValue;
            String encodingValue;
            String clientReferenceValue;
            String operatorValue;
            RecipientDeliveryReportImpl.requireNonNull(instance, "instance");
            this.batchId(instance.batchId());
            this.recipient(instance.recipient());
            this.code(instance.code());
            this.status(instance.status());
            String statusMessageValue = instance.statusMessage();
            if (statusMessageValue != null) {
                this.statusMessage(statusMessageValue);
            }
            if ((operatorValue = instance.operator()) != null) {
                this.operator(operatorValue);
            }
            this.at(instance.at());
            OffsetDateTime operatorStatusAtValue = instance.operatorStatusAt();
            if (operatorStatusAtValue != null) {
                this.operatorStatusAt(operatorStatusAtValue);
            }
            if ((clientReferenceValue = instance.clientReference()) != null) {
                this.clientReference(clientReferenceValue);
            }
            if ((encodingValue = instance.encoding()) != null) {
                this.encoding(encodingValue);
            }
            if ((numberOfMessagePartsValue = instance.numberOfMessageParts()) != null) {
                this.numberOfMessageParts(numberOfMessagePartsValue);
            }
            return (RecipientDeliveryReport.Builder)this;
        }

        @JsonProperty(value="batch_id")
        @CanIgnoreReturnValue
        public final RecipientDeliveryReport.Builder batchId(BatchId batchId) {
            this.batchId = (BatchId)RecipientDeliveryReportImpl.requireNonNull(batchId, "batchId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (RecipientDeliveryReport.Builder)this;
        }

        @JsonProperty(value="recipient")
        @CanIgnoreReturnValue
        public final RecipientDeliveryReport.Builder recipient(String recipient) {
            this.recipient = (String)RecipientDeliveryReportImpl.requireNonNull(recipient, "recipient");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (RecipientDeliveryReport.Builder)this;
        }

        @JsonProperty(value="code")
        @CanIgnoreReturnValue
        public final RecipientDeliveryReport.Builder code(int code) {
            this.code = code;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return (RecipientDeliveryReport.Builder)this;
        }

        @JsonProperty(value="status")
        @CanIgnoreReturnValue
        public final RecipientDeliveryReport.Builder status(DeliveryStatus status) {
            this.status = (DeliveryStatus)RecipientDeliveryReportImpl.requireNonNull(status, "status");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return (RecipientDeliveryReport.Builder)this;
        }

        @JsonProperty(value="status_message")
        @CanIgnoreReturnValue
        public final RecipientDeliveryReport.Builder statusMessage(@Nullable String statusMessage) {
            this.statusMessage = statusMessage;
            return (RecipientDeliveryReport.Builder)this;
        }

        @JsonProperty(value="operator")
        @CanIgnoreReturnValue
        public final RecipientDeliveryReport.Builder operator(@Nullable String operator) {
            this.operator = operator;
            return (RecipientDeliveryReport.Builder)this;
        }

        @JsonProperty(value="at")
        @CanIgnoreReturnValue
        public final RecipientDeliveryReport.Builder at(OffsetDateTime at) {
            this.at = (OffsetDateTime)RecipientDeliveryReportImpl.requireNonNull(at, "at");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return (RecipientDeliveryReport.Builder)this;
        }

        @JsonProperty(value="operator_status_at")
        @CanIgnoreReturnValue
        public final RecipientDeliveryReport.Builder operatorStatusAt(@Nullable OffsetDateTime operatorStatusAt) {
            this.operatorStatusAt = operatorStatusAt;
            return (RecipientDeliveryReport.Builder)this;
        }

        @JsonProperty(value="client_reference")
        @CanIgnoreReturnValue
        public final RecipientDeliveryReport.Builder clientReference(@Nullable String clientReference) {
            this.clientReference = clientReference;
            return (RecipientDeliveryReport.Builder)this;
        }

        @JsonProperty(value="encoding")
        @CanIgnoreReturnValue
        public final RecipientDeliveryReport.Builder encoding(@Nullable String encoding) {
            this.encoding = encoding;
            return (RecipientDeliveryReport.Builder)this;
        }

        @JsonProperty(value="number_of_message_parts")
        @CanIgnoreReturnValue
        public final RecipientDeliveryReport.Builder numberOfMessageParts(@Nullable Integer numberOfMessageParts) {
            this.numberOfMessageParts = numberOfMessageParts;
            return (RecipientDeliveryReport.Builder)this;
        }

        public RecipientDeliveryReport build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new RecipientDeliveryReportImpl(this.batchId, this.recipient, this.code, this.status, this.statusMessage, this.operator, this.at, this.operatorStatusAt, this.clientReference, this.encoding, this.numberOfMessageParts);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("batchId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("recipient");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("code");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("status");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("at");
            }
            return "Cannot build RecipientDeliveryReport, some of required attributes are not set " + attributes;
        }
    }
}

