/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms.api;

import com.sinch.xms.api.ReportType;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
final class ReportTypeImpl
extends ReportType {
    private final String type;
    private static final ConcurrentHashMap<InternProxy, ReportTypeImpl> INTERNER = new ConcurrentHashMap();

    private ReportTypeImpl(String type) {
        this.type = ReportTypeImpl.requireNonNull(type, "type");
    }

    @Override
    public String type() {
        return this.type;
    }

    public boolean equals(@Nullable Object another) {
        return this == another;
    }

    private boolean equalTo(ReportTypeImpl another) {
        return this.type.equals(another.type);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.type.hashCode();
        return h;
    }

    public static ReportType of(String type) {
        return ReportTypeImpl.validate(new ReportTypeImpl(type));
    }

    private static ReportTypeImpl validate(ReportTypeImpl instance) {
        ReportTypeImpl interned = INTERNER.putIfAbsent(new InternProxy(instance), instance);
        return interned != null ? interned : instance;
    }

    private static <T> T requireNonNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    private static class InternProxy {
        final ReportTypeImpl instance;

        InternProxy(ReportTypeImpl instance) {
            this.instance = instance;
        }

        public boolean equals(@Nullable Object another) {
            return another != null && this.instance.equalTo(((InternProxy)another).instance);
        }

        public int hashCode() {
            return this.instance.hashCode();
        }
    }
}

