/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sinch.xms.api.Tags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
final class TagsImpl
extends Tags {
    private final Set<String> tags;

    private TagsImpl(Set<String> tags) {
        this.tags = tags;
    }

    @Override
    @JsonProperty(value="tags")
    public Set<String> tags() {
        return this.tags;
    }

    public final TagsImpl withTags(String ... elements) {
        Set<String> newValue = TagsImpl.createUnmodifiableSet(TagsImpl.createSafeList(Arrays.asList(elements), true, false));
        return new TagsImpl(newValue);
    }

    public final TagsImpl withTags(Iterable<String> elements) {
        if (this.tags == elements) {
            return this;
        }
        Set<String> newValue = TagsImpl.createUnmodifiableSet(TagsImpl.createSafeList(elements, true, false));
        return new TagsImpl(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof TagsImpl && this.equalTo((TagsImpl)another);
    }

    private boolean equalTo(TagsImpl another) {
        return this.tags.equals(another.tags);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.tags.hashCode();
        return h;
    }

    public static Tags copyOf(Tags instance) {
        if (instance instanceof TagsImpl) {
            return (TagsImpl)instance;
        }
        return TagsImpl.builder().using(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> T requireNonNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                TagsImpl.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @NotThreadSafe
    static final class Builder {
        private List<String> tags = new ArrayList<String>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder using(Tags instance) {
            TagsImpl.requireNonNull(instance, "instance");
            this.addAllTags(instance.tags());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTag(String element) {
            this.tags.add((String)TagsImpl.requireNonNull(element, "tags element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTag(String ... elements) {
            for (String element : elements) {
                this.tags.add((String)TagsImpl.requireNonNull(element, "tags element"));
            }
            return this;
        }

        @JsonProperty(value="tags")
        @CanIgnoreReturnValue
        public final Builder tags(Iterable<String> elements) {
            this.tags.clear();
            return this.addAllTags(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTags(Iterable<String> elements) {
            for (String element : elements) {
                this.tags.add((String)TagsImpl.requireNonNull(element, "tags element"));
            }
            return this;
        }

        public Tags build() {
            return new TagsImpl(TagsImpl.createUnmodifiableSet(this.tags));
        }
    }
}

