/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.xms.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sinch.xms.api.TagsUpdate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
final class TagsUpdateImpl
extends TagsUpdate {
    private final Set<String> tagInsertions;
    private final Set<String> tagRemovals;

    private TagsUpdateImpl(Set<String> tagInsertions, Set<String> tagRemovals) {
        this.tagInsertions = tagInsertions;
        this.tagRemovals = tagRemovals;
    }

    @Override
    @JsonProperty(value="add")
    public Set<String> tagInsertions() {
        return this.tagInsertions;
    }

    @Override
    @JsonProperty(value="remove")
    public Set<String> tagRemovals() {
        return this.tagRemovals;
    }

    public final TagsUpdateImpl withTagInsertions(String ... elements) {
        Set<String> newValue = TagsUpdateImpl.createUnmodifiableSet(TagsUpdateImpl.createSafeList(Arrays.asList(elements), true, false));
        return new TagsUpdateImpl(newValue, this.tagRemovals);
    }

    public final TagsUpdateImpl withTagInsertions(Iterable<String> elements) {
        if (this.tagInsertions == elements) {
            return this;
        }
        Set<String> newValue = TagsUpdateImpl.createUnmodifiableSet(TagsUpdateImpl.createSafeList(elements, true, false));
        return new TagsUpdateImpl(newValue, this.tagRemovals);
    }

    public final TagsUpdateImpl withTagRemovals(String ... elements) {
        Set<String> newValue = TagsUpdateImpl.createUnmodifiableSet(TagsUpdateImpl.createSafeList(Arrays.asList(elements), true, false));
        return new TagsUpdateImpl(this.tagInsertions, newValue);
    }

    public final TagsUpdateImpl withTagRemovals(Iterable<String> elements) {
        if (this.tagRemovals == elements) {
            return this;
        }
        Set<String> newValue = TagsUpdateImpl.createUnmodifiableSet(TagsUpdateImpl.createSafeList(elements, true, false));
        return new TagsUpdateImpl(this.tagInsertions, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof TagsUpdateImpl && this.equalTo((TagsUpdateImpl)another);
    }

    private boolean equalTo(TagsUpdateImpl another) {
        return this.tagInsertions.equals(another.tagInsertions) && this.tagRemovals.equals(another.tagRemovals);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.tagInsertions.hashCode();
        h = h * 17 + this.tagRemovals.hashCode();
        return h;
    }

    public String toString() {
        return "TagsUpdate{tagInsertions=" + this.tagInsertions + ", tagRemovals=" + this.tagRemovals + "}";
    }

    public static TagsUpdate copyOf(TagsUpdate instance) {
        if (instance instanceof TagsUpdateImpl) {
            return (TagsUpdateImpl)instance;
        }
        return new TagsUpdate.Builder().using(instance).build();
    }

    private static <T> T requireNonNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                TagsUpdateImpl.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @NotThreadSafe
    static class Builder {
        private List<String> tagInsertions = new ArrayList<String>();
        private List<String> tagRemovals = new ArrayList<String>();

        Builder() {
            if (!(this instanceof TagsUpdate.Builder)) {
                throw new UnsupportedOperationException("Use: new TagsUpdate.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final TagsUpdate.Builder using(TagsUpdate instance) {
            TagsUpdateImpl.requireNonNull(instance, "instance");
            this.addAllTagInsertions(instance.tagInsertions());
            this.addAllTagRemovals(instance.tagRemovals());
            return (TagsUpdate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final TagsUpdate.Builder addTagInsertion(String element) {
            this.tagInsertions.add((String)TagsUpdateImpl.requireNonNull(element, "tagInsertions element"));
            return (TagsUpdate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final TagsUpdate.Builder addTagInsertion(String ... elements) {
            for (String element : elements) {
                this.tagInsertions.add((String)TagsUpdateImpl.requireNonNull(element, "tagInsertions element"));
            }
            return (TagsUpdate.Builder)this;
        }

        @JsonProperty(value="add")
        @CanIgnoreReturnValue
        public final TagsUpdate.Builder tagInsertions(Iterable<String> elements) {
            this.tagInsertions.clear();
            return this.addAllTagInsertions(elements);
        }

        @CanIgnoreReturnValue
        public final TagsUpdate.Builder addAllTagInsertions(Iterable<String> elements) {
            for (String element : elements) {
                this.tagInsertions.add((String)TagsUpdateImpl.requireNonNull(element, "tagInsertions element"));
            }
            return (TagsUpdate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final TagsUpdate.Builder addTagRemoval(String element) {
            this.tagRemovals.add((String)TagsUpdateImpl.requireNonNull(element, "tagRemovals element"));
            return (TagsUpdate.Builder)this;
        }

        @CanIgnoreReturnValue
        public final TagsUpdate.Builder addTagRemoval(String ... elements) {
            for (String element : elements) {
                this.tagRemovals.add((String)TagsUpdateImpl.requireNonNull(element, "tagRemovals element"));
            }
            return (TagsUpdate.Builder)this;
        }

        @JsonProperty(value="remove")
        @CanIgnoreReturnValue
        public final TagsUpdate.Builder tagRemovals(Iterable<String> elements) {
            this.tagRemovals.clear();
            return this.addAllTagRemovals(elements);
        }

        @CanIgnoreReturnValue
        public final TagsUpdate.Builder addAllTagRemovals(Iterable<String> elements) {
            for (String element : elements) {
                this.tagRemovals.add((String)TagsUpdateImpl.requireNonNull(element, "tagRemovals element"));
            }
            return (TagsUpdate.Builder)this;
        }

        public TagsUpdate build() {
            return new TagsUpdateImpl(TagsUpdateImpl.createUnmodifiableSet(this.tagInsertions), TagsUpdateImpl.createUnmodifiableSet(this.tagRemovals));
        }
    }
}

