/*
 * Numbers | Sinch
 * An API service for getting, listing and managing Sinch virtual numbers.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: Support@sinch.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sinch.sdk.domains.numbers.adapters.api.v1;

import com.fasterxml.jackson.core.type.TypeReference;
import com.sinch.sdk.core.exceptions.ApiException;
import com.sinch.sdk.core.exceptions.ApiExceptionBuilder;
import com.sinch.sdk.core.http.HttpClient;
import com.sinch.sdk.core.http.HttpMapper;
import com.sinch.sdk.core.http.HttpMethod;
import com.sinch.sdk.core.http.HttpRequest;
import com.sinch.sdk.core.http.HttpResponse;
import com.sinch.sdk.core.http.HttpStatus;
import com.sinch.sdk.core.http.URLParameter;
import com.sinch.sdk.core.http.URLParameterUtils;
import com.sinch.sdk.core.models.ServerConfiguration;
import com.sinch.sdk.domains.numbers.models.dto.v1.ActiveNumberDto;
import com.sinch.sdk.domains.numbers.models.dto.v1.ActiveNumberRequestDto;
import com.sinch.sdk.domains.numbers.models.dto.v1.ActiveNumbersResponseDto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

// @javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class ActiveNumberApi {

  private static final Logger LOGGER = Logger.getLogger(ActiveNumberApi.class.getName());
  private HttpClient httpClient;
  private ServerConfiguration serverConfiguration;
  private HttpMapper mapper;

  public ActiveNumberApi(
      HttpClient httpClient, ServerConfiguration serverConfiguration, HttpMapper mapper) {
    this.httpClient = httpClient;
    this.serverConfiguration = serverConfiguration;
    this.mapper = mapper;
  }

  /**
   * Get active Number Get a virtual number
   *
   * @param projectId Found on your &lt;a
   *     href&#x3D;\&quot;https://dashboard.sinch.com/settings/project-management\&quot;
   *     target&#x3D;\&quot;_blank\&quot;&gt;Sinch Customer Dashboard&lt;/a&gt;. (required)
   * @param phoneNumber Output only. The phone number in &lt;a
   *     href&#x3D;\&quot;https://community.sinch.com/t5/Glossary/E-164/ta-p/7537\&quot;
   *     target&#x3D;\&quot;_blank\&quot;&gt;E.164&lt;/a&gt; format with leading &#x60;+&#x60;.
   *     (required)
   * @return ActiveNumberDto
   * @throws ApiException if fails to make API call
   */
  public ActiveNumberDto numberServiceGetActiveNumber(String projectId, String phoneNumber)
      throws ApiException {

    LOGGER.finest(
        "[numberServiceGetActiveNumber] "
            + "projectId: "
            + projectId
            + ", "
            + "phoneNumber: "
            + phoneNumber);

    HttpRequest httpRequest = numberServiceGetActiveNumberRequestBuilder(projectId, phoneNumber);
    HttpResponse response = httpClient.invokeAPI(this.serverConfiguration, httpRequest);

    if (HttpStatus.isSuccessfulStatus(response.getCode())) {
      TypeReference<ActiveNumberDto> localVarReturnType = new TypeReference<ActiveNumberDto>() {};
      return mapper.deserialize(response, localVarReturnType);
    }
    // fallback to default errors handling:
    // all error cases definition are not required from specs: will try some "hardcoded" content
    // parsing
    throw ApiExceptionBuilder.build(
        response.getMessage(),
        response.getCode(),
        mapper.deserialize(response, new TypeReference<HashMap<String, ?>>() {}));
  }

  private HttpRequest numberServiceGetActiveNumberRequestBuilder(
      String projectId, String phoneNumber) throws ApiException {
    // verify the required parameter 'projectId' is set
    if (projectId == null) {
      throw new ApiException(
          400,
          "Missing the required parameter 'projectId' when calling numberServiceGetActiveNumber");
    }
    // verify the required parameter 'phoneNumber' is set
    if (phoneNumber == null) {
      throw new ApiException(
          400,
          "Missing the required parameter 'phoneNumber' when calling numberServiceGetActiveNumber");
    }

    String localVarPath =
        "/v1/projects/{projectId}/activeNumbers/{phoneNumber}"
            .replaceAll(
                "\\{" + "projectId" + "\\}",
                URLParameterUtils.encodeParameterValue(projectId.toString()))
            .replaceAll(
                "\\{" + "phoneNumber" + "\\}",
                URLParameterUtils.encodeParameterValue(phoneNumber.toString()));

    List<URLParameter> localVarQueryParams = new ArrayList<>();

    Map<String, String> localVarHeaderParams = new HashMap<>();

    final Collection<String> localVarAccepts = Arrays.asList("application/json");

    final Collection<String> localVarContentTypes = Arrays.asList();

    final Collection<String> localVarAuthNames = Arrays.asList("BasicAuth");
    final String serializedBody = null;

    return new HttpRequest(
        localVarPath,
        HttpMethod.GET,
        localVarQueryParams,
        serializedBody,
        localVarHeaderParams,
        localVarAccepts,
        localVarContentTypes,
        localVarAuthNames);
  }
  /**
   * List active numbers Lists all virtual numbers for a project.
   *
   * @param projectId Found on your &lt;a
   *     href&#x3D;\&quot;https://dashboard.sinch.com/settings/project-management\&quot;
   *     target&#x3D;\&quot;_blank\&quot;&gt;Sinch Customer Dashboard&lt;/a&gt;. (required)
   * @param regionCode Region code to filter by. ISO 3166-1 alpha-2 country code of the phone
   *     number. Example: &#x60;US&#x60;, &#x60;GB&#x60; or &#x60;SE&#x60;. (required)
   * @param type Number type to filter by. Options include, &#x60;MOBILE&#x60;, &#x60;LOCAL&#x60; or
   *     &#x60;TOLL_FREE&#x60;. (required)
   * @param numberPatternPattern Sequence of digits to search for. If you prefer or need certain
   *     digits in sequential order, you can enter the sequence of numbers here. For example,
   *     &#x60;2020&#x60;. (optional)
   * @param numberPatternSearchPattern Search pattern to apply. The options are, &#x60;START&#x60;,
   *     &#x60;CONTAIN&#x60;, and &#x60;END&#x60;. (optional)
   * @param capability Number capabilities to filter by, &#x60;SMS&#x60; and/or &#x60;VOICE&#x60;.
   *     (optional
   * @param pageSize The maximum number of items to return. (optional)
   * @param pageToken The next page token value returned from a previous List request, if any.
   *     (optional)
   * @param orderBy Supported fields for ordering by &#x60;phoneNumber&#x60; or
   *     &#x60;displayName&#x60;. (optional)
   * @return ActiveNumbersResponseDto
   * @throws ApiException if fails to make API call
   */
  public ActiveNumbersResponseDto numberServiceListActiveNumbers(
      String projectId,
      String regionCode,
      String type,
      String numberPatternPattern,
      String numberPatternSearchPattern,
      List<String> capability,
      Integer pageSize,
      String pageToken,
      String orderBy)
      throws ApiException {

    LOGGER.finest(
        "[numberServiceListActiveNumbers] "
            + "projectId: "
            + projectId
            + ", "
            + "regionCode: "
            + regionCode
            + ", "
            + "type: "
            + type
            + ", "
            + "numberPatternPattern: "
            + numberPatternPattern
            + ", "
            + "numberPatternSearchPattern: "
            + numberPatternSearchPattern
            + ", "
            + "capability: "
            + capability
            + ", "
            + "pageSize: "
            + pageSize
            + ", "
            + "pageToken: "
            + pageToken
            + ", "
            + "orderBy: "
            + orderBy);

    HttpRequest httpRequest =
        numberServiceListActiveNumbersRequestBuilder(
            projectId,
            regionCode,
            type,
            numberPatternPattern,
            numberPatternSearchPattern,
            capability,
            pageSize,
            pageToken,
            orderBy);
    HttpResponse response = httpClient.invokeAPI(this.serverConfiguration, httpRequest);

    if (HttpStatus.isSuccessfulStatus(response.getCode())) {
      TypeReference<ActiveNumbersResponseDto> localVarReturnType =
          new TypeReference<ActiveNumbersResponseDto>() {};
      return mapper.deserialize(response, localVarReturnType);
    }
    // fallback to default errors handling:
    // all error cases definition are not required from specs: will try some "hardcoded" content
    // parsing
    throw ApiExceptionBuilder.build(
        response.getMessage(),
        response.getCode(),
        mapper.deserialize(response, new TypeReference<HashMap<String, ?>>() {}));
  }

  private HttpRequest numberServiceListActiveNumbersRequestBuilder(
      String projectId,
      String regionCode,
      String type,
      String numberPatternPattern,
      String numberPatternSearchPattern,
      List<String> capability,
      Integer pageSize,
      String pageToken,
      String orderBy)
      throws ApiException {
    // verify the required parameter 'projectId' is set
    if (projectId == null) {
      throw new ApiException(
          400,
          "Missing the required parameter 'projectId' when calling numberServiceListActiveNumbers");
    }
    // verify the required parameter 'regionCode' is set
    if (regionCode == null) {
      throw new ApiException(
          400,
          "Missing the required parameter 'regionCode' when calling"
              + " numberServiceListActiveNumbers");
    }
    // verify the required parameter 'type' is set
    if (type == null) {
      throw new ApiException(
          400, "Missing the required parameter 'type' when calling numberServiceListActiveNumbers");
    }

    String localVarPath =
        "/v1/projects/{projectId}/activeNumbers"
            .replaceAll(
                "\\{" + "projectId" + "\\}",
                URLParameterUtils.encodeParameterValue(projectId.toString()));

    List<URLParameter> localVarQueryParams = new ArrayList<>();
    if (null != regionCode) {
      localVarQueryParams.add(
          new URLParameter(
              "regionCode", regionCode, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
    }
    if (null != numberPatternPattern) {
      localVarQueryParams.add(
          new URLParameter(
              "numberPattern.pattern",
              numberPatternPattern,
              URLParameter.STYLE.valueOf("form".toUpperCase()),
              true));
    }
    if (null != numberPatternSearchPattern) {
      localVarQueryParams.add(
          new URLParameter(
              "numberPattern.searchPattern",
              numberPatternSearchPattern,
              URLParameter.STYLE.valueOf("form".toUpperCase()),
              true));
    }
    if (null != type) {
      localVarQueryParams.add(
          new URLParameter("type", type, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
    }
    if (null != capability) {
      localVarQueryParams.add(
          new URLParameter(
              "capability", capability, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
    }
    if (null != pageSize) {
      localVarQueryParams.add(
          new URLParameter(
              "pageSize", pageSize, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
    }
    if (null != pageToken) {
      localVarQueryParams.add(
          new URLParameter(
              "pageToken", pageToken, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
    }
    if (null != orderBy) {
      localVarQueryParams.add(
          new URLParameter(
              "orderBy", orderBy, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
    }

    Map<String, String> localVarHeaderParams = new HashMap<>();

    final Collection<String> localVarAccepts = Arrays.asList("application/json");

    final Collection<String> localVarContentTypes = Arrays.asList();

    final Collection<String> localVarAuthNames = Arrays.asList("BasicAuth");
    final String serializedBody = null;

    return new HttpRequest(
        localVarPath,
        HttpMethod.GET,
        localVarQueryParams,
        serializedBody,
        localVarHeaderParams,
        localVarAccepts,
        localVarContentTypes,
        localVarAuthNames);
  }
  /**
   * Release number With this endpoint, you can cancel your subscription for a specific virtual
   * phone number.
   *
   * @param projectId Found on your &lt;a
   *     href&#x3D;\&quot;https://dashboard.sinch.com/settings/project-management\&quot;
   *     target&#x3D;\&quot;_blank\&quot;&gt;Sinch Customer Dashboard&lt;/a&gt;. (required)
   * @param phoneNumber Output only. The phone number in &lt;a
   *     href&#x3D;\&quot;https://community.sinch.com/t5/Glossary/E-164/ta-p/7537\&quot;
   *     target&#x3D;\&quot;_blank\&quot;&gt;E.164&lt;/a&gt; format with leading &#x60;+&#x60;.
   *     (required)
   * @return ActiveNumberDto
   * @throws ApiException if fails to make API call
   */
  public ActiveNumberDto numberServiceReleaseNumber(String projectId, String phoneNumber)
      throws ApiException {

    LOGGER.finest(
        "[numberServiceReleaseNumber] "
            + "projectId: "
            + projectId
            + ", "
            + "phoneNumber: "
            + phoneNumber);

    HttpRequest httpRequest = numberServiceReleaseNumberRequestBuilder(projectId, phoneNumber);
    HttpResponse response = httpClient.invokeAPI(this.serverConfiguration, httpRequest);

    if (HttpStatus.isSuccessfulStatus(response.getCode())) {
      TypeReference<ActiveNumberDto> localVarReturnType = new TypeReference<ActiveNumberDto>() {};
      return mapper.deserialize(response, localVarReturnType);
    }
    // fallback to default errors handling:
    // all error cases definition are not required from specs: will try some "hardcoded" content
    // parsing
    throw ApiExceptionBuilder.build(
        response.getMessage(),
        response.getCode(),
        mapper.deserialize(response, new TypeReference<HashMap<String, ?>>() {}));
  }

  private HttpRequest numberServiceReleaseNumberRequestBuilder(String projectId, String phoneNumber)
      throws ApiException {
    // verify the required parameter 'projectId' is set
    if (projectId == null) {
      throw new ApiException(
          400,
          "Missing the required parameter 'projectId' when calling numberServiceReleaseNumber");
    }
    // verify the required parameter 'phoneNumber' is set
    if (phoneNumber == null) {
      throw new ApiException(
          400,
          "Missing the required parameter 'phoneNumber' when calling numberServiceReleaseNumber");
    }

    String localVarPath =
        "/v1/projects/{projectId}/activeNumbers/{phoneNumber}:release"
            .replaceAll(
                "\\{" + "projectId" + "\\}",
                URLParameterUtils.encodeParameterValue(projectId.toString()))
            .replaceAll(
                "\\{" + "phoneNumber" + "\\}",
                URLParameterUtils.encodeParameterValue(phoneNumber.toString()));

    List<URLParameter> localVarQueryParams = new ArrayList<>();

    Map<String, String> localVarHeaderParams = new HashMap<>();

    final Collection<String> localVarAccepts = Arrays.asList("application/json");

    final Collection<String> localVarContentTypes = Arrays.asList();

    final Collection<String> localVarAuthNames = Arrays.asList("BasicAuth");
    final String serializedBody = null;

    return new HttpRequest(
        localVarPath,
        HttpMethod.POST,
        localVarQueryParams,
        serializedBody,
        localVarHeaderParams,
        localVarAccepts,
        localVarContentTypes,
        localVarAuthNames);
  }
  /**
   * Update active number Update a virtual phone number. For example: you can configure SMS/Voice
   * services or set a friendly name. To update the name that displays, modify the
   * &#x60;displayName&#x60; parameter. You&#39;ll use &#x60;smsConfiguration&#x60; to update your
   * SMS configuration and &#x60;voiceConfiguration&#x60; to update the voice configuration.
   *
   * @param projectId Found on your &lt;a
   *     href&#x3D;\&quot;https://dashboard.sinch.com/settings/project-management\&quot;
   *     target&#x3D;\&quot;_blank\&quot;&gt;Sinch Customer Dashboard&lt;/a&gt;. (required)
   * @param phoneNumber Output only. The phone number in &lt;a
   *     href&#x3D;\&quot;https://community.sinch.com/t5/Glossary/E-164/ta-p/7537\&quot;
   *     target&#x3D;\&quot;_blank\&quot;&gt;E.164&lt;/a&gt; format with leading &#x60;+&#x60;.
   *     (required)
   * @param activeNumberRequestDto The number body to be updated. (optional)
   * @return ActiveNumberDto
   * @throws ApiException if fails to make API call
   */
  public ActiveNumberDto numberServiceUpdateActiveNumber(
      String projectId, String phoneNumber, ActiveNumberRequestDto activeNumberRequestDto)
      throws ApiException {

    LOGGER.finest(
        "[numberServiceUpdateActiveNumber] "
            + "projectId: "
            + projectId
            + ", "
            + "phoneNumber: "
            + phoneNumber
            + ", "
            + "activeNumberRequestDto: "
            + activeNumberRequestDto);

    HttpRequest httpRequest =
        numberServiceUpdateActiveNumberRequestBuilder(
            projectId, phoneNumber, activeNumberRequestDto);
    HttpResponse response = httpClient.invokeAPI(this.serverConfiguration, httpRequest);

    if (HttpStatus.isSuccessfulStatus(response.getCode())) {
      TypeReference<ActiveNumberDto> localVarReturnType = new TypeReference<ActiveNumberDto>() {};
      return mapper.deserialize(response, localVarReturnType);
    }
    // fallback to default errors handling:
    // all error cases definition are not required from specs: will try some "hardcoded" content
    // parsing
    throw ApiExceptionBuilder.build(
        response.getMessage(),
        response.getCode(),
        mapper.deserialize(response, new TypeReference<HashMap<String, ?>>() {}));
  }

  private HttpRequest numberServiceUpdateActiveNumberRequestBuilder(
      String projectId, String phoneNumber, ActiveNumberRequestDto activeNumberRequestDto)
      throws ApiException {
    // verify the required parameter 'projectId' is set
    if (projectId == null) {
      throw new ApiException(
          400,
          "Missing the required parameter 'projectId' when calling"
              + " numberServiceUpdateActiveNumber");
    }
    // verify the required parameter 'phoneNumber' is set
    if (phoneNumber == null) {
      throw new ApiException(
          400,
          "Missing the required parameter 'phoneNumber' when calling"
              + " numberServiceUpdateActiveNumber");
    }

    String localVarPath =
        "/v1/projects/{projectId}/activeNumbers/{phoneNumber}"
            .replaceAll(
                "\\{" + "projectId" + "\\}",
                URLParameterUtils.encodeParameterValue(projectId.toString()))
            .replaceAll(
                "\\{" + "phoneNumber" + "\\}",
                URLParameterUtils.encodeParameterValue(phoneNumber.toString()));

    List<URLParameter> localVarQueryParams = new ArrayList<>();

    Map<String, String> localVarHeaderParams = new HashMap<>();

    final Collection<String> localVarAccepts = Arrays.asList("application/json");

    final Collection<String> localVarContentTypes = Arrays.asList("application/json");

    final Collection<String> localVarAuthNames = Arrays.asList("BasicAuth");
    final String serializedBody = mapper.serialize(localVarContentTypes, activeNumberRequestDto);

    return new HttpRequest(
        localVarPath,
        HttpMethod.PATCH,
        localVarQueryParams,
        serializedBody,
        localVarHeaderParams,
        localVarAccepts,
        localVarContentTypes,
        localVarAuthNames);
  }
}
