/*
 * Numbers | Sinch
 * An API service for getting, listing and managing Sinch virtual numbers.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: Support@sinch.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sinch.sdk.domains.numbers.adapters.api.v1;

import com.fasterxml.jackson.core.type.TypeReference;
import com.sinch.sdk.core.exceptions.ApiException;
import com.sinch.sdk.core.exceptions.ApiExceptionBuilder;
import com.sinch.sdk.core.http.HttpClient;
import com.sinch.sdk.core.http.HttpMapper;
import com.sinch.sdk.core.http.HttpMethod;
import com.sinch.sdk.core.http.HttpRequest;
import com.sinch.sdk.core.http.HttpResponse;
import com.sinch.sdk.core.http.HttpStatus;
import com.sinch.sdk.core.http.URLParameter;
import com.sinch.sdk.core.http.URLParameterUtils;
import com.sinch.sdk.core.models.ServerConfiguration;
import com.sinch.sdk.domains.numbers.models.dto.v1.CallbackConfigurationDto;
import com.sinch.sdk.domains.numbers.models.dto.v1.CallbackConfigurationUpdateDto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

// @javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class CallbackConfigurationApi {

  private static final Logger LOGGER = Logger.getLogger(CallbackConfigurationApi.class.getName());
  private HttpClient httpClient;
  private ServerConfiguration serverConfiguration;
  private HttpMapper mapper;

  public CallbackConfigurationApi(
      HttpClient httpClient, ServerConfiguration serverConfiguration, HttpMapper mapper) {
    this.httpClient = httpClient;
    this.serverConfiguration = serverConfiguration;
    this.mapper = mapper;
  }

  /**
   * Get callbacks configuration Returns the callbacks configuration for the specified project
   *
   * @param projectId Found on your &lt;a
   *     href&#x3D;\&quot;https://dashboard.sinch.com/settings/project-management\&quot;
   *     target&#x3D;\&quot;_blank\&quot;&gt;Sinch Customer Dashboard&lt;/a&gt;. (required)
   * @return CallbackConfigurationDto
   * @throws ApiException if fails to make API call
   */
  public CallbackConfigurationDto getCallbackConfiguration(String projectId) throws ApiException {

    LOGGER.finest("[getCallbackConfiguration] " + "projectId: " + projectId);

    HttpRequest httpRequest = getCallbackConfigurationRequestBuilder(projectId);
    HttpResponse response = httpClient.invokeAPI(this.serverConfiguration, httpRequest);

    if (HttpStatus.isSuccessfulStatus(response.getCode())) {
      TypeReference<CallbackConfigurationDto> localVarReturnType =
          new TypeReference<CallbackConfigurationDto>() {};
      return mapper.deserialize(response, localVarReturnType);
    }
    // fallback to default errors handling:
    // all error cases definition are not required from specs: will try some "hardcoded" content
    // parsing
    throw ApiExceptionBuilder.build(
        response.getMessage(),
        response.getCode(),
        mapper.deserialize(response, new TypeReference<HashMap<String, ?>>() {}));
  }

  private HttpRequest getCallbackConfigurationRequestBuilder(String projectId) throws ApiException {
    // verify the required parameter 'projectId' is set
    if (projectId == null) {
      throw new ApiException(
          400, "Missing the required parameter 'projectId' when calling getCallbackConfiguration");
    }

    String localVarPath =
        "/v1/projects/{projectId}/callbackConfiguration"
            .replaceAll(
                "\\{" + "projectId" + "\\}",
                URLParameterUtils.encodeParameterValue(projectId.toString()));

    List<URLParameter> localVarQueryParams = new ArrayList<>();

    Map<String, String> localVarHeaderParams = new HashMap<>();

    final Collection<String> localVarAccepts = Arrays.asList("application/json");

    final Collection<String> localVarContentTypes = Arrays.asList();

    final Collection<String> localVarAuthNames = Arrays.asList("BasicAuth");
    final String serializedBody = null;

    return new HttpRequest(
        localVarPath,
        HttpMethod.GET,
        localVarQueryParams,
        serializedBody,
        localVarHeaderParams,
        localVarAccepts,
        localVarContentTypes,
        localVarAuthNames);
  }
  /**
   * Update callback configuration Updates the callbacks configuration for the specified project
   *
   * @param projectId Found on your &lt;a
   *     href&#x3D;\&quot;https://dashboard.sinch.com/settings/project-management\&quot;
   *     target&#x3D;\&quot;_blank\&quot;&gt;Sinch Customer Dashboard&lt;/a&gt;. (required)
   * @param callbackConfigurationUpdateDto The callback configuration details to be updated.
   *     (optional)
   * @return CallbackConfigurationDto
   * @throws ApiException if fails to make API call
   */
  public CallbackConfigurationDto updateCallbackConfiguration(
      String projectId, CallbackConfigurationUpdateDto callbackConfigurationUpdateDto)
      throws ApiException {

    LOGGER.finest(
        "[updateCallbackConfiguration] "
            + "projectId: "
            + projectId
            + ", "
            + "callbackConfigurationUpdateDto: "
            + callbackConfigurationUpdateDto);

    HttpRequest httpRequest =
        updateCallbackConfigurationRequestBuilder(projectId, callbackConfigurationUpdateDto);
    HttpResponse response = httpClient.invokeAPI(this.serverConfiguration, httpRequest);

    if (HttpStatus.isSuccessfulStatus(response.getCode())) {
      TypeReference<CallbackConfigurationDto> localVarReturnType =
          new TypeReference<CallbackConfigurationDto>() {};
      return mapper.deserialize(response, localVarReturnType);
    }
    // fallback to default errors handling:
    // all error cases definition are not required from specs: will try some "hardcoded" content
    // parsing
    throw ApiExceptionBuilder.build(
        response.getMessage(),
        response.getCode(),
        mapper.deserialize(response, new TypeReference<HashMap<String, ?>>() {}));
  }

  private HttpRequest updateCallbackConfigurationRequestBuilder(
      String projectId, CallbackConfigurationUpdateDto callbackConfigurationUpdateDto)
      throws ApiException {
    // verify the required parameter 'projectId' is set
    if (projectId == null) {
      throw new ApiException(
          400,
          "Missing the required parameter 'projectId' when calling updateCallbackConfiguration");
    }

    String localVarPath =
        "/v1/projects/{projectId}/callbackConfiguration"
            .replaceAll(
                "\\{" + "projectId" + "\\}",
                URLParameterUtils.encodeParameterValue(projectId.toString()));

    List<URLParameter> localVarQueryParams = new ArrayList<>();

    Map<String, String> localVarHeaderParams = new HashMap<>();

    final Collection<String> localVarAccepts = Arrays.asList("application/json");

    final Collection<String> localVarContentTypes = Arrays.asList("application/json");

    final Collection<String> localVarAuthNames = Arrays.asList("BasicAuth");
    final String serializedBody =
        mapper.serialize(localVarContentTypes, callbackConfigurationUpdateDto);

    return new HttpRequest(
        localVarPath,
        HttpMethod.PATCH,
        localVarQueryParams,
        serializedBody,
        localVarHeaderParams,
        localVarAccepts,
        localVarContentTypes,
        localVarAuthNames);
  }
}
