/*
 * Numbers | Sinch
 * An API service for getting, listing and managing Sinch virtual numbers.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: Support@sinch.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sinch.sdk.domains.numbers.models.dto.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** The phone number that has been rented by a customer and assigned to a project. */
@JsonPropertyOrder({
  ActiveNumberDto.JSON_PROPERTY_PHONE_NUMBER,
  ActiveNumberDto.JSON_PROPERTY_PROJECT_ID,
  ActiveNumberDto.JSON_PROPERTY_DISPLAY_NAME,
  ActiveNumberDto.JSON_PROPERTY_REGION_CODE,
  ActiveNumberDto.JSON_PROPERTY_TYPE,
  ActiveNumberDto.JSON_PROPERTY_CAPABILITY,
  ActiveNumberDto.JSON_PROPERTY_MONEY,
  ActiveNumberDto.JSON_PROPERTY_PAYMENT_INTERVAL_MONTHS,
  ActiveNumberDto.JSON_PROPERTY_NEXT_CHARGE_DATE,
  ActiveNumberDto.JSON_PROPERTY_EXPIRE_AT,
  ActiveNumberDto.JSON_PROPERTY_SMS_CONFIGURATION,
  ActiveNumberDto.JSON_PROPERTY_VOICE_CONFIGURATION,
  ActiveNumberDto.JSON_PROPERTY_CALLBACK_URL
})
// @javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class ActiveNumberDto {
  public static final String JSON_PROPERTY_PHONE_NUMBER = "phoneNumber";
  private String phoneNumber;

  public static final String JSON_PROPERTY_PROJECT_ID = "projectId";
  private String projectId;

  public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
  private String displayName;

  public static final String JSON_PROPERTY_REGION_CODE = "regionCode";
  private String regionCode;

  public static final String JSON_PROPERTY_TYPE = "type";
  private String type = "MOBILE";

  public static final String JSON_PROPERTY_CAPABILITY = "capability";
  private List<String> capability;

  public static final String JSON_PROPERTY_MONEY = "money";
  private MoneyDto money;

  public static final String JSON_PROPERTY_PAYMENT_INTERVAL_MONTHS = "paymentIntervalMonths";
  private Integer paymentIntervalMonths;

  public static final String JSON_PROPERTY_NEXT_CHARGE_DATE = "nextChargeDate";
  private OffsetDateTime nextChargeDate;

  public static final String JSON_PROPERTY_EXPIRE_AT = "expireAt";
  private OffsetDateTime expireAt;

  public static final String JSON_PROPERTY_SMS_CONFIGURATION = "smsConfiguration";
  private SMSConfigurationDto smsConfiguration;

  public static final String JSON_PROPERTY_VOICE_CONFIGURATION = "voiceConfiguration";
  private VoiceConfigurationDto voiceConfiguration;

  public static final String JSON_PROPERTY_CALLBACK_URL = "callbackUrl";
  private String callbackUrl;

  public ActiveNumberDto() {}

  @JsonCreator
  public ActiveNumberDto(
      @JsonProperty(JSON_PROPERTY_REGION_CODE) String regionCode,
      @JsonProperty(JSON_PROPERTY_PAYMENT_INTERVAL_MONTHS) Integer paymentIntervalMonths,
      @JsonProperty(JSON_PROPERTY_NEXT_CHARGE_DATE) OffsetDateTime nextChargeDate,
      @JsonProperty(JSON_PROPERTY_EXPIRE_AT) OffsetDateTime expireAt) {
    this();
    this.regionCode = regionCode;
    this.paymentIntervalMonths = paymentIntervalMonths;
    this.nextChargeDate = nextChargeDate;
    this.expireAt = expireAt;
  }

  public ActiveNumberDto phoneNumber(String phoneNumber) {
    this.phoneNumber = phoneNumber;
    return this;
  }

  /**
   * The phone number in &lt;a
   * href&#x3D;\&quot;https://community.sinch.com/t5/Glossary/E-164/ta-p/7537\&quot;
   * target&#x3D;\&quot;_blank\&quot;&gt;E.164&lt;/a&gt; format with leading &#x60;+&#x60;. Example:
   * &#x60;+12025550134&#x60;.
   *
   * @return phoneNumber
   */
  @JsonProperty(JSON_PROPERTY_PHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPhoneNumber() {
    return phoneNumber;
  }

  @JsonProperty(JSON_PROPERTY_PHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhoneNumber(String phoneNumber) {
    this.phoneNumber = phoneNumber;
  }

  public ActiveNumberDto projectId(String projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * Project ID. Your project ID can be found on your &lt;a
   * href&#x3D;\&quot;https://dashboard.sinch.com/settings/project-management\&quot;
   * target&#x3D;\&quot;_blank\&quot;&gt;Sinch Customer Dashboard&lt;/a&gt;.
   *
   * @return projectId
   */
  @JsonProperty(JSON_PROPERTY_PROJECT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getProjectId() {
    return projectId;
  }

  @JsonProperty(JSON_PROPERTY_PROJECT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProjectId(String projectId) {
    this.projectId = projectId;
  }

  public ActiveNumberDto displayName(String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * User supplied name for the phone number.
   *
   * @return displayName
   */
  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDisplayName() {
    return displayName;
  }

  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }

  /**
   * ISO 3166-1 alpha-2 country code of the phone number. Example &#x60;US&#x60;, &#x60;GB&#x60; or
   * &#x60;SE&#x60;.
   *
   * @return regionCode
   */
  @JsonProperty(JSON_PROPERTY_REGION_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getRegionCode() {
    return regionCode;
  }

  public ActiveNumberDto type(String type) {
    this.type = type;
    return this;
  }

  /**
   * The number type.
   *
   * @return type
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getType() {
    return type;
  }

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(String type) {
    this.type = type;
  }

  public ActiveNumberDto capability(List<String> capability) {
    this.capability = capability;
    return this;
  }

  public ActiveNumberDto addCapabilityItem(String capabilityItem) {
    if (this.capability == null) {
      this.capability = new ArrayList<>();
    }
    this.capability.add(capabilityItem);
    return this;
  }

  /**
   * The capability of the number.
   *
   * @return capability
   */
  @JsonProperty(JSON_PROPERTY_CAPABILITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getCapability() {
    return capability;
  }

  @JsonProperty(JSON_PROPERTY_CAPABILITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCapability(List<String> capability) {
    this.capability = capability;
  }

  public ActiveNumberDto money(MoneyDto money) {
    this.money = money;
    return this;
  }

  /**
   * Get money
   *
   * @return money
   */
  @JsonProperty(JSON_PROPERTY_MONEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public MoneyDto getMoney() {
    return money;
  }

  @JsonProperty(JSON_PROPERTY_MONEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMoney(MoneyDto money) {
    this.money = money;
  }

  /**
   * How often the recurring price is charged in months.
   *
   * @return paymentIntervalMonths
   */
  @JsonProperty(JSON_PROPERTY_PAYMENT_INTERVAL_MONTHS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getPaymentIntervalMonths() {
    return paymentIntervalMonths;
  }

  /**
   * The date of the next charge.
   *
   * @return nextChargeDate
   */
  @JsonProperty(JSON_PROPERTY_NEXT_CHARGE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getNextChargeDate() {
    return nextChargeDate;
  }

  /**
   * The timestamp when the subscription will expire if an expiration date has been set.
   *
   * @return expireAt
   */
  @JsonProperty(JSON_PROPERTY_EXPIRE_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getExpireAt() {
    return expireAt;
  }

  public ActiveNumberDto smsConfiguration(SMSConfigurationDto smsConfiguration) {
    this.smsConfiguration = smsConfiguration;
    return this;
  }

  /**
   * Get smsConfiguration
   *
   * @return smsConfiguration
   */
  @JsonProperty(JSON_PROPERTY_SMS_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public SMSConfigurationDto getSmsConfiguration() {
    return smsConfiguration;
  }

  @JsonProperty(JSON_PROPERTY_SMS_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSmsConfiguration(SMSConfigurationDto smsConfiguration) {
    this.smsConfiguration = smsConfiguration;
  }

  public ActiveNumberDto voiceConfiguration(VoiceConfigurationDto voiceConfiguration) {
    this.voiceConfiguration = voiceConfiguration;
    return this;
  }

  /**
   * Get voiceConfiguration
   *
   * @return voiceConfiguration
   */
  @JsonProperty(JSON_PROPERTY_VOICE_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public VoiceConfigurationDto getVoiceConfiguration() {
    return voiceConfiguration;
  }

  @JsonProperty(JSON_PROPERTY_VOICE_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVoiceConfiguration(VoiceConfigurationDto voiceConfiguration) {
    this.voiceConfiguration = voiceConfiguration;
  }

  public ActiveNumberDto callbackUrl(String callbackUrl) {
    this.callbackUrl = callbackUrl;
    return this;
  }

  /**
   * The active number&#39;s callback URL to be called for provisioning / deprovisioning updates
   *
   * @return callbackUrl
   */
  @JsonProperty(JSON_PROPERTY_CALLBACK_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCallbackUrl() {
    return callbackUrl;
  }

  @JsonProperty(JSON_PROPERTY_CALLBACK_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCallbackUrl(String callbackUrl) {
    this.callbackUrl = callbackUrl;
  }

  /** Return true if this ActiveNumber object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ActiveNumberDto activeNumber = (ActiveNumberDto) o;
    return Objects.equals(this.phoneNumber, activeNumber.phoneNumber)
        && Objects.equals(this.projectId, activeNumber.projectId)
        && Objects.equals(this.displayName, activeNumber.displayName)
        && Objects.equals(this.regionCode, activeNumber.regionCode)
        && Objects.equals(this.type, activeNumber.type)
        && Objects.equals(this.capability, activeNumber.capability)
        && Objects.equals(this.money, activeNumber.money)
        && Objects.equals(this.paymentIntervalMonths, activeNumber.paymentIntervalMonths)
        && Objects.equals(this.nextChargeDate, activeNumber.nextChargeDate)
        && Objects.equals(this.expireAt, activeNumber.expireAt)
        && Objects.equals(this.smsConfiguration, activeNumber.smsConfiguration)
        && Objects.equals(this.voiceConfiguration, activeNumber.voiceConfiguration)
        && Objects.equals(this.callbackUrl, activeNumber.callbackUrl);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        phoneNumber,
        projectId,
        displayName,
        regionCode,
        type,
        capability,
        money,
        paymentIntervalMonths,
        nextChargeDate,
        expireAt,
        smsConfiguration,
        voiceConfiguration,
        callbackUrl);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ActiveNumberDto {\n");
    sb.append("    phoneNumber: ").append(toIndentedString(phoneNumber)).append("\n");
    sb.append("    projectId: ").append(toIndentedString(projectId)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    regionCode: ").append(toIndentedString(regionCode)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    capability: ").append(toIndentedString(capability)).append("\n");
    sb.append("    money: ").append(toIndentedString(money)).append("\n");
    sb.append("    paymentIntervalMonths: ")
        .append(toIndentedString(paymentIntervalMonths))
        .append("\n");
    sb.append("    nextChargeDate: ").append(toIndentedString(nextChargeDate)).append("\n");
    sb.append("    expireAt: ").append(toIndentedString(expireAt)).append("\n");
    sb.append("    smsConfiguration: ").append(toIndentedString(smsConfiguration)).append("\n");
    sb.append("    voiceConfiguration: ").append(toIndentedString(voiceConfiguration)).append("\n");
    sb.append("    callbackUrl: ").append(toIndentedString(callbackUrl)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
