/*
 * Numbers | Sinch
 * An API service for getting, listing and managing Sinch virtual numbers.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: Support@sinch.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sinch.sdk.domains.numbers.models.dto.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;

/** The phone number that has been rented by a customer and assigned to a project. */
@JsonPropertyOrder({
  ActiveNumberRequestDto.JSON_PROPERTY_DISPLAY_NAME,
  ActiveNumberRequestDto.JSON_PROPERTY_SMS_CONFIGURATION,
  ActiveNumberRequestDto.JSON_PROPERTY_VOICE_CONFIGURATION
})
// @javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class ActiveNumberRequestDto {
  public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
  private String displayName;

  public static final String JSON_PROPERTY_SMS_CONFIGURATION = "smsConfiguration";
  private SMSConfigurationDto smsConfiguration;

  public static final String JSON_PROPERTY_VOICE_CONFIGURATION = "voiceConfiguration";
  private VoiceConfigurationDto voiceConfiguration;

  public ActiveNumberRequestDto() {}

  public ActiveNumberRequestDto displayName(String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * User supplied name for the phone number.
   *
   * @return displayName
   */
  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDisplayName() {
    return displayName;
  }

  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }

  public ActiveNumberRequestDto smsConfiguration(SMSConfigurationDto smsConfiguration) {
    this.smsConfiguration = smsConfiguration;
    return this;
  }

  /**
   * Get smsConfiguration
   *
   * @return smsConfiguration
   */
  @JsonProperty(JSON_PROPERTY_SMS_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public SMSConfigurationDto getSmsConfiguration() {
    return smsConfiguration;
  }

  @JsonProperty(JSON_PROPERTY_SMS_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSmsConfiguration(SMSConfigurationDto smsConfiguration) {
    this.smsConfiguration = smsConfiguration;
  }

  public ActiveNumberRequestDto voiceConfiguration(VoiceConfigurationDto voiceConfiguration) {
    this.voiceConfiguration = voiceConfiguration;
    return this;
  }

  /**
   * Get voiceConfiguration
   *
   * @return voiceConfiguration
   */
  @JsonProperty(JSON_PROPERTY_VOICE_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public VoiceConfigurationDto getVoiceConfiguration() {
    return voiceConfiguration;
  }

  @JsonProperty(JSON_PROPERTY_VOICE_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVoiceConfiguration(VoiceConfigurationDto voiceConfiguration) {
    this.voiceConfiguration = voiceConfiguration;
  }

  /** Return true if this ActiveNumberRequest object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ActiveNumberRequestDto activeNumberRequest = (ActiveNumberRequestDto) o;
    return Objects.equals(this.displayName, activeNumberRequest.displayName)
        && Objects.equals(this.smsConfiguration, activeNumberRequest.smsConfiguration)
        && Objects.equals(this.voiceConfiguration, activeNumberRequest.voiceConfiguration);
  }

  @Override
  public int hashCode() {
    return Objects.hash(displayName, smsConfiguration, voiceConfiguration);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ActiveNumberRequestDto {\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    smsConfiguration: ").append(toIndentedString(smsConfiguration)).append("\n");
    sb.append("    voiceConfiguration: ").append(toIndentedString(voiceConfiguration)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
