/*
 * Numbers | Sinch
 * An API service for getting, listing and managing Sinch virtual numbers.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: Support@sinch.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sinch.sdk.domains.numbers.models.dto.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** Response message to list your active phone numbers. */
@JsonPropertyOrder({
  ActiveNumbersResponseDto.JSON_PROPERTY_ACTIVE_NUMBERS,
  ActiveNumbersResponseDto.JSON_PROPERTY_NEXT_PAGE_TOKEN,
  ActiveNumbersResponseDto.JSON_PROPERTY_TOTAL_SIZE
})
// @javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class ActiveNumbersResponseDto {
  public static final String JSON_PROPERTY_ACTIVE_NUMBERS = "activeNumbers";
  private List<ActiveNumberDto> activeNumbers;

  public static final String JSON_PROPERTY_NEXT_PAGE_TOKEN = "nextPageToken";
  private String nextPageToken;

  public static final String JSON_PROPERTY_TOTAL_SIZE = "totalSize";
  private Integer totalSize;

  public ActiveNumbersResponseDto() {}

  public ActiveNumbersResponseDto activeNumbers(List<ActiveNumberDto> activeNumbers) {
    this.activeNumbers = activeNumbers;
    return this;
  }

  public ActiveNumbersResponseDto addActiveNumbersItem(ActiveNumberDto activeNumbersItem) {
    if (this.activeNumbers == null) {
      this.activeNumbers = new ArrayList<>();
    }
    this.activeNumbers.add(activeNumbersItem);
    return this;
  }

  /**
   * List of numbers associated to the client project specified in &#x60;ListActiveNumbers&#x60;.
   *
   * @return activeNumbers
   */
  @JsonProperty(JSON_PROPERTY_ACTIVE_NUMBERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<ActiveNumberDto> getActiveNumbers() {
    return activeNumbers;
  }

  @JsonProperty(JSON_PROPERTY_ACTIVE_NUMBERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActiveNumbers(List<ActiveNumberDto> activeNumbers) {
    this.activeNumbers = activeNumbers;
  }

  public ActiveNumbersResponseDto nextPageToken(String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * Get nextPageToken
   *
   * @return nextPageToken
   */
  @JsonProperty(JSON_PROPERTY_NEXT_PAGE_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getNextPageToken() {
    return nextPageToken;
  }

  @JsonProperty(JSON_PROPERTY_NEXT_PAGE_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNextPageToken(String nextPageToken) {
    this.nextPageToken = nextPageToken;
  }

  public ActiveNumbersResponseDto totalSize(Integer totalSize) {
    this.totalSize = totalSize;
    return this;
  }

  /**
   * Get totalSize
   *
   * @return totalSize
   */
  @JsonProperty(JSON_PROPERTY_TOTAL_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getTotalSize() {
    return totalSize;
  }

  @JsonProperty(JSON_PROPERTY_TOTAL_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSize(Integer totalSize) {
    this.totalSize = totalSize;
  }

  /** Return true if this ActiveNumbersResponse object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ActiveNumbersResponseDto activeNumbersResponse = (ActiveNumbersResponseDto) o;
    return Objects.equals(this.activeNumbers, activeNumbersResponse.activeNumbers)
        && Objects.equals(this.nextPageToken, activeNumbersResponse.nextPageToken)
        && Objects.equals(this.totalSize, activeNumbersResponse.totalSize);
  }

  @Override
  public int hashCode() {
    return Objects.hash(activeNumbers, nextPageToken, totalSize);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ActiveNumbersResponseDto {\n");
    sb.append("    activeNumbers: ").append(toIndentedString(activeNumbers)).append("\n");
    sb.append("    nextPageToken: ").append(toIndentedString(nextPageToken)).append("\n");
    sb.append("    totalSize: ").append(toIndentedString(totalSize)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
