/*
 * Numbers | Sinch
 * An API service for getting, listing and managing Sinch virtual numbers.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: Support@sinch.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sinch.sdk.domains.numbers.models.dto.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** Available numbers schema base. */
@JsonPropertyOrder({
  ListAvailableNumberRequestDto.JSON_PROPERTY_NUMBER_PATTERN,
  ListAvailableNumberRequestDto.JSON_PROPERTY_NUMBER_PATTERN_SEARCH_PATTERN,
  ListAvailableNumberRequestDto.JSON_PROPERTY_REGION_CODE,
  ListAvailableNumberRequestDto.JSON_PROPERTY_TYPE,
  ListAvailableNumberRequestDto.JSON_PROPERTY_CAPABILITIES
})
// @javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class ListAvailableNumberRequestDto {
  public static final String JSON_PROPERTY_NUMBER_PATTERN = "NumberPattern";
  private NumberPatternPatternDto numberPattern;

  public static final String JSON_PROPERTY_NUMBER_PATTERN_SEARCH_PATTERN =
      "NumberPatternSearchPattern";
  private NumberPatternSearchPatternDto numberPatternSearchPattern;

  public static final String JSON_PROPERTY_REGION_CODE = "regionCode";
  private String regionCode;

  public static final String JSON_PROPERTY_TYPE = "type";
  private String type = "MOBILE";

  public static final String JSON_PROPERTY_CAPABILITIES = "capabilities";
  private List<String> capabilities;

  public ListAvailableNumberRequestDto() {}

  public ListAvailableNumberRequestDto numberPattern(NumberPatternPatternDto numberPattern) {
    this.numberPattern = numberPattern;
    return this;
  }

  /**
   * Get numberPattern
   *
   * @return numberPattern
   */
  @JsonProperty(JSON_PROPERTY_NUMBER_PATTERN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public NumberPatternPatternDto getNumberPattern() {
    return numberPattern;
  }

  @JsonProperty(JSON_PROPERTY_NUMBER_PATTERN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumberPattern(NumberPatternPatternDto numberPattern) {
    this.numberPattern = numberPattern;
  }

  public ListAvailableNumberRequestDto numberPatternSearchPattern(
      NumberPatternSearchPatternDto numberPatternSearchPattern) {
    this.numberPatternSearchPattern = numberPatternSearchPattern;
    return this;
  }

  /**
   * Get numberPatternSearchPattern
   *
   * @return numberPatternSearchPattern
   */
  @JsonProperty(JSON_PROPERTY_NUMBER_PATTERN_SEARCH_PATTERN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public NumberPatternSearchPatternDto getNumberPatternSearchPattern() {
    return numberPatternSearchPattern;
  }

  @JsonProperty(JSON_PROPERTY_NUMBER_PATTERN_SEARCH_PATTERN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumberPatternSearchPattern(
      NumberPatternSearchPatternDto numberPatternSearchPattern) {
    this.numberPatternSearchPattern = numberPatternSearchPattern;
  }

  public ListAvailableNumberRequestDto regionCode(String regionCode) {
    this.regionCode = regionCode;
    return this;
  }

  /**
   * Region code to filter by. ISO 3166-1 alpha-2 country code of the phone number. Example:
   * &#x60;US&#x60;, &#x60;GB&#x60; or &#x60;SE&#x60;.
   *
   * @return regionCode
   */
  @JsonProperty(JSON_PROPERTY_REGION_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getRegionCode() {
    return regionCode;
  }

  @JsonProperty(JSON_PROPERTY_REGION_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRegionCode(String regionCode) {
    this.regionCode = regionCode;
  }

  public ListAvailableNumberRequestDto type(String type) {
    this.type = type;
    return this;
  }

  /**
   * Number type to filter by. &#x60;MOBILE&#x60;, &#x60;LOCAL&#x60; or &#x60;TOLL_FREE&#x60;.
   *
   * @return type
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getType() {
    return type;
  }

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(String type) {
    this.type = type;
  }

  public ListAvailableNumberRequestDto capabilities(List<String> capabilities) {
    this.capabilities = capabilities;
    return this;
  }

  public ListAvailableNumberRequestDto addCapabilitiesItem(String capabilitiesItem) {
    if (this.capabilities == null) {
      this.capabilities = new ArrayList<>();
    }
    this.capabilities.add(capabilitiesItem);
    return this;
  }

  /**
   * Number capabilities to filter by, &#x60;SMS&#x60; and/or &#x60;VOICE&#x60;.
   *
   * @return capabilities
   */
  @JsonProperty(JSON_PROPERTY_CAPABILITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getCapabilities() {
    return capabilities;
  }

  @JsonProperty(JSON_PROPERTY_CAPABILITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCapabilities(List<String> capabilities) {
    this.capabilities = capabilities;
  }

  /** Return true if this ListAvailableNumberRequest object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ListAvailableNumberRequestDto listAvailableNumberRequest = (ListAvailableNumberRequestDto) o;
    return Objects.equals(this.numberPattern, listAvailableNumberRequest.numberPattern)
        && Objects.equals(
            this.numberPatternSearchPattern, listAvailableNumberRequest.numberPatternSearchPattern)
        && Objects.equals(this.regionCode, listAvailableNumberRequest.regionCode)
        && Objects.equals(this.type, listAvailableNumberRequest.type)
        && Objects.equals(this.capabilities, listAvailableNumberRequest.capabilities);
  }

  @Override
  public int hashCode() {
    return Objects.hash(numberPattern, numberPatternSearchPattern, regionCode, type, capabilities);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ListAvailableNumberRequestDto {\n");
    sb.append("    numberPattern: ").append(toIndentedString(numberPattern)).append("\n");
    sb.append("    numberPatternSearchPattern: ")
        .append(toIndentedString(numberPatternSearchPattern))
        .append("\n");
    sb.append("    regionCode: ").append(toIndentedString(regionCode)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    capabilities: ").append(toIndentedString(capabilities)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
