/*
 * Numbers | Sinch
 * An API service for getting, listing and managing Sinch virtual numbers.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: Support@sinch.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sinch.sdk.domains.numbers.models.dto.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;

/** RentAnyNumberRequestSmsConfigurationDto */
@JsonPropertyOrder({
  RentAnyNumberRequestSmsConfigurationDto.JSON_PROPERTY_SERVICE_PLAN_ID,
  RentAnyNumberRequestSmsConfigurationDto.JSON_PROPERTY_CAMPAIGN_ID
})
// @javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class RentAnyNumberRequestSmsConfigurationDto {
  public static final String JSON_PROPERTY_SERVICE_PLAN_ID = "servicePlanId";
  private String servicePlanId;

  public static final String JSON_PROPERTY_CAMPAIGN_ID = "campaignId";
  private String campaignId;

  public RentAnyNumberRequestSmsConfigurationDto() {}

  public RentAnyNumberRequestSmsConfigurationDto servicePlanId(String servicePlanId) {
    this.servicePlanId = servicePlanId;
    return this;
  }

  /**
   * The SMS service that the number will be linked to. The &#x60;servicePlanId&#x60; can be found
   * in the [Sinch Customer Dashboard](https://dashboard.sinch.com/sms/api/rest).
   *
   * @return servicePlanId
   */
  @JsonProperty(JSON_PROPERTY_SERVICE_PLAN_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getServicePlanId() {
    return servicePlanId;
  }

  @JsonProperty(JSON_PROPERTY_SERVICE_PLAN_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setServicePlanId(String servicePlanId) {
    this.servicePlanId = servicePlanId;
  }

  public RentAnyNumberRequestSmsConfigurationDto campaignId(String campaignId) {
    this.campaignId = campaignId;
    return this;
  }

  /**
   * The 10DLC campaign ID that the number will be linked to.
   *
   * @return campaignId
   */
  @JsonProperty(JSON_PROPERTY_CAMPAIGN_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCampaignId() {
    return campaignId;
  }

  @JsonProperty(JSON_PROPERTY_CAMPAIGN_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCampaignId(String campaignId) {
    this.campaignId = campaignId;
  }

  /** Return true if this RentAnyNumberRequest_smsConfiguration object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RentAnyNumberRequestSmsConfigurationDto rentAnyNumberRequestSmsConfiguration =
        (RentAnyNumberRequestSmsConfigurationDto) o;
    return Objects.equals(this.servicePlanId, rentAnyNumberRequestSmsConfiguration.servicePlanId)
        && Objects.equals(this.campaignId, rentAnyNumberRequestSmsConfiguration.campaignId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(servicePlanId, campaignId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RentAnyNumberRequestSmsConfigurationDto {\n");
    sb.append("    servicePlanId: ").append(toIndentedString(servicePlanId)).append("\n");
    sb.append("    campaignId: ").append(toIndentedString(campaignId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
