/*
 * Numbers | Sinch
 * An API service for getting, listing and managing Sinch virtual numbers.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: Support@sinch.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sinch.sdk.domains.numbers.models.dto.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;

/** Request message for renting a phone number. */
@JsonPropertyOrder({
  RentNumberRequestDto.JSON_PROPERTY_SMS_CONFIGURATION,
  RentNumberRequestDto.JSON_PROPERTY_VOICE_CONFIGURATION,
  RentNumberRequestDto.JSON_PROPERTY_CALLBACK_URL
})
// @javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class RentNumberRequestDto {
  public static final String JSON_PROPERTY_SMS_CONFIGURATION = "smsConfiguration";
  private RentAnyNumberRequestSmsConfigurationDto smsConfiguration;

  public static final String JSON_PROPERTY_VOICE_CONFIGURATION = "voiceConfiguration";
  private RentAnyNumberRequestVoiceConfigurationDto voiceConfiguration;

  public static final String JSON_PROPERTY_CALLBACK_URL = "callbackUrl";
  private String callbackUrl;

  public RentNumberRequestDto() {}

  public RentNumberRequestDto smsConfiguration(
      RentAnyNumberRequestSmsConfigurationDto smsConfiguration) {
    this.smsConfiguration = smsConfiguration;
    return this;
  }

  /**
   * Get smsConfiguration
   *
   * @return smsConfiguration
   */
  @JsonProperty(JSON_PROPERTY_SMS_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public RentAnyNumberRequestSmsConfigurationDto getSmsConfiguration() {
    return smsConfiguration;
  }

  @JsonProperty(JSON_PROPERTY_SMS_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSmsConfiguration(RentAnyNumberRequestSmsConfigurationDto smsConfiguration) {
    this.smsConfiguration = smsConfiguration;
  }

  public RentNumberRequestDto voiceConfiguration(
      RentAnyNumberRequestVoiceConfigurationDto voiceConfiguration) {
    this.voiceConfiguration = voiceConfiguration;
    return this;
  }

  /**
   * Get voiceConfiguration
   *
   * @return voiceConfiguration
   */
  @JsonProperty(JSON_PROPERTY_VOICE_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public RentAnyNumberRequestVoiceConfigurationDto getVoiceConfiguration() {
    return voiceConfiguration;
  }

  @JsonProperty(JSON_PROPERTY_VOICE_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVoiceConfiguration(RentAnyNumberRequestVoiceConfigurationDto voiceConfiguration) {
    this.voiceConfiguration = voiceConfiguration;
  }

  public RentNumberRequestDto callbackUrl(String callbackUrl) {
    this.callbackUrl = callbackUrl;
    return this;
  }

  /**
   * The callback URL to be called for a rented number provisioning / deprovisioning operations
   *
   * @return callbackUrl
   */
  @JsonProperty(JSON_PROPERTY_CALLBACK_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCallbackUrl() {
    return callbackUrl;
  }

  @JsonProperty(JSON_PROPERTY_CALLBACK_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCallbackUrl(String callbackUrl) {
    this.callbackUrl = callbackUrl;
  }

  /** Return true if this RentNumberRequest object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RentNumberRequestDto rentNumberRequest = (RentNumberRequestDto) o;
    return Objects.equals(this.smsConfiguration, rentNumberRequest.smsConfiguration)
        && Objects.equals(this.voiceConfiguration, rentNumberRequest.voiceConfiguration)
        && Objects.equals(this.callbackUrl, rentNumberRequest.callbackUrl);
  }

  @Override
  public int hashCode() {
    return Objects.hash(smsConfiguration, voiceConfiguration, callbackUrl);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RentNumberRequestDto {\n");
    sb.append("    smsConfiguration: ").append(toIndentedString(smsConfiguration)).append("\n");
    sb.append("    voiceConfiguration: ").append(toIndentedString(voiceConfiguration)).append("\n");
    sb.append("    callbackUrl: ").append(toIndentedString(callbackUrl)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
