/*
 * Numbers | Sinch
 * An API service for getting, listing and managing Sinch virtual numbers.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: Support@sinch.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sinch.sdk.domains.numbers.models.dto.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;

/**
 * The current SMS configuration for this number. Once the &#x60;servicePlanId&#x60; is sent, it
 * enters scheduled provisioning. The status of scheduled provisioning will show under a
 * &#x60;scheduledProvisioning&#x60; object if it&#39;s still running. Once processed successfully,
 * the &#x60;servicePlanId&#x60; sent will appear directly under the &#x60;smsConfiguration&#x60;
 * object.
 */
@JsonPropertyOrder({
  SMSConfigurationDto.JSON_PROPERTY_SERVICE_PLAN_ID,
  SMSConfigurationDto.JSON_PROPERTY_CAMPAIGN_ID,
  SMSConfigurationDto.JSON_PROPERTY_SCHEDULED_PROVISIONING
})
// @javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class SMSConfigurationDto {
  public static final String JSON_PROPERTY_SERVICE_PLAN_ID = "servicePlanId";
  private String servicePlanId;

  public static final String JSON_PROPERTY_CAMPAIGN_ID = "campaignId";
  private String campaignId;

  public static final String JSON_PROPERTY_SCHEDULED_PROVISIONING = "scheduledProvisioning";
  private ScheduledProvisioningDto scheduledProvisioning;

  public SMSConfigurationDto() {}

  public SMSConfigurationDto servicePlanId(String servicePlanId) {
    this.servicePlanId = servicePlanId;
    return this;
  }

  /**
   * The &#x60;servicePlanId&#x60; can be found in the &lt;a
   * href&#x3D;\&quot;https://dashboard.sinch.com/sms/api/rest\&quot;
   * target&#x3D;\&quot;_blank\&quot;&gt;Sinch Customer Dashboard&lt;/a&gt;. The service plan ID is
   * what ties this number to the configured SMS service.
   *
   * @return servicePlanId
   */
  @JsonProperty(JSON_PROPERTY_SERVICE_PLAN_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getServicePlanId() {
    return servicePlanId;
  }

  @JsonProperty(JSON_PROPERTY_SERVICE_PLAN_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setServicePlanId(String servicePlanId) {
    this.servicePlanId = servicePlanId;
  }

  public SMSConfigurationDto campaignId(String campaignId) {
    this.campaignId = campaignId;
    return this;
  }

  /**
   * Only for US virtual numbers. This campaign ID relates to &lt;a
   * href&#x3D;\&quot;https://community.sinch.com/t5/10DLC/What-is-10DLC/ta-p/7845\&quot;
   * target&#x3D;\&quot;_blank\&quot;&gt;10DLC numbers&lt;/a&gt;. So, it is the current campaign ID
   * for this number. The &#x60;campaignId&#x60; is found on your TCR platform.
   *
   * @return campaignId
   */
  @JsonProperty(JSON_PROPERTY_CAMPAIGN_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCampaignId() {
    return campaignId;
  }

  @JsonProperty(JSON_PROPERTY_CAMPAIGN_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCampaignId(String campaignId) {
    this.campaignId = campaignId;
  }

  public SMSConfigurationDto scheduledProvisioning(ScheduledProvisioningDto scheduledProvisioning) {
    this.scheduledProvisioning = scheduledProvisioning;
    return this;
  }

  /**
   * Get scheduledProvisioning
   *
   * @return scheduledProvisioning
   */
  @JsonProperty(JSON_PROPERTY_SCHEDULED_PROVISIONING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ScheduledProvisioningDto getScheduledProvisioning() {
    return scheduledProvisioning;
  }

  @JsonProperty(JSON_PROPERTY_SCHEDULED_PROVISIONING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScheduledProvisioning(ScheduledProvisioningDto scheduledProvisioning) {
    this.scheduledProvisioning = scheduledProvisioning;
  }

  /** Return true if this SMSConfiguration object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SMSConfigurationDto smSConfiguration = (SMSConfigurationDto) o;
    return Objects.equals(this.servicePlanId, smSConfiguration.servicePlanId)
        && Objects.equals(this.campaignId, smSConfiguration.campaignId)
        && Objects.equals(this.scheduledProvisioning, smSConfiguration.scheduledProvisioning);
  }

  @Override
  public int hashCode() {
    return Objects.hash(servicePlanId, campaignId, scheduledProvisioning);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SMSConfigurationDto {\n");
    sb.append("    servicePlanId: ").append(toIndentedString(servicePlanId)).append("\n");
    sb.append("    campaignId: ").append(toIndentedString(campaignId)).append("\n");
    sb.append("    scheduledProvisioning: ")
        .append(toIndentedString(scheduledProvisioning))
        .append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
