/*
 * Numbers | Sinch
 * An API service for getting, listing and managing Sinch virtual numbers.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: Support@sinch.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sinch.sdk.domains.numbers.models.dto.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.time.OffsetDateTime;
import java.util.Objects;

/**
 * Represents the ongoing or failed scheduled voice provisioning job. This field will be empty if
 * the number was successfully provisioned provisioned for voice.
 */
@JsonPropertyOrder({
  ScheduledVoiceProvisioningDto.JSON_PROPERTY_APP_ID,
  ScheduledVoiceProvisioningDto.JSON_PROPERTY_STATUS,
  ScheduledVoiceProvisioningDto.JSON_PROPERTY_LAST_UPDATED_TIME
})
// @javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class ScheduledVoiceProvisioningDto {
  public static final String JSON_PROPERTY_APP_ID = "appId";
  private String appId;

  public static final String JSON_PROPERTY_STATUS = "status";
  private ProvisioningStatusDto status;

  public static final String JSON_PROPERTY_LAST_UPDATED_TIME = "lastUpdatedTime";
  private OffsetDateTime lastUpdatedTime;

  public ScheduledVoiceProvisioningDto() {}

  @JsonCreator
  public ScheduledVoiceProvisioningDto(
      @JsonProperty(JSON_PROPERTY_APP_ID) String appId,
      @JsonProperty(JSON_PROPERTY_LAST_UPDATED_TIME) OffsetDateTime lastUpdatedTime) {
    this();
    this.appId = appId;
    this.lastUpdatedTime = lastUpdatedTime;
  }

  /**
   * Your app ID for the Voice API. The &#x60;appId&#x60; can be found in your &lt;a
   * href&#x3D;\&quot;https://dashboard.sinch.com/voice/apps\&quot;
   * target&#x3D;\&quot;_blank\&quot;&gt;Sinch Customer Dashboard&lt;/a&gt; under Voice, then apps.
   *
   * @return appId
   */
  @JsonProperty(JSON_PROPERTY_APP_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAppId() {
    return appId;
  }

  public ScheduledVoiceProvisioningDto status(ProvisioningStatusDto status) {
    this.status = status;
    return this;
  }

  /**
   * Get status
   *
   * @return status
   */
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ProvisioningStatusDto getStatus() {
    return status;
  }

  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(ProvisioningStatusDto status) {
    this.status = status;
  }

  /**
   * Timestamp when the status was last updated.
   *
   * @return lastUpdatedTime
   */
  @JsonProperty(JSON_PROPERTY_LAST_UPDATED_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getLastUpdatedTime() {
    return lastUpdatedTime;
  }

  /** Return true if this ScheduledVoiceProvisioning object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ScheduledVoiceProvisioningDto scheduledVoiceProvisioning = (ScheduledVoiceProvisioningDto) o;
    return Objects.equals(this.appId, scheduledVoiceProvisioning.appId)
        && Objects.equals(this.status, scheduledVoiceProvisioning.status)
        && Objects.equals(this.lastUpdatedTime, scheduledVoiceProvisioning.lastUpdatedTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(appId, status, lastUpdatedTime);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ScheduledVoiceProvisioningDto {\n");
    sb.append("    appId: ").append(toIndentedString(appId)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    lastUpdatedTime: ").append(toIndentedString(lastUpdatedTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
