/*
 * Numbers | Sinch
 * An API service for getting, listing and managing Sinch virtual numbers.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: Support@sinch.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sinch.sdk.domains.numbers.models.dto.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.time.OffsetDateTime;
import java.util.Objects;

/**
 * The current voice configuration for this number. During scheduled provisioning, the app ID value
 * may be empty in a response if it is still processing or if it has failed. The status of scheduled
 * provisioning will show under a &#x60;scheduledVoiceProvisioning&#x60; object if it&#39;s still
 * running. Once processed successfully, the &#x60;appId&#x60; sent will appear directly under the
 * &#x60;voiceConfiguration&#x60; object.
 */
@JsonPropertyOrder({
  VoiceConfigurationDto.JSON_PROPERTY_APP_ID,
  VoiceConfigurationDto.JSON_PROPERTY_LAST_UPDATED_TIME,
  VoiceConfigurationDto.JSON_PROPERTY_SCHEDULED_VOICE_PROVISIONING
})
// @javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class VoiceConfigurationDto {
  public static final String JSON_PROPERTY_APP_ID = "appId";
  private String appId;

  public static final String JSON_PROPERTY_LAST_UPDATED_TIME = "lastUpdatedTime";
  private OffsetDateTime lastUpdatedTime;

  public static final String JSON_PROPERTY_SCHEDULED_VOICE_PROVISIONING =
      "scheduledVoiceProvisioning";
  private ScheduledVoiceProvisioningDto scheduledVoiceProvisioning;

  public VoiceConfigurationDto() {}

  @JsonCreator
  public VoiceConfigurationDto(
      @JsonProperty(JSON_PROPERTY_LAST_UPDATED_TIME) OffsetDateTime lastUpdatedTime) {
    this();
    this.lastUpdatedTime = lastUpdatedTime;
  }

  public VoiceConfigurationDto appId(String appId) {
    this.appId = appId;
    return this;
  }

  /**
   * Your app ID for the Voice API. The &#x60;appId&#x60; can be found in your &lt;a
   * href&#x3D;\&quot;https://dashboard.sinch.com/voice/apps\&quot;
   * target&#x3D;\&quot;_blank\&quot;&gt;Sinch Customer Dashboard&lt;/a&gt; under Voice, then apps.
   *
   * @return appId
   */
  @JsonProperty(JSON_PROPERTY_APP_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAppId() {
    return appId;
  }

  @JsonProperty(JSON_PROPERTY_APP_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAppId(String appId) {
    this.appId = appId;
  }

  /**
   * Timestamp when the status was last updated.
   *
   * @return lastUpdatedTime
   */
  @JsonProperty(JSON_PROPERTY_LAST_UPDATED_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getLastUpdatedTime() {
    return lastUpdatedTime;
  }

  public VoiceConfigurationDto scheduledVoiceProvisioning(
      ScheduledVoiceProvisioningDto scheduledVoiceProvisioning) {
    this.scheduledVoiceProvisioning = scheduledVoiceProvisioning;
    return this;
  }

  /**
   * Get scheduledVoiceProvisioning
   *
   * @return scheduledVoiceProvisioning
   */
  @JsonProperty(JSON_PROPERTY_SCHEDULED_VOICE_PROVISIONING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ScheduledVoiceProvisioningDto getScheduledVoiceProvisioning() {
    return scheduledVoiceProvisioning;
  }

  @JsonProperty(JSON_PROPERTY_SCHEDULED_VOICE_PROVISIONING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScheduledVoiceProvisioning(
      ScheduledVoiceProvisioningDto scheduledVoiceProvisioning) {
    this.scheduledVoiceProvisioning = scheduledVoiceProvisioning;
  }

  /** Return true if this VoiceConfiguration object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    VoiceConfigurationDto voiceConfiguration = (VoiceConfigurationDto) o;
    return Objects.equals(this.appId, voiceConfiguration.appId)
        && Objects.equals(this.lastUpdatedTime, voiceConfiguration.lastUpdatedTime)
        && Objects.equals(
            this.scheduledVoiceProvisioning, voiceConfiguration.scheduledVoiceProvisioning);
  }

  @Override
  public int hashCode() {
    return Objects.hash(appId, lastUpdatedTime, scheduledVoiceProvisioning);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class VoiceConfigurationDto {\n");
    sb.append("    appId: ").append(toIndentedString(appId)).append("\n");
    sb.append("    lastUpdatedTime: ").append(toIndentedString(lastUpdatedTime)).append("\n");
    sb.append("    scheduledVoiceProvisioning: ")
        .append(toIndentedString(scheduledVoiceProvisioning))
        .append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
