/*
 * API Overview | Sinch
 * Sinch SMS API is one of the easiest APIs we offer and enables you to add fast and reliable global SMS to your applications. Send single messages, scheduled batch messages, use available message templates and more.
 *
 * The version of the OpenAPI document: v1
 * Contact: Support@sinch.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sinch.sdk.domains.sms.adapters.api.v1;

import com.fasterxml.jackson.core.type.TypeReference;
import com.sinch.sdk.core.exceptions.ApiException;
import com.sinch.sdk.core.exceptions.ApiExceptionBuilder;
import com.sinch.sdk.core.http.HttpClient;
import com.sinch.sdk.core.http.HttpMapper;
import com.sinch.sdk.core.http.HttpMethod;
import com.sinch.sdk.core.http.HttpRequest;
import com.sinch.sdk.core.http.HttpResponse;
import com.sinch.sdk.core.http.HttpStatus;
import com.sinch.sdk.core.http.URLParameter;
import com.sinch.sdk.core.http.URLParameterUtils;
import com.sinch.sdk.core.models.ServerConfiguration;
import com.sinch.sdk.domains.sms.models.dto.v1.DeliveryReportDto;
import com.sinch.sdk.domains.sms.models.dto.v1.DeliveryReportListDto;
import com.sinch.sdk.domains.sms.models.dto.v1.RecipientDeliveryReportDto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

// @javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class DeliveryReportsApi {

  private static final Logger LOGGER = Logger.getLogger(DeliveryReportsApi.class.getName());
  private HttpClient httpClient;
  private ServerConfiguration serverConfiguration;
  private HttpMapper mapper;

  public DeliveryReportsApi(
      HttpClient httpClient, ServerConfiguration serverConfiguration, HttpMapper mapper) {
    this.httpClient = httpClient;
    this.serverConfiguration = serverConfiguration;
    this.mapper = mapper;
  }

  /**
   * Retrieve a delivery report Delivery reports can be retrieved even if no callback was requested.
   * The difference between a summary and a full report is only that the full report contains the
   * phone numbers in &lt;a
   * href&#x3D;\&quot;https://community.sinch.com/t5/Glossary/E-164/ta-p/7537\&quot;
   * target&#x3D;\&quot;_blank\&quot;&gt;E.164&lt;/a&gt; format for each status code.
   *
   * @param servicePlanId Your service plan ID. You can find this on your
   *     [Dashboard](https://dashboard.sinch.com/sms/api/rest). (required)
   * @param batchId The batch ID you received from sending a message. (required)
   * @param type The type of delivery report. - A &#x60;summary&#x60; will count the number of
   *     messages sent per status. - A &#x60;full&#x60; report give that of a &#x60;summary&#x60;
   *     report but in addition, lists phone numbers. (optional, default to summary)
   * @param status Comma separated list of delivery_report_statuses to include (optional)
   * @param code Comma separated list of delivery_receipt_error_codes to include\&quot; (optional)
   * @return DeliveryReportDto
   * @throws ApiException if fails to make API call
   */
  public DeliveryReportDto getDeliveryReportByBatchId(
      String servicePlanId, String batchId, String type, String status, String code)
      throws ApiException {

    LOGGER.finest(
        "[getDeliveryReportByBatchId] "
            + "servicePlanId: "
            + servicePlanId
            + ", "
            + "batchId: "
            + batchId
            + ", "
            + "type: "
            + type
            + ", "
            + "status: "
            + status
            + ", "
            + "code: "
            + code);

    HttpRequest httpRequest =
        getDeliveryReportByBatchIdRequestBuilder(servicePlanId, batchId, type, status, code);
    HttpResponse response = httpClient.invokeAPI(this.serverConfiguration, httpRequest);

    if (HttpStatus.isSuccessfulStatus(response.getCode())) {
      TypeReference<DeliveryReportDto> localVarReturnType =
          new TypeReference<DeliveryReportDto>() {};
      return mapper.deserialize(response, localVarReturnType);
    }
    // fallback to default errors handling:
    // all error cases definition are not required from specs: will try some "hardcoded" content
    // parsing
    throw ApiExceptionBuilder.build(
        response.getMessage(),
        response.getCode(),
        mapper.deserialize(response, new TypeReference<HashMap<String, ?>>() {}));
  }

  private HttpRequest getDeliveryReportByBatchIdRequestBuilder(
      String servicePlanId, String batchId, String type, String status, String code)
      throws ApiException {
    // verify the required parameter 'servicePlanId' is set
    if (servicePlanId == null) {
      throw new ApiException(
          400,
          "Missing the required parameter 'servicePlanId' when calling getDeliveryReportByBatchId");
    }
    // verify the required parameter 'batchId' is set
    if (batchId == null) {
      throw new ApiException(
          400, "Missing the required parameter 'batchId' when calling getDeliveryReportByBatchId");
    }

    String localVarPath =
        "/xms/v1/{service_plan_id}/batches/{batch_id}/delivery_report"
            .replaceAll(
                "\\{" + "service_plan_id" + "\\}",
                URLParameterUtils.encodeParameterValue(servicePlanId.toString()))
            .replaceAll(
                "\\{" + "batch_id" + "\\}",
                URLParameterUtils.encodeParameterValue(batchId.toString()));

    List<URLParameter> localVarQueryParams = new ArrayList<>();
    if (null != type) {
      localVarQueryParams.add(
          new URLParameter("type", type, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
    }
    if (null != status) {
      localVarQueryParams.add(
          new URLParameter(
              "status", status, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
    }
    if (null != code) {
      localVarQueryParams.add(
          new URLParameter("code", code, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
    }

    Map<String, String> localVarHeaderParams = new HashMap<>();

    final Collection<String> localVarAccepts = Arrays.asList("application/json");

    final Collection<String> localVarContentTypes = Arrays.asList();

    final Collection<String> localVarAuthNames = Arrays.asList("BearerAuth");
    final String serializedBody = null;

    return new HttpRequest(
        localVarPath,
        HttpMethod.GET,
        localVarQueryParams,
        serializedBody,
        localVarHeaderParams,
        localVarAccepts,
        localVarContentTypes,
        localVarAuthNames);
  }
  /**
   * Retrieve a recipient delivery report A recipient delivery report contains the message status
   * for a single recipient phone number.
   *
   * @param servicePlanId Your service plan ID. You can find this on your
   *     [Dashboard](https://dashboard.sinch.com/sms/api/rest). (required)
   * @param batchId The batch ID you received from sending a message. (required)
   * @param recipientMsisdn Phone number for which you to want to search. (required)
   * @return RecipientDeliveryReportDto
   * @throws ApiException if fails to make API call
   */
  public RecipientDeliveryReportDto getDeliveryReportByPhoneNumber(
      String servicePlanId, String batchId, String recipientMsisdn) throws ApiException {

    LOGGER.finest(
        "[getDeliveryReportByPhoneNumber] "
            + "servicePlanId: "
            + servicePlanId
            + ", "
            + "batchId: "
            + batchId
            + ", "
            + "recipientMsisdn: "
            + recipientMsisdn);

    HttpRequest httpRequest =
        getDeliveryReportByPhoneNumberRequestBuilder(servicePlanId, batchId, recipientMsisdn);
    HttpResponse response = httpClient.invokeAPI(this.serverConfiguration, httpRequest);

    if (HttpStatus.isSuccessfulStatus(response.getCode())) {
      TypeReference<RecipientDeliveryReportDto> localVarReturnType =
          new TypeReference<RecipientDeliveryReportDto>() {};
      return mapper.deserialize(response, localVarReturnType);
    }
    // fallback to default errors handling:
    // all error cases definition are not required from specs: will try some "hardcoded" content
    // parsing
    throw ApiExceptionBuilder.build(
        response.getMessage(),
        response.getCode(),
        mapper.deserialize(response, new TypeReference<HashMap<String, ?>>() {}));
  }

  private HttpRequest getDeliveryReportByPhoneNumberRequestBuilder(
      String servicePlanId, String batchId, String recipientMsisdn) throws ApiException {
    // verify the required parameter 'servicePlanId' is set
    if (servicePlanId == null) {
      throw new ApiException(
          400,
          "Missing the required parameter 'servicePlanId' when calling"
              + " getDeliveryReportByPhoneNumber");
    }
    // verify the required parameter 'batchId' is set
    if (batchId == null) {
      throw new ApiException(
          400,
          "Missing the required parameter 'batchId' when calling getDeliveryReportByPhoneNumber");
    }
    // verify the required parameter 'recipientMsisdn' is set
    if (recipientMsisdn == null) {
      throw new ApiException(
          400,
          "Missing the required parameter 'recipientMsisdn' when calling"
              + " getDeliveryReportByPhoneNumber");
    }

    String localVarPath =
        "/xms/v1/{service_plan_id}/batches/{batch_id}/delivery_report/{recipient_msisdn}"
            .replaceAll(
                "\\{" + "service_plan_id" + "\\}",
                URLParameterUtils.encodeParameterValue(servicePlanId.toString()))
            .replaceAll(
                "\\{" + "batch_id" + "\\}",
                URLParameterUtils.encodeParameterValue(batchId.toString()))
            .replaceAll(
                "\\{" + "recipient_msisdn" + "\\}",
                URLParameterUtils.encodeParameterValue(recipientMsisdn.toString()));

    List<URLParameter> localVarQueryParams = new ArrayList<>();

    Map<String, String> localVarHeaderParams = new HashMap<>();

    final Collection<String> localVarAccepts = Arrays.asList("application/json");

    final Collection<String> localVarContentTypes = Arrays.asList();

    final Collection<String> localVarAuthNames = Arrays.asList("BearerAuth");
    final String serializedBody = null;

    return new HttpRequest(
        localVarPath,
        HttpMethod.GET,
        localVarQueryParams,
        serializedBody,
        localVarHeaderParams,
        localVarAccepts,
        localVarContentTypes,
        localVarAuthNames);
  }
  /**
   * Retrieve a list of delivery reports Get a list of finished delivery reports. This operation
   * supports pagination.
   *
   * @param servicePlanId Your service plan ID. You can find this on your
   *     [Dashboard](https://dashboard.sinch.com/sms/api/rest). (required)
   * @param page The page number starting from 0. (optional, default to 0)
   * @param pageSize Determines the size of a page. (optional, default to 30)
   * @param startDate Only list messages received at or after this date/time. Default: 24h ago
   *     (optional)
   * @param endDate Only list messages received before this date/time. (optional)
   * @param status Comma separated list of delivery report statuses to include. (optional)
   * @param code Comma separated list of delivery receipt error codes to include. (optional)
   * @param clientReference Client reference to include (optional)
   * @return DeliveryReportListDto
   * @throws ApiException if fails to make API call
   */
  public DeliveryReportListDto getDeliveryReports(
      String servicePlanId,
      Integer page,
      Integer pageSize,
      String startDate,
      String endDate,
      String status,
      String code,
      String clientReference)
      throws ApiException {

    LOGGER.finest(
        "[getDeliveryReports] "
            + "servicePlanId: "
            + servicePlanId
            + ", "
            + "page: "
            + page
            + ", "
            + "pageSize: "
            + pageSize
            + ", "
            + "startDate: "
            + startDate
            + ", "
            + "endDate: "
            + endDate
            + ", "
            + "status: "
            + status
            + ", "
            + "code: "
            + code
            + ", "
            + "clientReference: "
            + clientReference);

    HttpRequest httpRequest =
        getDeliveryReportsRequestBuilder(
            servicePlanId, page, pageSize, startDate, endDate, status, code, clientReference);
    HttpResponse response = httpClient.invokeAPI(this.serverConfiguration, httpRequest);

    if (HttpStatus.isSuccessfulStatus(response.getCode())) {
      TypeReference<DeliveryReportListDto> localVarReturnType =
          new TypeReference<DeliveryReportListDto>() {};
      return mapper.deserialize(response, localVarReturnType);
    }
    // fallback to default errors handling:
    // all error cases definition are not required from specs: will try some "hardcoded" content
    // parsing
    throw ApiExceptionBuilder.build(
        response.getMessage(),
        response.getCode(),
        mapper.deserialize(response, new TypeReference<HashMap<String, ?>>() {}));
  }

  private HttpRequest getDeliveryReportsRequestBuilder(
      String servicePlanId,
      Integer page,
      Integer pageSize,
      String startDate,
      String endDate,
      String status,
      String code,
      String clientReference)
      throws ApiException {
    // verify the required parameter 'servicePlanId' is set
    if (servicePlanId == null) {
      throw new ApiException(
          400, "Missing the required parameter 'servicePlanId' when calling getDeliveryReports");
    }

    String localVarPath =
        "/xms/v1/{service_plan_id}/delivery_reports"
            .replaceAll(
                "\\{" + "service_plan_id" + "\\}",
                URLParameterUtils.encodeParameterValue(servicePlanId.toString()));

    List<URLParameter> localVarQueryParams = new ArrayList<>();
    if (null != page) {
      localVarQueryParams.add(
          new URLParameter("page", page, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
    }
    if (null != pageSize) {
      localVarQueryParams.add(
          new URLParameter(
              "page_size", pageSize, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
    }
    if (null != startDate) {
      localVarQueryParams.add(
          new URLParameter(
              "start_date", startDate, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
    }
    if (null != endDate) {
      localVarQueryParams.add(
          new URLParameter(
              "end_date", endDate, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
    }
    if (null != status) {
      localVarQueryParams.add(
          new URLParameter(
              "status", status, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
    }
    if (null != code) {
      localVarQueryParams.add(
          new URLParameter("code", code, URLParameter.STYLE.valueOf("form".toUpperCase()), true));
    }
    if (null != clientReference) {
      localVarQueryParams.add(
          new URLParameter(
              "client_reference",
              clientReference,
              URLParameter.STYLE.valueOf("form".toUpperCase()),
              true));
    }

    Map<String, String> localVarHeaderParams = new HashMap<>();

    final Collection<String> localVarAccepts = Arrays.asList("application/json");

    final Collection<String> localVarContentTypes = Arrays.asList();

    final Collection<String> localVarAuthNames = Arrays.asList("BearerAuth");
    final String serializedBody = null;

    return new HttpRequest(
        localVarPath,
        HttpMethod.GET,
        localVarQueryParams,
        serializedBody,
        localVarHeaderParams,
        localVarAccepts,
        localVarContentTypes,
        localVarAuthNames);
  }
}
