/*
 * API Overview | Sinch
 * Sinch SMS API is one of the easiest APIs we offer and enables you to add fast and reliable global SMS to your applications. Send single messages, scheduled batch messages, use available message templates and more.
 *
 * The version of the OpenAPI document: v1
 * Contact: Support@sinch.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sinch.sdk.domains.sms.models.dto.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** ApiBatchListDto */
@JsonPropertyOrder({
  ApiBatchListDto.JSON_PROPERTY_COUNT,
  ApiBatchListDto.JSON_PROPERTY_PAGE,
  ApiBatchListDto.JSON_PROPERTY_BATCHES,
  ApiBatchListDto.JSON_PROPERTY_PAGE_SIZE
})
// @javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class ApiBatchListDto {
  public static final String JSON_PROPERTY_COUNT = "count";
  private Long count;

  public static final String JSON_PROPERTY_PAGE = "page";
  private Integer page;

  public static final String JSON_PROPERTY_BATCHES = "batches";
  private List<ApiBatchListBatchesInnerDto> batches;

  public static final String JSON_PROPERTY_PAGE_SIZE = "page_size";
  private Integer pageSize;

  public ApiBatchListDto() {}

  public ApiBatchListDto count(Long count) {
    this.count = count;
    return this;
  }

  /**
   * The total number of entries matching the given filters.
   *
   * @return count
   */
  @JsonProperty(JSON_PROPERTY_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Long getCount() {
    return count;
  }

  @JsonProperty(JSON_PROPERTY_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCount(Long count) {
    this.count = count;
  }

  public ApiBatchListDto page(Integer page) {
    this.page = page;
    return this;
  }

  /**
   * The requested page.
   *
   * @return page
   */
  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getPage() {
    return page;
  }

  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPage(Integer page) {
    this.page = page;
  }

  public ApiBatchListDto batches(List<ApiBatchListBatchesInnerDto> batches) {
    this.batches = batches;
    return this;
  }

  public ApiBatchListDto addBatchesItem(ApiBatchListBatchesInnerDto batchesItem) {
    if (this.batches == null) {
      this.batches = new ArrayList<>();
    }
    this.batches.add(batchesItem);
    return this;
  }

  /**
   * The page of batches matching the given filters.
   *
   * @return batches
   */
  @JsonProperty(JSON_PROPERTY_BATCHES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<ApiBatchListBatchesInnerDto> getBatches() {
    return batches;
  }

  @JsonProperty(JSON_PROPERTY_BATCHES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBatches(List<ApiBatchListBatchesInnerDto> batches) {
    this.batches = batches;
  }

  public ApiBatchListDto pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

  /**
   * The number of entries returned in this request.
   *
   * @return pageSize
   */
  @JsonProperty(JSON_PROPERTY_PAGE_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getPageSize() {
    return pageSize;
  }

  @JsonProperty(JSON_PROPERTY_PAGE_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  /** Return true if this ApiBatchList object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiBatchListDto apiBatchList = (ApiBatchListDto) o;
    return Objects.equals(this.count, apiBatchList.count)
        && Objects.equals(this.page, apiBatchList.page)
        && Objects.equals(this.batches, apiBatchList.batches)
        && Objects.equals(this.pageSize, apiBatchList.pageSize);
  }

  @Override
  public int hashCode() {
    return Objects.hash(count, page, batches, pageSize);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiBatchListDto {\n");
    sb.append("    count: ").append(toIndentedString(count)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    batches: ").append(toIndentedString(batches)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
