/*
 * API Overview | Sinch
 * Sinch SMS API is one of the easiest APIs we offer and enables you to add fast and reliable global SMS to your applications. Send single messages, scheduled batch messages, use available message templates and more.
 *
 * The version of the OpenAPI document: v1
 * Contact: Support@sinch.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sinch.sdk.domains.sms.models.dto.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** ApiInboundListDto */
@JsonPropertyOrder({
  ApiInboundListDto.JSON_PROPERTY_COUNT,
  ApiInboundListDto.JSON_PROPERTY_PAGE,
  ApiInboundListDto.JSON_PROPERTY_INBOUNDS,
  ApiInboundListDto.JSON_PROPERTY_PAGE_SIZE
})
// @javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class ApiInboundListDto {
  public static final String JSON_PROPERTY_COUNT = "count";
  private Long count;

  public static final String JSON_PROPERTY_PAGE = "page";
  private Integer page;

  public static final String JSON_PROPERTY_INBOUNDS = "inbounds";
  private List<InboundDto> inbounds;

  public static final String JSON_PROPERTY_PAGE_SIZE = "page_size";
  private Integer pageSize;

  public ApiInboundListDto() {}

  public ApiInboundListDto count(Long count) {
    this.count = count;
    return this;
  }

  /**
   * The total number of inbounds matching the given filters
   *
   * @return count
   */
  @JsonProperty(JSON_PROPERTY_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Long getCount() {
    return count;
  }

  @JsonProperty(JSON_PROPERTY_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCount(Long count) {
    this.count = count;
  }

  public ApiInboundListDto page(Integer page) {
    this.page = page;
    return this;
  }

  /**
   * The requested page.
   *
   * @return page
   */
  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getPage() {
    return page;
  }

  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPage(Integer page) {
    this.page = page;
  }

  public ApiInboundListDto inbounds(List<InboundDto> inbounds) {
    this.inbounds = inbounds;
    return this;
  }

  public ApiInboundListDto addInboundsItem(InboundDto inboundsItem) {
    if (this.inbounds == null) {
      this.inbounds = new ArrayList<>();
    }
    this.inbounds.add(inboundsItem);
    return this;
  }

  /**
   * The page of inbounds matching the given filters.
   *
   * @return inbounds
   */
  @JsonProperty(JSON_PROPERTY_INBOUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<InboundDto> getInbounds() {
    return inbounds;
  }

  @JsonProperty(JSON_PROPERTY_INBOUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInbounds(List<InboundDto> inbounds) {
    this.inbounds = inbounds;
  }

  public ApiInboundListDto pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

  /**
   * The number of inbounds returned in this request.
   *
   * @return pageSize
   */
  @JsonProperty(JSON_PROPERTY_PAGE_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getPageSize() {
    return pageSize;
  }

  @JsonProperty(JSON_PROPERTY_PAGE_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  /** Return true if this ApiInboundList object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiInboundListDto apiInboundList = (ApiInboundListDto) o;
    return Objects.equals(this.count, apiInboundList.count)
        && Objects.equals(this.page, apiInboundList.page)
        && Objects.equals(this.inbounds, apiInboundList.inbounds)
        && Objects.equals(this.pageSize, apiInboundList.pageSize);
  }

  @Override
  public int hashCode() {
    return Objects.hash(count, page, inbounds, pageSize);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiInboundListDto {\n");
    sb.append("    count: ").append(toIndentedString(count)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    inbounds: ").append(toIndentedString(inbounds)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
