/*
 * API Overview | Sinch
 * Sinch SMS API is one of the easiest APIs we offer and enables you to add fast and reliable global SMS to your applications. Send single messages, scheduled batch messages, use available message templates and more.
 *
 * The version of the OpenAPI document: v1
 * Contact: Support@sinch.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sinch.sdk.domains.sms.models.dto.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** ApiUpdateMmsMtMessageDto */
@JsonPropertyOrder({
  ApiUpdateMmsMtMessageDto.JSON_PROPERTY_FROM,
  ApiUpdateMmsMtMessageDto.JSON_PROPERTY_TYPE,
  ApiUpdateMmsMtMessageDto.JSON_PROPERTY_TO_ADD,
  ApiUpdateMmsMtMessageDto.JSON_PROPERTY_TO_REMOVE,
  ApiUpdateMmsMtMessageDto.JSON_PROPERTY_DELIVERY_REPORT,
  ApiUpdateMmsMtMessageDto.JSON_PROPERTY_SEND_AT,
  ApiUpdateMmsMtMessageDto.JSON_PROPERTY_EXPIRE_AT,
  ApiUpdateMmsMtMessageDto.JSON_PROPERTY_CALLBACK_URL,
  ApiUpdateMmsMtMessageDto.JSON_PROPERTY_BODY,
  ApiUpdateMmsMtMessageDto.JSON_PROPERTY_PARAMETERS,
  ApiUpdateMmsMtMessageDto.JSON_PROPERTY_STRICT_VALIDATION
})
// @javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class ApiUpdateMmsMtMessageDto {
  public static final String JSON_PROPERTY_FROM = "from";
  private String from;

  /** MMS */
  public enum TypeEnum {
    MT_MEDIA("mt_media"),

    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return UNKNOWN_DEFAULT_OPEN_API;
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  public static final String JSON_PROPERTY_TO_ADD = "to_add";
  private List<String> toAdd;

  public static final String JSON_PROPERTY_TO_REMOVE = "to_remove";
  private List<String> toRemove;

  public static final String JSON_PROPERTY_DELIVERY_REPORT = "delivery_report";
  private String deliveryReport;

  public static final String JSON_PROPERTY_SEND_AT = "send_at";
  private OffsetDateTime sendAt;

  public static final String JSON_PROPERTY_EXPIRE_AT = "expire_at";
  private OffsetDateTime expireAt;

  public static final String JSON_PROPERTY_CALLBACK_URL = "callback_url";
  private String callbackUrl;

  public static final String JSON_PROPERTY_BODY = "body";
  private MediaBodyDto body;

  public static final String JSON_PROPERTY_PARAMETERS = "parameters";
  private ParameterObjDto parameters;

  public static final String JSON_PROPERTY_STRICT_VALIDATION = "strict_validation";
  private Boolean strictValidation = false;

  public ApiUpdateMmsMtMessageDto() {}

  public ApiUpdateMmsMtMessageDto from(String from) {
    this.from = from;
    return this;
  }

  /**
   * Sender number. Must be valid phone number, short code or alphanumeric.
   *
   * @return from
   */
  @JsonProperty(JSON_PROPERTY_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getFrom() {
    return from;
  }

  @JsonProperty(JSON_PROPERTY_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFrom(String from) {
    this.from = from;
  }

  public ApiUpdateMmsMtMessageDto type(String type) {
    this.type = type;
    return this;
  }

  /**
   * MMS
   *
   * @return type
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getType() {
    return type;
  }

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(String type) {
    this.type = type;
  }

  public ApiUpdateMmsMtMessageDto toAdd(List<String> toAdd) {
    this.toAdd = toAdd;
    return this;
  }

  public ApiUpdateMmsMtMessageDto addToAddItem(String toAddItem) {
    if (this.toAdd == null) {
      this.toAdd = new ArrayList<>();
    }
    this.toAdd.add(toAddItem);
    return this;
  }

  /**
   * List of phone numbers and group IDs to add to the batch.
   *
   * @return toAdd
   */
  @JsonProperty(JSON_PROPERTY_TO_ADD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getToAdd() {
    return toAdd;
  }

  @JsonProperty(JSON_PROPERTY_TO_ADD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setToAdd(List<String> toAdd) {
    this.toAdd = toAdd;
  }

  public ApiUpdateMmsMtMessageDto toRemove(List<String> toRemove) {
    this.toRemove = toRemove;
    return this;
  }

  public ApiUpdateMmsMtMessageDto addToRemoveItem(String toRemoveItem) {
    if (this.toRemove == null) {
      this.toRemove = new ArrayList<>();
    }
    this.toRemove.add(toRemoveItem);
    return this;
  }

  /**
   * List of phone numbers and group IDs to remove from the batch.
   *
   * @return toRemove
   */
  @JsonProperty(JSON_PROPERTY_TO_REMOVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getToRemove() {
    return toRemove;
  }

  @JsonProperty(JSON_PROPERTY_TO_REMOVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setToRemove(List<String> toRemove) {
    this.toRemove = toRemove;
  }

  public ApiUpdateMmsMtMessageDto deliveryReport(String deliveryReport) {
    this.deliveryReport = deliveryReport;
    return this;
  }

  /**
   * Request delivery report callback. Note that delivery reports can be fetched from the API
   * regardless of this setting.
   *
   * @return deliveryReport
   */
  @JsonProperty(JSON_PROPERTY_DELIVERY_REPORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDeliveryReport() {
    return deliveryReport;
  }

  @JsonProperty(JSON_PROPERTY_DELIVERY_REPORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeliveryReport(String deliveryReport) {
    this.deliveryReport = deliveryReport;
  }

  public ApiUpdateMmsMtMessageDto sendAt(OffsetDateTime sendAt) {
    this.sendAt = sendAt;
    return this;
  }

  /**
   * If set, in the future the message will be delayed until &#x60;send_at&#x60; occurs. Formatted
   * as &lt;a href&#x3D;\&quot;https://en.wikipedia.org/wiki/ISO_8601\&quot;
   * target&#x3D;\&quot;_blank\&quot;&gt;ISO-8601&lt;/a&gt;: &#x60;YYYY-MM-DDThh:mm:ss.SSSZ&#x60;.
   * Constraints: Must be before expire_at. If set in the past, messages will be sent immediately.
   *
   * @return sendAt
   */
  @JsonProperty(JSON_PROPERTY_SEND_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getSendAt() {
    return sendAt;
  }

  @JsonProperty(JSON_PROPERTY_SEND_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSendAt(OffsetDateTime sendAt) {
    this.sendAt = sendAt;
  }

  public ApiUpdateMmsMtMessageDto expireAt(OffsetDateTime expireAt) {
    this.expireAt = expireAt;
    return this;
  }

  /**
   * If set, the system will stop trying to deliver the message at this point. Constraints: Must be
   * after &#x60;send_at&#x60; Default: 3 days after &#x60;send_at&#x60;
   *
   * @return expireAt
   */
  @JsonProperty(JSON_PROPERTY_EXPIRE_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getExpireAt() {
    return expireAt;
  }

  @JsonProperty(JSON_PROPERTY_EXPIRE_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpireAt(OffsetDateTime expireAt) {
    this.expireAt = expireAt;
  }

  public ApiUpdateMmsMtMessageDto callbackUrl(String callbackUrl) {
    this.callbackUrl = callbackUrl;
    return this;
  }

  /**
   * Override the default callback URL for this batch. Constraints: Must be valid URL.
   *
   * @return callbackUrl
   */
  @JsonProperty(JSON_PROPERTY_CALLBACK_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCallbackUrl() {
    return callbackUrl;
  }

  @JsonProperty(JSON_PROPERTY_CALLBACK_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCallbackUrl(String callbackUrl) {
    this.callbackUrl = callbackUrl;
  }

  public ApiUpdateMmsMtMessageDto body(MediaBodyDto body) {
    this.body = body;
    return this;
  }

  /**
   * Get body
   *
   * @return body
   */
  @JsonProperty(JSON_PROPERTY_BODY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public MediaBodyDto getBody() {
    return body;
  }

  @JsonProperty(JSON_PROPERTY_BODY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBody(MediaBodyDto body) {
    this.body = body;
  }

  public ApiUpdateMmsMtMessageDto parameters(ParameterObjDto parameters) {
    this.parameters = parameters;
    return this;
  }

  /**
   * Get parameters
   *
   * @return parameters
   */
  @JsonProperty(JSON_PROPERTY_PARAMETERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ParameterObjDto getParameters() {
    return parameters;
  }

  @JsonProperty(JSON_PROPERTY_PARAMETERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setParameters(ParameterObjDto parameters) {
    this.parameters = parameters;
  }

  public ApiUpdateMmsMtMessageDto strictValidation(Boolean strictValidation) {
    this.strictValidation = strictValidation;
    return this;
  }

  /**
   * Whether or not you want the media included in your message to be checked against [Sinch MMS
   * channel best practices](/docs/mms/bestpractices/). If set to true, your message will be
   * rejected if it doesn&#39;t conform to the listed recommendations, otherwise no validation will
   * be performed.
   *
   * @return strictValidation
   */
  @JsonProperty(JSON_PROPERTY_STRICT_VALIDATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getStrictValidation() {
    return strictValidation;
  }

  @JsonProperty(JSON_PROPERTY_STRICT_VALIDATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStrictValidation(Boolean strictValidation) {
    this.strictValidation = strictValidation;
  }

  /** Return true if this ApiUpdateMmsMtMessage object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiUpdateMmsMtMessageDto apiUpdateMmsMtMessage = (ApiUpdateMmsMtMessageDto) o;
    return Objects.equals(this.from, apiUpdateMmsMtMessage.from)
        && Objects.equals(this.type, apiUpdateMmsMtMessage.type)
        && Objects.equals(this.toAdd, apiUpdateMmsMtMessage.toAdd)
        && Objects.equals(this.toRemove, apiUpdateMmsMtMessage.toRemove)
        && Objects.equals(this.deliveryReport, apiUpdateMmsMtMessage.deliveryReport)
        && Objects.equals(this.sendAt, apiUpdateMmsMtMessage.sendAt)
        && Objects.equals(this.expireAt, apiUpdateMmsMtMessage.expireAt)
        && Objects.equals(this.callbackUrl, apiUpdateMmsMtMessage.callbackUrl)
        && Objects.equals(this.body, apiUpdateMmsMtMessage.body)
        && Objects.equals(this.parameters, apiUpdateMmsMtMessage.parameters)
        && Objects.equals(this.strictValidation, apiUpdateMmsMtMessage.strictValidation);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        from,
        type,
        toAdd,
        toRemove,
        deliveryReport,
        sendAt,
        expireAt,
        callbackUrl,
        body,
        parameters,
        strictValidation);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiUpdateMmsMtMessageDto {\n");
    sb.append("    from: ").append(toIndentedString(from)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    toAdd: ").append(toIndentedString(toAdd)).append("\n");
    sb.append("    toRemove: ").append(toIndentedString(toRemove)).append("\n");
    sb.append("    deliveryReport: ").append(toIndentedString(deliveryReport)).append("\n");
    sb.append("    sendAt: ").append(toIndentedString(sendAt)).append("\n");
    sb.append("    expireAt: ").append(toIndentedString(expireAt)).append("\n");
    sb.append("    callbackUrl: ").append(toIndentedString(callbackUrl)).append("\n");
    sb.append("    body: ").append(toIndentedString(body)).append("\n");
    sb.append("    parameters: ").append(toIndentedString(parameters)).append("\n");
    sb.append("    strictValidation: ").append(toIndentedString(strictValidation)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
