/*
 * API Overview | Sinch
 * Sinch SMS API is one of the easiest APIs we offer and enables you to add fast and reliable global SMS to your applications. Send single messages, scheduled batch messages, use available message templates and more.
 *
 * The version of the OpenAPI document: v1
 * Contact: Support@sinch.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sinch.sdk.domains.sms.models.dto.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** ApiUpdateTextMtMessageDto */
@JsonPropertyOrder({
  ApiUpdateTextMtMessageDto.JSON_PROPERTY_FROM,
  ApiUpdateTextMtMessageDto.JSON_PROPERTY_TYPE,
  ApiUpdateTextMtMessageDto.JSON_PROPERTY_TO_ADD,
  ApiUpdateTextMtMessageDto.JSON_PROPERTY_TO_REMOVE,
  ApiUpdateTextMtMessageDto.JSON_PROPERTY_DELIVERY_REPORT,
  ApiUpdateTextMtMessageDto.JSON_PROPERTY_SEND_AT,
  ApiUpdateTextMtMessageDto.JSON_PROPERTY_EXPIRE_AT,
  ApiUpdateTextMtMessageDto.JSON_PROPERTY_CALLBACK_URL,
  ApiUpdateTextMtMessageDto.JSON_PROPERTY_PARAMETERS,
  ApiUpdateTextMtMessageDto.JSON_PROPERTY_BODY
})
// @javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class ApiUpdateTextMtMessageDto {
  public static final String JSON_PROPERTY_FROM = "from";
  private String from;

  /** Regular SMS */
  public enum TypeEnum {
    MT_TEXT("mt_text"),

    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return UNKNOWN_DEFAULT_OPEN_API;
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  public static final String JSON_PROPERTY_TO_ADD = "to_add";
  private List<String> toAdd;

  public static final String JSON_PROPERTY_TO_REMOVE = "to_remove";
  private List<String> toRemove;

  public static final String JSON_PROPERTY_DELIVERY_REPORT = "delivery_report";
  private String deliveryReport;

  public static final String JSON_PROPERTY_SEND_AT = "send_at";
  private OffsetDateTime sendAt;

  public static final String JSON_PROPERTY_EXPIRE_AT = "expire_at";
  private OffsetDateTime expireAt;

  public static final String JSON_PROPERTY_CALLBACK_URL = "callback_url";
  private String callbackUrl;

  public static final String JSON_PROPERTY_PARAMETERS = "parameters";
  private ParameterObjDto parameters;

  public static final String JSON_PROPERTY_BODY = "body";
  private String body;

  public ApiUpdateTextMtMessageDto() {}

  public ApiUpdateTextMtMessageDto from(String from) {
    this.from = from;
    return this;
  }

  /**
   * Sender number. Must be valid phone number, short code or alphanumeric.
   *
   * @return from
   */
  @JsonProperty(JSON_PROPERTY_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getFrom() {
    return from;
  }

  @JsonProperty(JSON_PROPERTY_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFrom(String from) {
    this.from = from;
  }

  public ApiUpdateTextMtMessageDto type(String type) {
    this.type = type;
    return this;
  }

  /**
   * Regular SMS
   *
   * @return type
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getType() {
    return type;
  }

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(String type) {
    this.type = type;
  }

  public ApiUpdateTextMtMessageDto toAdd(List<String> toAdd) {
    this.toAdd = toAdd;
    return this;
  }

  public ApiUpdateTextMtMessageDto addToAddItem(String toAddItem) {
    if (this.toAdd == null) {
      this.toAdd = new ArrayList<>();
    }
    this.toAdd.add(toAddItem);
    return this;
  }

  /**
   * List of phone numbers and group IDs to add to the batch.
   *
   * @return toAdd
   */
  @JsonProperty(JSON_PROPERTY_TO_ADD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getToAdd() {
    return toAdd;
  }

  @JsonProperty(JSON_PROPERTY_TO_ADD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setToAdd(List<String> toAdd) {
    this.toAdd = toAdd;
  }

  public ApiUpdateTextMtMessageDto toRemove(List<String> toRemove) {
    this.toRemove = toRemove;
    return this;
  }

  public ApiUpdateTextMtMessageDto addToRemoveItem(String toRemoveItem) {
    if (this.toRemove == null) {
      this.toRemove = new ArrayList<>();
    }
    this.toRemove.add(toRemoveItem);
    return this;
  }

  /**
   * List of phone numbers and group IDs to remove from the batch.
   *
   * @return toRemove
   */
  @JsonProperty(JSON_PROPERTY_TO_REMOVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getToRemove() {
    return toRemove;
  }

  @JsonProperty(JSON_PROPERTY_TO_REMOVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setToRemove(List<String> toRemove) {
    this.toRemove = toRemove;
  }

  public ApiUpdateTextMtMessageDto deliveryReport(String deliveryReport) {
    this.deliveryReport = deliveryReport;
    return this;
  }

  /**
   * Request delivery report callback. Note that delivery reports can be fetched from the API
   * regardless of this setting.
   *
   * @return deliveryReport
   */
  @JsonProperty(JSON_PROPERTY_DELIVERY_REPORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDeliveryReport() {
    return deliveryReport;
  }

  @JsonProperty(JSON_PROPERTY_DELIVERY_REPORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeliveryReport(String deliveryReport) {
    this.deliveryReport = deliveryReport;
  }

  public ApiUpdateTextMtMessageDto sendAt(OffsetDateTime sendAt) {
    this.sendAt = sendAt;
    return this;
  }

  /**
   * If set, in the future the message will be delayed until &#x60;send_at&#x60; occurs. Formatted
   * as &lt;a href&#x3D;\&quot;https://en.wikipedia.org/wiki/ISO_8601\&quot;
   * target&#x3D;\&quot;_blank\&quot;&gt;ISO-8601&lt;/a&gt;: &#x60;YYYY-MM-DDThh:mm:ss.SSSZ&#x60;.
   * Constraints: Must be before expire_at. If set in the past, messages will be sent immediately.
   *
   * @return sendAt
   */
  @JsonProperty(JSON_PROPERTY_SEND_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getSendAt() {
    return sendAt;
  }

  @JsonProperty(JSON_PROPERTY_SEND_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSendAt(OffsetDateTime sendAt) {
    this.sendAt = sendAt;
  }

  public ApiUpdateTextMtMessageDto expireAt(OffsetDateTime expireAt) {
    this.expireAt = expireAt;
    return this;
  }

  /**
   * If set, the system will stop trying to deliver the message at this point. Constraints: Must be
   * after &#x60;send_at&#x60; Default: 3 days after &#x60;send_at&#x60;
   *
   * @return expireAt
   */
  @JsonProperty(JSON_PROPERTY_EXPIRE_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getExpireAt() {
    return expireAt;
  }

  @JsonProperty(JSON_PROPERTY_EXPIRE_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpireAt(OffsetDateTime expireAt) {
    this.expireAt = expireAt;
  }

  public ApiUpdateTextMtMessageDto callbackUrl(String callbackUrl) {
    this.callbackUrl = callbackUrl;
    return this;
  }

  /**
   * Override the default callback URL for this batch. Constraints: Must be valid URL.
   *
   * @return callbackUrl
   */
  @JsonProperty(JSON_PROPERTY_CALLBACK_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCallbackUrl() {
    return callbackUrl;
  }

  @JsonProperty(JSON_PROPERTY_CALLBACK_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCallbackUrl(String callbackUrl) {
    this.callbackUrl = callbackUrl;
  }

  public ApiUpdateTextMtMessageDto parameters(ParameterObjDto parameters) {
    this.parameters = parameters;
    return this;
  }

  /**
   * Get parameters
   *
   * @return parameters
   */
  @JsonProperty(JSON_PROPERTY_PARAMETERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ParameterObjDto getParameters() {
    return parameters;
  }

  @JsonProperty(JSON_PROPERTY_PARAMETERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setParameters(ParameterObjDto parameters) {
    this.parameters = parameters;
  }

  public ApiUpdateTextMtMessageDto body(String body) {
    this.body = body;
    return this;
  }

  /**
   * The message content
   *
   * @return body
   */
  @JsonProperty(JSON_PROPERTY_BODY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getBody() {
    return body;
  }

  @JsonProperty(JSON_PROPERTY_BODY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBody(String body) {
    this.body = body;
  }

  /** Return true if this ApiUpdateTextMtMessage object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiUpdateTextMtMessageDto apiUpdateTextMtMessage = (ApiUpdateTextMtMessageDto) o;
    return Objects.equals(this.from, apiUpdateTextMtMessage.from)
        && Objects.equals(this.type, apiUpdateTextMtMessage.type)
        && Objects.equals(this.toAdd, apiUpdateTextMtMessage.toAdd)
        && Objects.equals(this.toRemove, apiUpdateTextMtMessage.toRemove)
        && Objects.equals(this.deliveryReport, apiUpdateTextMtMessage.deliveryReport)
        && Objects.equals(this.sendAt, apiUpdateTextMtMessage.sendAt)
        && Objects.equals(this.expireAt, apiUpdateTextMtMessage.expireAt)
        && Objects.equals(this.callbackUrl, apiUpdateTextMtMessage.callbackUrl)
        && Objects.equals(this.parameters, apiUpdateTextMtMessage.parameters)
        && Objects.equals(this.body, apiUpdateTextMtMessage.body);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        from,
        type,
        toAdd,
        toRemove,
        deliveryReport,
        sendAt,
        expireAt,
        callbackUrl,
        parameters,
        body);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiUpdateTextMtMessageDto {\n");
    sb.append("    from: ").append(toIndentedString(from)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    toAdd: ").append(toIndentedString(toAdd)).append("\n");
    sb.append("    toRemove: ").append(toIndentedString(toRemove)).append("\n");
    sb.append("    deliveryReport: ").append(toIndentedString(deliveryReport)).append("\n");
    sb.append("    sendAt: ").append(toIndentedString(sendAt)).append("\n");
    sb.append("    expireAt: ").append(toIndentedString(expireAt)).append("\n");
    sb.append("    callbackUrl: ").append(toIndentedString(callbackUrl)).append("\n");
    sb.append("    parameters: ").append(toIndentedString(parameters)).append("\n");
    sb.append("    body: ").append(toIndentedString(body)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
