/*
 * API Overview | Sinch
 * Sinch SMS API is one of the easiest APIs we offer and enables you to add fast and reliable global SMS to your applications. Send single messages, scheduled batch messages, use available message templates and more.
 *
 * The version of the OpenAPI document: v1
 * Contact: Support@sinch.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sinch.sdk.domains.sms.models.dto.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** DeliveryReportListDto */
@JsonPropertyOrder({
  DeliveryReportListDto.JSON_PROPERTY_COUNT,
  DeliveryReportListDto.JSON_PROPERTY_PAGE,
  DeliveryReportListDto.JSON_PROPERTY_PAGE_SIZE,
  DeliveryReportListDto.JSON_PROPERTY_DELIVERY_REPORTS
})
// @javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class DeliveryReportListDto {
  public static final String JSON_PROPERTY_COUNT = "count";
  private Long count;

  public static final String JSON_PROPERTY_PAGE = "page";
  private Integer page;

  public static final String JSON_PROPERTY_PAGE_SIZE = "page_size";
  private Integer pageSize;

  public static final String JSON_PROPERTY_DELIVERY_REPORTS = "delivery_reports";
  private List<RecipientDeliveryReportDto> deliveryReports;

  public DeliveryReportListDto() {}

  public DeliveryReportListDto count(Long count) {
    this.count = count;
    return this;
  }

  /**
   * The total number of entries matching the given filters.
   *
   * @return count
   */
  @JsonProperty(JSON_PROPERTY_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Long getCount() {
    return count;
  }

  @JsonProperty(JSON_PROPERTY_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCount(Long count) {
    this.count = count;
  }

  public DeliveryReportListDto page(Integer page) {
    this.page = page;
    return this;
  }

  /**
   * The requested page.
   *
   * @return page
   */
  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getPage() {
    return page;
  }

  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPage(Integer page) {
    this.page = page;
  }

  public DeliveryReportListDto pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

  /**
   * The number of entries returned in this request.
   *
   * @return pageSize
   */
  @JsonProperty(JSON_PROPERTY_PAGE_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getPageSize() {
    return pageSize;
  }

  @JsonProperty(JSON_PROPERTY_PAGE_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  public DeliveryReportListDto deliveryReports(List<RecipientDeliveryReportDto> deliveryReports) {
    this.deliveryReports = deliveryReports;
    return this;
  }

  public DeliveryReportListDto addDeliveryReportsItem(
      RecipientDeliveryReportDto deliveryReportsItem) {
    if (this.deliveryReports == null) {
      this.deliveryReports = new ArrayList<>();
    }
    this.deliveryReports.add(deliveryReportsItem);
    return this;
  }

  /**
   * The page of delivery reports matching the given filters.
   *
   * @return deliveryReports
   */
  @JsonProperty(JSON_PROPERTY_DELIVERY_REPORTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<RecipientDeliveryReportDto> getDeliveryReports() {
    return deliveryReports;
  }

  @JsonProperty(JSON_PROPERTY_DELIVERY_REPORTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeliveryReports(List<RecipientDeliveryReportDto> deliveryReports) {
    this.deliveryReports = deliveryReports;
  }

  /** Return true if this DeliveryReportList object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeliveryReportListDto deliveryReportList = (DeliveryReportListDto) o;
    return Objects.equals(this.count, deliveryReportList.count)
        && Objects.equals(this.page, deliveryReportList.page)
        && Objects.equals(this.pageSize, deliveryReportList.pageSize)
        && Objects.equals(this.deliveryReports, deliveryReportList.deliveryReports);
  }

  @Override
  public int hashCode() {
    return Objects.hash(count, page, pageSize, deliveryReports);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeliveryReportListDto {\n");
    sb.append("    count: ").append(toIndentedString(count)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("    deliveryReports: ").append(toIndentedString(deliveryReports)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
