/*
 * API Overview | Sinch
 * Sinch SMS API is one of the easiest APIs we offer and enables you to add fast and reliable global SMS to your applications. Send single messages, scheduled batch messages, use available message templates and more.
 *
 * The version of the OpenAPI document: v1
 * Contact: Support@sinch.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sinch.sdk.domains.sms.models.dto.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** GroupObjectDto */
@JsonPropertyOrder({
  GroupObjectDto.JSON_PROPERTY_NAME,
  GroupObjectDto.JSON_PROPERTY_MEMBERS,
  GroupObjectDto.JSON_PROPERTY_CHILD_GROUPS,
  GroupObjectDto.JSON_PROPERTY_AUTO_UPDATE
})
// @javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class GroupObjectDto {
  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_MEMBERS = "members";
  private List<String> members;

  public static final String JSON_PROPERTY_CHILD_GROUPS = "child_groups";
  private List<String> childGroups;

  public static final String JSON_PROPERTY_AUTO_UPDATE = "auto_update";
  private GroupObjectAutoUpdateDto autoUpdate;

  public GroupObjectDto() {}

  public GroupObjectDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Name of the group
   *
   * @return name
   */
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getName() {
    return name;
  }

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }

  public GroupObjectDto members(List<String> members) {
    this.members = members;
    return this;
  }

  public GroupObjectDto addMembersItem(String membersItem) {
    if (this.members == null) {
      this.members = new ArrayList<>();
    }
    this.members.add(membersItem);
    return this;
  }

  /**
   * \&quot;Initial list of phone numbers in &lt;a
   * href&#x3D;\&quot;https://community.sinch.com/t5/Glossary/E-164/ta-p/7537\&quot;
   * target&#x3D;\&quot;_blank\&quot;&gt;E.164&lt;/a&gt; format &lt;a
   * href&#x3D;\&quot;https://community.sinch.com/t5/Glossary/MSISDN/ta-p/7628\&quot;
   * target&#x3D;\&quot;_blank\&quot;&gt;MSISDNs&lt;/a&gt; for the group.\&quot;
   *
   * @return members
   */
  @JsonProperty(JSON_PROPERTY_MEMBERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getMembers() {
    return members;
  }

  @JsonProperty(JSON_PROPERTY_MEMBERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMembers(List<String> members) {
    this.members = members;
  }

  public GroupObjectDto childGroups(List<String> childGroups) {
    this.childGroups = childGroups;
    return this;
  }

  public GroupObjectDto addChildGroupsItem(String childGroupsItem) {
    if (this.childGroups == null) {
      this.childGroups = new ArrayList<>();
    }
    this.childGroups.add(childGroupsItem);
    return this;
  }

  /**
   * Phone numbers (&lt;a
   * href&#x3D;\&quot;https://community.sinch.com/t5/Glossary/MSISDN/ta-p/7628\&quot;
   * target&#x3D;\&quot;_blank\&quot;&gt;MSISDNs&lt;/a&gt;) of child group will be included in this
   * group. If present then this group will be auto populated. Constraints: Elements must be group
   * IDs.
   *
   * @return childGroups
   */
  @JsonProperty(JSON_PROPERTY_CHILD_GROUPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getChildGroups() {
    return childGroups;
  }

  @JsonProperty(JSON_PROPERTY_CHILD_GROUPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChildGroups(List<String> childGroups) {
    this.childGroups = childGroups;
  }

  public GroupObjectDto autoUpdate(GroupObjectAutoUpdateDto autoUpdate) {
    this.autoUpdate = autoUpdate;
    return this;
  }

  /**
   * Get autoUpdate
   *
   * @return autoUpdate
   */
  @JsonProperty(JSON_PROPERTY_AUTO_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public GroupObjectAutoUpdateDto getAutoUpdate() {
    return autoUpdate;
  }

  @JsonProperty(JSON_PROPERTY_AUTO_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAutoUpdate(GroupObjectAutoUpdateDto autoUpdate) {
    this.autoUpdate = autoUpdate;
  }

  /** Return true if this groupObject object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GroupObjectDto groupObject = (GroupObjectDto) o;
    return Objects.equals(this.name, groupObject.name)
        && Objects.equals(this.members, groupObject.members)
        && Objects.equals(this.childGroups, groupObject.childGroups)
        && Objects.equals(this.autoUpdate, groupObject.autoUpdate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, members, childGroups, autoUpdate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GroupObjectDto {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    members: ").append(toIndentedString(members)).append("\n");
    sb.append("    childGroups: ").append(toIndentedString(childGroups)).append("\n");
    sb.append("    autoUpdate: ").append(toIndentedString(autoUpdate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
