/*
 * API Overview | Sinch
 * Sinch SMS API is one of the easiest APIs we offer and enables you to add fast and reliable global SMS to your applications. Send single messages, scheduled batch messages, use available message templates and more.
 *
 * The version of the OpenAPI document: v1
 * Contact: Support@sinch.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sinch.sdk.domains.sms.models.dto.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.sinch.sdk.core.utils.databind.JSONNavigator;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/** MOBinaryDto */
@JsonPropertyOrder({
  MOBinaryDto.JSON_PROPERTY_BODY,
  MOBinaryDto.JSON_PROPERTY_TYPE,
  MOBinaryDto.JSON_PROPERTY_UDH
})
// @javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
/*@JsonIgnoreProperties(
  value = "type", // ignore manually set type, it will be automatically generated by Jackson during serialization
  allowSetters = true // allows the type to be set during deserialization
)*/
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE,
    include = JsonTypeInfo.As.EXISTING_PROPERTY,
    property = "type",
    visible = true)
public class MOBinaryDto extends ApiMoMessageDto {
  public static final String JSON_PROPERTY_BODY = "body";
  private String body;

  /** SMS in binary format */
  public enum TypeEnum {
    MO_BINARY("mo_binary"),

    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return UNKNOWN_DEFAULT_OPEN_API;
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  public static final String JSON_PROPERTY_UDH = "udh";
  private String udh;

  public MOBinaryDto() {}

  @JsonCreator
  public MOBinaryDto(@JsonProperty(JSON_PROPERTY_TYPE) String type) {
    this();
    this.type = type;
  }

  public MOBinaryDto body(String body) {
    this.body = body;
    return this;
  }

  /**
   * The message content Base64 encoded. Max 140 bytes together with udh.
   *
   * @return body
   */
  @JsonProperty(JSON_PROPERTY_BODY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getBody() {
    return body;
  }

  @JsonProperty(JSON_PROPERTY_BODY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBody(String body) {
    this.body = body;
  }

  /**
   * SMS in binary format
   *
   * @return type
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getType() {
    return type;
  }

  public MOBinaryDto udh(String udh) {
    this.udh = udh;
    return this;
  }

  /**
   * The UDH header of a binary message HEX encoded. Max 140 bytes together with body.
   *
   * @return udh
   */
  @JsonProperty(JSON_PROPERTY_UDH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getUdh() {
    return udh;
  }

  @JsonProperty(JSON_PROPERTY_UDH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUdh(String udh) {
    this.udh = udh;
  }

  @Override
  public MOBinaryDto from(String from) {
    this.setFrom(from);
    return this;
  }

  @Override
  public MOBinaryDto id(String id) {
    this.setId(id);
    return this;
  }

  @Override
  public MOBinaryDto receivedAt(OffsetDateTime receivedAt) {
    this.setReceivedAt(receivedAt);
    return this;
  }

  @Override
  public MOBinaryDto to(String to) {
    this.setTo(to);
    return this;
  }

  @Override
  public MOBinaryDto clientReference(String clientReference) {
    this.setClientReference(clientReference);
    return this;
  }

  @Override
  public MOBinaryDto operatorId(String operatorId) {
    this.setOperatorId(operatorId);
    return this;
  }

  @Override
  public MOBinaryDto sentAt(OffsetDateTime sentAt) {
    this.setSentAt(sentAt);
    return this;
  }

  /** Return true if this MOBinary object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MOBinaryDto moBinary = (MOBinaryDto) o;
    return Objects.equals(this.body, moBinary.body)
        && Objects.equals(this.type, moBinary.type)
        && Objects.equals(this.udh, moBinary.udh)
        && super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(body, type, udh, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MOBinaryDto {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    body: ").append(toIndentedString(body)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    udh: ").append(toIndentedString(udh)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  static {
    // Initialize and register the discriminator mappings.
    Map<String, Class<?>> mappings = new HashMap<String, Class<?>>();
    mappings.put("MOBinary", MOBinaryDto.class);
    JSONNavigator.registerDiscriminator(MOBinaryDto.class, "type", mappings);
  }
}
