/*
 * API Overview | Sinch
 * Sinch SMS API is one of the easiest APIs we offer and enables you to add fast and reliable global SMS to your applications. Send single messages, scheduled batch messages, use available message templates and more.
 *
 * The version of the OpenAPI document: v1
 * Contact: Support@sinch.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sinch.sdk.domains.sms.models.dto.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

/** Array with status objects. Only status codes with at least one recipient will be listed. */
@JsonPropertyOrder({
  MessageDeliveryStatusDto.JSON_PROPERTY_CODE,
  MessageDeliveryStatusDto.JSON_PROPERTY_COUNT,
  MessageDeliveryStatusDto.JSON_PROPERTY_RECIPIENTS,
  MessageDeliveryStatusDto.JSON_PROPERTY_STATUS
})
// @javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class MessageDeliveryStatusDto {
  public static final String JSON_PROPERTY_CODE = "code";
  private Integer code;

  public static final String JSON_PROPERTY_COUNT = "count";
  private Integer count;

  public static final String JSON_PROPERTY_RECIPIENTS = "recipients";
  private Set<String> recipients = new LinkedHashSet<>();

  public static final String JSON_PROPERTY_STATUS = "status";
  private String status;

  public MessageDeliveryStatusDto() {}

  public MessageDeliveryStatusDto code(Integer code) {
    this.code = code;
    return this;
  }

  /**
   * The detailed status code.
   *
   * @return code
   */
  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Integer getCode() {
    return code;
  }

  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCode(Integer code) {
    this.code = code;
  }

  public MessageDeliveryStatusDto count(Integer count) {
    this.count = count;
    return this;
  }

  /**
   * The number of messages that currently has this code. minimum: 1
   *
   * @return count
   */
  @JsonProperty(JSON_PROPERTY_COUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Integer getCount() {
    return count;
  }

  @JsonProperty(JSON_PROPERTY_COUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCount(Integer count) {
    this.count = count;
  }

  public MessageDeliveryStatusDto recipients(Set<String> recipients) {
    this.recipients = recipients;
    return this;
  }

  public MessageDeliveryStatusDto addRecipientsItem(String recipientsItem) {
    if (this.recipients == null) {
      this.recipients = new LinkedHashSet<>();
    }
    this.recipients.add(recipientsItem);
    return this;
  }

  /**
   * Only for &#x60;full&#x60; report. A list of the phone number recipients which messages has this
   * status code.
   *
   * @return recipients
   */
  @JsonProperty(JSON_PROPERTY_RECIPIENTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Set<String> getRecipients() {
    return recipients;
  }

  @JsonDeserialize(as = LinkedHashSet.class)
  @JsonProperty(JSON_PROPERTY_RECIPIENTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRecipients(Set<String> recipients) {
    this.recipients = recipients;
  }

  public MessageDeliveryStatusDto status(String status) {
    this.status = status;
    return this;
  }

  /**
   * The simplified status as described in _Delivery Report Statuses_.
   *
   * @return status
   */
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getStatus() {
    return status;
  }

  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStatus(String status) {
    this.status = status;
  }

  /** Return true if this MessageDeliveryStatus object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MessageDeliveryStatusDto messageDeliveryStatus = (MessageDeliveryStatusDto) o;
    return Objects.equals(this.code, messageDeliveryStatus.code)
        && Objects.equals(this.count, messageDeliveryStatus.count)
        && Objects.equals(this.recipients, messageDeliveryStatus.recipients)
        && Objects.equals(this.status, messageDeliveryStatus.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, count, recipients, status);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MessageDeliveryStatusDto {\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    count: ").append(toIndentedString(count)).append("\n");
    sb.append("    recipients: ").append(toIndentedString(recipients)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
