/*
 * API Overview | Sinch
 * Sinch SMS API is one of the easiest APIs we offer and enables you to add fast and reliable global SMS to your applications. Send single messages, scheduled batch messages, use available message templates and more.
 *
 * The version of the OpenAPI document: v1
 * Contact: Support@sinch.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sinch.sdk.domains.sms.models.dto.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** TextRequestDto */
@JsonPropertyOrder({
  TextRequestDto.JSON_PROPERTY_TO,
  TextRequestDto.JSON_PROPERTY_BODY,
  TextRequestDto.JSON_PROPERTY_FROM,
  TextRequestDto.JSON_PROPERTY_PARAMETERS,
  TextRequestDto.JSON_PROPERTY_TYPE,
  TextRequestDto.JSON_PROPERTY_DELIVERY_REPORT,
  TextRequestDto.JSON_PROPERTY_SEND_AT,
  TextRequestDto.JSON_PROPERTY_EXPIRE_AT,
  TextRequestDto.JSON_PROPERTY_CALLBACK_URL,
  TextRequestDto.JSON_PROPERTY_CLIENT_REFERENCE,
  TextRequestDto.JSON_PROPERTY_FEEDBACK_ENABLED,
  TextRequestDto.JSON_PROPERTY_FLASH_MESSAGE,
  TextRequestDto.JSON_PROPERTY_TRUNCATE_CONCAT,
  TextRequestDto.JSON_PROPERTY_MAX_NUMBER_OF_MESSAGE_PARTS,
  TextRequestDto.JSON_PROPERTY_FROM_TON,
  TextRequestDto.JSON_PROPERTY_FROM_NPI
})
// @javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class TextRequestDto {
  public static final String JSON_PROPERTY_TO = "to";
  private List<String> to = new ArrayList<>();

  public static final String JSON_PROPERTY_BODY = "body";
  private String body;

  public static final String JSON_PROPERTY_FROM = "from";
  private String from;

  public static final String JSON_PROPERTY_PARAMETERS = "parameters";
  private ParameterObjDto parameters;

  /** Regular SMS */
  public enum TypeEnum {
    MT_TEXT("mt_text"),

    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return UNKNOWN_DEFAULT_OPEN_API;
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  public static final String JSON_PROPERTY_DELIVERY_REPORT = "delivery_report";
  private String deliveryReport = "none";

  public static final String JSON_PROPERTY_SEND_AT = "send_at";
  private OffsetDateTime sendAt;

  public static final String JSON_PROPERTY_EXPIRE_AT = "expire_at";
  private OffsetDateTime expireAt;

  public static final String JSON_PROPERTY_CALLBACK_URL = "callback_url";
  private String callbackUrl;

  public static final String JSON_PROPERTY_CLIENT_REFERENCE = "client_reference";
  private String clientReference;

  public static final String JSON_PROPERTY_FEEDBACK_ENABLED = "feedback_enabled";
  private Boolean feedbackEnabled = false;

  public static final String JSON_PROPERTY_FLASH_MESSAGE = "flash_message";
  private Boolean flashMessage = false;

  public static final String JSON_PROPERTY_TRUNCATE_CONCAT = "truncate_concat";
  private Boolean truncateConcat;

  public static final String JSON_PROPERTY_MAX_NUMBER_OF_MESSAGE_PARTS =
      "max_number_of_message_parts";
  private Integer maxNumberOfMessageParts;

  public static final String JSON_PROPERTY_FROM_TON = "from_ton";
  private Integer fromTon;

  public static final String JSON_PROPERTY_FROM_NPI = "from_npi";
  private Integer fromNpi;

  public TextRequestDto() {}

  public TextRequestDto to(List<String> to) {
    this.to = to;
    return this;
  }

  public TextRequestDto addToItem(String toItem) {
    if (this.to == null) {
      this.to = new ArrayList<>();
    }
    this.to.add(toItem);
    return this;
  }

  /**
   * List of Phone numbers and group IDs that will receive the batch. &lt;a
   * href&#x3D;\&quot;https://community.sinch.com/t5/Glossary/MSISDN/ta-p/7628\&quot;
   * target&#x3D;\&quot;_blank\&quot;&gt;More info&lt;/a&gt;
   *
   * @return to
   */
  @JsonProperty(JSON_PROPERTY_TO)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public List<String> getTo() {
    return to;
  }

  @JsonProperty(JSON_PROPERTY_TO)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTo(List<String> to) {
    this.to = to;
  }

  public TextRequestDto body(String body) {
    this.body = body;
    return this;
  }

  /**
   * The message content
   *
   * @return body
   */
  @JsonProperty(JSON_PROPERTY_BODY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getBody() {
    return body;
  }

  @JsonProperty(JSON_PROPERTY_BODY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBody(String body) {
    this.body = body;
  }

  public TextRequestDto from(String from) {
    this.from = from;
    return this;
  }

  /**
   * Sender number. Must be valid phone number, short code or alphanumeric. Required if Automatic
   * Default Originator not configured.
   *
   * @return from
   */
  @JsonProperty(JSON_PROPERTY_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getFrom() {
    return from;
  }

  @JsonProperty(JSON_PROPERTY_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFrom(String from) {
    this.from = from;
  }

  public TextRequestDto parameters(ParameterObjDto parameters) {
    this.parameters = parameters;
    return this;
  }

  /**
   * Get parameters
   *
   * @return parameters
   */
  @JsonProperty(JSON_PROPERTY_PARAMETERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ParameterObjDto getParameters() {
    return parameters;
  }

  @JsonProperty(JSON_PROPERTY_PARAMETERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setParameters(ParameterObjDto parameters) {
    this.parameters = parameters;
  }

  public TextRequestDto type(String type) {
    this.type = type;
    return this;
  }

  /**
   * Regular SMS
   *
   * @return type
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getType() {
    return type;
  }

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(String type) {
    this.type = type;
  }

  public TextRequestDto deliveryReport(String deliveryReport) {
    this.deliveryReport = deliveryReport;
    return this;
  }

  /**
   * Request delivery report callback. Note that delivery reports can be fetched from the API
   * regardless of this setting.
   *
   * @return deliveryReport
   */
  @JsonProperty(JSON_PROPERTY_DELIVERY_REPORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDeliveryReport() {
    return deliveryReport;
  }

  @JsonProperty(JSON_PROPERTY_DELIVERY_REPORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeliveryReport(String deliveryReport) {
    this.deliveryReport = deliveryReport;
  }

  public TextRequestDto sendAt(OffsetDateTime sendAt) {
    this.sendAt = sendAt;
    return this;
  }

  /**
   * If set in the future, the message will be delayed until &#x60;send_at&#x60; occurs. Must be
   * before &#x60;expire_at&#x60;. If set in the past, messages will be sent immediately. Formatted
   * as [ISO-8601](https://en.wikipedia.org/wiki/ISO_8601): &#x60;YYYY-MM-DDThh:mm:ss.SSSZ&#x60;.
   *
   * @return sendAt
   */
  @JsonProperty(JSON_PROPERTY_SEND_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getSendAt() {
    return sendAt;
  }

  @JsonProperty(JSON_PROPERTY_SEND_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSendAt(OffsetDateTime sendAt) {
    this.sendAt = sendAt;
  }

  public TextRequestDto expireAt(OffsetDateTime expireAt) {
    this.expireAt = expireAt;
    return this;
  }

  /**
   * If set, the system will stop trying to deliver the message at this point. Must be after
   * &#x60;send_at&#x60;. Default and max is 3 days after &#x60;send_at&#x60;. Formatted as
   * [ISO-8601](https://en.wikipedia.org/wiki/ISO_8601): &#x60;YYYY-MM-DDThh:mm:ss.SSSZ&#x60;.
   *
   * @return expireAt
   */
  @JsonProperty(JSON_PROPERTY_EXPIRE_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getExpireAt() {
    return expireAt;
  }

  @JsonProperty(JSON_PROPERTY_EXPIRE_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpireAt(OffsetDateTime expireAt) {
    this.expireAt = expireAt;
  }

  public TextRequestDto callbackUrl(String callbackUrl) {
    this.callbackUrl = callbackUrl;
    return this;
  }

  /**
   * Override the *default* callback URL for this batch. Must be a valid URL. Learn how to set a
   * default callback URL &lt;a
   * href&#x3D;\&quot;https://community.sinch.com/t5/SMS/How-do-I-assign-a-callback-URL-to-an-SMS-service-plan/ta-p/8414\&quot;
   * target&#x3D;\&quot;_blank\&quot;&gt;here&lt;/a&gt;.
   *
   * @return callbackUrl
   */
  @JsonProperty(JSON_PROPERTY_CALLBACK_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCallbackUrl() {
    return callbackUrl;
  }

  @JsonProperty(JSON_PROPERTY_CALLBACK_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCallbackUrl(String callbackUrl) {
    this.callbackUrl = callbackUrl;
  }

  public TextRequestDto clientReference(String clientReference) {
    this.clientReference = clientReference;
    return this;
  }

  /**
   * The client identifier of a batch message. If set, the identifier will be added in the delivery
   * report/callback of this batch
   *
   * @return clientReference
   */
  @JsonProperty(JSON_PROPERTY_CLIENT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getClientReference() {
    return clientReference;
  }

  @JsonProperty(JSON_PROPERTY_CLIENT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClientReference(String clientReference) {
    this.clientReference = clientReference;
  }

  public TextRequestDto feedbackEnabled(Boolean feedbackEnabled) {
    this.feedbackEnabled = feedbackEnabled;
    return this;
  }

  /**
   * If set to &#x60;true&#x60;, then
   * [feedback](/docs/sms/api-reference/sms/tag/Batches/#tag/Batches/operation/deliveryFeedback) is
   * expected after successful delivery.
   *
   * @return feedbackEnabled
   */
  @JsonProperty(JSON_PROPERTY_FEEDBACK_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getFeedbackEnabled() {
    return feedbackEnabled;
  }

  @JsonProperty(JSON_PROPERTY_FEEDBACK_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFeedbackEnabled(Boolean feedbackEnabled) {
    this.feedbackEnabled = feedbackEnabled;
  }

  public TextRequestDto flashMessage(Boolean flashMessage) {
    this.flashMessage = flashMessage;
    return this;
  }

  /**
   * Shows message on screen without user interaction while not saving the message to the inbox.
   *
   * @return flashMessage
   */
  @JsonProperty(JSON_PROPERTY_FLASH_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getFlashMessage() {
    return flashMessage;
  }

  @JsonProperty(JSON_PROPERTY_FLASH_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFlashMessage(Boolean flashMessage) {
    this.flashMessage = flashMessage;
  }

  public TextRequestDto truncateConcat(Boolean truncateConcat) {
    this.truncateConcat = truncateConcat;
    return this;
  }

  /**
   * If set to &#x60;true&#x60; the message will be shortened when exceeding one part.
   *
   * @return truncateConcat
   */
  @JsonProperty(JSON_PROPERTY_TRUNCATE_CONCAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getTruncateConcat() {
    return truncateConcat;
  }

  @JsonProperty(JSON_PROPERTY_TRUNCATE_CONCAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTruncateConcat(Boolean truncateConcat) {
    this.truncateConcat = truncateConcat;
  }

  public TextRequestDto maxNumberOfMessageParts(Integer maxNumberOfMessageParts) {
    this.maxNumberOfMessageParts = maxNumberOfMessageParts;
    return this;
  }

  /**
   * Message will be dispatched only if it is not split to more parts than Max Number of Message
   * Parts minimum: 1
   *
   * @return maxNumberOfMessageParts
   */
  @JsonProperty(JSON_PROPERTY_MAX_NUMBER_OF_MESSAGE_PARTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getMaxNumberOfMessageParts() {
    return maxNumberOfMessageParts;
  }

  @JsonProperty(JSON_PROPERTY_MAX_NUMBER_OF_MESSAGE_PARTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxNumberOfMessageParts(Integer maxNumberOfMessageParts) {
    this.maxNumberOfMessageParts = maxNumberOfMessageParts;
  }

  public TextRequestDto fromTon(Integer fromTon) {
    this.fromTon = fromTon;
    return this;
  }

  /**
   * The type of number for the sender number. Use to override the automatic detection. minimum: 0
   * maximum: 6
   *
   * @return fromTon
   */
  @JsonProperty(JSON_PROPERTY_FROM_TON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getFromTon() {
    return fromTon;
  }

  @JsonProperty(JSON_PROPERTY_FROM_TON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFromTon(Integer fromTon) {
    this.fromTon = fromTon;
  }

  public TextRequestDto fromNpi(Integer fromNpi) {
    this.fromNpi = fromNpi;
    return this;
  }

  /**
   * Number Plan Indicator for the sender number. Use to override the automatic detection. minimum:
   * 0 maximum: 18
   *
   * @return fromNpi
   */
  @JsonProperty(JSON_PROPERTY_FROM_NPI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getFromNpi() {
    return fromNpi;
  }

  @JsonProperty(JSON_PROPERTY_FROM_NPI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFromNpi(Integer fromNpi) {
    this.fromNpi = fromNpi;
  }

  /** Return true if this TextRequest object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TextRequestDto textRequest = (TextRequestDto) o;
    return Objects.equals(this.to, textRequest.to)
        && Objects.equals(this.body, textRequest.body)
        && Objects.equals(this.from, textRequest.from)
        && Objects.equals(this.parameters, textRequest.parameters)
        && Objects.equals(this.type, textRequest.type)
        && Objects.equals(this.deliveryReport, textRequest.deliveryReport)
        && Objects.equals(this.sendAt, textRequest.sendAt)
        && Objects.equals(this.expireAt, textRequest.expireAt)
        && Objects.equals(this.callbackUrl, textRequest.callbackUrl)
        && Objects.equals(this.clientReference, textRequest.clientReference)
        && Objects.equals(this.feedbackEnabled, textRequest.feedbackEnabled)
        && Objects.equals(this.flashMessage, textRequest.flashMessage)
        && Objects.equals(this.truncateConcat, textRequest.truncateConcat)
        && Objects.equals(this.maxNumberOfMessageParts, textRequest.maxNumberOfMessageParts)
        && Objects.equals(this.fromTon, textRequest.fromTon)
        && Objects.equals(this.fromNpi, textRequest.fromNpi);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        to,
        body,
        from,
        parameters,
        type,
        deliveryReport,
        sendAt,
        expireAt,
        callbackUrl,
        clientReference,
        feedbackEnabled,
        flashMessage,
        truncateConcat,
        maxNumberOfMessageParts,
        fromTon,
        fromNpi);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TextRequestDto {\n");
    sb.append("    to: ").append(toIndentedString(to)).append("\n");
    sb.append("    body: ").append(toIndentedString(body)).append("\n");
    sb.append("    from: ").append(toIndentedString(from)).append("\n");
    sb.append("    parameters: ").append(toIndentedString(parameters)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    deliveryReport: ").append(toIndentedString(deliveryReport)).append("\n");
    sb.append("    sendAt: ").append(toIndentedString(sendAt)).append("\n");
    sb.append("    expireAt: ").append(toIndentedString(expireAt)).append("\n");
    sb.append("    callbackUrl: ").append(toIndentedString(callbackUrl)).append("\n");
    sb.append("    clientReference: ").append(toIndentedString(clientReference)).append("\n");
    sb.append("    feedbackEnabled: ").append(toIndentedString(feedbackEnabled)).append("\n");
    sb.append("    flashMessage: ").append(toIndentedString(flashMessage)).append("\n");
    sb.append("    truncateConcat: ").append(toIndentedString(truncateConcat)).append("\n");
    sb.append("    maxNumberOfMessageParts: ")
        .append(toIndentedString(maxNumberOfMessageParts))
        .append("\n");
    sb.append("    fromTon: ").append(toIndentedString(fromTon)).append("\n");
    sb.append("    fromNpi: ").append(toIndentedString(fromNpi)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
