/*
 * API Overview | Sinch
 * Sinch SMS API is one of the easiest APIs we offer and enables you to add fast and reliable global SMS to your applications. Send single messages, scheduled batch messages, use available message templates and more.
 *
 * The version of the OpenAPI document: v1
 * Contact: Support@sinch.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sinch.sdk.domains.sms.models.dto.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** TextResponseDto */
@JsonPropertyOrder({
  TextResponseDto.JSON_PROPERTY_ID,
  TextResponseDto.JSON_PROPERTY_TO,
  TextResponseDto.JSON_PROPERTY_FROM,
  TextResponseDto.JSON_PROPERTY_CANCELED,
  TextResponseDto.JSON_PROPERTY_PARAMETERS,
  TextResponseDto.JSON_PROPERTY_BODY,
  TextResponseDto.JSON_PROPERTY_TYPE,
  TextResponseDto.JSON_PROPERTY_CREATED_AT,
  TextResponseDto.JSON_PROPERTY_MODIFIED_AT,
  TextResponseDto.JSON_PROPERTY_DELIVERY_REPORT,
  TextResponseDto.JSON_PROPERTY_SEND_AT,
  TextResponseDto.JSON_PROPERTY_EXPIRE_AT,
  TextResponseDto.JSON_PROPERTY_CALLBACK_URL,
  TextResponseDto.JSON_PROPERTY_CLIENT_REFERENCE,
  TextResponseDto.JSON_PROPERTY_FEEDBACK_ENABLED,
  TextResponseDto.JSON_PROPERTY_FLASH_MESSAGE,
  TextResponseDto.JSON_PROPERTY_TRUNCATE_CONCAT,
  TextResponseDto.JSON_PROPERTY_MAX_NUMBER_OF_MESSAGE_PARTS,
  TextResponseDto.JSON_PROPERTY_FROM_TON,
  TextResponseDto.JSON_PROPERTY_FROM_NPI
})
// @javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class TextResponseDto {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_TO = "to";
  private List<String> to;

  public static final String JSON_PROPERTY_FROM = "from";
  private String from;

  public static final String JSON_PROPERTY_CANCELED = "canceled";
  private Boolean canceled = false;

  public static final String JSON_PROPERTY_PARAMETERS = "parameters";
  private ParameterObjDto parameters;

  public static final String JSON_PROPERTY_BODY = "body";
  private String body;

  /** Regular SMS */
  public enum TypeEnum {
    MT_TEXT("mt_text"),

    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return UNKNOWN_DEFAULT_OPEN_API;
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  public static final String JSON_PROPERTY_CREATED_AT = "created_at";
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_MODIFIED_AT = "modified_at";
  private OffsetDateTime modifiedAt;

  public static final String JSON_PROPERTY_DELIVERY_REPORT = "delivery_report";
  private String deliveryReport = "none";

  public static final String JSON_PROPERTY_SEND_AT = "send_at";
  private OffsetDateTime sendAt;

  public static final String JSON_PROPERTY_EXPIRE_AT = "expire_at";
  private OffsetDateTime expireAt;

  public static final String JSON_PROPERTY_CALLBACK_URL = "callback_url";
  private String callbackUrl;

  public static final String JSON_PROPERTY_CLIENT_REFERENCE = "client_reference";
  private String clientReference;

  public static final String JSON_PROPERTY_FEEDBACK_ENABLED = "feedback_enabled";
  private Boolean feedbackEnabled = false;

  public static final String JSON_PROPERTY_FLASH_MESSAGE = "flash_message";
  private Boolean flashMessage = false;

  public static final String JSON_PROPERTY_TRUNCATE_CONCAT = "truncate_concat";
  private Boolean truncateConcat;

  public static final String JSON_PROPERTY_MAX_NUMBER_OF_MESSAGE_PARTS =
      "max_number_of_message_parts";
  private Integer maxNumberOfMessageParts;

  public static final String JSON_PROPERTY_FROM_TON = "from_ton";
  private Integer fromTon;

  public static final String JSON_PROPERTY_FROM_NPI = "from_npi";
  private Integer fromNpi;

  public TextResponseDto() {}

  @JsonCreator
  public TextResponseDto(
      @JsonProperty(JSON_PROPERTY_ID) String id,
      @JsonProperty(JSON_PROPERTY_CANCELED) Boolean canceled,
      @JsonProperty(JSON_PROPERTY_TYPE) String type,
      @JsonProperty(JSON_PROPERTY_CREATED_AT) OffsetDateTime createdAt,
      @JsonProperty(JSON_PROPERTY_MODIFIED_AT) OffsetDateTime modifiedAt) {
    this();
    this.id = id;
    this.canceled = canceled;
    this.type = type;
    this.createdAt = createdAt;
    this.modifiedAt = modifiedAt;
  }

  /**
   * Unique identifier for batch
   *
   * @return id
   */
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getId() {
    return id;
  }

  public TextResponseDto to(List<String> to) {
    this.to = to;
    return this;
  }

  public TextResponseDto addToItem(String toItem) {
    if (this.to == null) {
      this.to = new ArrayList<>();
    }
    this.to.add(toItem);
    return this;
  }

  /**
   * List of Phone numbers and group IDs that will receive the batch. [More
   * info](https://community.sinch.com/t5/Glossary/MSISDN/ta-p/7628)
   *
   * @return to
   */
  @JsonProperty(JSON_PROPERTY_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getTo() {
    return to;
  }

  @JsonProperty(JSON_PROPERTY_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTo(List<String> to) {
    this.to = to;
  }

  public TextResponseDto from(String from) {
    this.from = from;
    return this;
  }

  /**
   * Sender number. Must be valid phone number, short code or alphanumeric. Required if Automatic
   * Default Originator not configured.
   *
   * @return from
   */
  @JsonProperty(JSON_PROPERTY_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getFrom() {
    return from;
  }

  @JsonProperty(JSON_PROPERTY_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFrom(String from) {
    this.from = from;
  }

  /**
   * Indicates if the batch has been canceled or not.
   *
   * @return canceled
   */
  @JsonProperty(JSON_PROPERTY_CANCELED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getCanceled() {
    return canceled;
  }

  public TextResponseDto parameters(ParameterObjDto parameters) {
    this.parameters = parameters;
    return this;
  }

  /**
   * Get parameters
   *
   * @return parameters
   */
  @JsonProperty(JSON_PROPERTY_PARAMETERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ParameterObjDto getParameters() {
    return parameters;
  }

  @JsonProperty(JSON_PROPERTY_PARAMETERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setParameters(ParameterObjDto parameters) {
    this.parameters = parameters;
  }

  public TextResponseDto body(String body) {
    this.body = body;
    return this;
  }

  /**
   * The message content
   *
   * @return body
   */
  @JsonProperty(JSON_PROPERTY_BODY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getBody() {
    return body;
  }

  @JsonProperty(JSON_PROPERTY_BODY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBody(String body) {
    this.body = body;
  }

  /**
   * Regular SMS
   *
   * @return type
   */
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getType() {
    return type;
  }

  /**
   * Timestamp for when batch was created. Formatted as
   * [ISO-8601](https://en.wikipedia.org/wiki/ISO_8601):&#x60;YYYY-MM-DDThh:mm:ss.SSSZ&#x60;.
   *
   * @return createdAt
   */
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  /**
   * Timestamp for when batch was last updated. Formatted as
   * [ISO-8601](https://en.wikipedia.org/wiki/ISO_8601):&#x60;YYYY-MM-DDThh:mm:ss.SSSZ&#x60;.
   *
   * @return modifiedAt
   */
  @JsonProperty(JSON_PROPERTY_MODIFIED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getModifiedAt() {
    return modifiedAt;
  }

  public TextResponseDto deliveryReport(String deliveryReport) {
    this.deliveryReport = deliveryReport;
    return this;
  }

  /**
   * Request delivery report callback. Note that delivery reports can be fetched from the API
   * regardless of this setting.
   *
   * @return deliveryReport
   */
  @JsonProperty(JSON_PROPERTY_DELIVERY_REPORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDeliveryReport() {
    return deliveryReport;
  }

  @JsonProperty(JSON_PROPERTY_DELIVERY_REPORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeliveryReport(String deliveryReport) {
    this.deliveryReport = deliveryReport;
  }

  public TextResponseDto sendAt(OffsetDateTime sendAt) {
    this.sendAt = sendAt;
    return this;
  }

  /**
   * If set in the future, the message will be delayed until &#x60;send_at&#x60; occurs. Must be
   * before &#x60;expire_at&#x60;. If set in the past, messages will be sent immediately. Formatted
   * as [ISO-8601](https://en.wikipedia.org/wiki/ISO_8601): &#x60;YYYY-MM-DDThh:mm:ss.SSSZ&#x60;.
   *
   * @return sendAt
   */
  @JsonProperty(JSON_PROPERTY_SEND_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getSendAt() {
    return sendAt;
  }

  @JsonProperty(JSON_PROPERTY_SEND_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSendAt(OffsetDateTime sendAt) {
    this.sendAt = sendAt;
  }

  public TextResponseDto expireAt(OffsetDateTime expireAt) {
    this.expireAt = expireAt;
    return this;
  }

  /**
   * If set, the system will stop trying to deliver the message at this point. Must be after
   * &#x60;send_at&#x60;. Default and max is 3 days after &#x60;send_at&#x60;. Formatted as
   * [ISO-8601](https://en.wikipedia.org/wiki/ISO_8601): &#x60;YYYY-MM-DDThh:mm:ss.SSSZ&#x60;.
   *
   * @return expireAt
   */
  @JsonProperty(JSON_PROPERTY_EXPIRE_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getExpireAt() {
    return expireAt;
  }

  @JsonProperty(JSON_PROPERTY_EXPIRE_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpireAt(OffsetDateTime expireAt) {
    this.expireAt = expireAt;
  }

  public TextResponseDto callbackUrl(String callbackUrl) {
    this.callbackUrl = callbackUrl;
    return this;
  }

  /**
   * Override the default callback URL for this batch. Must be valid URL.
   *
   * @return callbackUrl
   */
  @JsonProperty(JSON_PROPERTY_CALLBACK_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCallbackUrl() {
    return callbackUrl;
  }

  @JsonProperty(JSON_PROPERTY_CALLBACK_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCallbackUrl(String callbackUrl) {
    this.callbackUrl = callbackUrl;
  }

  public TextResponseDto clientReference(String clientReference) {
    this.clientReference = clientReference;
    return this;
  }

  /**
   * The client identifier of a batch message. If set, the identifier will be added in the delivery
   * report/callback of this batch
   *
   * @return clientReference
   */
  @JsonProperty(JSON_PROPERTY_CLIENT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getClientReference() {
    return clientReference;
  }

  @JsonProperty(JSON_PROPERTY_CLIENT_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClientReference(String clientReference) {
    this.clientReference = clientReference;
  }

  public TextResponseDto feedbackEnabled(Boolean feedbackEnabled) {
    this.feedbackEnabled = feedbackEnabled;
    return this;
  }

  /**
   * If set to &#x60;true&#x60;, then
   * [feedback](/docs/sms/api-reference/sms/tag/Batches/#tag/Batches/operation/deliveryFeedback) is
   * expected after successful delivery.
   *
   * @return feedbackEnabled
   */
  @JsonProperty(JSON_PROPERTY_FEEDBACK_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getFeedbackEnabled() {
    return feedbackEnabled;
  }

  @JsonProperty(JSON_PROPERTY_FEEDBACK_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFeedbackEnabled(Boolean feedbackEnabled) {
    this.feedbackEnabled = feedbackEnabled;
  }

  public TextResponseDto flashMessage(Boolean flashMessage) {
    this.flashMessage = flashMessage;
    return this;
  }

  /**
   * Shows message on screen without user interaction while not saving the message to the inbox.
   *
   * @return flashMessage
   */
  @JsonProperty(JSON_PROPERTY_FLASH_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getFlashMessage() {
    return flashMessage;
  }

  @JsonProperty(JSON_PROPERTY_FLASH_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFlashMessage(Boolean flashMessage) {
    this.flashMessage = flashMessage;
  }

  public TextResponseDto truncateConcat(Boolean truncateConcat) {
    this.truncateConcat = truncateConcat;
    return this;
  }

  /**
   * If set to &#x60;true&#x60; the message will be shortened when exceeding one part.
   *
   * @return truncateConcat
   */
  @JsonProperty(JSON_PROPERTY_TRUNCATE_CONCAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getTruncateConcat() {
    return truncateConcat;
  }

  @JsonProperty(JSON_PROPERTY_TRUNCATE_CONCAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTruncateConcat(Boolean truncateConcat) {
    this.truncateConcat = truncateConcat;
  }

  public TextResponseDto maxNumberOfMessageParts(Integer maxNumberOfMessageParts) {
    this.maxNumberOfMessageParts = maxNumberOfMessageParts;
    return this;
  }

  /**
   * Message will be dispatched only if it is not split to more parts than Max Number of Message
   * Parts minimum: 1
   *
   * @return maxNumberOfMessageParts
   */
  @JsonProperty(JSON_PROPERTY_MAX_NUMBER_OF_MESSAGE_PARTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getMaxNumberOfMessageParts() {
    return maxNumberOfMessageParts;
  }

  @JsonProperty(JSON_PROPERTY_MAX_NUMBER_OF_MESSAGE_PARTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxNumberOfMessageParts(Integer maxNumberOfMessageParts) {
    this.maxNumberOfMessageParts = maxNumberOfMessageParts;
  }

  public TextResponseDto fromTon(Integer fromTon) {
    this.fromTon = fromTon;
    return this;
  }

  /**
   * The type of number for the sender number. Use to override the automatic detection. minimum: 0
   * maximum: 6
   *
   * @return fromTon
   */
  @JsonProperty(JSON_PROPERTY_FROM_TON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getFromTon() {
    return fromTon;
  }

  @JsonProperty(JSON_PROPERTY_FROM_TON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFromTon(Integer fromTon) {
    this.fromTon = fromTon;
  }

  public TextResponseDto fromNpi(Integer fromNpi) {
    this.fromNpi = fromNpi;
    return this;
  }

  /**
   * Number Plan Indicator for the sender number. Use to override the automatic detection. minimum:
   * 0 maximum: 18
   *
   * @return fromNpi
   */
  @JsonProperty(JSON_PROPERTY_FROM_NPI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getFromNpi() {
    return fromNpi;
  }

  @JsonProperty(JSON_PROPERTY_FROM_NPI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFromNpi(Integer fromNpi) {
    this.fromNpi = fromNpi;
  }

  /** Return true if this TextResponse object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TextResponseDto textResponse = (TextResponseDto) o;
    return Objects.equals(this.id, textResponse.id)
        && Objects.equals(this.to, textResponse.to)
        && Objects.equals(this.from, textResponse.from)
        && Objects.equals(this.canceled, textResponse.canceled)
        && Objects.equals(this.parameters, textResponse.parameters)
        && Objects.equals(this.body, textResponse.body)
        && Objects.equals(this.type, textResponse.type)
        && Objects.equals(this.createdAt, textResponse.createdAt)
        && Objects.equals(this.modifiedAt, textResponse.modifiedAt)
        && Objects.equals(this.deliveryReport, textResponse.deliveryReport)
        && Objects.equals(this.sendAt, textResponse.sendAt)
        && Objects.equals(this.expireAt, textResponse.expireAt)
        && Objects.equals(this.callbackUrl, textResponse.callbackUrl)
        && Objects.equals(this.clientReference, textResponse.clientReference)
        && Objects.equals(this.feedbackEnabled, textResponse.feedbackEnabled)
        && Objects.equals(this.flashMessage, textResponse.flashMessage)
        && Objects.equals(this.truncateConcat, textResponse.truncateConcat)
        && Objects.equals(this.maxNumberOfMessageParts, textResponse.maxNumberOfMessageParts)
        && Objects.equals(this.fromTon, textResponse.fromTon)
        && Objects.equals(this.fromNpi, textResponse.fromNpi);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        id,
        to,
        from,
        canceled,
        parameters,
        body,
        type,
        createdAt,
        modifiedAt,
        deliveryReport,
        sendAt,
        expireAt,
        callbackUrl,
        clientReference,
        feedbackEnabled,
        flashMessage,
        truncateConcat,
        maxNumberOfMessageParts,
        fromTon,
        fromNpi);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TextResponseDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    to: ").append(toIndentedString(to)).append("\n");
    sb.append("    from: ").append(toIndentedString(from)).append("\n");
    sb.append("    canceled: ").append(toIndentedString(canceled)).append("\n");
    sb.append("    parameters: ").append(toIndentedString(parameters)).append("\n");
    sb.append("    body: ").append(toIndentedString(body)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    modifiedAt: ").append(toIndentedString(modifiedAt)).append("\n");
    sb.append("    deliveryReport: ").append(toIndentedString(deliveryReport)).append("\n");
    sb.append("    sendAt: ").append(toIndentedString(sendAt)).append("\n");
    sb.append("    expireAt: ").append(toIndentedString(expireAt)).append("\n");
    sb.append("    callbackUrl: ").append(toIndentedString(callbackUrl)).append("\n");
    sb.append("    clientReference: ").append(toIndentedString(clientReference)).append("\n");
    sb.append("    feedbackEnabled: ").append(toIndentedString(feedbackEnabled)).append("\n");
    sb.append("    flashMessage: ").append(toIndentedString(flashMessage)).append("\n");
    sb.append("    truncateConcat: ").append(toIndentedString(truncateConcat)).append("\n");
    sb.append("    maxNumberOfMessageParts: ")
        .append(toIndentedString(maxNumberOfMessageParts))
        .append("\n");
    sb.append("    fromTon: ").append(toIndentedString(fromTon)).append("\n");
    sb.append("    fromNpi: ").append(toIndentedString(fromNpi)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
