/*
 * API Overview | Sinch
 * Sinch SMS API is one of the easiest APIs we offer and enables you to add fast and reliable global SMS to your applications. Send single messages, scheduled batch messages, use available message templates and more.
 *
 * The version of the OpenAPI document: v1
 * Contact: Support@sinch.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sinch.sdk.domains.sms.models.dto.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** UpdateGroupRequestDto */
@JsonPropertyOrder({
  UpdateGroupRequestDto.JSON_PROPERTY_NAME,
  UpdateGroupRequestDto.JSON_PROPERTY_ADD,
  UpdateGroupRequestDto.JSON_PROPERTY_REMOVE,
  UpdateGroupRequestDto.JSON_PROPERTY_ADD_FROM_GROUP,
  UpdateGroupRequestDto.JSON_PROPERTY_REMOVE_FROM_GROUP,
  UpdateGroupRequestDto.JSON_PROPERTY_AUTO_UPDATE
})
// @javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class UpdateGroupRequestDto {
  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_ADD = "add";
  private List<String> add;

  public static final String JSON_PROPERTY_REMOVE = "remove";
  private List<String> remove;

  public static final String JSON_PROPERTY_ADD_FROM_GROUP = "add_from_group";
  private String addFromGroup;

  public static final String JSON_PROPERTY_REMOVE_FROM_GROUP = "remove_from_group";
  private String removeFromGroup;

  public static final String JSON_PROPERTY_AUTO_UPDATE = "auto_update";
  private UpdateGroupRequestAutoUpdateDto autoUpdate;

  public UpdateGroupRequestDto() {}

  public UpdateGroupRequestDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * The name of the group. Omitting &#x60;name&#x60; from the JSON body will leave the name
   * unchanged. To remove an existing name set, name explicitly to the JSON value &#x60;null&#x60;.
   *
   * @return name
   */
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getName() {
    return name;
  }

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }

  public UpdateGroupRequestDto add(List<String> add) {
    this.add = add;
    return this;
  }

  public UpdateGroupRequestDto addAddItem(String addItem) {
    if (this.add == null) {
      this.add = new ArrayList<>();
    }
    this.add.add(addItem);
    return this;
  }

  /**
   * Add a list of phone numbers (MSISDNs) to this group. The phone numbers are a strings within an
   * array and must be in &lt;a
   * href&#x3D;\&quot;https://community.sinch.com/t5/Glossary/E-164/ta-p/7537\&quot;
   * target&#x3D;\&quot;_blank\&quot;&gt;E.164 format&lt;/a&gt;.
   *
   * @return add
   */
  @JsonProperty(JSON_PROPERTY_ADD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getAdd() {
    return add;
  }

  @JsonProperty(JSON_PROPERTY_ADD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdd(List<String> add) {
    this.add = add;
  }

  public UpdateGroupRequestDto remove(List<String> remove) {
    this.remove = remove;
    return this;
  }

  public UpdateGroupRequestDto addRemoveItem(String removeItem) {
    if (this.remove == null) {
      this.remove = new ArrayList<>();
    }
    this.remove.add(removeItem);
    return this;
  }

  /**
   * Remove a list of phone numbers (MSISDNs) to this group.The phone numbers are a strings within
   * an array and must be in &lt;a
   * href&#x3D;\&quot;https://community.sinch.com/t5/Glossary/E-164/ta-p/7537\&quot;
   * target&#x3D;\&quot;_blank\&quot;&gt;E.164 format&lt;/a&gt;.
   *
   * @return remove
   */
  @JsonProperty(JSON_PROPERTY_REMOVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getRemove() {
    return remove;
  }

  @JsonProperty(JSON_PROPERTY_REMOVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRemove(List<String> remove) {
    this.remove = remove;
  }

  public UpdateGroupRequestDto addFromGroup(String addFromGroup) {
    this.addFromGroup = addFromGroup;
    return this;
  }

  /**
   * Copy the members from the another group into this group. Constraints: Must be valid group ID
   *
   * @return addFromGroup
   */
  @JsonProperty(JSON_PROPERTY_ADD_FROM_GROUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAddFromGroup() {
    return addFromGroup;
  }

  @JsonProperty(JSON_PROPERTY_ADD_FROM_GROUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddFromGroup(String addFromGroup) {
    this.addFromGroup = addFromGroup;
  }

  public UpdateGroupRequestDto removeFromGroup(String removeFromGroup) {
    this.removeFromGroup = removeFromGroup;
    return this;
  }

  /**
   * Remove the members in a specified group from this group. Constraints: Must be valid group ID
   *
   * @return removeFromGroup
   */
  @JsonProperty(JSON_PROPERTY_REMOVE_FROM_GROUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getRemoveFromGroup() {
    return removeFromGroup;
  }

  @JsonProperty(JSON_PROPERTY_REMOVE_FROM_GROUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRemoveFromGroup(String removeFromGroup) {
    this.removeFromGroup = removeFromGroup;
  }

  public UpdateGroupRequestDto autoUpdate(UpdateGroupRequestAutoUpdateDto autoUpdate) {
    this.autoUpdate = autoUpdate;
    return this;
  }

  /**
   * Get autoUpdate
   *
   * @return autoUpdate
   */
  @JsonProperty(JSON_PROPERTY_AUTO_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public UpdateGroupRequestAutoUpdateDto getAutoUpdate() {
    return autoUpdate;
  }

  @JsonProperty(JSON_PROPERTY_AUTO_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAutoUpdate(UpdateGroupRequestAutoUpdateDto autoUpdate) {
    this.autoUpdate = autoUpdate;
  }

  /** Return true if this UpdateGroup_request object is equal to o. */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateGroupRequestDto updateGroupRequest = (UpdateGroupRequestDto) o;
    return Objects.equals(this.name, updateGroupRequest.name)
        && Objects.equals(this.add, updateGroupRequest.add)
        && Objects.equals(this.remove, updateGroupRequest.remove)
        && Objects.equals(this.addFromGroup, updateGroupRequest.addFromGroup)
        && Objects.equals(this.removeFromGroup, updateGroupRequest.removeFromGroup)
        && Objects.equals(this.autoUpdate, updateGroupRequest.autoUpdate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, add, remove, addFromGroup, removeFromGroup, autoUpdate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateGroupRequestDto {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    add: ").append(toIndentedString(add)).append("\n");
    sb.append("    remove: ").append(toIndentedString(remove)).append("\n");
    sb.append("    addFromGroup: ").append(toIndentedString(addFromGroup)).append("\n");
    sb.append("    removeFromGroup: ").append(toIndentedString(removeFromGroup)).append("\n");
    sb.append("    autoUpdate: ").append(toIndentedString(autoUpdate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
