/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk;

import com.sinch.sdk.auth.AuthManager;
import com.sinch.sdk.auth.adapters.BasicAuthManager;
import com.sinch.sdk.auth.adapters.BearerAuthManager;
import com.sinch.sdk.core.http.HttpMapper;
import com.sinch.sdk.core.utils.StringUtil;
import com.sinch.sdk.domains.numbers.NumbersService;
import com.sinch.sdk.domains.sms.SMSService;
import com.sinch.sdk.http.HttpClientApache;
import com.sinch.sdk.models.Configuration;
import com.sinch.sdk.models.SMSRegion;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SinchClient {
    private static final String DEFAULT_PROPERTIES_FILE_NAME = "/config-default.properties";
    private static final String VERSION_PROPERTIES_FILE_NAME = "/version.properties";
    private static final String OAUTH_URL_KEY = "oauth-url";
    private static final String NUMBERS_SERVER_KEY = "numbers-server";
    private static final String SMS_REGION_KEY = "sms-region";
    private static final String SMS_SERVER_KEY = "sms-server";
    private static final String PROJECT_NAME_KEY = "project.name";
    private static final String PROJECT_VERSION_KEY = "project.version";
    private static final String PROJECT_AUXILIARY_FLAG = "project.auxiliary_flag";
    private static final String SDK_USER_AGENT_HEADER = "User-Agent";
    private static final String SDK_USER_AGENT_FORMAT = "sinch-sdk/%s (%s/%s; %s; %s)";
    private static final Logger LOGGER = Logger.getLogger(SinchClient.class.getName());
    private final Configuration configuration;
    private final Properties versionProperties;
    private NumbersService numbers;
    private SMSService sms;
    private HttpClientApache httpClient;

    public SinchClient(Configuration configuration) {
        Configuration.Builder builder = Configuration.builder(configuration);
        Properties props = this.handlePropertiesFile(DEFAULT_PROPERTIES_FILE_NAME);
        if (null == configuration.getOAuthUrl() && props.containsKey(OAUTH_URL_KEY)) {
            builder.setOAuthUrl(props.getProperty(OAUTH_URL_KEY));
        }
        if (null == configuration.getNumbersUrl() && props.containsKey(NUMBERS_SERVER_KEY)) {
            builder.setNumbersUrl(props.getProperty(NUMBERS_SERVER_KEY));
        }
        if (null == configuration.getSmsUrl() && props.containsKey(SMS_SERVER_KEY)) {
            builder.setSmsUrl(props.getProperty(SMS_SERVER_KEY));
        }
        if (null == configuration.getSmsRegion() && props.containsKey(SMS_REGION_KEY)) {
            builder.setSmsRegion(SMSRegion.from(props.getProperty(SMS_REGION_KEY)));
        }
        Configuration newConfiguration = builder.build();
        this.checkConfiguration(newConfiguration);
        this.configuration = newConfiguration;
        this.versionProperties = this.handlePropertiesFile(VERSION_PROPERTIES_FILE_NAME);
        LOGGER.fine(String.format("%s (%s) started with projectId '%s'", this.versionProperties.getProperty(PROJECT_NAME_KEY), this.versionProperties.getProperty(PROJECT_VERSION_KEY), configuration.getProjectId()));
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public NumbersService numbers() {
        if (null == this.numbers) {
            this.numbers = this.numbersInit();
        }
        return this.numbers;
    }

    public SMSService sms() {
        if (null == this.sms) {
            this.sms = this.smsInit();
        }
        return this.sms;
    }

    private void checkConfiguration(Configuration configuration) throws NullPointerException {
        Objects.requireNonNull(configuration.getKeyId(), "'keyId' cannot be null");
        Objects.requireNonNull(configuration.getKeySecret(), "'keySecret' cannot be null");
        Objects.requireNonNull(configuration.getProjectId(), "'projectId' cannot be null");
        Objects.requireNonNull(configuration.getOAuthUrl(), "'oauthUrl' cannot be null");
        Objects.requireNonNull(configuration.getNumbersUrl(), "'numbersUrl' cannot be null");
        Objects.requireNonNull(configuration.getSmsUrl(), "'smsUrl' cannot be null");
    }

    private NumbersService numbersInit() {
        LOGGER.fine("Activate numbers API with server='" + this.getConfiguration().getNumbersServer().getUrl() + "'");
        return new com.sinch.sdk.domains.numbers.adapters.NumbersService(this.getConfiguration(), this.getHttpClient());
    }

    private SMSService smsInit() {
        LOGGER.fine("Activate SMS API with server='" + this.getConfiguration().getSmsServer().getUrl() + "'");
        return new com.sinch.sdk.domains.sms.adapters.SMSService(this.getConfiguration(), this.getHttpClient());
    }

    private Properties handlePropertiesFile(String fileName) {
        Properties prop = new Properties();
        try (InputStream is = this.getClass().getResourceAsStream(fileName);){
            prop.load(is);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return prop;
    }

    private HttpClientApache getHttpClient() {
        if (null == this.httpClient || this.httpClient.isClosed()) {
            BasicAuthManager basicAuthManager = new BasicAuthManager(this.configuration);
            BearerAuthManager bearerAuthManager = new BearerAuthManager(this.configuration, new HttpMapper());
            Map<String, AuthManager> authManagers = Stream.of(basicAuthManager, bearerAuthManager).map(e -> new AbstractMap.SimpleEntry<String, AuthManager>(e.getSchema(), (AuthManager)e)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            this.httpClient = new HttpClientApache(authManagers);
            bearerAuthManager.setHttpClient(this.httpClient);
            String userAgent = this.formatSdkUserAgentHeader(this.versionProperties);
            this.httpClient.setRequestHeaders(Stream.of(new String[][]{{SDK_USER_AGENT_HEADER, userAgent}}).collect(Collectors.toMap(data -> data[0], data -> data[1])));
            LOGGER.fine("HTTP client loaded");
        }
        return this.httpClient;
    }

    private String formatSdkUserAgentHeader(Properties versionProperties) {
        return String.format(SDK_USER_AGENT_FORMAT, versionProperties.get(PROJECT_VERSION_KEY), "Java", System.getProperty("java.version"), "Apache", this.formatAuxiliaryFlag((String)versionProperties.get(PROJECT_AUXILIARY_FLAG)));
    }

    private String formatAuxiliaryFlag(String auxiliaryFlag) {
        List<String> values = Arrays.asList(System.getProperty("java.vendor"));
        if (!StringUtil.isEmpty(auxiliaryFlag)) {
            values.add(auxiliaryFlag);
        }
        return String.join((CharSequence)",", values);
    }
}

