/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.auth.adapters;

import com.fasterxml.jackson.core.type.TypeReference;
import com.sinch.sdk.auth.AuthManager;
import com.sinch.sdk.auth.models.BearerAuthResponse;
import com.sinch.sdk.core.exceptions.ApiAuthException;
import com.sinch.sdk.core.http.HttpClient;
import com.sinch.sdk.core.http.HttpMapper;
import com.sinch.sdk.core.http.HttpMethod;
import com.sinch.sdk.core.http.HttpRequest;
import com.sinch.sdk.core.http.HttpResponse;
import com.sinch.sdk.models.Configuration;
import java.util.Collections;
import java.util.Optional;
import java.util.logging.Logger;

public class BearerAuthManager
implements AuthManager {
    public static final String BEARER_SCHEMA_KEYWORD = "BearerAuth";
    public static final String BEARER_EXPIRED_KEYWORD = "expired";
    public static final String BEARER_AUTHENTICATE_RESPONSE_HEADER_KEYWORD = "www-authenticate";
    private static final Logger LOGGER = Logger.getLogger(BearerAuthManager.class.getName());
    private static final String BEARER_AUTH_KEYWORD = "Bearer";
    private static final int maxRefreshAttempt = 5;
    private final Configuration configuration;
    private final HttpMapper mapper;
    private HttpClient httpClient;
    private String token;

    public BearerAuthManager(Configuration configuration, HttpMapper mapper) {
        this.configuration = configuration;
        this.mapper = mapper;
    }

    @Override
    public String getSchema() {
        return BEARER_SCHEMA_KEYWORD;
    }

    @Override
    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public void resetToken() {
        this.token = null;
    }

    @Override
    public String getAuthorizationHeaderValue() {
        if (this.token == null) {
            this.refreshToken();
        }
        return "Bearer " + this.token;
    }

    private void refreshToken() {
        for (int attempt = 0; attempt < 5; ++attempt) {
            Optional<String> newValue = this.getNewToken();
            if (!newValue.isPresent()) continue;
            this.token = newValue.get();
            return;
        }
        throw new ApiAuthException("Unable to get new token");
    }

    private Optional<String> getNewToken() {
        LOGGER.fine("Refreshing OAuth token");
        HttpRequest request = new HttpRequest(null, HttpMethod.POST, Collections.emptyList(), "grant_type=client_credentials", null, null, Collections.singletonList("application/x-www-form-urlencoded"), Collections.singletonList("BasicAuth"));
        try {
            HttpResponse httpResponse = this.httpClient.invokeAPI(this.configuration.getOAuthServer(), request);
            BearerAuthResponse authResponse = this.mapper.deserialize(httpResponse, new TypeReference<BearerAuthResponse>(){});
            return Optional.ofNullable(authResponse.getAccessToken());
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

