/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.core.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.sinch.sdk.core.exceptions.ApiException;
import com.sinch.sdk.core.http.HttpContentType;
import com.sinch.sdk.core.http.HttpResponse;
import com.sinch.sdk.core.utils.databind.Mapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Scanner;

public class HttpMapper {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T deserialize(HttpResponse response, TypeReference<T> valueType) throws ApiException {
        if (null == valueType) return null;
        if (null == response) {
            return null;
        }
        try (InputStream stream = response.getContent();){
            String t;
            if (null == stream) {
                T t2 = null;
                return t2;
            }
            Collection contentType = response.getHeaders().get("content-type");
            if (null == contentType || contentType.isEmpty() || HttpContentType.isMimeJson(contentType)) {
                String content;
                Scanner s = new Scanner(stream).useDelimiter("\\A");
                String string = content = s.hasNext() ? s.next() : "";
                if ("".equals(content)) {
                    T t3 = null;
                    return t3;
                }
                Object object = Mapper.getInstance().readValue(content, valueType);
                return (T)object;
            }
            if (!HttpContentType.isMimeTextPlain(contentType)) throw new ApiException("Deserialization for content type '" + contentType + "' not supported for type '" + valueType);
            Scanner s = new Scanner(stream).useDelimiter("\\A");
            String string = t = s.hasNext() ? s.next() : "";
            return (T)string;
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    public String serialize(Collection<String> contentTypes, Object body) {
        if (null == body) {
            return null;
        }
        if (null == contentTypes || contentTypes.isEmpty() || HttpContentType.isMimeJson(contentTypes)) {
            try {
                return Mapper.getInstance().writeValueAsString(body);
            }
            catch (JsonProcessingException e) {
                throw new ApiException(e);
            }
        }
        throw new ApiException("Deserialization for content type '" + contentTypes + "' not supported ");
    }
}

