/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.core.http;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class HttpResponse {
    private final int code;
    private final String message;
    private final Map<String, List<String>> headers;
    private final byte[] buffer;

    public HttpResponse(int code, String message, Map<String, List<String>> headers, byte[] buffer) {
        this.code = code;
        this.message = null != message ? message : "";
        this.headers = null != headers ? headers : Collections.emptyMap();
        this.buffer = null != buffer ? buffer : "".getBytes(StandardCharsets.UTF_8);
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public InputStream getContent() {
        return new ByteArrayInputStream(this.buffer);
    }

    public String toString() {
        return "HttpResponse{code=" + this.code + ", message='" + this.message + '\'' + ", headers=" + this.headers + ", buffer=" + new String(this.buffer) + '}';
    }
}

