/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.core.models.pagination;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class ListResponse<T> {
    public abstract boolean hasNextPage();

    public abstract ListResponse<T> nextPage() throws NoSuchElementException;

    public abstract Collection<T> getContent();

    public Iterator<T> iterator() {
        return new ItemsIterator(this);
    }

    public Stream<T> stream() {
        Iterable iterable = this::iterator;
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    static class ItemsIterator<T>
    implements Iterator<T> {
        ListResponse<T> response;
        int currentIndex = 0;
        ArrayList<T> currentList;

        public ItemsIterator(ListResponse<T> response) {
            this.response = response;
            this.syncIteratorWithCurrentPage();
        }

        private void syncIteratorWithCurrentPage() {
            this.currentIndex = 0;
            this.currentList = new ArrayList<T>(this.response.getContent());
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < this.currentList.size() || this.response.hasNextPage();
        }

        @Override
        public T next() {
            if (this.currentIndex >= this.currentList.size()) {
                this.response = this.response.nextPage();
                this.syncIteratorWithCurrentPage();
            }
            return this.currentList.get(this.currentIndex++);
        }
    }
}

