/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.core.utils;

import com.sinch.sdk.core.utils.EnumDynamic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class EnumSupportDynamic<T, E extends EnumDynamic<T, E>> {
    private final Class<E> aClass;
    private final Map<T, E> valueMap;
    private final Function<T, E> surplusFactory;
    private volatile List<E> values;

    public EnumSupportDynamic(Class<E> aClass, Function<T, E> surplusFactory, List<E> values) {
        this.aClass = aClass;
        this.values = Collections.unmodifiableList(values);
        this.valueMap = this.values.stream().collect(Collectors.toMap(EnumDynamic::value, v -> v));
        this.surplusFactory = surplusFactory;
    }

    private static <E> List<E> createImmutableList(List<E> values2, E newValue) {
        ArrayList<E> newValues = new ArrayList<E>(values2);
        newValues.add(newValue);
        return Collections.unmodifiableList(newValues);
    }

    public Stream<E> values() {
        return this.values.stream();
    }

    public T valueOf(E e) {
        return e == null ? null : (T)((EnumDynamic)e).value();
    }

    public List<T> valuesOf(Collection<E> values) {
        if (values == null) {
            return null;
        }
        return values.stream().map(this::valueOf).collect(Collectors.toList());
    }

    public List<E> fromValues(Collection<T> values) {
        if (values == null) {
            return null;
        }
        return values.stream().map(this::from).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E from(T value) {
        if (value == null) {
            return null;
        }
        EnumDynamic e = (EnumDynamic)this.valueMap.get(value);
        if (e != null) {
            return (E)e;
        }
        Map<T, E> map = this.valueMap;
        synchronized (map) {
            EnumDynamic present = (EnumDynamic)this.valueMap.get(value);
            if (present == null) {
                EnumDynamic newValue = (EnumDynamic)this.surplusFactory.apply(value);
                this.valueMap.put(value, newValue);
                this.values = EnumSupportDynamic.createImmutableList(this.values, newValue);
                return (E)newValue;
            }
            return (E)present;
        }
    }

    public int compare(Object o1, Object o2) {
        String v1 = this.toComparableValue(o1);
        String v2 = this.toComparableValue(o2);
        return Objects.compare(v1, v2, String::compareTo);
    }

    public String toComparableValue(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (this.aClass.isInstance(o)) {
            EnumDynamic obj = (EnumDynamic)this.aClass.cast(o);
            return obj.value().toString();
        }
        throw new IllegalArgumentException(String.format("Object %s is neither %s nor a String.", o.getClass().getSimpleName(), this.aClass.getSimpleName()));
    }
}

