/*
 * Decompiled with CFR 0.152.
 */
package com.sinch.sdk.core.utils.databind;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class JSONNavigator {
    private static final Map<Class<?>, ClassDiscriminatorMapping> modelDiscriminators = new HashMap();
    private static final Map<Class<?>, Map<String, Class<?>>> modelDescendants = new HashMap();
    private static JSONNavigator jsonNavigator = new JSONNavigator();

    public static Class<?> getClassForElement(JsonNode node, Class<?> modelClass) {
        ClassDiscriminatorMapping cdm = modelDiscriminators.get(modelClass);
        if (cdm != null) {
            return cdm.getClassForElement(node, new HashSet());
        }
        return null;
    }

    public static boolean isInstanceOf(Class<?> modelClass, Object inst, Set<Class<?>> visitedClasses) {
        if (modelClass.isInstance(inst)) {
            return true;
        }
        if (visitedClasses.contains(modelClass)) {
            return false;
        }
        visitedClasses.add(modelClass);
        Map<String, Class<?>> descendants = modelDescendants.get(modelClass);
        if (descendants != null) {
            for (Class<?> childType : descendants.values()) {
                if (!JSONNavigator.isInstanceOf(childType, inst, visitedClasses)) continue;
                return true;
            }
        }
        return false;
    }

    public static void registerDiscriminator(Class<?> modelClass, String discriminatorPropertyName, Map<String, Class<?>> mappings) {
        ClassDiscriminatorMapping m = new ClassDiscriminatorMapping(modelClass, discriminatorPropertyName, mappings);
        modelDiscriminators.put(modelClass, m);
    }

    public static void registerDescendants(Class<?> modelClass, Map<String, Class<?>> descendants) {
        modelDescendants.put(modelClass, descendants);
    }

    public static JSONNavigator getDefault() {
        return jsonNavigator;
    }

    public static void setDefault(JSONNavigator jsonNavigator) {
        JSONNavigator.jsonNavigator = jsonNavigator;
    }

    private static class ClassDiscriminatorMapping {
        Class<?> modelClass;
        String discriminatorName;
        Map<String, Class<?>> discriminatorMappings;

        ClassDiscriminatorMapping(Class<?> cls, String propertyName, Map<String, Class<?>> mappings) {
            this.modelClass = cls;
            this.discriminatorName = propertyName;
            this.discriminatorMappings = new HashMap();
            if (mappings != null) {
                this.discriminatorMappings.putAll(mappings);
            }
        }

        String getDiscriminatorPropertyName() {
            return this.discriminatorName;
        }

        String getDiscriminatorValue(JsonNode node) {
            if (this.discriminatorName != null && (node = node.get(this.discriminatorName)) != null && node.isValueNode()) {
                String discrValue = node.asText();
                return discrValue;
            }
            return null;
        }

        Class<?> getClassForElement(JsonNode node, Set<Class<?>> visitedClasses) {
            if (visitedClasses.contains(this.modelClass)) {
                return null;
            }
            String discrValue = this.getDiscriminatorValue(node);
            if (discrValue == null) {
                return null;
            }
            Class<?> cls = this.discriminatorMappings.get(discrValue);
            visitedClasses.add(this.modelClass);
            for (Class<?> childClass : this.discriminatorMappings.values()) {
                Class<?> childDiscr;
                ClassDiscriminatorMapping childCdm = (ClassDiscriminatorMapping)modelDiscriminators.get(childClass);
                if (childCdm == null || !this.discriminatorName.equals(childCdm.discriminatorName) && (discrValue = this.getDiscriminatorValue(node)) == null || childCdm == null || (childDiscr = childCdm.getClassForElement(node, visitedClasses)) == null) continue;
                return childDiscr;
            }
            return cls;
        }
    }
}

